/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolItem
extends Item {
    int boxHandle;
    int arrowHandle;
    int separatorHandle;
    int labelHandle;
    int imageHandle;
    ToolBar parent;
    Control control;
    Image hotImage;
    Image disabledImage;
    String toolTipText;
    boolean drawHotImage;

    public ToolItem(ToolBar parent, int style) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        this.createWidget(parent.getItemCount());
    }

    public ToolItem(ToolBar parent, int style, int index) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        int count = parent.getItemCount();
        if (index < 0 || index > count) {
            this.error(14);
        }
        this.createWidget(index);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void createHandle(int index) {
        this.state |= 8;
        if ((this.style & 2) == 0) {
            int n = this.boxHandle = (this.parent.style & 0x20000) != 0 ? OS.gtk_hbox_new((boolean)false, (int)0) : OS.gtk_vbox_new((boolean)false, (int)0);
            if (this.boxHandle == 0) {
                this.error(2);
            }
            this.labelHandle = OS.gtk_label_new_with_mnemonic(null);
            if (this.labelHandle == 0) {
                this.error(2);
            }
            this.imageHandle = OS.gtk_image_new();
            if (this.imageHandle == 0) {
                this.error(2);
            }
            OS.gtk_container_add((int)this.boxHandle, (int)this.imageHandle);
            OS.gtk_container_add((int)this.boxHandle, (int)this.labelHandle);
            OS.gtk_widget_show((int)this.boxHandle);
        }
        int bits = 62;
        switch (this.style & bits) {
            case 2: {
                this.handle = OS.gtk_hbox_new((boolean)false, (int)0);
                if (this.handle == 0) {
                    this.error(2);
                }
                boolean isVertical = (this.parent.style & 0x200) != 0;
                int n = this.separatorHandle = isVertical ? OS.gtk_hseparator_new() : OS.gtk_vseparator_new();
                if (this.separatorHandle == 0) {
                    this.error(2);
                }
                OS.gtk_widget_set_size_request((int)this.separatorHandle, (int)(isVertical ? 15 : 6), (int)(isVertical ? 6 : 15));
                OS.gtk_widget_set_size_request((int)this.handle, (int)(isVertical ? 15 : 6), (int)(isVertical ? 6 : 15));
                OS.gtk_container_add((int)this.handle, (int)this.separatorHandle);
                OS.gtk_widget_show((int)this.separatorHandle);
                break;
            }
            case 4: {
                int arrowBoxHandle;
                this.handle = OS.gtk_button_new();
                if (this.handle == 0) {
                    this.error(2);
                }
                if ((arrowBoxHandle = OS.gtk_hbox_new((boolean)false, (int)0)) == 0) {
                    this.error(2);
                }
                this.arrowHandle = OS.gtk_arrow_new((int)1, (int)0);
                if (this.arrowHandle == 0) {
                    this.error(2);
                }
                OS.gtk_widget_set_size_request((int)this.arrowHandle, (int)8, (int)6);
                OS.gtk_container_add((int)this.handle, (int)arrowBoxHandle);
                OS.gtk_container_add((int)arrowBoxHandle, (int)this.boxHandle);
                OS.gtk_container_add((int)arrowBoxHandle, (int)this.arrowHandle);
                OS.gtk_widget_show((int)arrowBoxHandle);
                OS.gtk_widget_show((int)this.arrowHandle);
                break;
            }
            case 16: 
            case 32: {
                this.handle = OS.gtk_toggle_button_new();
                if (this.handle == 0) {
                    this.error(2);
                }
                OS.gtk_toggle_button_set_mode((int)this.handle, (boolean)false);
                OS.gtk_container_add((int)this.handle, (int)this.boxHandle);
                break;
            }
            default: {
                this.handle = OS.gtk_button_new();
                if (this.handle == 0) {
                    this.error(2);
                }
                OS.gtk_container_add((int)this.handle, (int)this.boxHandle);
            }
        }
        if ((this.style & 2) == 0) {
            int[] relief = new int[1];
            OS.gtk_widget_style_get((int)this.parent.handle, (byte[])OS.button_relief, (int[])relief, (int)0);
            OS.gtk_button_set_relief((int)this.handle, (int)relief[0]);
        }
        OS.GTK_WIDGET_UNSET_FLAGS((int)this.handle, (int)2048);
        OS.gtk_widget_show((int)this.handle);
        OS.gtk_toolbar_insert_widget((int)this.parent.handle, (int)this.handle, null, null, (int)index);
        this.setForegroundColor(this.parent.getForegroundColor());
        this.setFontDescription(this.parent.getFontDescription());
    }

    void deregister() {
        super.deregister();
        if (this.labelHandle != 0) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int topHandle = this.topHandle();
        int x = OS.GTK_WIDGET_X((int)topHandle);
        int y = OS.GTK_WIDGET_Y((int)topHandle);
        int width = OS.GTK_WIDGET_WIDTH((int)topHandle);
        int height = OS.GTK_WIDGET_HEIGHT((int)topHandle);
        return new Rectangle(x, y, width, height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        int topHandle = this.topHandle();
        return OS.GTK_WIDGET_SENSITIVE((int)topHandle);
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public ToolBar getParent() {
        this.checkWidget();
        if (this.parent == null) {
            this.error(24);
        }
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return OS.gtk_toggle_button_get_active((int)this.handle);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        int topHandle = this.topHandle();
        return OS.GTK_WIDGET_WIDTH((int)topHandle);
    }

    int gtk_button_press_event(int widget, int event) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove((GdkEventButton)gdkEvent, (int)event, (int)GdkEventButton.sizeof);
        double x = gdkEvent.x;
        gdkEvent.x += (double)OS.GTK_WIDGET_X((int)this.handle);
        double y = gdkEvent.y;
        gdkEvent.y += (double)OS.GTK_WIDGET_Y((int)this.handle);
        OS.memmove((int)event, (GdkEventButton)gdkEvent, (int)GdkEventButton.sizeof);
        this.parent.gtk_button_press_event(widget, event);
        gdkEvent.x = x;
        gdkEvent.y = y;
        OS.memmove((int)event, (GdkEventButton)gdkEvent, (int)GdkEventButton.sizeof);
        return 0;
    }

    int gtk_button_release_event(int widget, int event) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove((GdkEventButton)gdkEvent, (int)event, (int)GdkEventButton.sizeof);
        double x = gdkEvent.x;
        gdkEvent.x += (double)OS.GTK_WIDGET_X((int)this.handle);
        double y = gdkEvent.y;
        gdkEvent.y += (double)OS.GTK_WIDGET_Y((int)this.handle);
        OS.memmove((int)event, (GdkEventButton)gdkEvent, (int)GdkEventButton.sizeof);
        this.parent.gtk_button_release_event(widget, event);
        gdkEvent.x = x;
        gdkEvent.y = y;
        OS.memmove((int)event, (GdkEventButton)gdkEvent, (int)GdkEventButton.sizeof);
        return 0;
    }

    int gtk_clicked(int widget) {
        int eventPtr;
        Event event = new Event();
        if ((this.style & 4) != 0 && (eventPtr = OS.gtk_get_current_event()) != 0) {
            GdkEvent gdkEvent = new GdkEvent();
            OS.memmove((GdkEvent)gdkEvent, (int)eventPtr, (int)GdkEvent.sizeof);
            switch (gdkEvent.type) {
                case 4: 
                case 5: 
                case 7: {
                    double[] x_win = new double[1];
                    double[] y_win = new double[1];
                    OS.gdk_event_get_coords((int)eventPtr, (double[])x_win, (double[])y_win);
                    if ((int)x_win[0] <= OS.GTK_WIDGET_WIDTH((int)this.boxHandle)) break;
                    event.detail = 4;
                    int topHandle = this.topHandle();
                    event.x = OS.GTK_WIDGET_X((int)topHandle);
                    event.y = OS.GTK_WIDGET_Y((int)topHandle) + OS.GTK_WIDGET_HEIGHT((int)topHandle);
                }
            }
            OS.gdk_event_free((int)eventPtr);
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.postEvent(13, event);
        return 0;
    }

    int gtk_enter_notify_event(int widget, int event) {
        boolean bl = this.drawHotImage = (this.parent.style & 0x800000) != 0 && this.hotImage != null;
        if (this.drawHotImage && this.imageHandle != 0) {
            OS.gtk_image_set_from_pixmap((int)this.imageHandle, (int)this.hotImage.pixmap, (int)this.hotImage.mask);
        }
        return 0;
    }

    int gtk_event_after(int widget, int gdkEvent) {
        GdkEvent event = new GdkEvent();
        OS.memmove((GdkEvent)event, (int)gdkEvent, (int)GdkEvent.sizeof);
        switch (event.type) {
            case 4: {
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove((GdkEventButton)gdkEventButton, (int)gdkEvent, (int)GdkEventButton.sizeof);
                if (gdkEventButton.button != 3) break;
                this.parent.showMenu((int)gdkEventButton.x_root, (int)gdkEventButton.y_root);
            }
        }
        return 0;
    }

    int gtk_focus_out_event(int widget, int event) {
        OS.GTK_WIDGET_UNSET_FLAGS((int)this.handle, (int)2048);
        this.parent.lastFocus = this;
        return 0;
    }

    int gtk_leave_notify_event(int widget, int event) {
        if (this.drawHotImage) {
            this.drawHotImage = false;
            if (this.imageHandle != 0 && this.image != null) {
                OS.gtk_image_set_from_pixmap((int)this.imageHandle, (int)this.image.pixmap, (int)this.image.mask);
            }
        }
        return 0;
    }

    int gtk_mnemonic_activate(int widget, int arg1) {
        return this.parent.gtk_mnemonic_activate(widget, arg1);
    }

    boolean hasFocus() {
        return OS.GTK_WIDGET_HAS_FOCUS((int)this.handle);
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.style & 2) != 0) {
            return;
        }
        int windowProc2 = this.display.windowProc2;
        int windowProc3 = this.display.windowProc3;
        OS.g_signal_connect((int)this.handle, (byte[])OS.clicked, (int)windowProc2, (int)5);
        OS.g_signal_connect((int)this.handle, (byte[])OS.enter_notify_event, (int)windowProc3, (int)11);
        OS.g_signal_connect((int)this.handle, (byte[])OS.leave_notify_event, (int)windowProc3, (int)22);
        if (this.labelHandle != 0) {
            OS.g_signal_connect((int)this.labelHandle, (byte[])OS.mnemonic_activate, (int)this.display.windowProc3, (int)24);
        }
        OS.g_signal_connect((int)this.handle, (byte[])OS.focus_out_event, (int)windowProc3, (int)17);
        int mask = 32518;
        OS.gtk_widget_add_events((int)this.handle, (int)mask);
        OS.g_signal_connect((int)this.handle, (byte[])OS.button_press_event, (int)windowProc3, (int)2);
        OS.g_signal_connect((int)this.handle, (byte[])OS.button_release_event, (int)windowProc3, (int)3);
        OS.g_signal_connect((int)this.handle, (byte[])OS.event_after, (int)windowProc3, (int)13);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    void register() {
        super.register();
        if (this.labelHandle != 0) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0;
        this.labelHandle = 0;
        this.separatorHandle = 0;
        this.arrowHandle = 0;
        this.boxHandle = 0;
    }

    void releaseWidget() {
        if (this.control != null) {
            this.setControl(null);
        }
        super.releaseWidget();
        if (this.parent.lastFocus == this) {
            this.parent.lastFocus = null;
        }
        this.parent = null;
        this.control = null;
        this.disabledImage = null;
        this.hotImage = null;
        this.toolTipText = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void selectRadio() {
        int index = 0;
        ToolItem[] items = this.parent.getItems();
        while (index < items.length && items[index] != this) {
            ++index;
        }
        int i = index - 1;
        while (i >= 0 && items[i].setRadioSelection(false)) {
            --i;
        }
        int j = index + 1;
        while (j < items.length && items[j].setRadioSelection(false)) {
            ++j;
        }
        this.setSelection(true);
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        Control oldControl = this.control;
        Control newControl = control;
        if (oldControl == newControl) {
            return;
        }
        this.control = newControl;
        int parentHandle = this.parent.parentingHandle();
        if (oldControl != null) {
            OS.gtk_widget_reparent((int)oldControl.topHandle(), (int)parentHandle);
        }
        if (newControl != null) {
            OS.gtk_widget_reparent((int)newControl.topHandle(), (int)parentHandle);
            newControl.setBounds(this.getBounds());
            OS.gtk_widget_reparent((int)newControl.topHandle(), (int)this.handle);
            OS.gtk_widget_hide((int)this.separatorHandle);
        } else {
            OS.gtk_widget_show((int)this.separatorHandle);
        }
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        this.disabledImage = image;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        int topHandle = this.topHandle();
        OS.gtk_widget_set_sensitive((int)topHandle, (boolean)enabled);
    }

    boolean setFocus() {
        if ((this.style & 2) != 0) {
            return false;
        }
        OS.GTK_WIDGET_SET_FLAGS((int)this.handle, (int)2048);
        OS.gtk_widget_grab_focus((int)this.handle);
        boolean result = OS.gtk_widget_is_focus((int)this.handle);
        if (!result) {
            OS.GTK_WIDGET_UNSET_FLAGS((int)this.handle, (int)2048);
        }
        return result;
    }

    void setFontDescription(int font) {
        OS.gtk_widget_modify_font((int)this.handle, (int)font);
        if (this.labelHandle != 0) {
            OS.gtk_widget_modify_font((int)this.labelHandle, (int)font);
        }
        if (this.imageHandle != 0) {
            OS.gtk_widget_modify_font((int)this.imageHandle, (int)font);
        }
    }

    void setForegroundColor(GdkColor color) {
        OS.gtk_widget_modify_fg((int)this.handle, (int)0, (GdkColor)color);
        if (this.labelHandle != 0) {
            OS.gtk_widget_modify_fg((int)this.labelHandle, (int)0, (GdkColor)color);
        }
        if (this.imageHandle != 0) {
            OS.gtk_widget_modify_fg((int)this.imageHandle, (int)0, (GdkColor)color);
        }
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        this.hotImage = image;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        if (this.imageHandle == 0) {
            return;
        }
        if (image != null) {
            OS.gtk_image_set_from_pixmap((int)this.imageHandle, (int)image.pixmap, (int)image.mask);
            OS.gtk_widget_show((int)this.imageHandle);
        } else {
            OS.gtk_image_set_from_pixmap((int)this.imageHandle, (int)0, (int)0);
            OS.gtk_widget_hide((int)this.imageHandle);
        }
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        if (!this.isValidThread()) {
            this.error(22);
        }
        if (!this.isValidWidget()) {
            this.error(24);
        }
        if ((this.style & 0x30) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)5);
        OS.gtk_toggle_button_set_active((int)this.handle, (boolean)selected);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)5);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setText(string);
        if (this.labelHandle == 0) {
            return;
        }
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        OS.gtk_label_set_text_with_mnemonic((int)this.labelHandle, (byte[])buffer);
        if (string.length() != 0) {
            OS.gtk_widget_show((int)this.labelHandle);
        } else {
            OS.gtk_widget_hide((int)this.labelHandle);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        if (this.parent.toolTipText == null) {
            Shell shell = this.parent._getShell();
            shell.setToolTipText(this.handle, this.toolTipText);
        }
    }

    public void setWidth(int width) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (width < 0) {
            return;
        }
        OS.gtk_widget_set_size_request((int)this.handle, (int)width, (int)-1);
        int parentHandle = this.parent.parentingHandle();
        OS.gtk_container_resize_children((int)parentHandle);
        if (this.control != null && !this.control.isDisposed()) {
            OS.gtk_widget_reparent((int)this.control.topHandle(), (int)parentHandle);
            this.control.setBounds(this.getBounds());
            OS.gtk_widget_reparent((int)this.control.topHandle(), (int)this.handle);
        }
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 8, 32, 16, 2, 4, 0);
    }
}

