// start of definition 
if (!window.TabbrowserOverlay) {
	
// static class "TabbrowserOverlay" 
var TabbrowserOverlay =
{
	lastSent_bookmarks_command : 0,
	lastSent_bookmarks_click   : 0,
	lastSent_history_command   : 0,
	lastSent_history_click     : 0,

	get service()
	{
		return TabbrowserService;
	},
	
	onBeforeInit : function() 
	{
		var nodes, i;
		var b = this.service.browser;


		window.__tabextensions__goQuitApplication = window.goQuitApplication;
		window.goQuitApplication = this.goQuitApplication;

		if (this.service.isNewTypeBrowser) { // Firefox
			if (this.service.isBrowserWindow) {
				window.__tabextensions__openNewTabWith = window.openNewTabWith;
				window.openNewTabWith = this.openNewTabWith;

				window.__tabextensions__openNewWindowWith = window.openNewWindowWith;
				window.openNewWindowWith = this.openNewWindowWith;
			}

			if ('ctrlNumberTabSelection' in window)
				window.ctrlNumberTabSelection = this.ctrlNumberTabSelection;
		}
		else {
			if (this.service.isBrowserWindow) {
				window.__tabextensions__openNewTabWith = window.openNewTabWith;
				window.openNewTabWith = this.openNewTabWith_old;

				window.__tabextensions__openNewWindowWith = window.openNewWindowWith;
				window.openNewWindowWith = this.openNewWindowWith_old;
			}
		}

		window.BrowserOpenTab = this.BrowserOpenTab;

		// for Netscape 7
		if (b) b.newTab = this.BrowserOpenTab;

		if (window.BrowserCloseTabOrWindow) {
			window.BrowserCloseTabOrWindow = this.BrowserCloseTabOrWindow;
		}


		// native tabbed browsing (Firefox 1.0 or later)
		if ('nsBrowserAccess' in window) {
			nsBrowserAccess.prototype.__tabextensions__openURI = nsBrowserAccess.prototype.openURI;
			nsBrowserAccess.prototype.openURI = this.nsBrowserAccessOpenURI;

			// old method for Firefox 1.1 or later.
			try {
				window.QueryInterface(Components.interfaces.nsIDOMChromeWindow).browserDOMWindow = null;
				window.QueryInterface(Components.interfaces.nsIDOMChromeWindow).browserDOMWindow = new nsBrowserAccess();
			}
			catch(e) {
				if (this.service.debug) dump('NOTE: The NEW METHOD to override nsBrowserAccess is skipped.\n'+e+'\n');
			}

			// old method for Firefox 1.0 or before.
			try {
				var util = gBrowser.docShell
					.QueryInterface(nsCI.nsIDocShellTreeItem)
					.rootTreeItem
					.QueryInterface(nsCI.nsIInterfaceRequestor)
					.getInterface(nsCI.nsIDOMWindow)
					.QueryInterface(nsCI.nsIInterfaceRequestor)
					.getInterface(nsCI.nsIDOMWindowUtils);
				if (util) {
					util.browserDOMWindow = null;
					util.browserDOMWindow = new nsBrowserAccess();
				}
			}
			catch(e) {
				if (this.service.debug) dump('NOTE: The OLD METHOD to override nsBrowserAccess is skipped.\n'+e+'\n');
			}
		}

		// Link Click
		if ('contentAreaClick' in window) {
			window.__tabextensions__contentAreaClick = window.contentAreaClick;
			window.contentAreaClick = this.contentAreaClick;
			if (b) b.hookContentAreaClick = true;
		}
		if ('handleLinkClick' in window) {
			window.__tabextensions__handleLinkClick = window.handleLinkClick;
			window.handleLinkClick = this.handleLinkClick;
		}
		// Mail&News (1.4 or later)
		if ('messagePaneOnClick' in window) {
			document.getElementById('messagepane').removeEventListener('click', messagePaneOnClick, true);
			window.__tabextensions__messagePaneOnClick = window.messagePaneOnClick;
			window.messagePaneOnClick = this.messagePaneOnClick;
			document.getElementById('messagepane').addEventListener('click', window.messagePaneOnClick, true);
		}



		// Toolbar Items
		if (this.service.isNewTypeBrowser) {
			nodes = document.getElementsByTagName('toolbar');
			for (i = 0; i < nodes.length; i++) {
				nodes[i].__tabextensions__insertItem = nodes[i].insertItem;
				nodes[i].insertItem = this.insertItem;
				nodes[i].addEventListener('TSToolbarItemInserted', gTSToolbarItemsInsertedEventListener, false);
			}
		}



		// Location Bar
		if ('BrowserLoadURL' in window) {
			window.__tabextensions__BrowserLoadURL = window.BrowserLoadURL;
			window.BrowserLoadURL = this.BrowserLoadURL;

			if (this.service.isNewTypeBrowser) {
				window.__tabextensions__handleURLBarCommand = window.handleURLBarCommand;
				window.handleURLBarCommand = this.handleURLBarCommand;
			}
		}

		// Web Search
		if ('SearchLoadURL' in window) {
			window.__tabextensions__SearchLoadURL = window.SearchLoadURL;
			window.SearchLoadURL = this.SearchLoadURL;
		}
		if ('OpenSearch' in window) {
			if (window.OpenSearch.arity == 4) { // old Mozilla Suite
				window.OpenSearch = function(aTabName, aForceDialogFlag, aSearchStr, aNewWindowFlag) {
					TabbrowserOverlay.OpenSearch(aTabName, aSearchStr, aNewWindowFlag, aForceDialogFlag);
				};
			}
			else {
				window.OpenSearch = this.OpenSearch;
			}
		}



		// Bookmarks
		window.OpenBookmarkURL = this.openBookmarkURL;
		window.OpenBookmarkGroupFromResource = this.service.openBookmarkGroup;
		window.addBookmarkForTabBrowser = this.addBookmarkForTabBrowser;
		if ('BookmarksUtils' in window) {
			BookmarksUtils.__tabextensions__addBookmark = BookmarksUtils.addBookmark;
			BookmarksUtils.addBookmark = this.addBookmark;
			BookmarksUtils.__tabextensions__createBookmark = BookmarksUtils.createBookmark;
			BookmarksUtils.createBookmark = this.createBookmark;
			BookmarksUtils.addBookmarkForTabBrowser = this.addBookmarkForTabBrowser;
		}
		if ('BookmarksMenu' in window) {
			BookmarksMenu.__tabextensions__loadBookmark = BookmarksMenu.loadBookmark;
			BookmarksMenu.loadBookmark = this.loadBookmark;
			BookmarksMenu.__tabextensions__loadBookmarkMiddleClick = BookmarksMenu.loadBookmarkMiddleClick;
			BookmarksMenu.loadBookmarkMiddleClick = this.loadBookmarkMiddleClick;
		}
		if ('BookmarksCommand' in window) {
			BookmarksCommand.__tabextensions__openBookmark = BookmarksCommand.openBookmark;
			BookmarksCommand.openBookmark = this.BookmarksCommandOpenBookmark;
			BookmarksCommand.__tabextensions__createContextMenu = BookmarksCommand.createContextMenu;
			BookmarksCommand.createContextMenu = this.BookmarksCommandCreateContextMenu;
		}

		if (this.service.isNewTypeBrowser) { // Firefox
			if ('BookmarksCommand' in window)
				BookmarksCommand.openGroupBookmark = this.openGroupBookmark;

			nodes = document.getElementsByTagName('bookmarks-toolbar');
			for (i = 0; i < nodes.length; i++) {
				nodes[i].toolbar.setAttribute('oncommand', 'TabbrowserOverlay.openBookmarkURL(event.originalTarget, this.database, event, this);');
				nodes[i].toolbar.setAttribute('onclick', 'TabbrowserOverlay.openBookmarkURL(event.originalTarget, this.database, event, this);');
			}
		}

		nodes = document.getElementsByTagNameNS(this.service.XULNS, 'bookmarks-tree');
		for (i = 0; i < nodes.length; i++)
		{
			if ('openItemClick' in nodes[i]) {
				nodes[i].__tabextensions__openItemKey  = nodes[i].openItemKey;
				nodes[i].__tabextensions__openItemClick = nodes[i].openItemClick;
			}
			nodes[i].openItemKey   = this.openBookmarkItemClickOrKey;
			nodes[i].openItemClick = this.openBookmarkItemClickOrKey;

			// old implementation
			nodes[i].__tabextensions__openItem = nodes[i].openItem;
			nodes[i].openItem = (this.service.isNewTypeBrowser) ? this.openBookmarkItemClickOrKey : this.openBookmarkItem ; // Firefox

			if ('tree' in nodes[i] && nodes[i].tree &&
				!nodes[i].tree.getAttribute('onclick'))
				nodes[i].tree.setAttribute('onclick', 'if (event.button != 1) return; '+nodes[i].tree.getAttribute('ondblclick'));

			nodes[i].validOpenClickConditions = this.validOpenClickConditions;
		}

		// Bookmarks and Text Zoom
		if ('ZoomManager' in window) {
			ZoomManager.prototype.__defineSetter__(
				'textZoom',
				function(aZoom)
				{
					// implementations in original code
					if (aZoom < this.MIN || aZoom > this.MAX)
						throw Components.results.NS_ERROR_INVALID_ARG;

					getMarkupDocumentViewer().textZoom = aZoom / 100;

					// TBE extra feature
					try {
						var TS = TabbrowserService;
						var b  = TS.browser;
						var t  = b.selectedTab;
						if (!t.getAttribute('tab-bookmarkID') ||
							t.getAttribute('tab-bookmarkURI') != t.getAttribute('tab-loadingURI') ||
							!TS.isBookmarked(t.getAttribute('tab-bookmarkID')))
							t.removeAttribute('tab-textZoomTargetURI');
//						else
						b.setTextZoomFor(t, aZoom, t.getAttribute('tab-loadingURI'));
					}
					catch(e) {
					}
				}
			);
		}

		// Bookmarks and Icon
		if ('bookmarksFavIconLoadListener' in window) {
			bookmarksFavIconLoadListener.prototype.__tabextensions__onStopRequest = bookmarksFavIconLoadListener.prototype.onStopRequest;
			bookmarksFavIconLoadListener.prototype.onStopRequest = this.bookmarksFavIconLoadListenerOnStopRequest;
		}




		// History
		if ('gHistoryTree' in window && !this.service.isNewTypeBrowser) {
			if ('OpenURL' in window) {
				window.__tabextensions__OpenURL = window.OpenURL;
				window.OpenURL = this.OpenURL;
			}
			if ('historyOnClick' in window) {
				window.__tabextensions__historyOnClick = window.historyOnClick;
				window.historyOnClick = this.historyOnClick;
			}
		}
		if (this.service.isNewTypeBrowser && 'OpenURL' in window) {
			window.__tabextensions__OpenURL = window.OpenURL;
			window.OpenURL = this.OpenURL;
		}

		// for Firefox 1.1 or later?
		if ('gHistoryTree' in window &&
			'openURL' in window && 'whereToOpenLink' in window) {
			window.__tabextensions__openURL = window.openURL;
			window.openURL = this.openURL;
		}

		if ('gotoHistoryIndex' in window) {
//			window.__tabextensions__gotoHistoryIndex = window.gotoHistoryIndex;
			window.gotoHistoryIndex = this.gotoHistoryIndex;

			if (navigator.platform.indexOf('Mac') < 0) {
				var buttons = {
						back    : null,
						forward : null
					};

				nodes = document.getElementsByAttribute('oncommand', 'gotoHistoryIndex(event);');
				for (i = 0; i < nodes.length; i++)
				{
					nodes[i].addEventListener('click', gotoHistoryIndex, true);
					if (nodes[i].id == 'back-button')
						buttons.back = nodes[i];
					else if (nodes[i].id == 'forward-button')
						buttons.forward = nodes[i];
				}

				// back and forward buttons
				if (this.service.isNewTypeBrowser) {
					gTSToolbarItemsInsertedEventListener(null, 'back-button');
					gTSToolbarItemsInsertedEventListener(null, 'forward-button');
				}
				else {
					for (i in buttons) {
						if (buttons[i]) continue;

						buttons[i] = document.getElementById(i+'-button');
						if (buttons[i])
							buttons[i].addEventListener('click', gotoHistoryIndex, true);
					}
				}
			}
		}



		// Context Menu
		if ('nsContextMenu' in window) {
			nsContextMenu.prototype.__tabextensions__initItems = nsContextMenu.prototype.initItems;
			nsContextMenu.prototype.initItems = this.initItems;

			var contextmenu = document.getElementById('contentAreaContextMenu') || document.getElementById('messagePaneContext') ;
			contextmenu.addEventListener('popupshowing', this.onContentAreaContextMenuShowing, false);
		}



		// view source
		if ('BrowserViewSourceOfDocument' in window) {
			window.__tabextensions__BrowserViewSourceOfDocument = window.BrowserViewSourceOfDocument;
			window.BrowserViewSourceOfDocument = function(aDocument)
			{
				return TabbrowserService.viewSourceInTab ? TabbrowserOverlay.viewSourceOf('document', aDocument) : __tabextensions__BrowserViewSourceOfDocument(aDocument);
			};
		}
		if ('BrowserViewSourceOfURL' in window) {
			window.__tabextensions__BrowserViewSourceOfURL = window.BrowserViewSourceOfURL;
			window.BrowserViewSourceOfURL = function(aURI, aCharset, aPageCookie)
			{
				return TabbrowserService.viewSourceInTab ? TabbrowserOverlay.viewSourceOf('uri', aURI, aCharset, aPageCookie) : __tabextensions__BrowserViewSourceOfURL(aURI, aCharset, aPageCookie);
			};
		}
		if('nsContextMenu' in window) {
			nsContextMenu.prototype.__tabextensions__viewPartialSource = nsContextMenu.prototype.viewPartialSource;
			nsContextMenu.prototype.viewPartialSource = function(aContext)
			{
				return TabbrowserService.viewSourceInTab ? TabbrowserOverlay.viewSourceOf('partial', aContext) : this.__tabextensions__viewPartialSource(aContext);
			};
		}



		// kill original confirming
		if ('WindowIsClosing' in window) {
			window.WindowIsClosing = function() { return true; };
		}
		if ('BrowserTryToCloseWindow' in window) {
			window.BrowserTryToCloseWindow = function() {
				if (TabbrowserService.onWindowClose()) {
					if ('BrowserCloseWindow' in window)
						window.BrowserCloseWindow();
					else
						window.close();
				}

				return true;
			};
		}
	},
 
	onBeforeDestruct : function() 
	{
		// Context Menu
		if ('nsContextMenu' in window) {
			var contextmenu = document.getElementById('contentAreaContextMenu') || document.getElementById('messagePaneContext') ;
			contextmenu.removeEventListener('popupshowing', this.onContentAreaContextMenuShowing, false);
		}

		if (this.service.isNewTypeBrowser) {
			var toolbars = document.getElementsByTagName('toolbar');
			for (i = 0; i < toolbars.length; i++)
				toolbars[i].removeEventListener('TSToolbarItemInserted', gTSToolbarItemsInsertedEventListener, false);
		}
	},
 
	onInit : function() 
	{
		this.service.addPrefListener(gTSOpentabforLinksPrefListener);
		gTSOpentabforLinksPrefListener.observe('nsPref:changed', null, 'browser.tabs.opentabfor.links.targetBehavior');
		gTSOpentabforLinksPrefListener.observe('nsPref:changed', null, 'browser.tabs.opentabfor.links.middleClickBehavior');
	},
 
	onDestruct : function() 
	{
		this.service.removePrefListener(gTSOpentabforLinksPrefListener);
	},
 
	// native tabbed browsing (Firefox 1.0 or later) 
	nsBrowserAccessOpenURI : function(aURI, aOpener, aWhere, aContext)
	{
		var TS = TabbrowserService;
		if (TS.debug)
			dump('TabbrowserOverlay::nsBrowserAccessOpenURI CALLED!!\n');

		const nsIBrowserDOMWindow = 'nsIBrowserDOMWindow' in Components.interfaces ? Components.interfaces.nsIBrowserDOMWindow : 'nsIBrowserWindow' in Components.interfaces ? Components.interfaces.nsIBrowserWindow : null ;


		var uri = aURI ? aURI.spec : 'about:blank';
		var loadInBackground;
		var loadInBackgroundWindow;

		switch (aContext)
		{
			case nsIBrowserDOMWindow.OPEN_EXTERNAL:
				if (aWhere == nsIBrowserDOMWindow.OPEN_DEFAULTWINDOW)
	//				aWhere = TS.getPref('browser.link.open_external');
					aWhere = TS.platformNativeBehavior == 2 ? nsIBrowserDOMWindow.OPEN_NEWTAB :
							TS.platformNativeBehavior == 3 ? nsIBrowserDOMWindow.OPEN_NEWWINDOW :
							nsIBrowserDOMWindow.OPEN_CURRENTWINDOW;
				loadInBackground       = TS.getPref('browser.tabs.extensions.loadInBackgroundPlatformNative');
				loadInBackgroundWindow = TS.getPref('browser.tabs.extensions.loadInBackgroundWindow.platformNative');
				break;

			/*
				This section will be called from links[target], form[target],
				or javascript. But likns are handled in "contentAreaClick".
				We can ignore cases from links in this section.
			*/
			default:
				if (aWhere == nsIBrowserDOMWindow.OPEN_DEFAULTWINDOW)
					aWhere = TS.getPref('browser.link.open_newwindow');

				// see "hookContentAreaEvents" in tabextensions.xml
				if (aOpener) {
//					alert('@TabbrowserOverlay.nsBrowserAccessOpenURI()\n'+aOpener.__tabextensions__lastTarget+'\n'+aOpener.__tabextensions__lastAction+'\n'+aOpener.__tabextensions__lastHref+'\n'+uri);
					if (
						aOpener.__tabextensions__lastTarget &&
						(
							TS.makeURLAbsolute(aOpener.location.href, aOpener.__tabextensions__lastAction) == uri ||
							TS.makeURLAbsolute(aOpener.location.href, aOpener.__tabextensions__lastHref) == uri
						)
						) {
						loadInBackground = TS.getPref('browser.tabs.opentabfor.links.targetBehavior');
						loadInBackground = (loadInBackground < 0) ? TS.loadInBackground : (loadInBackground == 2) ;
					}
					else
						loadInBackground = TS.getPref('browser.tabs.extensions.loadInBackgroundJS');
				}
				else
					loadInBackground = TS.loadInBackground;

				loadInBackgroundWindow = TS.loadInBackgroundWindow;
				break;
		}

		if (TS.winHookMode == 2 &&
			aWhere != nsIBrowserDOMWindow.OPEN_CURRENTWINDOW) {
			aWhere = nsIBrowserDOMWindow.OPEN_NEWTAB;
		}

		if (
			aWhere == nsIBrowserDOMWindow.OPEN_NEWTAB &&
			TS.checkToLoadInCurrentTabOf(gBrowser)
			)
			aWhere = nsIBrowserDOMWindow.OPEN_CURRENTWINDOW;


		/*
			When new tab is loaded, the top-level XUL window always gets focus.
			If there is only the browser window, the window is focused even if
			we wish it to stay in background.
			This dummy window gets the focus instead of the browser window,
			and closes itself after a while.
		*/
		var dummyWindow;
		if (loadInBackgroundWindow) {
			dummyWindow = window.openDialog('chrome://tabextensions/content/dummyWindow.xul', '', 'chrome,width=1,height=1,titlebar=no,screenX=16777216,screenY=16777216');
			try { // Ô߁B
				dummyWindow.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
					.getInterface(Components.interfaces.nsIWebNavigation)
					.QueryInterface(Components.interfaces.nsIDocShell)
					.QueryInterface(Components.interfaces.nsIDocShellTreeItem)
					.treeOwner
					.QueryInterface(Components.interfaces.nsIBaseWindow)
					.visibility = false;
			}
			catch(e) {
			}
		}


		var referrer = null;
		try {
			if (aOpener)
				referrer = TS.makeURIFromSpec(Components.lookupMethod(aOpener, 'location').call(aOpener));
		}
		catch(e) {
		}

		var newWindow = null;

		switch (aWhere)
		{
			case nsIBrowserDOMWindow.OPEN_NEWWINDOW:
				newWindow = window.openDialog(TS.browserURI, '_blank', 'chrome,all,dialog=no', uri);
				if (!loadInBackgroundWindow) newWindow.focus();
				break;

			case nsIBrowserDOMWindow.OPEN_NEWTAB:
				var info = {};
				if (aOpener && gBrowser.tabGroupsAvailable) {
					var topWin = Components.lookupMethod(aOpener, 'top').call(aOpener);
					for (var i = 0; i < gBrowser.mTabs.length; i++)
					{
						if (gBrowser.mTabs[i].mBrowser.contentWindow == topWin) {
							info.parentTab           = gBrowser.mTabs[i].tabId;
							info.openedAutomatically = true;

							var openIn = TS.getPref('browser.tabs.extensions.open_tab_in_link');
							if (openIn > -1) info.openIn = openIn;
							break;
						}
					}
				}

				var newTab = gBrowser.addTabInternal('about:blank', null, info);
				if (!loadInBackground) gBrowser.selectedTab = newTab;
				if (!loadInBackgroundWindow) window.focus();

				newWindow = newTab.mBrowser.docShell
							.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
							.getInterface(Components.interfaces.nsIDOMWindow);

				newTab.mBrowser.docShell
					.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
					.getInterface(Components.interfaces.nsIWebNavigation)
					.loadURI(
						uri,
						Components.interfaces.nsIWebNavigation.LOAD_FLAGS_NONE,
						referrer,
						null,
						null
					);

				if (aOpener && info.parentTab)
					newTab.parentTab = gBrowser.getTabByTabId(info.parentTab);


				window.setTimeout(
					function() {
						try {
							var name = Components.lookupMethod(newWindow, 'name').call(newWindow);
							if (name) {
								newTab.browserName = name;
							}
						}
						catch(e) {
						}
					},
					10
				);
				break;

			default: // OPEN_CURRENTWINDOW or an illegal value
				try {
					if (aOpener) {
						newWindow = Components.lookupMethod(aOpener, 'top').call(aOpener);
						newWindow.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
							.getInterface(Components.interfaces.nsIWebNavigation)
							.loadURI(
								uri,
								Components.interfaces.nsIWebNavigation.LOAD_FLAGS_NONE,
								referrer,
								null,
								null
							);
					}
					else {
						newWindow = gBrowser.docShell
									.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
									.getInterface(Components.interfaces.nsIDOMWindow);
						loadURI(uri, null);
					}
				}
				catch(e) {
				}
				if (!loadInBackgroundWindow) window.focus();
				break;
		}

		if (dummyWindow && loadInBackgroundWindow) {
			dummyWindow.focus();
			window.setTimeout(function() { dummyWindow.close(); }, 100);
		}


		if (
			TabbrowserService.browser.mTabs.length > 1 ||
			aWhere == nsIBrowserDOMWindow.OPEN_NEWTAB
			)
			TabbrowserService.preventModifyWindowState(newWindow);

		return newWindow;
	},
 
	// Links 
	
	contentAreaClick : function(aEvent, aFieldNormalClicks) 
	{
		// ignore clicks on XUL elements (Mozilla 1.4 or later?)
		if (aEvent.target.ownerDocument.defaultView == window)
			return true;

		var TS   = TabbrowserService,
			TO   = TabbrowserOverlay,
			nav  = ('__tabextensions__browserWindow' in aEvent ? aEvent.__tabextensions__browserWindow : TS.browserWindow ),
			b    = (nav ? nav.TabbrowserService.browser : null ),
			node = (
					findParentNode(aEvent.target, 'a') ||
					findParentNode(aEvent.target, 'area') ||
					findParentNode(aEvent.target, 'link') ||
					null
				);


		var eventInfo = {
				DOMEvent          : aEvent,
				cancelProcess     : false,
				retVal            : true,
				fieldNormalClicks : aFieldNormalClicks
			};

		TS.fireEventForModules('ContentAreaClick_preProcess', eventInfo);
		if (eventInfo.cancelProcess) return eventInfo.retVal;

		// ignore clicks not on a link
		if (!node || (aEvent.type == 'click' && aEvent.button > 1))
			return __tabextensions__contentAreaClick(aEvent, aInfo.fieldNormalClicks);


		// get URI, REFERRER, TARGET
		var linkInfo = TO.getLinkInfo(node);

		linkInfo.referrerBlocked = (b && b.selectedTab.referrerBlocked) || (linkInfo.originalURI != linkInfo.uri) ;
		if (linkInfo.referrerBlocked)
			linkInfo.referrer = null;

		linkInfo.browser           = b;
		linkInfo.tabId             = ('__tabextensions__tabId' in aEvent ? aEvent.__tabextensions__tabId : b.selectedTab.tabId );
		linkInfo.fieldNormalClicks = aFieldNormalClicks;


		// if there is no browser window...
		if (!b) {
			TS.markLinkVisited(linkInfo.uri, node);
			if (!linkInfo.uri.match(/^javascript:/)) {
				window.openDialog(
					TS.browserURI,
					'_blank',
					'chrome,all,dialog=no',
					linkInfo.uri,
					null,
					linkInfo.referrer
				);
				TS.stopEvent(aEvent, true);
			}
			else {
				TS.fireEventForModules('ContentAreaClick_noBrowserWindow', eventInfo);
				if (eventInfo.cancelProcess) return eventInfo.retVal;
			}

			return true;
		}

try {
		TO.computeActionForLink(linkInfo, aEvent);
}
catch(e) { if (TS.debug) dump('contentAreaClick => computeActionForLink:\n'+e+'\n'); }

		if (
			linkInfo.behavior == -1 ||
			(
				linkInfo.newTabActionMiddleClick &&
				linkInfo.ignoreMiddleClickAction
			) ||
			( // prevent to open new tab
				(
					linkInfo.behavior > 0 ||
					(linkInfo.newTypeBrowserOpenWindow && TS.winHookMode > 0)
				) &&
				TO.blockSameURLTab(linkInfo.uri, b)
			)
			) {
			TS.stopEvent(aEvent, true);
			return true;
		}


if (TS.debug) {
	dump('TabbrowserSerivce.contentAreaClick() ---- LOADING LINK INFORMATION\n');
	for (var p in linkInfo)
		dump('   '+ p + ' : ' + linkInfo[p] +'\n');
}


try {
		var retVal = TO.doLinkAction(linkInfo, aEvent);
}
catch(e) { if (TS.debug) dump('contentAreaClick => doLinkAction:\n'+e+'\n'); }


		TS.fireEventForModules('ContentAreaClick_postProcess', eventInfo);
		if (eventInfo.cancelProcess) return eventInfo.retVal;

		return retVal;
	},
	
	blockSameURLTab : function(aURI, aTabBrowser) 
	{
		if (!this.service.preventSameURLTab) return false;

		var b = aTabBrowser || this.browser ;

		if (b.selectedTab.getAttribute('tab-loadingURI') == aURI) return true;

		for (var i = 0; i < b.mTabs.length; i++)
		{
			if (b.mTabs[i].getAttribute('tab-loadingURI') != aURI) continue;

			this.service.popupAlert(this.service.strbundle.GetStringFromName('status_same_uri_tab_exists'));

			if (!aLinkInfo.loadInBackground) {
				b.selectedTab = b.mTabs[i];
				b.scrollTabbarToTab(b.selectedTab);
				b.setFocusInternal();
			}
			return true;
		}
		return false;
	},
 
	getLinkInfo : function(aLinkNode) 
	{
		// uri
		var uri = (
				aLinkNode.href ||
				aLinkNode.getAttributeNS(this.service.XHTMLNS, 'href') ||
				aLinkNode.getAttributeNS(this.service.XLinkNS, 'href') ||
				aLinkNode.getAttribute('href') ||
				''
			);
		var originalURI = uri;
		// for accesses from ime.nu(www.2ch.net), etc....
		var realURI = this.service.getRealURI(uri);
		if (realURI) uri = realURI;

		// referrer
		var w = aLinkNode.ownerDocument.defaultView;
		var sourceURI = Components.lookupMethod(w, 'location').call(w).href;

		// link target
		var nameInfo = this.getTargetForLink(aLinkNode);

		return {
			node        : aLinkNode,
			window      : w,
			document    : Components.lookupMethod(w, 'document').call(w),

			uri         : uri,
			originalURI : originalURI,

			source      : sourceURI,
			referrer    : (realURI ? null : this.service.makeURIFromSpec(sourceURI) ),

			target      : nameInfo.target,
			realTarget  : nameInfo.realTarget
		};
	},
	
	getTargetForLink : function(aLinkNode) 
	{
		if (!aLinkNode) return { name : '', realName : '' };

		var realName = (
				aLinkNode.target ||
				(
					'getAttributeNS' in aLinkNode &&
					(
						aLinkNode.getAttributeNS(this.service.XHTMLNS, 'target') ||
						aLinkNode.getAttributeNS(this.service.XLinkNS, 'target')
					)
				) ||
				aLinkNode.getAttribute('target') ||
				''
			);

		var name = realName.replace(/^_(self|top|parent|content)$/i, '').replace(/^_main$/, '');

		// find "target" attribute of "base" element
		var base = aLinkNode.ownerDocument.getElementsByTagName('base');
		if (!base.length) base = aLinkNode.ownerDocument.getElementsByTagNameNS(this.service.XHTMLNS, 'base');
		if (!realName && base.length) {
			var tempRealName;
			for (var i = base.length-1; i > -1 ; i--)
				if ((tempRealName = (
						base[i].target ||
						base[i].getAttributeNS(this.XHTMLNS, 'target') ||
						base[i].getAttributeNS(this.XLinkNS, 'target') ||
						base[i].getAttribute('target') ||
						''
					))) {
					realName = tempRealName;
					name = realName.replace(/^_(self|top|parent|content)$/i, '').replace(/^_main$/, '');
				}
		}

		return { target : name, realTarget : realName };
	},
  
	computeActionForLink : function(aLinkInfo, aEvent) 
	{
		var topWin = Components.lookupMethod(aLinkInfo.window, 'top').call(aLinkInfo.window);
		var tab;

		aLinkInfo.behavior = -1;


		// middle click
		aLinkInfo.newTabActionMiddleClick = (
				aEvent.type == 'click' &&
				(
					aEvent.button == 1 ||
					(aEvent.button == 0 && (aEvent.ctrlKey || aEvent.metaKey))
				)
			);
		aLinkInfo.ignoreMiddleClickAction = false;
		if (aLinkInfo.newTabActionMiddleClick) {
			var middleClickBehavior = this.service.getPref('browser.tabs.opentabfor.links.middleClickBehavior');
			if (aLinkInfo.behavior < 0)
				aLinkInfo.behavior = middleClickBehavior;
			aLinkInfo.ignoreMiddleClickAction = (middleClickBehavior < 0);

			if (aLinkInfo.behavior < 0) return;
		}

		// locked tabs
		aLinkInfo.newTabActionLocked = (
				aLinkInfo.browser &&
				aLinkInfo.browser.localName == 'tabbrowser' &&
				(tab = aLinkInfo.browser.getTabByTabId(aLinkInfo.tabId)) &&
				tab.locked &&
				tab.mBrowser.contentDocument &&
				tab.mBrowser.contentDocument.defaultView == topWin
			);
		if (aLinkInfo.behavior < 0 && aLinkInfo.newTabActionLocked) {
			aLinkInfo.behavior = this.service.getPref('browser.tabs.opentabfor.links.lockedBehavior');
		}

		// target links
		aLinkInfo.newTabActionTarget = (
				aLinkInfo.target &&
				!this.service.getFrameByName(topWin, aLinkInfo.target)
			);
		if (aLinkInfo.behavior < 0 && aLinkInfo.newTabActionTarget) {
			aLinkInfo.behavior = this.service.getPref('browser.tabs.opentabfor.links.targetBehavior');
			if (aLinkInfo.behavior < 0 && this.service.winHookMode > 0)
				aLinkInfo.behavior = this.service.loadInBackground ? 2 : 1 ;
		}

		// outer link
		var source = this.service.browserWindow ? this.service.browserWindow.TabbrowserService.browser.selectedTab.getAttribute('tab-loadingURI') : null ;
		if (aLinkInfo.behavior < 0)
			aLinkInfo.behavior = (
					this.service.getPref('browser.tabs.opentabfor.outerlink.level') > 0 &&
					source &&
					!this.service.isSameHost(aLinkInfo.uri, source)
				) ? this.service.getPref('browser.tabs.opentabfor.links.outerBehavior') : -1 ;

		// normal
		aLinkInfo.normalClickAction = (
				!aLinkInfo.browser ||
				!tab ||
				!this.service.checkToLoadInCurrentTabOf(aLinkInfo.browser)
			);
		if (aLinkInfo.behavior < 0)
			aLinkInfo.behavior = aLinkInfo.normalClickAction ? this.service.getPref('browser.tabs.opentabfor.links.behavior') :
				-1 ;

		if (aLinkInfo.behavior < 0)
			aLinkInfo.behavior = 0;



		aLinkInfo.newTypeBrowserOpenWindow = false;

		if (
			this.service.isNewTypeBrowser &&
			(aEvent.type != 'click' || aEvent.button == 0) &&
			!aEvent.ctrlKey && !aEvent.metaKey &&
			(this.service.getPref('ui.key.saveLink.shift') ? aEvent.altKey : aEvent.shiftKey ) // save modifier
			)
			aLinkInfo.newTypeBrowserOpenWindow = true;

		// reverse behavior
		if (
			!aLinkInfo.newTabActionLocked &&
			this.service.isNewTypeBrowser &&
			aLinkInfo.newTypeBrowserOpenWindow &&
			!this.service.getPref('ui.key.saveLink.shift') &&
			aEvent.shiftKey &&
			(
				aLinkInfo.behavior > 0 ||
				this.service.winHookMode > 1
			)
			)
			aLinkInfo.newTypeBrowserOpenWindow = false;

		aLinkInfo.loadInBackground = (aLinkInfo.behavior == 2);
		if (aEvent.shiftKey &&
			!aLinkInfo.newTypeBrowserOpenWindow &&
			!aLinkInfo.newTabActionLocked)
			aLinkInfo.loadInBackground = !aLinkInfo.loadInBackground;
	},
 
	doLinkAction : function(aLinkInfo, aEvent) 
	{
		var i;
		var uri  = aLinkInfo.uri;
		var node = aLinkInfo.node;
		var b    = aLinkInfo.browser;
		var nav  = ('__tabextensions__browserWindow' in aEvent ? aEvent.__tabextensions__browserWindow : this.service.browserWindow );


		this.service.fireEventForModules('DoLinkAction_preProcess', aLinkInfo);


		// web panels (Sidebar)
		if (aLinkInfo.fieldNormalClicks &&
			(!aLinkInfo.target || aLinkInfo.target == '_content')) {
			if (aLinkInfo.node.getAttribute('onclick') ||
				aLinkInfo.uri.substr(0, 11) == 'javascript:')
				return true;

			if (aLinkInfo.behavior == 0) {
				this.service.stopEvent(aEvent);
				aLinkInfo.loadFlags = Components.interfaces.nsIWebNavigation.LOAD_FLAGS_NONE;
				this.loadLinkNormally(aLinkInfo);
				return true;
			}
		}


		if (
			( // sidebar features (Firefox)
				(aLinkInfo.target == '_search' || node.getAttribute('rel') == 'sidebar') &&
				!aLinkInfo.newTabActionMiddleClick &&
				!aEvent.shiftKey &&
				!aEvent.ctrlKey &&
				!aEvent.altKey &&
				!aEvent.metaKey
			) ||

			// special features of links
			!uri ||
			uri.match(/^(mailto|javascript):/) ||
			(aEvent.type == 'click' && aEvent.button > 1)
			) {
			if (uri.match(/^javascript:/)) {
				this.service.stopEvent(aEvent);
				this.loadLinkNormally(aLinkInfo);
				return true;
			}
			return __tabextensions__contentAreaClick(aEvent, aLinkInfo.fieldNormalClicks);
		}



		// FOLLOWING CODES ARE FOR NORMAL LINKS.

		var topWin = Components.lookupMethod(aLinkInfo.window, 'top').call(aLinkInfo.window);


		// in frames, ignore "open any link in new tab" feature for normal links.
		if (
			aLinkInfo.normalClickAction &&
			!aLinkInfo.realTarget &&
			topWin != aLinkInfo.window
			) {
			if (!aLinkInfo.referrerBlocked)
				return __tabextensions__contentAreaClick(aEvent, aLinkInfo.fieldNormalClicks);

			this.service.stopEvent(aEvent);
			this.loadLinkNormally(aLinkInfo);
			return true;
		}

		var postData = {};
		var convertedURI = ('getShortcutOrURI' in window) ? getShortcutOrURI(uri, postData) : uri ; // in Mail&Newsgroup, "getShortcutOrURI()" is not defined!!
		postData = 'value' in postData ? postData.value : null ;
		aLinkInfo.postData = postData;


		// If a tab (named by "TARGET") exists, then open the link in the tab.
		if (
			!this.service.getPref('browser.tabs.extensions.ignore_target') &&
			(
				(
					aLinkInfo.newTabActionTarget &&
					!aLinkInfo.newTabActionMiddleClick
				) ||
				( // Don't open new tab when the link aims to an existing tab/frame
					aLinkInfo.normalClickAction &&
					aLinkInfo.target &&
					aLinkInfo.target.toLowerCase() != '_blank'
				)
			)
			) {
			var browser;
			for (i = 0; i < b.mTabs.length; i++)
			{
				browser = b.mTabs[i].mBrowser;
				if (
					b.mTabs[i].browserName != aLinkInfo.target &&
					browser.contentDocument.defaultView.name != aLinkInfo.target
					) continue;

				this.service.uriSecurityCheck(uri, aLinkInfo.source);

				browser.webNavigation.loadURI(
					convertedURI,
					Components.interfaces.nsIWebNavigation.LOAD_FLAGS_IS_LINK,
					aLinkInfo.referrer,
					postData,
					null
				);

				browser.contentDocument.defaultView.opener = aLinkInfo.window;
				if (
					aLinkInfo.target &&
					!String(aLinkInfo.target).match(/^_(self|top|parent|content|blank)$/i) &&
					aLinkInfo.target != '_main'
					)
					browser.contentDocument.defaultView.name = aLinkInfo.target;

				if (!aLinkInfo.loadInBackground) {
					b.selectedTab = b.mTabs[i];
					b.scrollTabbarToTab(b.selectedTab);
					b.setFocusInternal();
				}

				(nav._content ? nav._content : nav ).focus();

				this.service.markLinkVisited(uri, node);

				// add the tab to the children list
				if (
					b.tabGroupsAvailable &&
					b.ownerDocument == document && // reject tabs opened by undocked sidebar and so on
					b.mTabs[i] != b.selectedTab // reject current tab
					)
					b.attachTabTo(b.mTabs[i], b.selectedTab, true);

				this.service.stopEvent(aEvent, true);
				return false;
			}
		}



		// load URI
		if (
			aLinkInfo.behavior == 0 &&
			(
				aLinkInfo.newTabActionTarget ||
				aLinkInfo.newTabActionMiddleClick ||
				aLinkInfo.referrerBlocked
			)
			) {
			aLinkInfo.uri = convertedURI;
			if (aEvent.shiftKey || aEvent.altKey)
				handleLinkClick(aEvent, uri, node);
			else // block referrer
				this.loadLinkNormally(aLinkInfo)

			this.service.stopEvent(aEvent);

			return false;
		}


		// open new tab
		if (
			aLinkInfo.behavior > 0 ||
			(aLinkInfo.newTypeBrowserOpenWindow && this.winHookMode > 0)
			) {
			this.service.stopEvent(aEvent, true);

			this.service.uriSecurityCheck(uri, aLinkInfo.source);

			var info = { openedFromTab : true };
			if (postData)
				info.postData = b.readPostStream(postData);

			// If the link has "TARGET", then the tab is named.
			info.browserName = (aLinkInfo.newTabActionTarget && !aLinkInfo.newTabActionMiddleClick) ? aLinkInfo.target : null ;

			if (this.service.getPref('browser.tabs.extensions.show_link_text_as_label')) {
				var label = this.service.getInnerTextOf(node) || '';
				info.fixedLabel = this.service.strbundle.GetStringFromName('loading_temp_label').replace(/%s/gi, label).replace(/\s+/g, ' ');
				info.fixedLabelAutoDestroy = true;
				if (this.service.getPref('browser.tabs.extensions.show_link_text_as_label_permanently'))
					info.nextFixedLabel = label;
			}

			// inherit status
			if (
				b.ownerDocument == document && // reject tabs opened by undocked sidebar and so on
				(
					!this.service.getPref('browser.tabs.extensions.inherit.onlySameSite') ||
					this.service.isSameHost(uri, aLinkInfo.source)
				)
				) {
				var props = [];
				if(this.service.getPref('browser.tabs.extensions.inherit.textZoom'))
					props.push('textZoom');
				if (this.service.getPref('browser.tabs.extensions.inherit.locked'))
					props.push('locked');
				if (this.service.getPref('browser.tabs.extensions.inherit.referrerBlocked'))
					props.push('referrerBlocked');
				if (this.service.getPref('browser.tabs.extensions.inherit.allow'))
					props = props.concat([
							'allowPlugins',
							'allowJavascript',
							'allowMetaRedirects',
							'allowSubframes',
							'allowImages'
						]);
				if (props.length) {
					info.uri = uri;
					for (i in props)
						info[props[i]] = b.selectedTab[props[i]];
				}
			}

			// add the tab to the children list
			if (
				b.tabGroupsAvailable &&
				b.ownerDocument == document // reject tabs opened by undocked sidebar and so on
				) {
				for (i = 0; i < b.mTabs.length; i++)
					if (Components.lookupMethod(aLinkInfo.window, 'top').call(aLinkInfo.window).document == b.mTabs[i].mBrowser.contentDocument) {
						info.parentTab = b.mTabs[i].tabId;
						info.openedAutomatically = aLinkInfo.causedByTargetAttribute || aLinkInfo.causedByLocked || aLinkInfo.causedByAlwaysNewTab ;

						var openIn = this.service.getPref('browser.tabs.extensions.open_tab_in_link');
						if (openIn > -1)
							info.openIn = openIn;
					}
			}

			var newTab = b.addTabInternal(uri, aLinkInfo.referrer, info);

			if (aLinkInfo.causedByTargetAttribute) {
				newTab.mBrowser.contentDocument.defaultView.opener = aLinkInfo.window;
				if (
					aLinkInfo.target &&
					!String(aLinkInfo.target).match(/^_(self|top|parent|content|blank)$/i) &&
					aLinkInfo.target != '_main'
					)
					newTab.mBrowser.contentDocument.defaultView.name = aLinkInfo.target;
			}

			if (!aLinkInfo.loadInBackground) {
				b.selectedTab = newTab;
				b.scrollTabbarToTab(b.selectedTab);
				b.setFocusInternal();
			}

			if (!this.service.loadInBackgroundWindow)
				(nav._content ? nav._content : nav ).focus();

			this.service.markLinkVisited(uri, node);

			return false;
		}


		aLinkInfo.retVal = __tabextensions__contentAreaClick(aEvent, aLinkInfo.fieldNormalClicks);
		aLinkInfo.DOMEvent = aEvent;

		this.service.fireEventForModules('DoLinkAction_postProcess', aLinkInfo);


		return aLinkInfo.retVal;
	},
  
	loadLinkNormally : function(aLinkInfo) 
	{
		this.service.uriSecurityCheck(aLinkInfo.uri, aLinkInfo.source);
try{

		var topWin = Components.lookupMethod(aLinkInfo.window, 'top').call(aLinkInfo.window);
		var docShell;
		var target = aLinkInfo.window;
		var tab;
		var newWin = false;
		var done   = false;

		if (aLinkInfo.realTarget == '_self') {
		}
		else if (aLinkInfo.realTarget == '_parent' && topWin != window) {
			target = Components.lookupMethod(target, 'parent').call(target) || topWin ;
		}
		else if (
			aLinkInfo.browser &&
			aLinkInfo.browser.localName == 'tabbrowser' &&
			(tab = aLinkInfo.browser.getTabByTabId(aLinkInfo.tabId)) &&
			topWin != tab.mBrowser.contentDocument.defaultView
			) { // sidebar or others
			docShell = tab.mBrowser.docShell;
		}
		else if (aLinkInfo.realTarget.match(/^_(main|top|content)$/)) {
			target = topWin;
		}
		else if (aLinkInfo.realTarget) {
			docShell = tab.mBrowser.docShell;

			if (aLinkInfo.realTarget != '_blank') {
				docShell = docShell.QueryInterface(Components.interfaces.nsIDocShellTreeNode);
				if (docShell.findChildWithName.arity == 4) // Firefox 1.0 or before
					docShell = docShell.findChildWithName(
						aLinkInfo.realTarget,
						true,
						true,
						docShell
					);
				else // Firefox 1.1 or later?
					docShell = docShell.findChildWithName(
						aLinkInfo.realTarget,
						true,
						true,
						docShell,
						docShell
					);
			}

			newWin = !this.service.getPref('browser.block.target_new_window');
		}

		if (newWin && !docShell) {
			var nsIBrowserDOMWindow = 'nsIBrowserDOMWindow' in Components.interfaces ? Components.interfaces.nsIBrowserDOMWindow : 'nsIBrowserWindow' in Components.interfaces ? Components.interfaces.nsIBrowserWindow : null ;

			// 1 = current, 2 = new window, 3 = new tab
			var loadIn = 1;
			if (!nsIBrowserDOMWindow) {
				if (
					this.service.winHookMode > 0 ||
					this.service.getPref('browser.tabs.opentabfor.links.targetBehavior') > 0
					)
					loadIn = 3;
				else
					loadIn = 2;
			}
			else {
				switch (this.service.getPref('browser.link.open_newwindow'))
				{
					case nsIBrowserDOMWindow.OPEN_NEWWINDOW:
						if (
							this.service.winHookMode < 1 &&
							this.service.getPref('browser.tabs.opentabfor.links.targetBehavior') < 1
							) {
							loadIn = 2;
							break;
						}
					case nsIBrowserDOMWindow.OPEN_NEWTAB:
						loadIn = 3;
						break;
					default:
					case nsIBrowserDOMWindow.OPEN_CURRENTWINDOW:
						break;
				}
			}

			switch (loadIn)
			{
				case 2:
					window.openDialog(
						this.service.browserURI,
						'_blank',
						'chrome,all,dialog=no',
						aLinkInfo.uri,
						null,
						(aLinkInfo.referrerBlocked ? null : aLinkInfo.referrer )
					);
					docShell = true;
					done     = true;
					break;

				case 3:
					var newTab = gBrowser.addTabInternal(
									aLinkInfo.uri,
									(aLinkInfo.referrerBlocked ? null : aLinkInfo.referrer ),
									{
										openedFromTab : true,
										browserName : aLinkInfo.target,
										postData    : (('postData' in aLinkInfo ? aLinkInfo.postData : null ) ? gBrowser.readPostStream(aLinkInfo.postData) : null )
									}
								);

					var newWindow = newTab.mBrowser.docShell
								.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
								.getInterface(Components.interfaces.nsIDOMWindow);

					var name = aLinkInfo.target;
					var win  = aLinkInfo.window;
					window.setTimeout(
						function() {
							newWindow.name   = name;
							newWindow.opener = aLinkInfo.window;
							if (gBrowser.tabGroupsAvailable) {
								var doc = Components.lookupMethod(win, 'document').call(win);
								for (var i = 0; i < gBrowser.mTabs.length; i++)
								{
									if (gBrowser.mTabs[i].mBrowser.contentDocument != doc)
										continue;
									newTab.parentTab = gBrowser.mTabs[i];
									break;
								}
							}
						},
						10
					);

					if (!aLinkInfo.loadInBackground)
						gBrowser.selectedTab = newTab;
					if (!this.service.loadInBackgroundWindow)
						window.focus();

					docShell = true;
					done     = true;
					break;

				default:
					break;
			}
		}

		if (!done || !docShell) {
			if (!docShell)
				docShell = target
					.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
					.getInterface(Components.interfaces.nsIWebNavigation)
					.QueryInterface(Components.interfaces.nsIDocShell);

			docShell.QueryInterface(Components.interfaces.nsIWebNavigation)
				.loadURI(
					aLinkInfo.uri,
					(
						'loadFlags' in aLinkInfo ? aLinkInfo.loadFlags :
							Components.interfaces.nsIWebNavigation.LOAD_FLAGS_IS_LINK
					),
					(aLinkInfo.referrerBlocked ? null : aLinkInfo.referrer ),
					('postData' in aLinkInfo ? aLinkInfo.postData : null ),
					null
				);

			if (aLinkInfo.realTarget &&
				docShell.QueryInterface(Components.interfaces.nsIWebNavigation).contentWindow != aLinkInfo.window &&
				!aLinkInfo.loadInBackground) {
				var tab = gBrowser.selectedTab;
				for (var i = 0; i < gBrowser.mTabs.length; i++)
				{
					if (gBrowser.mTabs[i].mBrowser.contentDocument.defaultView != topWin)
						continue;

					tab = gBrowser.mTabs[i];
					break;
				}

				gBrowser.selectedTab = tab;
				gBrowser.scrollTabbarToTab(gBrowser.selectedTab);
				gBrowser.setFocusInternal();
			}
		}

}
catch(e){
	if (this.service.debug)
		alert('@TabbrowserOverlay.loadLinkNormally()\n'+e);
}
		this.service.markLinkVisited(aLinkInfo.originalURI, aLinkInfo.node);
	},
 
	handleLinkClick : function(aEvent, aURI, aNode) 
	{
		var retVal = __tabextensions__handleLinkClick(aEvent, aURI, aNode);

		var saveClick = (aEvent.button == 0 && (TabbrowserService.getPref('ui.key.saveLink.shift') ? aEvent.shiftKey : aEvent.altKey ));
		var nullClick = (aEvent.button == 0 && aEvent.altKey);

		if (aEvent.button < 2 &&
			(!retVal || (retVal && !saveClick && !nullClick)))
			TabbrowserService.markLinkVisited(aURI, aNode);

		return retVal;
	},
 
	messagePaneOnClick : function(aEvent) 
	{
		// ignore simple click, because new browser has been opened by customized contentAreaClick().
		var uri = hrefForClickEvent(aEvent);
		if (uri &&
			uri.match(/^(https?|ftp|file|gopher|chrome|resource|about):/i) &&
			aEvent.button == 0 &&
			!aEvent.metaKey &&
			!aEvent.ctrlKey &&
			!aEvent.shiftKey &&
			!aEvent.altKey) {
			TabbrowserService.stopEvent(aEvent);
		}

		window.__tabextensions__messagePaneOnClick(aEvent);
	},
  
	// Location Bar 
	
	BrowserLoadURL : function(aEvent, aPostData, aOriginalURI, aSearchURL) 
	{
		var TS = TabbrowserService;

		var uri    = aSearchURL || gURLBar.value;
		var b      = TS.browser;
		var id     = aEvent ? aEvent.target.id || aEvent.target.parentNode.id : '' ;
		// Firefox 1.0PR hands "textbox" element inside of the searchbar as the event target,instead of the sarachbar element itself. Why?

		var newTabAction = !aEvent ? false :
							TS.isNewTypeBrowser ? aEvent.altKey :
							(aEvent.ctrlKey || aEvent.metaKey);

		if (aSearchURL) // for Firefox 1.0 or later
			id = 'searchbar';

		var behavior;
		var modifierKeyEnterBehavior;
		var foreignDomainBehavior;
		switch (id)
		{
			case 'searchbar': // Firefox 1.0 or later
			case 'search-bar': // old Firefox
				behavior = TS.getPref('browser.tabs.opentabfor.searchbar.behavior');
				modifierKeyEnterBehavior = TS.getPref('browser.tabs.opentabfor.searchbar.modifierKeyEnterBehavior');
				foreignDomainBehavior = TS.getPref('browser.tabs.opentabfor.searchbar.foreignDomainBehavior');

				break;

			default:
				behavior = TS.getPref('browser.tabs.opentabfor.urlbar.behavior');
				modifierKeyEnterBehavior = TS.getPref('browser.tabs.opentabfor.urlbar.modifierKeyEnterBehavior');
				foreignDomainBehavior = TS.getPref('browser.tabs.opentabfor.urlbar.foreignDomainBehavior');
				break;
		}


		if (uri.match(/^view-source:/))
			return window.__tabextensions__BrowserLoadURL(aEvent);


		var uriWithKeyword = String(aOriginalURI) || uri;
		uri = getShortcutOrURI(uri, {});

		var info     = null,
			referrer = null;

		// when this is a keyword
		if (uri != uriWithKeyword) {
			var bookmarkRes = TS.getBookmarkResourceFromKeyword(uriWithKeyword.substring(0, uriWithKeyword.indexOf(' ')), uri);
			if (bookmarkRes) {
				id = bookmarkRes.Value;

				referrer = TS.getReferrerForBookmark(id) || null ;

				info = {
					uri        : uri,
					fixedLabel : TS.getFixedLabelForBookmark(id),
					textZoom   : TS.getTextZoomForBookmark(id),
					bookmarkID : id
				};

				if (!info.fixedLabel && TS.getPref('browser.tabs.extensions.show_link_text_as_label')) {
					var name = TS.getNameForBookmark(id) || '';
					info.fixedLabelAutoDestroy = true;
					info.fixedLabel = TS.strbundle.GetStringFromName('loading_temp_label').replace(/%s/gi, name).replace(/\s+/g, ' ');
					if (TS.getPref('browser.tabs.extensions.show_link_text_as_label_permanently'))
						info.nextFixedLabel = name;
				}

				if (TS.shouldSaveBookmarksStatus)
					info = TS.loadBookmarkStatus(id, info);
			}
		}


		if (newTabAction)
			behavior = modifierKeyEnterBehavior;
		else if (foreignDomainBehavior > -1) {
			var isSameHost = true;
			try {
				var fixedURI = TS.fixupURI(uri);
				isSameHost = (
							fixedURI.indexOf('about:') < 0 &&
							b.currentURI.spec.indexOf('about:') < 0
						) ? TS.makeURIFromSpec(fixedURI).host == b.currentURI.host :
							(!fixedURI.indexOf('about:') && !b.currentURI.spec.indexOf('about:'));
			}
			catch(e) {
//				alert(e);
			}
			if (!isSameHost)
				behavior = foreignDomainBehavior;
		}

		var t;
		if (TS.preventSameURLTab) {
			var testURI = TS.fixupURI(uri);
			if (testURI) uri = testURI;

			for (var i = 0; i < b.mTabs.length; i++)
			{
				if (b.mTabs[i].getAttribute('tab-loadingURI') != uri) continue;

				t = b.mTabs[i];

				TS.popupAlert(TS.strbundle.GetStringFromName('status_same_uri_tab_exists'));

				t.mBrowser.webNavigation.loadURI(
					uri,
					Components.interfaces.nsIWebNavigation.LOAD_FLAGS_REPLACE_HISTORY,
					referrer,
					aPostData || null,
					null
				);
				if (info)
					t.mBrowser.initTabWithTabInfo(t, info);

				var loadInBackground = behavior == 2;
				if (aEvent.shiftKey) loadInBackground = !loadInBackground;

				if (!loadInBackground) {
					b.userTypedValue = null;
					b.selectedTab    = t;
					b.scrollTabbarToTab(b.selectedTab);
				}
				break;
			}
		}

		if (!t) {
			if (behavior > 0 && !b.selectedTab.isReallyBlank) {
				if (!info) info = {};
				if (aPostData)
					info.postData = b.readPostStream(aPostData);

				t = b.addTabInternal(uri, referrer, info);
				gURLBar.value = uri;

				var loadInBackground = behavior == 2;
				if (aEvent.shiftKey) loadInBackground = !loadInBackground;

				if (!loadInBackground) {
					b.userTypedValue = null;
					b.selectedTab    = t;
					b.scrollTabbarToTab(b.selectedTab);
				}
			}
			else if (behavior > -1) {
				b.webNavigation.loadURI(
					uri,
					Components.interfaces.nsIWebNavigation.LOAD_FLAGS_NONE,
					referrer,
					aPostData || null,
					null
				);
				if (info)
					b.initTabWithTabInfo(b.selectedTab, info);
				t = b.selectedTab;
			}
		}

		if (aEvent) TS.stopEvent(aEvent);

		if (t) {
			b.setFocusInternal();
			_content.focus();
		}

		return true;
	},
 
	SearchLoadURL : function(aURL, aTriggeringEvent) // for Firefox 1.0 or later 
	{
		return BrowserLoadURL(aTriggeringEvent, null, null, aURL);
	},
 
	handleURLBarCommand : function(aEvent) 
	{
		var originalURI = gURLBar.value
		var postData = {};
		if ('canonizeUrl' in window) canonizeUrl(aEvent, postData);
		try {
			if ('addToUrlbarHistory' in window) addToUrlbarHistory();
		}
		catch(e) {
		}
		TabbrowserOverlay.BrowserLoadURL(
			aEvent,
			('value' in postData ? postData.value : null ),
			originalURI
		);
	},
  
	// Toolbars (Firefox) 
	
	insertItem : function(aId, aBeforeElt, aWrapper, aBeforePermanent) 
	{
		var ret = this.__tabextensions__insertItem(aId, aBeforeElt, aWrapper, aBeforePermanent);

		// dispatch "TSToolbarItemInserted" event
		var event = document.createEvent('Events');
		event.initEvent('TSToolbarItemInserted', false, true);
		event.targetItem = ret ? ret : null ;
		this.dispatchEvent(event);

		return ret;
	},
  
	// Bookmarks 
	
	openBookmarkURL : function(aNode, aDataSource, aEvent, aRoot) 
	{
		var TS   = TabbrowserService,
			TO   = TabbrowserOverlay,
			type = (aEvent ? aEvent.type : 'command' ),
			node = aNode;
		var url  = (node) ? node.id :
					(aEvent) ? aEvent.target.id :
					null ;

		if (
			aEvent && type == 'click' &&
			(
				aEvent.button != 1 ||
				TS.getPref('browser.tabs.opentabfor.bookmarks.middleClickBehavior') < 0
			)
			)
			return;

		// "Open in Tabs" in folders
		if (
			url == 'openintabs-menuitem' ||
			node.getAttribute('class') == 'openintabs-menuitem'
			) {
			TS.openBookmark(aEvent.target.parentNode.parentNode.id, aEvent, 'folder-as-group', null);
			return;
		}

		// Mozilla for MacOS has a bug...it handles a wrong event from the menubar.
		if (navigator.platform.indexOf('Mac') > -1 &&
			aEvent.ctrlKey &&
			aEvent.altKey &&
			aEvent.metaKey) {
			aEvent = {
				type     : aEvent.type,
				button   : aEvent.button,
				ctrlKey  : false,
				metaKey  : false,
				altKey   : false,
				shiftKey : false,
				target   : aEvent.target
			};
		}

		if (!TS.openBookmark(url, aEvent)) return;

		if (!node) return;
		var parent = node.parentNode;
		while (parent && parent != aRoot)
		{
			if ('hidePopup' in parent)
				parent.hidePopup();
			else if ('closePopup' in parent)
				parent.closePopup();

			parent = parent.parentNode;
		}
	},
 
	// open bookmark groups in Firefox 
	openGroupBookmark : function(aURI, aTargetBrowser)
	{
		var TS = TabbrowserService;
		var resource = TS.RDF.GetResource(aURI);

		if (aTargetBrowser == 'window') {
			var w = window.openDialog(TS.browserURI, '_blank', 'chrome,all,dialog=no', null, null, null, resource);
			w.addEventListener(
				'load',
				function(aEvent)
				{
					aEvent.target.TabbrowserService.openBookmarkGroup(aEvent.target.arguments[3]);
				},
				false
			);
		}
		else
			TS.openBookmarkGroup(resource, TS.BookmarksDS);
	},
 
	// Bookmarks Tree 
	
	// in Bookmarks Tree 
	openBookmarkItem : function(aEvent, aInNewWindow, aOpenGroups)
	{
		var groupRes      = this.rdf.GetResource(this.NC_NS + 'FolderGroup');
		var groupTarget   = this.db.GetTarget(this.currentRes, groupRes, true);

		var TS = TabbrowserService;

		var browserWindow = TS.browserWindow;

		var rdf = TS.RDF;
		var db  = TS.BookmarksDatabase;

		try {
			var middleclick  = aEvent && (
						aEvent.button == 1 ||
						(aEvent.button == 0 && (aEvent.ctrlKey || aEvent.metaKey))
					);
			var normalBehavior      = TS.getPref('browser.tabs.opentabfor.bookmarks.behavior');
			var middleClickBehavior = TS.getPref('browser.tabs.opentabfor.bookmarks.middleClickBehavior');


			// actions not to open the bookmark in new tab
			var otherAction = (
						!aEvent || // "Open" or "Open in New Window" selected in the context menu
						(groupTarget && (!aOpenGroups || aEvent.detail > 1)) ||
						(!groupTarget && this.treeBoxObject.view.isContainer(this.treeBoxObject.view.selection.currentIndex)) ||
						aEvent.altKey || //  open property
						aInNewWindow //  open in window compulsory
					);

			// action to open the bookmark in new tab
			var openTabAction = (
					middleClickBehavior > 0 &&
					middleclick &&
					(
						normalBehavior < 1 ||
						TS.shouldOpenBookmarkGroup(this.currentRes)
					)
				);
			if (browserWindow)
				openTabAction = (
						openTabAction ||
						(
						!middleclick &&
						normalBehavior > 0 &&
						!TS.shouldOpenBookmarkGroup(this.currentRes) &&
						!TS.checkToLoadInCurrentTabOf(browserWindow.gBrowser)
						)
					);

			// open the folder as a group
			if (openTabAction &&
				TS.shouldOpenBookmarkGroup(this.currentRes))
				return TS.openBookmarkGroup(this.currentRes, this.db);

			if ((otherAction || !openTabAction) &&
				aEvent && aEvent.type.match(/click/) && aEvent.button > 1) {
				aEvent.preventBubble();
				return true;
			}


			if (
				TS.isBookmarkFolder(this.currentRes) ||
				!aEvent // from the context menu
				)
				return this.__tabextensions__openItem(aEvent, aInNewWindow, aOpenGroups);

			var urlValue = db.GetTarget(this.currentRes, TS.kNC_URL, true);
			if (!urlValue) return false;

			urlValue = urlValue.QueryInterface(TS.knsIRDFLiteral).Value;
			if (!urlValue || urlValue.substring(0,3) == 'NC:') return false;

			if (!browserWindow)
				return window.openDialog(TS.browserURI, '_blank', 'chrome,all,dialog=no', urlValue, null, null);

			TS.openBookmark(urlValue, aEvent, (otherAction || !openTabAction) ? 'current' : 'tab', sel.parent[0]);
		}
		catch(e) {
		}

		if (aEvent) aEvent.preventBubble();
		return true;
	},
	
	validOpenClickConditions : function(aEvent) 
	{
		if (
			aEvent.button > 1 ||
			aEvent.originalTarget.localName != 'treechildren' ||
			(
				aEvent.button == 1 &&
				TabbrowserService.getPref('browser.tabs.opentabfor.bookmarks.middleClickBehavior') < 0
			)
			)
			return false;

		var row = {};
		var col = {};
		var obj = {};
		this.treeBoxObject.getCellAt(aEvent.clientX, aEvent.clientY, row, col, obj);
		if (row.value == -1 || obj.value == 'twisty')
			return false;

		return true;
	},
  
	// in Bookmarks Tree (new implementation, Firefox) 
	openBookmarkItemClickOrKey : function(aEvent, aClickCount)
	{
		var TS = TabbrowserService;

		if (
			(aEvent && !this.validOpenClickConditions(aEvent)) ||
			(aClickCount != this.clickCount && aEvent && aEvent.button != 1)
			)
			return false;

		var browserWindow = TS.browserWindow;
		var rdf = TS.RDF;
		var db  = TS.BookmarksDatabase;

		// for new implementation
		var sel = this._selection;
		var res = sel ? rdf.GetResource(sel.item[0].Value) : this.currentRes ;

		try {
			var middleclick  = aEvent && (
						aEvent.button == 1 ||
						(aEvent.button == 0 && (aEvent.ctrlKey || aEvent.metaKey))
					);
			var normalBehavior      = TS.getPref('browser.tabs.opentabfor.bookmarks.behavior');
			var middleClickBehavior = TS.getPref('browser.tabs.opentabfor.bookmarks.middleClickBehavior');


			// actions not to open the bookmark in new tab
			var otherAction = (
						!aEvent || // "Open" or "Open in New Window" selected in the context menu
//						aEvent.detail > 1 ||
						(sel && sel.type[0] != 'Bookmark') || // new implementation
						( // old implementation: clicking folders
							this.treeBoxObject.view.selection &&
							this.treeBoxObject.view.isContainer(this.treeBoxObject.view.selection.currentIndex)
						) ||
						aEvent.altKey // open property
					);

			// action to open the bookmark in new tab
			var openTabAction = (
					middleClickBehavior > 0 &&
					middleclick &&
					(
						normalBehavior < 1 ||
						TS.shouldOpenBookmarkGroup(res)
					)
				);
			if (browserWindow)
				openTabAction = (
						openTabAction ||
						(
						!middleclick &&
						normalBehavior > 0 &&
						!TS.shouldOpenBookmarkGroup(res) &&
						!TS.checkToLoadInCurrentTabOf(browserWindow.gBrowser)
						)
					);


			// open the folder as a group
			if (openTabAction &&
				TS.shouldOpenBookmarkGroup(res))
				return TS.openBookmarkGroup(res, db);


			if ((otherAction || !openTabAction) &&
				aEvent && aEvent.type.match(/click/) && aEvent.button > 1) {
				aEvent.preventBubble();
				return true;
			}


			if (
				TabbrowserService.isBookmarkFolder(res) ||
				!aEvent // from the context menu
				) {
				return ('__tabextensions__openItemClick' in this) ? (aEvent ? this.__tabextensions__openItemClick(aEvent, aClickCount) : this.__tabextensions__openItemKey() ) : this.__tabextensions__openItem(aEvent, aClickCount) ;
			}

			var urlValue = db.GetTarget(res, TS.kNC_URL, true);
			if (!urlValue) return false;

			urlValue = urlValue.QueryInterface(TS.knsIRDFLiteral).Value;
			if (!urlValue || urlValue.substring(0,3) == 'NC:') return false;

			if (!browserWindow)
				return window.openDialog(TS.browserURI, '_blank', 'chrome,all,dialog=no', urlValue, null, null);

			TabbrowserService.openBookmark((sel ? sel.item[0].Value : urlValue ), aEvent, (otherAction || !openTabAction) ? 'current' : 'tab', sel.parent[0]);
		}
		catch(e) {
//			alert('@TabbrowserOverlay.openBookmarkItemClickOrKey()\n'+e); // In some environments, "Type Error: this.getBrowserForTab(aTab).currentURI has no properties" error appears (but works fine). Why?
		}

		if (aEvent) aEvent.preventBubble();
		return true;
	},
  
	// BookmarksUtils 
	
	addBookmark : function(aURI, aTitle, aCharset, aShowDialogOrIsWebPanel) 
	{
		// use fixed label instead of the title
		var nav = TabbrowserService.browserWindow;
		var b   = nav ? nav.TabbrowserService.browser : null ;
		if (b &&
			b.selectedTab &&
			b.selectedTab.getAttribute('tab-loadingURI') == aURI &&
			b.selectedTab.getAttribute('tab-fixedLabel'))
			aTitle = b.selectedTab.getAttribute('tab-fixedLabel');

		this.__tabextensions__addBookmark(aURI, aTitle, aCharset, aShowDialogOrIsWebPanel);
	},
 
	createBookmark : function(aName, aURI, aCharSet, aDefaultName) 
	{
		// use fixed label instead of the title (for drag'n'drop)
		var nav = TabbrowserService.browserWindow;
		var b   = nav ? nav.TabbrowserService.browser : null ;
		if (b &&
			b.selectedTab &&
			b.selectedTab.getAttribute('tab-loadingURI') == aURI &&
			b.selectedTab.getAttribute('tab-fixedLabel') &&
			b.selectedTab.getAttribute('tab-fixedLabel') == aDefaultName)
			aName = b.selectedTab.getAttribute('tab-fixedLabel');

		return this.__tabextensions__createBookmark(aName, aURI, aCharSet, aDefaultName);
	},
  
	// BookmarksMenu 
	
	loadBookmark : function(aEvent, aTarget, aDatabase) 
	{
		TabbrowserOverlay.openBookmarkURL(aTarget, aDatabase, aEvent, aEvent.currentTarget);
	},
 
	loadBookmarkMiddleClick : function(aEvent, aDatabase) 
	{
		TabbrowserOverlay.openBookmarkURL(aEvent.target, aDatabase, aEvent, aEvent.currentTarget);
	},

  
	// BookmarksCommand 
	
	BookmarksCommandOpenBookmark : function(aSelection, aOpenType, aDataSource) 
	{
		if (!aOpenType) return;

		var type;
		for (var i = 0; i < aSelection.length; i++)
		{
			type = aSelection.type[i];
			if (!type || type == 'Bookmark')
				TabbrowserService.openBookmark(aSelection.item[i].Value, null, aOpenType, aSelection.parent[i]);
			else if (type.match(/^(FolderGroup|Folder|PersonalToolbarFolder)$/))
				TabbrowserService.openBookmarkGroup(aSelection.item[i].Value, aDataSource);
		}
	},
 
	BookmarksCommandCreateContextMenu : function(aEvent, aSelection) 
	{
		this.__tabextensions__createContextMenu(aEvent, aSelection);

		var TS    = TabbrowserService,
			popup = aEvent.target;

		var newTabItem = popup.getElementsByAttribute('command', 'cmd_bm_openinnewtab');
		if (!newTabItem.length)
			newTabItem = popup.getElementsByAttribute('cmd', 'http://home.netscape.com/NC-rdf#command?cmd=bm_openinnewtab');
		if (!newTabItem.length)
			return;

		var node;

		if (TS.getPref('browser.tabs.extensions.showNewActiveTabItem.bookmarks') &&
			TS.getPref('browser.tabs.extensions.loadInBackgroundBookmarks')) {
			node = popup.insertBefore(document.createElement('menuitem'), newTabItem[0].nextSibling);
			node.setAttribute('label', TS.strbundle.GetStringFromName('openBookmarkInNewActiveTab_label'));
			node.setAttribute('accesskey', TS.strbundle.GetStringFromName('openBookmarkInNewActiveTab_accesskey'));
			node.setAttribute('oncommand', 'TabbrowserService.openBookmark((\'BookmarksMenu\' in window ? BookmarksMenu._selection.item[0].Value : this.parentNode.parentNode._selection.item[0].Value ), null, \'newactivetab\');');
		}

		if (TS.getPref('browser.tabs.opentabfor.bookmarks.behavior') > 0) {
			newTabItem[0].hidden = true;
			if (TS.getPref('browser.tabs.extensions.showThisTabItem.bookmarks')) {
				node = popup.insertBefore(document.createElement('menuitem'), newTabItem[0].nextSibling);
				node.setAttribute('label', TS.strbundle.GetStringFromName('openBookmarkInThisTab_label'));
				node.setAttribute('accesskey', TS.strbundle.GetStringFromName('openBookmarkInThisTab_accesskey'));
				node.setAttribute('oncommand', 'TabbrowserService.openBookmark((\'BookmarksMenu\' in window ? BookmarksMenu._selection.item[0].Value : this.parentNode.parentNode._selection.item[0].Value ), null, \'current\');');
			}
		}
		else {
			newTabItem[0].hidden = false;
		}
	},
  
	addBookmarkForTabBrowser : function(aTabBrowser, aSelect) 
	{
		var info = [];
		var currentInfo;

		var tabs = aTabBrowser.mTabs;
		var b;
		var doc;
		for (var i = 0; i < tabs.length; i++)
		{
			b = tabs[i].mBrowser;
			try {
				doc = b.contentDocument;
			}
			catch(e) {
				doc = null;
			}
			info[i] = {
				name    : (doc ? doc.title : '' ) || b.currentURI.spec,
				url     : b.currentURI.spec,
				charset : (doc ? doc.characterSet : null )
			};

			if (tabs[i] == aTabBrowser.selectedTab)
				currentInfo = info[i];
		}
		if (!TabbrowserService.isNewTypeBrowser)
			window.openDialog(
				'chrome://communicator/content/bookmarks/addBookmark.xul',
				'',
				'centerscreen,chrome,dialog,resizable,dependent',
				currentInfo.name,
				currentInfo.url,
				null,
				currentInfo.charset,
				'addGroup' + (aSelect ? ',group' : ''),
				info
			);
		else
			window.openDialog(
				'chrome://browser/content/bookmarks/addBookmark2.xul',
				'',
				'centerscreen,chrome,dialog,resizable,dependent',
				currentInfo.name,
				currentInfo.url,
				null,
				currentInfo.charset,
				'addGroup' + (aSelect ? ',group' : ''),
				info
			);
	},
 
	// favicon 
	// original code is in the file "chrome://browser/content/bookmrks/bookmarks.js" (of Trunk 20050323)
	bookmarksFavIconLoadListenerOnStopRequest : function(aRequest, aContext, aStatusCode)
	{
		var isLocalFile = this.mFavIconURL.indexOf('file:') == 0;
		var httpChannel = this.mChannel.QueryInterface(isLocalFile ? Components.interfaces.nsIFileChannel : Components.interfaces.nsIHttpChannel );
		if (
			httpChannel &&
			(isLocalFile ?
				(
					httpChannel.file.exists() &&
					httpChannel.file.isFile() &&
					httpChannel.file.isReadable()
				) :
				httpChannel.requestSucceeded
			) &&
			Components.isSuccessCode(aStatusCode) &&
			this.mCountRead > 0
			) {
			var dataurl;
			if (this.mCountRead > 16384) {
				dataurl = 'data:';
			}
			else {
				var mimeType = null;

				const nsICategoryManager = Components.interfaces.nsICategoryManager;
				const nsIContentSniffer = Components.interfaces.nsIContentSniffer;

				var catMgr = Components.classes['@mozilla.org/categorymanager;1'].getService(nsICategoryManager);
				var sniffers = catMgr.enumerateCategory('content-sniffing-services');
				while (mimeType == null && sniffers.hasMoreElements())
				{
					var snifferCID = sniffers.getNext().QueryInterface(Components.interfaces.nsISupportsCString).toString();
					var sniffer = Components.classes[snifferCID].getService(nsIContentSniffer);

					try {
						mimeType = sniffer.getMIMETypeFromContent(this.mBytes, this.mCountRead);
					}
					catch(e) {
						mimeType = null;
					}
				}
			}

			if (mimeType == null) {
				BMSVC.updateBookmarkIcon(this.mURI, null, null, 0);
			}
			else {
				BMSVC.updateBookmarkIcon(this.mURI, mimeType, this.mBytes, this.mCountRead);
			}
		}

		this.mChannel = null;
	},
  
	// History 
	
	OpenURL : function(aWhereOrInNewTabFlag, aEvent) 
	{
		var inNewTab = (typeof aWhereOrInNewTabFlag != 'number') ? aWhereOrInNewTabFlag : (aWhereOrInNewTabFlag > 1) ;
		if (typeof inNewTab == 'string')
			inNewTab = (inNewTab == 'tab' || inNewTab == 'window');

		var TS = TabbrowserService;

		var currentIndex = gHistoryTree.currentIndex;
		var count        = ('selection' in gHistoryTree.treeBoxObject ? gHistoryTree.treeBoxObject.selection : gHistoryTree.view.selection).count; // "view.selection" is for 1.8a or later. "treeBoxObject.selection" is for 1.7x.

		var behavior = inNewTab ? TS.getPref('browser.tabs.opentabfor.history.middleClickBehavior') :
						!TS.checkToLoadInCurrentTabOf(TS.browserWindow.TabbrowserService.browser) ? TS.getPref('browser.tabs.opentabfor.history.behavior' ) :
						0;

		if (
			!TS.browserWindow ||
			count != 1 ||
			isContainer(gHistoryTree, currentIndex)
			) {
			if (behavior < 0)
				return false;
			else
				return __tabextensions__OpenURL(aWhereOrInNewTabFlag, aEvent);
		}

		if (behavior < 0) return false;


		var builder = gHistoryTree.builder.QueryInterface(Components.interfaces.nsIXULTreeBuilder);
		var uri = builder.getResourceAtIndex(currentIndex).Value;
		var b = TS.browserWindow.TabbrowserService.browser;

		if (behavior == 0) {
			TS.browserWindow.loadURI(uri);
			b.setFocusInternal();
		}
		else if (behavior > 0) {
			var t = b.addTab(uri);
			if (behavior == 1) {
				b.selectedTab = t;
				b.scrollTabbarToTab(t);
				b.setFocusInternal();
			}
		}

		if (!TS.loadInBackgroundWindow)
			TS.browserWindow.focus();

		return true;
	},
 
	openURL : function(aEvent) // for Firefox 1.1 or later? 
	{
		var TS = TabbrowserService;
		var behavior = (
				aEvent.button == 1 ||
				(
					aEvent.button == 0 &&
					(aEvent.ctrlKey || aEvent.metaKey)
				)
			) ? TS.getPref('browser.tabs.opentabfor.history.middleClickBehavior') :
				TS.getPref('browser.tabs.opentabfor.history.behavior') ;

		var b = TS.browserWindow ? TS.browserWindow.gBrowser : null ;


//		if (behavior < 0) return __tabextensions__openURL(aEvent);
		if (behavior < 0) return false;


		var count = gHistoryTree.view.selection.count;
		if (count != 1)
			return;

		var currentIndex = gHistoryTree.currentIndex;
		if (isContainer(gHistoryTree, currentIndex))
			return;

		var builder = gHistoryTree.builder.QueryInterface(Components.interfaces.nsIXULTreeBuilder);
		var uri = builder.getResourceAtIndex(currentIndex).ValueUTF8;

		if (!checkURLSecurity(uri))
			return;

		if (behavior > 0 && !TS.checkToLoadInCurrentTabOf(b)) {
			var t = b.addTab(uri);
			if (t && behavior == 1) {
				b.selectedTab = t;
				b.scrollTabbarToTab(t);
				b.setFocusInternal();
			}
		}
		else {
			TS.browserWindow.loadURI(uri);
		}

		if (!TS.loadInBackgroundWindow)
			TS.browserWindow.focus();
	},
 
	historyOnClick : function(aEvent) 
	{
		var TS = TabbrowserService;

		var currentIndex = gHistoryTree.currentIndex;
		var count        = ('selection' in gHistoryTree.treeBoxObject ? gHistoryTree.treeBoxObject.selection : gHistoryTree.view.selection).count; // "view.selection" is for 1.8a or later. "treeBoxObject.selection" is for 1.7x.

		var b = TS.browserWindow ? TS.browserWindow.TabbrowserService.browser : null ;

		var middleClick = (
				aEvent.button == 1 ||
				(
					aEvent.button == 0 && (aEvent.ctrlKey || aEvent.metaKey)
				)
			);
		var behavior = middleClick ? TS.getPref('browser.tabs.opentabfor.history.middleClickBehavior') :
				(
					aEvent.button == 0 &&
					!aEvent.shiftKey &&
					!aEvent.ctrlKey &&
					!aEvent.altKey &&
					!aEvent.metaKey &&
					!TS.checkToLoadInCurrentTabOf(b)
				) ? TS.getPref('browser.tabs.opentabfor.history.behavior' ) :
				0;

		if (
			!b ||
			count != 1 ||
			isContainer(gHistoryTree, currentIndex)
			) {
			if (behavior < 0)
				return false;
			else
				return __tabextensions__historyOnClick(aEvent);
		}


		if (behavior < 0) return false;


		var builder = gHistoryTree.builder.QueryInterface(Components.interfaces.nsIXULTreeBuilder);
		var uri = builder.getResourceAtIndex(currentIndex).Value;

		if (behavior == 0) {
			TS.browserWindow.loadURI(uri);
		}
		else {
			var t = b.addTab(uri);
			if (behavior == 1) {
				b.selectedTab = t;
				b.scrollTabbarToTab(t);
				b.setFocusInternal();
			}
		}

		if (!TS.loadInBackgroundWindow)
			TS.browserWindow.focus();
	},
 
	gotoHistoryIndex : function(aEvent, aIndex, aNode) 
	{
		var index = aIndex || aEvent.target.getAttribute('index');
		if (!index) return false;

		var TS   = TabbrowserService,
			TO   = TabbrowserOverlay,
			node = aNode || aEvent.target;

		if (aEvent.type == 'click' && aEvent.button != 1) return false;


		// Mozilla for MacOS has a bug...it handles a wrong event from the menubar.
		if (navigator.platform.indexOf('Mac') > -1 &&
			aEvent.ctrlKey &&
			aEvent.altKey &&
			aEvent.metaKey) {
			aEvent = {
				type     : aEvent.type,
				button   : aEvent.button,
				ctrlKey  : false,
				metaKey  : false,
				altKey   : false,
				shiftKey : false,
				target   : aEvent.target
			};
		}


		try {
			var b = TS.browser;

			var behavior = (aEvent.type != 'click') ? 0 :
				(
					aEvent.button == 1 ||
					(aEvent.button == 0 && (aEvent.ctrlKey || aEvent.metaKey))
				) ? TS.getPref('browser.tabs.opentabfor.goToHistoryIndex.middleClickBehavior') :
					TS.checkToLoadInCurrentTabOf(b) ? TS.getPref('browser.tabs.opentabfor.goToHistoryIndex.behavior') :
					0;

			if (index == 'back')
				b.goBackGroup();
			else if (index == 'forward')
				b.goForwardGroup();
			else if (behavior > 0) {
				var SH = null;
				try {
					SH = b.sessionHistory;
				}
				catch(ex) {
					return false;
				}

				var entry = SH.getEntryAtIndex(index, false);
				if (!entry) return false;

				entry = entry.QueryInterface(Components.interfaces.nsISHEntry);
				var t = b.addTab(entry.URI.spec, entry.referrerURI);

				if (behavior == 1) {
					b.selectedTab = t;
					b.scrollTabbarToTab(b.selectedTab);
					b.setFocusInternal();
				}
			}
			else if (behavior == 0)
				b.webNavigation.gotoIndex(index);
			else
				return false;
		}
		catch(e) {
			return false;
		}


		if (node) {
			var parent = node;
			while (parent)
			{
				if ('hidePopup' in parent)
					parent.hidePopup();
				else if ('closePopup' in parent)
					parent.closePopup();

				parent = parent.parentNode;
			}
		}
		return true;
	},
  
	// Web Search 
	OpenSearch : function(aTabName, aSearchStr, aFromContextMenu, aForceDialogFlag)
	{
		/*
			The original third argument is a flag to open the result
			in a new window or tab, but the flag is used only from the
			context menu.
			So, I regard the flag that this function is called from
			the context menu.
			This function is based on Firefox Trunk 20050313.
		*/
		var TS = TabbrowserService;
		var w  = TS.browserWindow;


		var defaultSearchURL = null;
		var navigatorRegionBundle = window.gNavigatorRegionBundle || // Mozilla Suite
				document.getElementById('bundle_browser_region'); // Firefox
		var fallbackDefaultSearchURL = navigatorRegionBundle.getString('fallbackDefaultSearchURL');

		var urlmatch= /(:\/\/|^ftp\.)[^ \S]+$/;
		var forceAsURL = urlmatch.test(aSearchStr);

		try {
			defaultSearchURL = TS.getPref('browser.search.defaulturl', Components.interfaces.nsIPrefLocalizedString);
		}
		catch (e) {
		}

		// Fallback to a default url (one that we can get sidebar search results for)
		if (!defaultSearchURL)
			defaultSearchURL = fallbackDefaultSearchURL;

		if (!aSearchStr) {
			BrowserSearchInternet();
		}
		else if (forceAsURL) {
			 BrowserLoadURL(null, null);
		}
		else if ( // only for Mozilla Suite
			!TS.isNewTypeBrowser &&
			(
				aForceDialogFlag ||
				TS.getPref('browser.search.powermode') == 1
			)
			) {
			var searchWindow = TS.windowManager.getMostRecentWindow('search:window');
			if (!searchWindow) {
				openDialog('chrome://communicator/content/search/search.xul', 'SearchWindow', 'dialog=no,close,chrome,resizable', aTabName, aSearchStr);
			}
			else {
				searchWindow.focus();

				if ('loadPage' in searchWindow)
					searchWindow.loadPage(aTabName, aSearchStr);
			}
		}
		else if (aSearchStr) {
			var escapedSearchStr = encodeURIComponent(aSearchStr);
			defaultSearchURL += escapedSearchStr;
			var searchDS = Components.classes['@mozilla.org/rdf/datasource;1?name=internetsearch']
					.getService(Components.interfaces.nsIInternetSearchService);

			searchDS.RememberLastSearchText(escapedSearchStr);
			try {
				var searchBox = w ? (w.document.getElementById('searchbar') || w.document.getElementById('search-bar')) : null ;
				var useSearchBox = searchBox && TS.getPref('browser.tabs.opentabfor.contextsearch.useSearchBox');

				var searchEngineURI = useSearchBox ? searchBox.mTextbox.currentEngine :
						TS.getPref('browser.search.defaultengine');
				if (searchEngineURI) {
					var searchURL = 'getSearchUrl' in window ? getSearchUrl('actionButton') : null ;
					if (!useSearchBox && searchURL) {
						defaultSearchURL = searchURL + escapedSearchStr;
					}
					else {
						searchURL = searchDS.GetInternetSearchURL(searchEngineURI, escapedSearchStr, 0, 0, { value: 0 });
						if (searchURL)
							defaultSearchURL = searchURL;
					}
				}
			}
			catch (e) {
			}


			var behavior = !aFromContextMenu ? 0 :
					TS.getPref('browser.tabs.opentabfor.contextsearch.behavior');
			if (behavior < 0)
				behavior = !TS.isNewTypeBrowser ? 3 :
							TS.loadInBackground ? 2 :
							1 ;

			var info = null;
			if (behavior == 1 || behavior == 2) {
				info = { openedFromTab : true };

				if (TS.getPref('browser.tabs.extensions.show_link_text_as_label')) {
					var label = aSearchStr;
					info.fixedLabel = TS.strbundle.GetStringFromName('loading_temp_label').replace(/%s/gi, label).replace(/\s+/g, ' ');
					info.fixedLabelAutoDestroy = true;
					if (TS.getPref('browser.tabs.extensions.show_link_text_as_label_permanently'))
						info.nextFixedLabel = label;
				}

				if (w.gBrowser.tabGroupsAvailable) {
					info.parentTab           = gBrowser.selectedTab.tabId;
					info.openedAutomatically = false;

					var openIn = TS.getPref('browser.tabs.extensions.open_tab_in_link');
					if (openIn > -1)
						info.openIn = openIn;
				}
			}

			switch (behavior)
			{
				case 0:
					w.loadURI(defaultSearchURL, null, null);
					break;
				case 1:
					w.gBrowser.selectedTab = w.gBrowser.addTabInternal(defaultSearchURL, null, info);
					break;
				case 2:
					w.gBrowser.addTabInternal(defaultSearchURL, null, info);
					break;
				case 3:
					window.openDialog(TabbrowserService.browserURI, '_blank', 'chrome,all,dialog=no', defaultSearchURL);
					break;

				default:
					break;
			}
		}

		if (!TS.isNewTypeBrowser &&
			TS.getPref('browser.search.opensidebarsearchpanel') &&
			'RevealSearchPanel' in window)
			RevealSearchPanel();
	},
 
	// view source 
	
	viewSourceOf : function() 
	{
		if (!arguments || !arguments.length) return false;

		var w,
			uri,
			args,
			onload,
			target,
			targetURI,
			parentTab;
		var TS = TabbrowserService;

		var root = TS.isNewTypeBrowser ? 'chrome://global/content/' : 'chrome://navigator/content/' ;

		switch (arguments[0])
		{
			case 'document':
				var doc = arguments[1];
				var nav;
				try {
					w = doc.defaultView;
					if(w == window) w = _content;
					nav = w.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
							.getInterface(Components.interfaces.nsIWebNavigation);
				}
				catch(e) {
					nav = TS.browser.webNavigation;
				}

				var cookie = null;
				try{
					var pageLoader = nav.QueryInterface(Components.interfaces.nsIWebPageDescriptor);
					cookie = pageLoader.currentDescriptor;
				}
				catch(e) {
				}

				uri  = root+'viewSource.xul?url='+escape(nav.currentURI.spec);
				args = [
					nav.currentURI.spec,
					'charset='+doc.characterSet,
					cookie
				];
				onload    = 'onLoadViewSource();'
				target    = targetURI = nav.currentURI.spec;
				parentTab = TS.browser.selectedTab;
				break;

			case 'uri':
				uri  = root+'viewSource.xul?url='+escape(arguments[1]);
				args = [
					arguments[1],
					arguments[2],
					arguments[3]
				];
				onload    = 'onLoadViewSource();'
				target    = targetURI = arguments[1];
				parentTab = null;
				break;

			case 'partial':
				var context = arguments[1];
				w = document.commandDispatcher.focusedWindow || _content ;

				var reference;
				switch (context)
				{
					case 'selection':
						reference = w.__proto__.getSelection.call(w);
						targetURI = [
							'data:text/html;charset=utf-8,',
							encodeURIComponent(TS.getSelectionSource(w))
						].join('');
						break;
					case 'mathml':
						reference = document.popupNode;
						targetURI = [
							'data:text/html;charset=utf-8,',
							encodeURIComponent(this.getPartialSourceOf(reference, context))
						].join('');
						break;
					default:
						throw 'not reached';
				}

				uri  = root+'viewPartialSource.xul?url='+escape(w.location.href);
				args = [
					null,
					'charset='+w.document.characterSet,
					reference,
					context
				];
				onload    = 'onLoadViewPartialSource();'
				target    = w.location.href;
				parentTab = TS.browser.selectedTab;
				break;

			default:
				return false;
		}

		var label = TS.strbundle.GetStringFromName('view_source_label').replace(/%s/gi, target);

		var b        = TS.browser;
		var t        = b.addTab(uri);
		var listener = function()
			{
				t.mBrowser.removeEventListener('load', listener, true);
				t.mBrowser.contentDocument.documentElement.removeAttribute('onload');
				t.mBrowser.contentWindow.onload = function() {};

				t.mBrowser.contentWindow.arguments = args;
				t.mBrowser.contentWindow.setTimeout(onload, 0);

				t.mBrowser.sessionHistory.QueryInterface(Components.interfaces.nsISHistoryInternal).replaceEntry(
					0,
					b.createSHEntryFromInfo({
						uri              : 'view-source:'+targetURI,
						title            : label,
						isSubFrame       : false,
						saveLayoutState  : true,
						expirationStatus : true,
						loadType         : 2,
						x                : 0,
						y                : 0
					})
				);
			};
		t.mBrowser.addEventListener('load', listener, true);

		t.mBrowser.userTypedValue = 'view-source:'+target;

		if (!TS.getPref('browser.tabs.extensions.loadInBackgroundViewSource'))
			b.selectedTab = t;

		b.setFixedLabelFor(t, label, 'ANY');
		if (parentTab)
			t.parentTab = parentTab;

		return true;
	},
 
	getPartialSourceOf : function(aNode, aContext) // see viewPartialSource.js 
	{
		var node = aNode;
		if (aNode && aNode.nodeType == Node.TEXT_NODE)
			node = node.parentNode;

		var topTag;
		switch (aContext)
		{
			case 'mathml':
				topTag = 'math';
				break;
			default:
				throw 'not reached';
		}
		while (node && node.localName != topTag)
			node = node.parentNode;

		if (!node) return '';

		var w   = node.ownerDocument.defaultView;
		var sel = w.__proto__.getSelection.call(w);

		sel.removeAllRanges();

		var range = w.document.createRange();
		range.setStart(node, 0);
		range.setEnd(node, node.childNodes.length);

		sel.addRange(range);

		return TabbrowserService.getSelectionSource(w, null, sel);
	},
    
	// nsContextMenu 
	
	initItems : function() 
	{
		this.__tabextensions__initItems();

		var TS = TabbrowserService;

		var b = /*TS.popupNodeOwnerBrowser ||*/ TS.browser ;

		var onLinks              = false,
			onLinksWithoutMailto = false,
			isSingleWindow       = false,
			tab                  = null,
			tabs                 = [];

		var showOpenInActiveTab = TS.getPref('browser.tabs.extensions.showNewActiveTabItem.links') && TS.getPref('browser.tabs.opentabfor.links.behavior') == 2;
		var showOpenInThisTab = TS.getPref('browser.tabs.extensions.showThisTabItem.links') && (
			TS.getPref('browser.tabs.opentabfor.links.behavior') > 0 ||
			(
				TS.getPref('browser.tabs.opentabfor.outerlink.level') > 0 &&
				this.link &&
				!TS.isSameHost(this.linkURL(), this.link.ownerDocument.defaultView.location.href)
			) ||
			(
				(
					TS.winHookMode > 0 ||
					TS.getPref('browser.tabs.opentabfor.links.targetBehavior') > 0
				) &&
				(
					TS.getPref('browser.link.open_newwindow') === null ? !TS.getPref('browser.block.target_new_window') : (TS.getPref('browser.link.open_newwindow') == 1)
				) &&
				TabbrowserOverlay.getTargetForLink(this.link).name
			)
		);
		var showOpenAllLinksInTabs = TS.getPref('browser.tabs.extensions.show_context.openAllLinksInTabs');
		var showOpenAllLinksInGroup = TS.getPref('browser.tabs.extensions.show_context.openAllLinksInGroup');
		var showBookmarkAllLinksAsGroup = TS.getPref('browser.tabs.extensions.show_context.bookmarkAllLinksAsGroup');
		var showBookmarkTabGroup = TS.getPref('browser.tabs.extensions.show_context.bookmarkTabGroup');

		if (showOpenAllLinksInTabs ||
			showOpenAllLinksInGroup ||
			showBookmarkAllLinksAsGroup) {
			try {
				var links = TS.getSelectionLinks();
				onLinks = (links.length > 1);

				for (var i = links.length-1; i > -1; i--)
					if (links[i].uri.match(/^mailto:/))
						links.splice(1, 1);
				onLinksWithoutMailto = (links.length > 1);

				isSingleWindow = TS.winHookMode == 2;

				tab  = (b) ? b.selectedTab : null ;
				if (tab) {
					if (!tab.hasChildTabs() && tab.parentTab)
						tab = tab.parentTab;
					tabs = tab.allChildTabs;
					tabs.unshift(tab);
				}
			}
			catch(e) {
				alert('@TabbrowserOverlay.initItems()\n'+e);
			}
		}


		this.showItem('context-openlink', (this.onSaveableLink || ( this.inDirList && this.onLink )) && !isSingleWindow);

		this.showItem('context-openLinkInNewActiveTab', this.onLink && showOpenInActiveTab);
		this.showItem('context-openLinkInThisTab', this.onLink && showOpenInThisTab);

		this.showItem('context-sep-openAllLinksInGroup', onLinks && !this.onLink && showOpenAllLinksInTabs);
		this.showItem('context-openAllLinksInTabs', onLinks && !this.onLink && showOpenAllLinksInTabs);
		this.showItem('context-openAllLinksInGroup', onLinks && !this.onLink && showOpenAllLinksInGroup && TS.isGroupMode);

		this.showItem('context-openAllLinksInTabs-onLink', onLinks && this.onLink && showOpenAllLinksInTabs);
		this.showItem('context-openAllLinksInGroup-onLink', onLinks && this.onLink && showOpenAllLinksInGroup && TS.isGroupMode);
		this.showItem('context-sep-open', (onLinks && this.onLink && (showOpenAllLinksInTabs || showOpenAllLinksInGroup)) || this.onSaveableLink || ( this.inDirList && this.onLink ) );


		this.showItem('context-sep-bookmarkAllLinksAsGroup', onLinksWithoutMailto && showBookmarkAllLinksAsGroup);
		this.showItem('context-bookmarkAllLinksAsGroup', onLinksWithoutMailto && !this.onLink && showBookmarkAllLinksAsGroup);
		this.showItem('context-bookmarkAllLinksAsGroup-onLink', onLinksWithoutMailto && this.onLink && showBookmarkAllLinksAsGroup);

		this.showItem('context-bookmarkTabGroup', b && TS.browser.tabGroupsAvailable && !(this.isTextSelected || this.onTextInput) && tabs.length > 1 && showBookmarkTabGroup);
	},
 
	onContentAreaContextMenuShowing : function(aEvent) 
	{
		var TS = TabbrowserService;
		if (!TS) return true;

		var b = TS.browser; //TS.popupNodeOwnerBrowser;
		if (!b || !b.isBlank) return true;

		// popup a small menu instead of the normal
		aEvent.preventDefault();

		var p = b.selectedTab.mBrowser;
		TS.popupMenu('tabextensions-blankWindow-contextMenu', b.mMouseDownX-p.boxObject.screenX, b.mMouseDownY-p.boxObject.screenY, p);

		return false;
	},
  
	// General Functions 
	
	BrowserOpenTab : function() 
	{
		if ('gInPrintPreviewMode' in window && window.gInPrintPreviewMode)
			return;

		var TS = TabbrowserService;
		var b  = TS.browser;

		// 0 = blank, 1 = home, 2 = last, -1 = inherit
		var startup = TS.getPref('browser.tabs.loadOnNewTab');
		if (startup === null) // for 1.4a or earlier
			startup = TS.getPref('browser.tabs.extensions.startup.page');

		if (startup == -1 ||
			startup == 100) /* old implementation (for 1.4a or earlier) */
			startup = (TS.isNewTypeBrowser) ? 1 : TS.getPref('browser.startup.page') ;

		var uri = 'about:blank';

		var replaceURI = null;
		switch (startup)
		{
			default:
			case 0:
				if (!TS.getPref('browser.tabs.extensions.clear_location_bar'))
					replaceURI = b.currentURI.spec;
				else
					replaceURI = '';
				break;

			case 1:
				uri = 'getHomePage' in window ? getHomePage() :
						'gHomeButton' in window && 'getHomePage' in gHomeButton ? gHomeButton.getHomePage() :
						'about:blank' ;
				if (typeof uri != 'string')
					uri = uri[0];
				if (TS.isNewTypeBrowser && uri.match(/.\|./))
					uri = uri.split('|')[0];

				if (uri == 'about:blank' &&
					TS.getPref('browser.tabs.extensions.clear_location_bar'))
					replaceURI = '';

				break;

			case 2:
				uri = b.currentURI.spec;
				break;
		}

		b.selectedTab = b.addTab(uri);
		b.scrollTabbarToTab(b.selectedTab);

		window.setTimeout(TabbrowserOverlay.BrowserOpenTabCallBack, 0, replaceURI, uri);
	},
	BrowserOpenTabCallBack : function(aShouldBeDisplayedURI, aLoadedURI)
	{
		if (aShouldBeDisplayedURI !== null)
			gURLBar.value = aShouldBeDisplayedURI;

		var navBar = document.getElementById('nav-bar');
		if (aLoadedURI == 'about:blank' &&
			!navBar.hidden &&
			window.locationbar.visible)
			window.setTimeout('Components.lookupMethod(gURLBar, \'focus\').call(gURLBar);', 0);
		else
			gBrowser.setFocusInternal();
	},
 
	BrowserCloseTabOrWindow : function() 
	{
		var browser = TabbrowserService.browser;
		if (
			browser &&
			browser.localName == 'tabbrowser' &&
			browser.canRemoveCurrentTab()
			) {
			browser.removeCurrentTab();
			return;
		}

		if (!TabbrowserService.getPref('browser.tabs.extensions.close_only_tab'))
			BrowserCloseWindow();
	},
 
	openNewTabWith_old : function(aURI, aShouldSendReferrer, aReverseBackgroundPref) 
	{
		urlSecurityCheck(aURI, document);

		var loadInBackground = TabbrowserService.loadInBackground;
		if (aReverseBackgroundPref)
			loadInBackground = !loadInBackground;

		TabbrowserService.openLinkInNewTab(aURI, TabbrowserService.getLastActiveLink(), !loadInBackground);
	},
	
	openNewTabWith : function(aURI, aLinkNode, aEventOrFlag, aSecurityCheckOrEvent, aPostData) 
	{ // OrFlag/OrEvent is for 0.4 before
		if (typeof aSecurityCheckOrEvent == 'boolean' &&
			aSecurityCheckOrEvent)
			urlSecurityCheck(aURI, document);

		var event = (typeof aEventOrFlag == 'object') ? aEventOrFlag : aSecurityCheckOrEvent ;

		var loadInBackground = aLinkNode ? (TabbrowserService.getPref('browser.tabs.opentabfor.links.behavior') == 2 || TabbrowserService.getPref('browser.tabs.opentabfor.links.middleClickBehavior') == 2) : TabbrowserService.loadInBackground ;
		if (event && event.shiftKey)
			loadInBackground = !loadInBackground;

		TabbrowserService.openLinkInNewTab(aURI, aLinkNode, !loadInBackground, aPostData);
	},
  
	openNewWindowWith_old : function(aURI, aShouldSendReferrer) 
	{
		urlSecurityCheck(aURI, document);

		var charsetArg = null;
		if (TabbrowserService.isBrowserWindow)
			charsetArg = 'charset=' + window._content.document.characterSet;

		var referrer = aShouldSendReferrer && TabbrowserService.shouldSendReferrerWithLinkClick() ? getReferrer(document) : null;
		window.openDialog(TabbrowserService.browserURI, '_blank', 'chrome,all,dialog=no', aURI, charsetArg, referrer);

		TabbrowserService.markLinkVisited(aURI, TabbrowserService.getLastActiveLink());
	},
	
	openNewWindowWith : function(aURI, aLinkNode, aSecurityCheck, aPostData) 
	{
		if (aSecurityCheck)
			urlSecurityCheck(aURI, document);

		var charsetArg = null;
		if (TabbrowserService.isBrowserWindow)
			charsetArg = 'charset=' + window._content.document.characterSet;

		var referrer = TabbrowserService.shouldSendReferrerWithLinkClick() ? getReferrer(document) : null;
		window.openDialog(TabbrowserService.browserURI, '_blank', 'chrome,all,dialog=no', aURI, charsetArg, referrer, aPostData);

		TabbrowserService.markLinkVisited(aURI, aLinkNode);
	},
  
	// Tab Selection 
	ctrlNumberTabSelection : function(aEvent)
	{
		if (aEvent.altKey && aEvent.keyCode == KeyEvent.DOM_VK_RETURN) { // for WinXP
			aEvent.preventDefault();
			return;
		}

		var index = aEvent.charCode - 49,
			b     = TabbrowserService.browser;

		if (
			(
				navigator.platform.match(/mac/i) ? !aEvent.metaKey :
				navigator.platform.match(/unix|linux/i) ? !aEvent.altKey :
				!aEvent.ctrlKey
			) ||
//			!(TabbrowserService.isNewTypeBrowser || aEvent.shiftKey) || // firebird:ctrl+num, mozilla:ctrl+shift+num
			index < 0 || index > 9 || index >= b.mTabs.length // out of range
			)
			return;

		var oldTab = b.selectedTab;
		var newTab = b.mTabs[index];
		if (newTab != oldTab) {
			oldTab.selected = false;
			b.selectedTab = newTab;
			b.scrollTabbarToTab(b.selectedTab);
			b.setFocusInternal();
		}

		TabbrowserService.stopEvent(aEvent);

		return;
	},
 
	goQuitApplication : function() 
	{
		var w = TabbrowserService.browserWindows;
		for (var i in w)
			w[i].TabbrowserService.onQuit = true;

		window.__tabextensions__goQuitApplication();
	}
  
}; 

 
// Listeners 
	
var gTSToolbarItemsInsertedEventListener = function(aEvent, aId) 
{
	if (!aEvent && !aId) return;

	var node = aId ? document.getElementById(aId) : aEvent.targetItem ;
	if (!node) return;

	switch (node.id)
	{
		case 'back-button':
			node.setAttribute('onclick', 'if (event.target != this) gotoHistoryIndex(event); event.preventBubble();');
			break;

		case 'forward-button':
			node.setAttribute('onclick', 'if (event.target != this) gotoHistoryIndex(event); event.preventBubble();');
			break;

		default:
			break;
	}
};
 
var gTSOpentabforLinksPrefListener = 
{
	domains : [
		'browser.tabs.opentabfor.links',
		'browser.block.target_new_window',
		'browser.tabs.opentabfor.middleclick'
	],
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;
		var TS = TabbrowserService;

		switch (aPrefName)
		{
			case 'browser.tabs.opentabfor.links.targetBehavior':
			case 'browser.block.target_new_window':
				if (
					!TS.getPref('browser.block.target_new_window') &&
					TS.getPref('browser.tabs.opentabfor.links.targetBehavior') > -1
					)
					TS.setPref('browser.block.target_new_window', true);
				break;

			case 'browser.tabs.opentabfor.links.middleClickBehavior':
			case 'browser.tabs.opentabfor.middleclick':
				if (TS.getPref('browser.tabs.opentabfor.middleclick') != (TS.getPref('browser.tabs.opentabfor.links.middleClickBehavior') > 0))
					TS.setPref('browser.tabs.opentabfor.middleclick', TS.getPref('browser.tabs.opentabfor.links.middleClickBehavior') > 0);
				break;

			default:
				break;
		}
	}
};
  
// end of definition 

if (!window.TabbrowserServiceModules)
	window.TabbrowserServiceModules = [];

TabbrowserServiceModules.push(TabbrowserOverlay);
}
 