/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.CallGraphWindow;
import edu.uoregon.tau.paraprof.CallPathTextWindow;
import edu.uoregon.tau.paraprof.FunctionDataWindow;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.PPThread;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfImageInterface;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.StatWindow;
import edu.uoregon.tau.paraprof.ThreadDataWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class FunctionDataWindowPanel
extends JPanel
implements ActionListener,
MouseListener,
Printable,
ParaProfImageInterface {
    private ParaProfTrial ppTrial = null;
    private FunctionDataWindow window = null;
    private Vector list = null;
    private Function function = null;
    private int barHeight = -1;
    private int barSpacing = -1;
    private int baseBarLength = 250;
    private int barLength = 0;
    private int textOffset = 60;
    private int barXCoord = 0;
    private int lastHeaderEndPosition = 0;
    int xPanelSize = 0;
    int yPanelSize = 0;
    private JPopupMenu popup1 = new JPopupMenu();
    private JPopupMenu popup2 = new JPopupMenu();
    private JPopupMenu popup3 = new JPopupMenu();
    private Object clickedOnObject = null;

    public FunctionDataWindowPanel(ParaProfTrial paraProfTrial, Function function, FunctionDataWindow functionDataWindow) {
        this.ppTrial = paraProfTrial;
        this.window = functionDataWindow;
        this.function = function;
        this.barLength = this.baseBarLength;
        this.setBackground(Color.white);
        this.addMouseListener(this);
        JMenuItem jMenuItem = new JMenuItem("Show Mean Statistics Window");
        jMenuItem.addActionListener(this);
        this.popup1.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Mean Call Path Thread Relations");
        jMenuItem.addActionListener(this);
        this.popup1.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Mean Call Graph");
        jMenuItem.addActionListener(this);
        this.popup1.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Statistics Window");
        jMenuItem.addActionListener(this);
        this.popup2.add(jMenuItem);
        if (paraProfTrial.userEventsPresent()) {
            jMenuItem = new JMenuItem("Show User Event Statistics Window");
            jMenuItem.addActionListener(this);
            this.popup2.add(jMenuItem);
        }
        jMenuItem = new JMenuItem("Show Call Path Thread Relations");
        jMenuItem.addActionListener(this);
        this.popup2.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Thread Call Graph");
        jMenuItem.addActionListener(this);
        this.popup2.add(jMenuItem);
        jMenuItem = new JMenuItem("Change Function Color");
        jMenuItem.addActionListener(this);
        this.popup3.add(jMenuItem);
        jMenuItem = new JMenuItem("Reset to Generic Color");
        jMenuItem.addActionListener(this);
        this.popup3.add(jMenuItem);
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.renderIt((Graphics2D)graphics, true, false, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            this.window.closeThisWindow();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.xPanelSize, this.yPanelSize);
            this.renderIt((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            new ParaProfErrorDialog(exception);
            return 1;
        }
    }

    public void renderIt(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) throws ParaProfException {
        Object object;
        Object object2;
        this.list = this.window.getData();
        int n = 0;
        int n2 = 0;
        this.barXCoord = this.barLength + this.textOffset;
        this.ppTrial.getPreferences().setBarDetails(graphics2D);
        this.barSpacing = this.ppTrial.getPreferences().getBarSpacing();
        this.barHeight = this.ppTrial.getPreferences().getBarHeight();
        Font font = new Font(this.ppTrial.getPreferences().getParaProfFont(), this.ppTrial.getPreferences().getFontStyle(), this.barHeight);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        double d = this.window.getMaxValue();
        if (this.window.isPercent()) {
            n = fontMetrics.stringWidth(UtilFncs.getOutputString((int)0, (double)d, (int)6) + "%");
            this.barXCoord += n;
        } else {
            n = fontMetrics.stringWidth(UtilFncs.getOutputString((int)this.window.units(), (double)d, (int)ParaProf.defaultNumberPrecision));
            this.barXCoord += n;
        }
        if (this.resizePanel(fontMetrics, this.barXCoord) && bl) {
            this.revalidate();
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (!bl2) {
            Rectangle rectangle;
            if (bl) {
                rectangle = graphics2D.getClipBounds();
                n3 = (int)rectangle.getY();
                n4 = (int)((double)n3 + rectangle.getHeight());
            } else {
                rectangle = this.window.getViewRect();
                n3 = (int)rectangle.getY();
                n4 = (int)((double)n3 + rectangle.getHeight());
            }
            n5 = (n3 - n2) / this.barSpacing - 1;
            n6 = (n4 - n2) / this.barSpacing + 1;
            if (n5 < 0) {
                n5 = 0;
            }
            if (n6 < 0) {
                n6 = 0;
            }
            if (n5 > this.list.size() - 1) {
                n5 = this.list.size() - 1;
            }
            if (n6 > this.list.size() - 1) {
                n6 = this.list.size() - 1;
            }
            if (bl) {
                n2 += n5 * this.barSpacing;
            }
        } else {
            n5 = 0;
            n6 = this.list.size() - 1;
        }
        boolean bl4 = this.function.isGroupMember(this.ppTrial.getColorChooser().getHighlightedGroup());
        if (bl3) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            object2 = this.getInsets();
            String string = this.window.getHeaderString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "'\n'");
            while (stringTokenizer.hasMoreTokens()) {
                object = new AttributedString(stringTokenizer.nextToken());
                ((AttributedString)object).addAttribute(TextAttribute.FONT, font);
                AttributedCharacterIterator attributedCharacterIterator = ((AttributedString)object).getIterator();
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                float f = this.getSize().width - ((Insets)object2).left - ((Insets)object2).right;
                float f2 = ((Insets)object2).left;
                float f3 = ((Insets)object2).right;
                while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                    TextLayout textLayout = lineBreakMeasurer.nextLayout(f);
                    textLayout.draw(graphics2D, f2, n2 += this.barSpacing);
                    f2 = ((Insets)object2).left;
                }
            }
            this.lastHeaderEndPosition = n2 += this.barSpacing;
        }
        int n7 = n5;
        while (n7 <= n6) {
            object2 = (PPFunctionProfile)this.list.elementAt(n7);
            double d2 = ParaProfUtils.getValue((PPFunctionProfile)object2, this.window.getValueType(), this.window.isPercent());
            object = ((PPFunctionProfile)object2).getNodeID() == -1 ? "mean" : "n,c,t " + ((PPFunctionProfile)object2).getNodeID() + "," + ((PPFunctionProfile)object2).getContextID() + "," + ((PPFunctionProfile)object2).getThreadID();
            this.drawBar(graphics2D, fontMetrics, d2, d, (String)object, this.barXCoord, n2 += this.barSpacing, this.barHeight, bl4);
            ++n7;
        }
    }

    private void drawBar(Graphics2D graphics2D, FontMetrics fontMetrics, double d, double d2, String string, int n, int n2, int n3, boolean bl) {
        int n4 = 0;
        double d3 = 0.0;
        String string2 = null;
        int n5 = 0;
        int n6 = 0;
        d3 = d / d2;
        n4 = (int)(d3 * (double)this.barLength);
        if (n4 == 0) {
            n4 = 1;
        }
        if (n4 > 2 && n3 > 2) {
            graphics2D.setColor(this.function.getColor());
            graphics2D.fillRect(n - n4 + 1, n2 - n3 + 1, n4 - 1, n3 - 1);
            if (this.function == this.ppTrial.getColorChooser().getHighlightedFunction()) {
                graphics2D.setColor(this.ppTrial.getColorChooser().getHighlightColor());
                graphics2D.drawRect(n - n4, n2 - n3, n4, n3);
                graphics2D.drawRect(n - n4 + 1, n2 - n3 + 1, n4 - 2, n3 - 2);
            } else if (bl) {
                graphics2D.setColor(this.ppTrial.getColorChooser().getGroupHighlightColor());
                graphics2D.drawRect(n - n4, n2 - n3, n4, n3);
                graphics2D.drawRect(n - n4 + 1, n2 - n3 + 1, n4 - 2, n3 - 2);
            } else {
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(n - n4, n2 - n3, n4, n3);
            }
        } else {
            if (this.function == this.ppTrial.getColorChooser().getHighlightedFunction()) {
                graphics2D.setColor(this.ppTrial.getColorChooser().getHighlightColor());
            } else if (this.function.isGroupMember(this.ppTrial.getColorChooser().getHighlightedGroup())) {
                graphics2D.setColor(this.ppTrial.getColorChooser().getGroupHighlightColor());
            } else {
                graphics2D.setColor(this.function.getColor());
            }
            graphics2D.fillRect(n - n4, n2 - n3, n4, n3);
        }
        graphics2D.setColor(Color.black);
        string2 = this.window.isPercent() && this.window.getValueType() <= 4 ? UtilFncs.getOutputString((int)0, (double)d, (int)6) + "%" : UtilFncs.getOutputString((int)this.window.units(), (double)d, (int)ParaProf.defaultNumberPrecision);
        n5 = fontMetrics.stringWidth(string2);
        n6 = n - n4 - n5 - 5;
        graphics2D.drawString(string2, n6, n2);
        graphics2D.drawString(string, n + 5, n2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            PPFunctionProfile pPFunctionProfile = null;
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Mean Statistics Window")) {
                    StatWindow statWindow = new StatWindow(this.ppTrial, -1, -1, -1, this.window.getDataSorter(), false);
                    this.ppTrial.getSystemEvents().addObserver(statWindow);
                    statWindow.show();
                } else if (string.equals("Show Mean User Event Statistics Window")) {
                    if (this.clickedOnObject instanceof PPFunctionProfile) {
                        pPFunctionProfile = (PPFunctionProfile)this.clickedOnObject;
                        StatWindow statWindow = new StatWindow(this.ppTrial, pPFunctionProfile.getNodeID(), pPFunctionProfile.getContextID(), pPFunctionProfile.getThreadID(), this.window.getDataSorter(), true);
                        this.ppTrial.getSystemEvents().addObserver(statWindow);
                        statWindow.show();
                    }
                } else if (string.equals("Show Mean Call Path Thread Relations")) {
                    if (this.clickedOnObject instanceof PPFunctionProfile) {
                        pPFunctionProfile = (PPFunctionProfile)this.clickedOnObject;
                        CallPathTextWindow callPathTextWindow = new CallPathTextWindow(this.ppTrial, pPFunctionProfile.getNodeID(), pPFunctionProfile.getContextID(), pPFunctionProfile.getThreadID(), this.window.getDataSorter(), 1);
                        this.ppTrial.getSystemEvents().addObserver(callPathTextWindow);
                        callPathTextWindow.show();
                    }
                } else if (string.equals("Show Mean Call Graph")) {
                    PPThread pPThread = (PPThread)this.clickedOnObject;
                    CallGraphWindow callGraphWindow = new CallGraphWindow(this.ppTrial, pPThread.getThread());
                    this.ppTrial.getSystemEvents().addObserver(callGraphWindow);
                    callGraphWindow.show();
                } else if (string.equals("Show Statistics Window")) {
                    if (this.clickedOnObject instanceof PPFunctionProfile) {
                        pPFunctionProfile = (PPFunctionProfile)this.clickedOnObject;
                        StatWindow statWindow = new StatWindow(this.ppTrial, pPFunctionProfile.getNodeID(), pPFunctionProfile.getContextID(), pPFunctionProfile.getThreadID(), this.window.getDataSorter(), false);
                        this.ppTrial.getSystemEvents().addObserver(statWindow);
                        statWindow.show();
                    }
                } else if (string.equals("Show User Event Statistics Window")) {
                    if (this.clickedOnObject instanceof PPFunctionProfile) {
                        pPFunctionProfile = (PPFunctionProfile)this.clickedOnObject;
                        StatWindow statWindow = new StatWindow(this.ppTrial, pPFunctionProfile.getNodeID(), pPFunctionProfile.getContextID(), pPFunctionProfile.getThreadID(), this.window.getDataSorter(), true);
                        this.ppTrial.getSystemEvents().addObserver(statWindow);
                        statWindow.show();
                    }
                } else if (string.equals("Show Call Path Thread Relations")) {
                    if (this.clickedOnObject instanceof PPFunctionProfile) {
                        pPFunctionProfile = (PPFunctionProfile)this.clickedOnObject;
                        CallPathTextWindow callPathTextWindow = new CallPathTextWindow(this.ppTrial, pPFunctionProfile.getNodeID(), pPFunctionProfile.getContextID(), pPFunctionProfile.getThreadID(), this.window.getDataSorter(), 1);
                        this.ppTrial.getSystemEvents().addObserver(callPathTextWindow);
                        callPathTextWindow.show();
                    }
                } else if (string.equals("Show Thread Call Graph")) {
                    PPThread pPThread = (PPThread)this.clickedOnObject;
                    CallGraphWindow callGraphWindow = new CallGraphWindow(this.ppTrial, pPThread.getThread());
                    this.ppTrial.getSystemEvents().addObserver(callGraphWindow);
                    callGraphWindow.show();
                } else if (string.equals("Change Function Color")) {
                    Color color = this.function.getColor();
                    JColorChooser jColorChooser = new JColorChooser();
                    if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                        this.function.setSpecificColor(color);
                        this.function.setColorFlag(true);
                        this.ppTrial.getSystemEvents().updateRegisteredObjects("colorEvent");
                    }
                } else if (string.equals("Reset to Generic Color")) {
                    this.function.setColorFlag(false);
                    this.ppTrial.getSystemEvents().updateRegisteredObjects("colorEvent");
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            PPFunctionProfile pPFunctionProfile = null;
            int n4 = n2 / this.ppTrial.getPreferences().getBarSpacing();
            if (this.list != null && n4 < this.list.size()) {
                pPFunctionProfile = (PPFunctionProfile)this.list.elementAt(n4);
                if ((mouseEvent.getModifiers() & 0x10) == 0) {
                    this.clickedOnObject = pPFunctionProfile;
                    if (n > this.barXCoord) {
                        if (n4 == 0) {
                            this.popup1.show(this, mouseEvent.getX(), mouseEvent.getY());
                        } else {
                            this.popup2.show(this, mouseEvent.getX(), mouseEvent.getY());
                        }
                    } else {
                        this.popup3.show(this, mouseEvent.getX(), mouseEvent.getY());
                    }
                } else if (n > this.barXCoord) {
                    ThreadDataWindow threadDataWindow = new ThreadDataWindow(this.ppTrial, pPFunctionProfile.getNodeID(), pPFunctionProfile.getContextID(), pPFunctionProfile.getThreadID(), this.window.getDataSorter());
                    this.ppTrial.getSystemEvents().addObserver(threadDataWindow);
                    threadDataWindow.show();
                } else {
                    this.ppTrial.getColorChooser().toggleHighlightedFunction(this.function);
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        Dimension dimension = null;
        dimension = bl ? this.getSize() : this.window.getSize();
        if (bl2) {
            dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.lastHeaderEndPosition);
        } else {
            dimension.setSize(dimension.getWidth(), dimension.getHeight());
        }
        return dimension;
    }

    public void changeInMultiples() {
        this.computeBarLength();
        this.repaint();
    }

    public void computeBarLength() {
        double d = this.window.getSliderValue();
        double d2 = this.window.getSliderMultiple();
        this.barLength = (int)((double)this.baseBarLength * (d * d2));
    }

    private boolean resizePanel(FontMetrics fontMetrics, int n) {
        boolean bl = false;
        int n2 = (this.window.getData().size() + 1) * this.barSpacing + 10;
        int[] nArray = this.ppTrial.getMaxNCTNumbers();
        String string = "n,c,t " + nArray[0] + "," + nArray[1] + "," + nArray[2];
        int n3 = n + 5 + fontMetrics.stringWidth(string) + 25;
        if (n2 != this.yPanelSize || n3 != this.xPanelSize) {
            this.yPanelSize = n2;
            this.xPanelSize = n3;
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            bl = false;
        }
        return bl;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize);
    }
}

