/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.Group;
import edu.uoregon.tau.dms.dss.UserEvent;
import edu.uoregon.tau.paraprof.CallPathTextWindow;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.LedgerDataElement;
import edu.uoregon.tau.paraprof.LedgerWindowPanel;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfImageOutput;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class LedgerWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer {
    public static final int FUNCTION_LEDGER = 0;
    public static final int GROUP_LEDGER = 1;
    public static final int USEREVENT_LEDGER = 2;
    private int windowType = -1;
    private ParaProfTrial trial = null;
    private JMenu windowsMenu = null;
    private JScrollPane sp = null;
    private LedgerWindowPanel panel = null;
    private Vector list = null;

    public void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = null;
        JMenuItem jMenuItem = null;
        JMenu jMenu2 = new JMenu("File");
        jMenu = new JMenu("Save ...");
        jMenuItem = new JMenuItem("Save Image");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu2.add(jMenu);
        jMenuItem = new JMenuItem("Preferences...");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Print");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Close This Window");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Exit ParaProf!");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenu2.addMenuListener(this);
        this.windowsMenu = new JMenu("Windows");
        jMenuItem = new JMenuItem("Show ParaProf Manager");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Function Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Group Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show User Event Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Call Path Relations");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Close All Sub-Windows");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        this.windowsMenu.addMenuListener(this);
        JMenu jMenu3 = new JMenu("Help");
        jMenuItem = new JMenuItem("Show Help Window");
        jMenuItem.addActionListener(this);
        jMenu3.add(jMenuItem);
        jMenuItem = new JMenuItem("About ParaProf");
        jMenuItem.addActionListener(this);
        jMenu3.add(jMenuItem);
        jMenu3.addMenuListener(this);
        jMenuBar.add(jMenu2);
        jMenuBar.add(this.windowsMenu);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
    }

    public LedgerWindow(ParaProfTrial paraProfTrial, int n) throws ParaProfException {
        this.trial = paraProfTrial;
        this.windowType = n;
        ((Component)this).setLocation(new Point(300, 200));
        ((Component)this).setSize(new Dimension(350, 450));
        switch (n) {
            case 0: {
                this.setTitle("Function Ledger Window: " + paraProfTrial.getTrialIdentifier(true));
                break;
            }
            case 1: {
                this.setTitle("Group Ledger Window: " + paraProfTrial.getTrialIdentifier(true));
                break;
            }
            case 2: {
                this.setTitle("User Event Window: " + paraProfTrial.getTrialIdentifier(true));
                break;
            }
            default: {
                throw new ParaProfException("Invalid Ledger Window Type: " + n);
            }
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LedgerWindow.this.thisWindowClosing(windowEvent);
            }
        });
        if (ParaProf.helpWindow.isVisible()) {
            this.help(false);
        }
        this.setupMenus();
        this.sortLocalData();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panel = new LedgerWindowPanel(paraProfTrial, this, n);
        this.sp = new JScrollPane(this.panel);
        JScrollBar jScrollBar = this.sp.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.sp, gridBagConstraints, 0, 0, 1, 1);
        paraProfTrial.getSystemEvents().addObserver(this);
        ParaProf.incrementNumWindows();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Print")) {
                    ParaProfUtils.print(this.panel);
                } else if (string.equals("Preferences...")) {
                    this.trial.getPreferences().showPreferencesWindow();
                } else if (string.equals("Save Image")) {
                    ParaProfImageOutput paraProfImageOutput = new ParaProfImageOutput();
                    paraProfImageOutput.saveImage(this.panel);
                } else if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                } else if (string.equals("Exit ParaProf!")) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    ParaProf.exitParaProf(0);
                } else if (string.equals("Show ParaProf Manager")) {
                    new ParaProfManagerWindow().show();
                } else if (string.equals("Show Function Ledger")) {
                    new LedgerWindow(this.trial, 0).show();
                } else if (string.equals("Show Group Ledger")) {
                    new LedgerWindow(this.trial, 1).show();
                } else if (string.equals("Show User Event Ledger")) {
                    new LedgerWindow(this.trial, 2).show();
                } else if (string.equals("Show Call Path Relations")) {
                    CallPathTextWindow callPathTextWindow = new CallPathTextWindow(this.trial, -1, -1, -1, new DataSorter(this.trial), 2);
                    this.trial.getSystemEvents().addObserver(callPathTextWindow);
                    callPathTextWindow.show();
                } else if (string.equals("Close All Sub-Windows")) {
                    this.trial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                } else if (string.equals("About ParaProf")) {
                    JOptionPane.showMessageDialog(this, ParaProf.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    this.help(true);
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.trial.groupNamesPresent()) {
                this.windowsMenu.getItem(2).setEnabled(true);
            } else {
                this.windowsMenu.getItem(2).setEnabled(false);
            }
            if (this.trial.userEventsPresent()) {
                this.windowsMenu.getItem(3).setEnabled(true);
            } else {
                this.windowsMenu.getItem(3).setEnabled(false);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("prefEvent")) {
            this.panel.repaint();
        } else if (string.equals("colorEvent")) {
            this.panel.repaint();
        } else if (string.equals("dataEvent")) {
            this.sortLocalData();
            this.panel.repaint();
        } else if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        }
    }

    private void help(boolean bl) {
        ParaProf.helpWindow.clearText();
        if (bl) {
            ParaProf.helpWindow.show();
        }
        if (this.windowType == 0) {
            ParaProf.helpWindow.writeText("This is the function ledger window.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("This window shows all the functionProfiles tracked in this profile.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("To see more information about any of the functionProfiles shown here,");
            ParaProf.helpWindow.writeText("right click on that function, and select from the popup menu.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("You can also left click any function to highlight it in the system.");
        } else if (this.windowType == 1) {
            ParaProf.helpWindow.writeText("This is the group ledger window.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("This window shows all the groups tracked in this profile.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("Left click any group to highlight it in the system.");
            ParaProf.helpWindow.writeText("Right click on any group, and select from the popup menu to display more options for masking or displaying functionProfiles in a particular group.");
        } else {
            ParaProf.helpWindow.writeText("This is the user event ledger window.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("This window shows all the user events tracked in this profile.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("Left click any user event to highlight it in the system.");
            ParaProf.helpWindow.writeText("Right click on any user event, and select from the popup menu.");
        }
    }

    private void sortLocalData() {
        block4: {
            block5: {
                block3: {
                    this.list = new Vector();
                    if (this.windowType != 0) break block3;
                    Iterator iterator = this.trial.getDataSource().getFunctions();
                    while (iterator.hasNext()) {
                        this.list.addElement(new LedgerDataElement((Function)iterator.next()));
                    }
                    break block4;
                }
                if (this.windowType != 1) break block5;
                Iterator iterator = this.trial.getDataSource().getGroups();
                while (iterator.hasNext()) {
                    this.list.addElement(new LedgerDataElement((Group)iterator.next()));
                }
                break block4;
            }
            if (this.windowType != 2) break block4;
            Iterator iterator = this.trial.getDataSource().getUserEvents();
            while (iterator.hasNext()) {
                this.list.addElement(new LedgerDataElement((UserEvent)iterator.next()));
            }
        }
    }

    public Vector getData() {
        return this.list;
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    public Rectangle getViewRect() {
        return this.sp.getViewport().getViewRect();
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            ((Component)this).setVisible(false);
            this.trial.getSystemEvents().deleteObserver(this);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }
}

