/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.DssIterator;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import java.util.Collections;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.Vector;

public class PPThread {
    private double maxExclusive;
    private double maxExclusivePercent;
    private double maxInclusive;
    private double maxInclusivePercent;
    private double maxNumCalls;
    private double maxNumSubr;
    private double maxInclusivePerCall;
    int miscXBeg;
    int miscXEnd;
    int miscYBeg;
    int miscYEnd;
    private ParaProfTrial ppTrial;
    private Thread thread = null;
    private Vector functions = new Vector();
    private Vector userevents = new Vector();
    int yDrawCoord = -1;

    public PPThread(Thread thread, ParaProfTrial paraProfTrial) {
        this.ppTrial = paraProfTrial;
        this.thread = thread;
    }

    public Thread getThread() {
        return this.thread;
    }

    public int getNodeID() {
        return this.thread.getNodeID();
    }

    public int getContextID() {
        return this.thread.getContextID();
    }

    public int getThreadID() {
        return this.thread.getThreadID();
    }

    public void addFunction(PPFunctionProfile pPFunctionProfile) {
        this.functions.addElement(pPFunctionProfile);
    }

    public void addUserevent(PPFunctionProfile pPFunctionProfile) {
        this.userevents.addElement(pPFunctionProfile);
    }

    public Vector getFunctionList() {
        return this.functions;
    }

    public ListIterator getFunctionListIterator() {
        return new DssIterator(this.functions);
    }

    public Vector getUsereventList() {
        return this.userevents;
    }

    public ListIterator getUsereventListIterator() {
        return new DssIterator(this.userevents);
    }

    public double getMaxExclusive() {
        return this.maxExclusive;
    }

    public double getMaxExclusivePercent() {
        return this.maxExclusivePercent;
    }

    public double getMaxInclusive() {
        return this.maxInclusive;
    }

    public double getMaxInclusivePercent() {
        return this.maxInclusivePercent;
    }

    public double getMaxNumCalls() {
        return this.maxNumCalls;
    }

    public double getMaxNumSubr() {
        return this.maxNumSubr;
    }

    public double getMaxInclusivePerCall() {
        return this.maxInclusivePerCall;
    }

    public double getMaxValue(int n, boolean bl) {
        double d = 0.0;
        switch (n) {
            case 2: {
                if (bl) {
                    d = this.maxExclusivePercent;
                    break;
                }
                d = this.maxExclusive;
                break;
            }
            case 4: {
                if (bl) {
                    d = this.maxInclusivePercent;
                    break;
                }
                d = this.maxInclusive;
                break;
            }
            case 6: {
                d = this.maxNumCalls;
                break;
            }
            case 8: {
                d = this.maxNumSubr;
                break;
            }
            case 10: {
                d = this.maxInclusivePerCall;
                break;
            }
            default: {
                throw new RuntimeException("Invalid Value Type: " + n);
            }
        }
        return d;
    }

    public Vector getSortedFunctionProfiles(int n, boolean bl) {
        Vector<PPFunctionProfile> vector = null;
        Vector vector2 = this.thread.getFunctionProfiles();
        vector = new Vector<PPFunctionProfile>();
        this.maxExclusive = 0.0;
        this.maxExclusivePercent = 0.0;
        this.maxInclusive = 0.0;
        this.maxInclusivePercent = 0.0;
        this.maxNumCalls = 0.0;
        this.maxNumSubr = 0.0;
        this.maxInclusivePerCall = 0.0;
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            FunctionProfile functionProfile = (FunctionProfile)enumeration.nextElement();
            if (functionProfile == null || !bl && !this.ppTrial.displayFunction(functionProfile.getFunction())) continue;
            PPFunctionProfile pPFunctionProfile = new PPFunctionProfile(this.ppTrial, this.thread, functionProfile);
            pPFunctionProfile.setSortType(n);
            vector.addElement(pPFunctionProfile);
            this.maxExclusive = Math.max(this.maxExclusive, functionProfile.getExclusive(this.ppTrial.getSelectedMetricID()));
            this.maxInclusive = Math.max(this.maxInclusive, functionProfile.getInclusive(this.ppTrial.getSelectedMetricID()));
            this.maxExclusivePercent = Math.max(this.maxExclusivePercent, functionProfile.getExclusivePercent(this.ppTrial.getSelectedMetricID()));
            this.maxInclusivePercent = Math.max(this.maxInclusivePercent, functionProfile.getInclusivePercent(this.ppTrial.getSelectedMetricID()));
            this.maxNumCalls = Math.max(this.maxNumCalls, functionProfile.getNumCalls());
            this.maxNumSubr = Math.max(this.maxNumSubr, functionProfile.getNumSubr());
            this.maxInclusivePerCall = Math.max(this.maxInclusivePerCall, functionProfile.getInclusivePerCall(this.ppTrial.getSelectedMetricID()));
        }
        Collections.sort(vector);
        return vector;
    }

    public void setYDrawCoord(int n) {
        n = this.yDrawCoord;
    }

    public int getYDrawCoord() {
        return this.yDrawCoord;
    }

    public void setMiscCoords(int n, int n2, int n3, int n4) {
        this.miscXBeg = n;
        this.miscXEnd = n2;
        this.miscYBeg = n3;
        this.miscYEnd = n4;
    }

    public int getMiscXBeg() {
        return this.miscXBeg;
    }

    public int getMiscXEnd() {
        return this.miscXEnd;
    }

    public int getMiscYBeg() {
        return this.miscYBeg;
    }

    public int getMiscYEnd() {
        return this.miscYEnd;
    }
}

