/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DecimalDatatypeValidator;
import org.apache.xerces.validators.datatype.DoubleDatatypeValidator;
import org.apache.xerces.validators.datatype.FloatDatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.ListDatatypeValidator;

public class UnionDatatypeValidator
extends AbstractDatatypeValidator {
    private Locale fLocale = null;
    private Vector fBaseValidators = null;
    private DatatypeValidator fBaseValidator = null;
    private int fValidatorsSize = 0;
    private String fPattern = null;
    private Vector fEnumeration = null;
    private int fFacetsDefined = 0;
    private StringBuffer errorMsg = null;
    private RegularExpression fRegex = null;

    public UnionDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public UnionDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        this.setBasetype(datatypeValidator);
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.equals("enumeration")) {
                    this.fFacetsDefined += 16;
                    this.fEnumeration = (Vector)hashtable.get(string);
                    continue;
                }
                if (string.equals("pattern")) {
                    this.fFacetsDefined += 8;
                    this.fPattern = (String)hashtable.get(string);
                    this.fRegex = new RegularExpression(this.fPattern, "X");
                    continue;
                }
                throw new InvalidDatatypeFacetException("invalid facet tag : " + string);
            }
        }
    }

    public UnionDatatypeValidator(Vector vector) {
        if (vector != null) {
            this.fValidatorsSize = vector.size();
            this.fBaseValidators = new Vector(this.fValidatorsSize);
            this.fBaseValidators = vector;
        }
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        if (string == null && object != null) {
            this.fBaseValidator.validate(string, object);
        } else {
            this.checkContentEnum(string, object, false, null);
        }
        return null;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Hashtable getFacets() {
        return null;
    }

    public int compare(String string, String string2) {
        if (this.fBaseValidator != null) {
            return this.fBaseValidator.compare(string, string2);
        }
        int n = -1;
        while (++n < this.fValidatorsSize) {
            DatatypeValidator datatypeValidator = (DatatypeValidator)this.fBaseValidators.elementAt(n);
            if (datatypeValidator.compare(string, string2) != 0) continue;
            return 0;
        }
        return -1;
    }

    public Object clone() throws CloneNotSupportedException {
        UnionDatatypeValidator unionDatatypeValidator = null;
        try {
            unionDatatypeValidator = new UnionDatatypeValidator();
            unionDatatypeValidator.fLocale = this.fLocale;
            unionDatatypeValidator.fBaseValidator = this.fBaseValidator;
            unionDatatypeValidator.fBaseValidators = (Vector)this.fBaseValidators.clone();
            unionDatatypeValidator.fPattern = this.fPattern;
            unionDatatypeValidator.fEnumeration = this.fEnumeration;
            unionDatatypeValidator.fFacetsDefined = this.fFacetsDefined;
        }
        catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
            invalidDatatypeFacetException.printStackTrace();
        }
        return unionDatatypeValidator;
    }

    private boolean verifyEnum(Vector vector) {
        if ((this.fFacetsDefined & 0x10) != 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                if (this.fEnumeration.contains(enumeration.nextElement())) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void checkContentEnum(String var1_1, Object var2_2, boolean var3_3, Vector var4_4) throws InvalidDatatypeValueException {
        var5_5 = -1;
        var6_6 = false;
        var7_7 = null;
        if (this.fBaseValidator == null) ** GOTO lbl48
        if ((this.fFacetsDefined & 8) != 0) {
            if (this.fRegex == null || !this.fRegex.matches(var1_1)) {
                throw new InvalidDatatypeValueException("Value '" + var1_1 + "' does not match regular expression facet '" + this.fPattern + "'.");
            }
            var3_3 = true;
        }
        if (var4_4 != null) {
            if (!this.verifyEnum(var4_4)) {
                throw new InvalidDatatypeValueException("Enumeration '" + var4_4 + "' for value '" + var1_1 + "' is based on enumeration '" + this.fEnumeration + "'");
            }
        } else {
            var4_4 = this.fEnumeration != null ? this.fEnumeration : null;
        }
        ((UnionDatatypeValidator)this.fBaseValidator).checkContentEnum(var1_1, var2_2, var3_3, var4_4);
        return;
lbl-1000:
        // 1 sources

        {
            var7_7 = (DatatypeValidator)this.fBaseValidators.elementAt(var5_5);
            if (var6_6) break;
            try {
                if (var7_7 instanceof ListDatatypeValidator) {
                    if (var3_3) {
                        throw new InvalidDatatypeValueException("Facet \"Pattern\" can not be applied to a list datatype");
                    }
                    ((ListDatatypeValidator)var7_7).checkContentEnum(var1_1, var2_2, var4_4);
                } else if (var7_7 instanceof UnionDatatypeValidator) {
                    ((UnionDatatypeValidator)var7_7).checkContentEnum(var1_1, var2_2, var3_3, var4_4);
                } else if (var4_4 != null) {
                    if (var7_7 instanceof DecimalDatatypeValidator) {
                        ((DecimalDatatypeValidator)var7_7).checkContentEnum(var1_1, var2_2, var4_4);
                    } else if (var7_7 instanceof FloatDatatypeValidator) {
                        ((FloatDatatypeValidator)var7_7).checkContentEnum(var1_1, var2_2, var4_4);
                    } else if (var7_7 instanceof DoubleDatatypeValidator) {
                        ((DoubleDatatypeValidator)var7_7).checkContentEnum(var1_1, var2_2, var4_4);
                    } else {
                        if (!var4_4.contains(var1_1)) {
                            throw new InvalidDatatypeValueException("Value '" + var1_1 + "' must be one of " + var4_4);
                        }
                        var7_7.validate(var1_1, var2_2);
                    }
                } else {
                    var7_7.validate(var1_1, var2_2);
                }
                var6_6 = true;
                continue;
            }
            catch (InvalidDatatypeValueException var8_8) {
                // empty catch block
            }
lbl48:
            // 3 sources

            ** while (++var5_5 < this.fValidatorsSize)
        }
lbl49:
        // 2 sources

        if (!var6_6) {
            throw new InvalidDatatypeValueException("Content '" + var1_1 + "' does not match any union types");
        }
    }

    private void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }
}

