/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.compile;

import org.jatha.Jatha;
import org.jatha.compile.CompilerException;
import org.jatha.compile.LispPrimitive;
import org.jatha.dynatype.LispValue;
import org.jatha.machine.SECDMachine;

public class TimePrimitive
extends LispPrimitive {
    public TimePrimitive(Jatha lisp) {
        super(lisp, "TIME", 1L);
    }

    public void Execute(SECDMachine machine) throws CompilerException {
        LispValue expr = machine.S.pop();
        LispValue code = this.f_lisp.COMPILER.compile(this.f_lisp.MACHINE, expr, (LispValue)this.f_lisp.NIL);
        SECDMachine newMachine = new SECDMachine(this.f_lisp);
        long startMemory = this.f_lisp.SYSTEM_INFO.freeMemory();
        long startTime = System.currentTimeMillis();
        LispValue value = newMachine.Execute(code, this.f_lisp.NIL);
        long endTime = System.currentTimeMillis();
        long endMemory = this.f_lisp.SYSTEM_INFO.freeMemory();
        System.out.println("\n; real time: " + (endTime - startTime) + " ms");
        System.out.println(";     space: " + (startMemory - endMemory) + " bytes");
        machine.S.push(value);
        machine.C.pop();
    }
}

