/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.dynatype;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import org.jatha.Jatha;
import org.jatha.dynatype.LispBignum;
import org.jatha.dynatype.LispCons;
import org.jatha.dynatype.LispConsOrNil;
import org.jatha.dynatype.LispInteger;
import org.jatha.dynatype.LispReal;
import org.jatha.dynatype.LispString;
import org.jatha.dynatype.LispSymbol;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.StandardLispBignum;
import org.jatha.dynatype.StandardLispCons;
import org.jatha.dynatype.StandardLispConstant;
import org.jatha.dynatype.StandardLispInteger;
import org.jatha.dynatype.StandardLispKeyword;
import org.jatha.dynatype.StandardLispNIL;
import org.jatha.dynatype.StandardLispReal;
import org.jatha.dynatype.StandardLispString;
import org.jatha.dynatype.StandardLispSymbol;
import org.jatha.read.LispParser;

public class LispValueFactory {
    public static LispCons makeCons(Jatha lisp, LispValue theCar, LispValue theCdr) {
        return new StandardLispCons(lisp, theCar, theCdr);
    }

    public static LispConsOrNil makeList(Jatha lisp, Collection elements) {
        Object[] elArray = elements.toArray();
        LispConsOrNil result = lisp.NIL;
        for (int i = elArray.length - 1; i >= 0; --i) {
            result = new StandardLispCons(lisp, (LispValue)elArray[i], result);
        }
        return result;
    }

    public static LispCons makeList(Jatha lisp, LispValue first) {
        return new StandardLispCons(lisp, first, lisp.NIL);
    }

    public static LispCons makeList(Jatha lisp, LispValue first, LispValue second) {
        return new StandardLispCons(lisp, first, new StandardLispCons(lisp, second, lisp.NIL));
    }

    public static LispCons makeList(Jatha lisp, LispValue first, LispValue second, LispValue third) {
        return new StandardLispCons(lisp, first, new StandardLispCons(lisp, second, new StandardLispCons(lisp, third, lisp.NIL)));
    }

    public static LispCons makeList(Jatha lisp, LispValue first, LispValue second, LispValue third, LispValue fourth) {
        return new StandardLispCons(lisp, first, new StandardLispCons(lisp, second, new StandardLispCons(lisp, third, new StandardLispCons(lisp, fourth, lisp.NIL))));
    }

    public static LispConsOrNil makeAppendList(Jatha lisp, Collection elements) {
        if (elements.size() == 0) {
            return lisp.NIL;
        }
        LispValue result = lisp.NIL;
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            LispValue o = (LispValue)iterator.next();
            result = result.append(o);
        }
        return result;
    }

    public static LispConsOrNil makeNconcList(Jatha lisp, Collection elements) {
        if (elements.size() == 0) {
            return lisp.NIL;
        }
        LispValue result = lisp.NIL;
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            LispValue o = (LispValue)iterator.next();
            result = result.nconc(o);
        }
        return result;
    }

    public static LispInteger makeInteger(Jatha lisp, Long value) {
        return new StandardLispInteger(lisp, value);
    }

    public static LispInteger makeInteger(Jatha lisp, long value) {
        return new StandardLispInteger(lisp, value);
    }

    public static LispInteger makeInteger(Jatha lisp, Integer value) {
        return new StandardLispInteger(lisp, value.longValue());
    }

    public static LispInteger makeInteger(Jatha lisp, int value) {
        return new StandardLispInteger(lisp, value);
    }

    public static LispInteger makeInteger(Jatha lisp) {
        return new StandardLispInteger(lisp, 0L);
    }

    public static LispBignum makeBignum(Jatha lisp, BigInteger value) {
        return new StandardLispBignum(lisp, value);
    }

    public static LispBignum makeBignum(Jatha lisp, LispInteger value) {
        return new StandardLispBignum(lisp, BigInteger.valueOf(value.getLongValue()));
    }

    public static LispBignum makeBignum(Jatha lisp, double value) {
        return new StandardLispBignum(lisp, BigInteger.valueOf((long)value));
    }

    public static LispBignum makeBignum(Jatha lisp, long value) {
        return new StandardLispBignum(lisp, BigInteger.valueOf(value));
    }

    public static LispReal makeReal(Jatha lisp, Double value) {
        return new StandardLispReal(lisp, value);
    }

    public static LispReal makeReal(Jatha lisp, double value) {
        return new StandardLispReal(lisp, value);
    }

    public static LispReal makeReal(Jatha lisp, Float value) {
        return new StandardLispReal(lisp, value.doubleValue());
    }

    public static LispReal makeReal(Jatha lisp, float value) {
        return new StandardLispReal(lisp, value);
    }

    public static LispReal makeReal(Jatha lisp) {
        return new StandardLispReal(lisp, 0.0);
    }

    public static LispString makeString(Jatha lisp, String str) {
        return new StandardLispString(lisp, str);
    }

    public static LispSymbol makeSymbol(Jatha lisp, String symbolName) {
        return new StandardLispSymbol(lisp, symbolName);
    }

    public static LispSymbol makeSymbol(Jatha lisp, LispString symbolName) {
        return new StandardLispSymbol(lisp, symbolName);
    }

    public static LispSymbol makeConstant(Jatha lisp, String symbolName) {
        return new StandardLispConstant(lisp, symbolName);
    }

    public static LispSymbol makeConstant(Jatha lisp, LispString symbolName) {
        return new StandardLispConstant(lisp, symbolName);
    }

    public static LispSymbol makeKeyword(Jatha lisp, String symbolName) {
        return new StandardLispKeyword(lisp, symbolName);
    }

    public static LispSymbol makeKeyword(Jatha lisp, LispString symbolName) {
        return new StandardLispKeyword(lisp, symbolName);
    }

    public static StandardLispNIL makeNIL(Jatha lisp, String symbolName) {
        return new StandardLispNIL(lisp, symbolName);
    }

    public static StandardLispNIL makeNIL(Jatha lisp, LispString symbolName) {
        return new StandardLispNIL(lisp, symbolName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LispValue toLisp(Jatha lisp, Object obj) {
        if (obj == null) {
            return lisp.NIL;
        }
        if (obj instanceof LispValue) {
            return (LispValue)obj;
        }
        if (obj instanceof Integer) {
            return new StandardLispInteger(lisp, ((Integer)obj).intValue());
        }
        if (obj instanceof Long) {
            return new StandardLispInteger(lisp, (Long)obj);
        }
        if (obj instanceof Double) {
            return new StandardLispReal(lisp, (Double)obj);
        }
        if (obj instanceof Float) {
            return new StandardLispReal(lisp, ((Float)obj).doubleValue());
        }
        if (obj instanceof String) {
            return new StandardLispString(lisp, (String)obj);
        }
        LispValue result = lisp.NIL;
        try {
            result = new LispParser(lisp, obj.toString(), 3).parse();
            return result;
        }
        catch (Exception e) {
            System.err.println("Error in LispValueFactory.toLisp(" + obj + ")");
        }
        finally {
            return result;
        }
    }
}

