/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.eval;

import org.jatha.Jatha;
import org.jatha.dynatype.LispPackage;
import org.jatha.dynatype.LispString;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.StandardLispInteger;
import org.jatha.dynatype.StandardLispString;

public class LispEvaluator {
    private Jatha f_lisp = null;

    public LispEvaluator(Jatha lisp) {
        this.f_lisp = lisp;
    }

    public void init() {
        this.setf_symbol_value(this.intern("*"), this.f_lisp.NIL);
        this.setf_symbol_value(this.intern("**"), this.f_lisp.NIL);
        this.setf_symbol_value(this.intern("***"), this.f_lisp.NIL);
        this.setf_symbol_value(this.intern("*LISP-TRACE*"), this.f_lisp.NIL);
        this.setf_symbol_value(this.intern("*COMP-NATIVE-FUNCTIONS*"), this.f_lisp.NIL);
        this.setf_symbol_value(this.intern("*COMP-SPECIAL-FUNCTIONS*"), this.f_lisp.NIL);
        this.setf_symbol_value(this.intern("*PACKAGE*"), this.f_lisp.PACKAGE);
        this.intern("*PACKAGE*").set_special(true);
    }

    public LispValue cons(LispValue theCar, LispValue theCdr) {
        return this.f_lisp.makeCons(theCar, theCdr);
    }

    public LispValue intern(LispString symbolString) {
        if (this.f_lisp.COLON.eql(symbolString.basic_elt(0)) != this.f_lisp.NIL) {
            return this.intern((LispString)symbolString.substring(new StandardLispInteger(this.f_lisp, 1L)), (LispPackage)this.f_lisp.findPackage("KEYWORD"));
        }
        return this.intern(symbolString, this.f_lisp.PACKAGE);
    }

    public LispValue intern(LispString symbolString, LispPackage pkg) {
        LispValue newSymbol = pkg.getSymbol(symbolString);
        if (newSymbol != this.f_lisp.NIL) {
            return newSymbol;
        }
        if (pkg == this.f_lisp.findPackage("KEYWORD")) {
            String newString = symbolString.toStringSimple().toUpperCase();
            newSymbol = this.f_lisp.makeKeyword(new StandardLispString(this.f_lisp, newString));
        } else {
            newSymbol = this.f_lisp.makeSymbol(symbolString);
        }
        return this.intern(symbolString, newSymbol, pkg);
    }

    public LispValue intern(LispString symbolString, LispValue symbol) {
        return this.intern(symbolString, symbol, this.f_lisp.PACKAGE);
    }

    public LispValue intern(LispString symbolString, LispValue symbol, LispPackage pkg) {
        if (pkg == null) {
            return symbol;
        }
        symbol.setPackage(pkg);
        return pkg.addSymbol(symbolString, symbol);
    }

    public LispValue intern(String str) {
        return this.intern(this.f_lisp.makeString(str));
    }

    public LispValue intern(String str, LispPackage pkg) {
        return this.intern(this.f_lisp.makeString(str), pkg);
    }

    public LispValue nreverse(LispValue thing) {
        return thing.nreverse();
    }

    public LispValue reverse(LispValue thing) {
        return thing.reverse();
    }

    public LispValue setf_symbol_function(LispValue symbol, LispValue value) {
        return symbol.setf_symbol_function(value);
    }

    public LispValue setf_symbol_plist(LispValue symbol, LispValue value) {
        return symbol.setf_symbol_plist(value);
    }

    public LispValue setf_symbol_value(LispValue symbol, LispValue value) {
        return symbol.setf_symbol_value(value);
    }
}

