/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.analysis;

import edu.uoregon.tau.dms.analysis.ScalabilityResult;
import edu.uoregon.tau.dms.analysis.ScalabilityResults;
import edu.uoregon.tau.dms.database.DB;
import edu.uoregon.tau.dms.dss.DatabaseAPI;
import edu.uoregon.tau.dms.dss.DssIterator;
import edu.uoregon.tau.dms.dss.Trial;
import java.sql.SQLException;
import java.util.Vector;

public class Scalability {
    private DB db = null;

    public Scalability(DatabaseAPI databaseAPI) {
        this.db = databaseAPI.db();
    }

    public ScalabilityResults exclusive(Vector vector, String string) {
        return this.trials(vector, "exclusive", string);
    }

    public ScalabilityResults exclusivePercentage(Vector vector, String string) {
        return this.trials(vector, "exclusive_percentage", string);
    }

    public ScalabilityResults inclusive(Vector vector, String string) {
        return this.trials(vector, "inclusive", string);
    }

    public ScalabilityResults inclusivePercentage(Vector vector, String string) {
        return this.trials(vector, "inclusive_percentage", string);
    }

    public ScalabilityResults trials(Vector vector, String string, String string2) {
        Object object;
        ScalabilityResults scalabilityResults = new ScalabilityResults();
        DssIterator dssIterator = new DssIterator(vector);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select e.name, e.trial, t.node_count * ");
        stringBuffer.append("t.contexts_per_node * t.threads_per_context as threads, ");
        stringBuffer.append("min(i.");
        stringBuffer.append(string);
        stringBuffer.append("), avg(i.");
        stringBuffer.append(string);
        stringBuffer.append("), max(i.");
        stringBuffer.append(string);
        stringBuffer.append("), stddev(i.");
        stringBuffer.append(string);
        stringBuffer.append(") from interval_event e inner join interval_location_profile ");
        stringBuffer.append("i on e.id = i.interval_event inner join trial t on e.trial = ");
        stringBuffer.append("t.id where e.trial in (");
        int n = 0;
        while (dssIterator.hasNext()) {
            object = (Trial)dssIterator.next();
            if (n++ > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(((Trial)object).getID());
        }
        stringBuffer.append(") ");
        if (string2 != null) {
            stringBuffer.append("and e.name like '" + string2 + "' ");
        }
        stringBuffer.append("group by e.name, e.trial, threads order by ");
        stringBuffer.append("e.name, threads, e.trial");
        try {
            object = this.db.executeQuery(stringBuffer.toString());
            String string3 = new String("");
            ScalabilityResult scalabilityResult = null;
            int n2 = 0;
            while (object.next()) {
                if (!string3.equals(object.getString(1))) {
                    scalabilityResult = new ScalabilityResult(object.getString(1), vector.size());
                    scalabilityResults.add(scalabilityResult);
                    n2 = 0;
                    string3 = object.getString(1);
                } else {
                    ++n2;
                }
                scalabilityResult.threadCount[n2] = object.getInt(3);
                scalabilityResult.minimum[n2] = object.getDouble(4);
                scalabilityResult.average[n2] = object.getDouble(5);
                scalabilityResult.maximum[n2] = object.getDouble(6);
                scalabilityResult.stddev[n2] = object.getDouble(7);
            }
            object.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
        return scalabilityResults;
    }
}

