/*
 * Decompiled with CFR 0.152.
 */
package TauIL.absyn;

import TauIL.absyn.DecList;
import TauIL.absyn.DirectiveList;
import TauIL.absyn.StatementList;
import TauIL.absyn.SyntaxElement;

public class Instrumentation
implements SyntaxElement {
    public static final int PROFILE = 0;
    public static final int STATIC = 1;
    public static final int RUNTIME = 2;
    public static final String[] literals = new String[]{"profile", "static", "runtime"};
    public DirectiveList directives;
    public DecList declarations;
    public StatementList conditions;
    public StatementList anti_conditions;
    public String fname = "inst.sel";
    public int type = 0;

    public Instrumentation(DirectiveList directiveList, DecList decList, StatementList statementList, StatementList statementList2) {
        this.directives = directiveList;
        this.declarations = decList;
        this.conditions = statementList;
        this.anti_conditions = statementList2;
    }

    public Instrumentation(DecList decList, StatementList statementList, StatementList statementList2) {
        this(null, decList, statementList, statementList2);
    }

    public Instrumentation(DirectiveList directiveList, StatementList statementList, StatementList statementList2) {
        this(directiveList, null, statementList, statementList2);
    }

    public Instrumentation(DirectiveList directiveList, DecList decList, StatementList statementList) {
        this(directiveList, decList, statementList, null);
    }

    public Instrumentation(DirectiveList directiveList, StatementList statementList) {
        this(directiveList, null, statementList, null);
    }

    public Instrumentation(DecList decList, StatementList statementList) {
        this(null, decList, statementList, null);
    }

    public Instrumentation(StatementList statementList, StatementList statementList2) {
        this(null, null, statementList, statementList2);
    }

    public Instrumentation(StatementList statementList) {
        this(null, null, statementList, null);
    }

    public void setDataType(int n) {
        this.type = n;
    }

    public void setFileName(String string) {
        this.fname = string;
    }

    public String generateSyntax() {
        String string = "instrument with " + literals[this.type] + " as " + this.fname + "\n";
        if (this.directives != null) {
            string = "directives\n{:\n";
            string = this.directives.generateSyntax() + "\n:}\n";
        }
        if (this.declarations != null) {
            string = "declarations\n{:\n";
            string = this.declarations.generateSyntax() + "\n:}\n";
        }
        string = "conditions\n{:\n";
        string = string + this.conditions.generateSyntax() + "\n:}\n";
        if (this.anti_conditions != null) {
            string = "anti-conditions\n{:\n";
            string = string + this.anti_conditions.generateSyntax() + "\n:}\n";
        }
        string = string + "end\n\n";
        return string;
    }
}

