/*
 * ui-quit.c - a module for quit UI
 * by Hirotsugu Kakugawa
 */
/*
 * Copyright (C) 1996-1997 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/param.h>
#include <X11/Xlib.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/MessageB.h>
#include <Xm/PushB.h>

#include "cf-xmdvi.h"
#include "dvi-2_6.h"
#include "defs.h"
#include "dev.h"
#include "resource.h"
#include "paper.h"
#include "window.h"
#include "ui.h"

Private Widget  dialog_quit; 

Private void  cb_quit_quit(Widget,caddr_t,caddr_t);
Private void  cb_quit_cancel(Widget,caddr_t,caddr_t);



Public Widget
x_make_panel_quit(Widget parent)
{
  Widget  xquit;
  Arg     args[10];
  int     i;

  i = 0;
  XtSetArg(args[i], XmNmessageString, 
	   XmStringCreate("Do you really want to quit?", 
			  XmSTRING_DEFAULT_CHARSET)); i++;
  XtSetArg(args[i], XmNokLabelString, 
	   XmStringCreate("   Yes   ", XmSTRING_DEFAULT_CHARSET)); i++;
  XtSetArg(args[i], XmNcancelLabelString,
	   XmStringCreate("   No   ", XmSTRING_DEFAULT_CHARSET)); i++;
  XtSetArg(args[i], XmNdialogStyle, XmDIALOG_MODELESS); i++;
  XtSetArg(args[i], XmNdefaultButtonType, XmDIALOG_CANCEL_BUTTON); i++;
  xquit = XmCreateQuestionDialog(parent, "Quit", args, i);
  XtAddCallback(xquit, XmNokCallback, 
		(XtCallbackProc)cb_quit_quit, NULL);
  XtAddCallback(xquit, XmNcancelCallback, 
		(XtCallbackProc)cb_quit_cancel, NULL);

  XtUnmanageChild(XmMessageBoxGetChild(xquit, XmDIALOG_HELP_BUTTON));

  dialog_quit = xquit;
  return xquit;
}

Public void 
cb_quit(Widget w, caddr_t d1, caddr_t d2)
{
  if (RES(DviDev,novice) == 1){
    if (XtIsManaged(dialog_quit)){
      XtUnmanageChild(dialog_quit);
    } else {
      ui_close_panel_all();
      XtManageChild(dialog_quit);
    }
  } else {
    do_exit();
  }
}

Public void 
cb_quit_close(Widget w, caddr_t d1, caddr_t d2)
{
  if (XtIsManaged(dialog_quit))
    XtUnmanageChild(dialog_quit);
}

Public void 
cmd_quit(void)
{
  if (DviDisableCommand == 1)
    ; /* no return */
  cb_quit(NULL, 0, 0);
}

Public void 
cmd_quit_anyway(void)
{
  if (DviDisableCommand == 1)
    ; /* no return */
  do_exit();
}

Private void 
cb_quit_quit(Widget w, caddr_t d1, caddr_t d2)
{
  do_exit();
}

Private void
cb_quit_cancel(Widget w, caddr_t d1, caddr_t d2)
{
  XtUnmanageChild(dialog_quit);  
}


