/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ConfigFile.H"
#include "LessonStatusSizer.H"
#include <wx/wx.h>
#include <wx/listctrl.h>

class ClassSelectDlg : public wxDialog {
public:
  ClassSelectDlg (wxWindow* parent);
  ~ClassSelectDlg ();
  
  int ShowModal();

  KursName* GetSelection () { return this->selected; };

  void OnDClickActivated (wxListEvent& e);
  void OnButtonActivated (wxCommandEvent& WXUNUSED(e));
  void OnSelection (wxListEvent& e);
  void OnNewClass (wxCommandEvent& WXUNUSED(e));

private:
  std::vector<KursName>* entries;
  KursName* selected;
  wxButton* btnSel;
  wxButton* btnNew;
  wxButton* btnCancel;
  wxListCtrl* listDisplay;
  wxStaticBox* sb;
  LessonStatusSizer* dataDisplay;

  wxListCtrl* getListCtrl (int id);

  DECLARE_EVENT_TABLE()
};

enum {
  LC = wxID_HIGHEST+1,
  NEW_B,
  SEL_B
};
