/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirs.H"
#include <wx/wx.h>

#ifndef URLSELECTPANEL_H
#define URLSELECTPANEL_H

/* abstract parent class
 */
class UrlSelectPanel : public wxPanel {
public:
  UrlSelectPanel (wxWindow* parent, int id, UrlFile& defaultUrl,
		  const wxString& pathLabel);

  virtual bool Enable (bool enable);
  virtual bool allFieldsValid () = 0;
  virtual wxString getURLstr () = 0;

protected:
  wxSizer* panelSizer;
  const wxString protocolDescr;
  wxComboBox* protocol;
  const wxString serverDescr;
  wxStaticText* serverText;
  wxTextCtrl* server;
  const wxString pathDescr;
  wxTextCtrl* path;
  wxButton* pathBtn;

  wxArrayString protocols;

  virtual void onPathBtn (wxCommandEvent& e) = 0;
  wxSizer* getPanelSizer (UrlFile& defaultUrl);
  wxSizer* getCorePanelSizer (UrlFile& defaultUrl);
  wxComboBox* getProtocolBox (const wxString& defaultUrl);

private:

  void onProtocol (wxCommandEvent& e);

  DECLARE_EVENT_TABLE()
};

/* sub class for selecting a file URL
 */
class FileUrlSelectPanel : public UrlSelectPanel {
public:
  FileUrlSelectPanel (wxWindow* parent, int id, UrlFile defaultUrl = UrlFile());

  virtual bool allFieldsValid ();
  wxString getURLstr ();

private:
  void onPathBtn (wxCommandEvent& e);  

  DECLARE_EVENT_TABLE()
};

class BinaryFileUrlSelectPanel : public FileUrlSelectPanel {
public:
  BinaryFileUrlSelectPanel (wxWindow* parent, int id, UrlFile defaultUrl = UrlFile());
};

class TextFileUrlSelectPanel : public FileUrlSelectPanel {
public:
  TextFileUrlSelectPanel (wxWindow* parent, int id, UrlFile defaultUrl = UrlFile());

  wxString getCharset () { return charset->GetValue(); };

private:
  wxComboBox* charset;
  wxArrayString charsets;

  wxComboBox* getCharsetBox (const wxString& charset);
};

/* sub class for selecting a directory URL (ending with '/')
 */
class DirUrlSelectPanel : public UrlSelectPanel {
public:
  DirUrlSelectPanel (wxWindow* parent, int id, UrlFile defaultUrl = UrlFile());

  bool allFieldsValid ();
  wxString getURLstr ();

private:
  void onPathBtn (wxCommandEvent& e);  

  DECLARE_EVENT_TABLE()
};


#endif
