<?php

	Function TWIGGetContext() 
		{
		GLOBAL $config, $c;

   		if( is_array( $c ) )
			{
			$context["feature"] = URLDecode( stripslashes( $c["f"] ) );
			$context["action"] = URLDecode( stripslashes( $c["a"] ) );
			}
		else
			{
			$context = array( "feature"=>$config["default_feature"], "action"=>"main" );
			}

		return $context;
 		}

	Function TWIGGetSession() 
		{
		GLOBAL $s;

   		if( !is_array( $s ) )
			{
			$session = array( "mailbox"=>"INBOX" );
			}
		else
			{
			while( list( $key, $val ) = each( $s ) ) 
			 	{
   				$session[$key] = URLDecode( stripslashes( $val ) );
				}
			}
		return $session;
 		}

 	Function TWIGSession( $type = "get", $other = "" ) 
		{
		global $session;

		$tsession = $session;

		if( $other )
			{
			$j = count( $other );

			for( $i = 0; $i < $j; $i++ )
				{
				$tsession[$other[$i]["item"]] = $other[$i]["value"];
				}
			}

	 	if( $type == "get" )
			{
			while( list( $key, $val ) = each( $tsession ) )
				{
				$str .= "&s[$key]=" . URLEncode( $val );
				}
			}
		else
			{
			while( list( $key, $val ) = each( $tsession ) )
				{
				$str .= "<input type=hidden name=s[$key] value=\"" . URLEncode($val) . "\">\n";
				}
			}

		reset( $session );

		return $str;
 		}

	Function TWIGContext( $type = "get", $feature = "", $action = "", $other = "" )
		{
		global $context;

		$tcontext = $context;

		if( $feature ) { $tcontext["feature"] = $feature; }
		if( $action ) { $tcontext["action"] = $action; }

		if( $other )
			{
			$j = count( $other );

			for( $i = 0; $i < $j; $i++ )
				{
				$tcontext[$other[$i]["item"]] = $other[$i]["value"];
				}
			}

	 	if( $type == "get" )
			{
			$str = "&c[f]=" . URLEncode( $tcontext["feature"] ) . "&c[a]=" . URLEncode( $tcontext["action"] );
			}
		else
			{
			$str = "<input type=hidden name=c[f] value=\"" . URLEncode( $tcontext["feature"] ) . "\">\n<input type=hidden name=c[a] value=\"" . URLEncode( $tcontext["action"] ) . "\">\n";
			}

		return $str;
 		}

	Function TWIGCleanSession()
		{
		return;
		}

	Function TWIGCleanContext()
		{
		return;
		}
?>
