/*
 *  ibm437.h  --  include for ibm437 (codepage 437) characters database
 */

#ifndef _TUTF_IBM437_H
#define _TUTF_IBM437_H

#define T_IBM437_NULL	0x0000
#define T_IBM437_WHITE_SMILING_FACE	0x0001
#define T_IBM437_BLACK_SMILING_FACE	0x0002
#define T_IBM437_BLACK_HEART_SUIT	0x0003
#define T_IBM437_BLACK_DIAMOND_SUIT	0x0004
#define T_IBM437_BLACK_CLUB_SUIT	0x0005
#define T_IBM437_BLACK_SPADE_SUIT	0x0006
#define T_IBM437_BULLET	0x0007
#define T_IBM437_INVERSE_BULLET	0x0008
#define T_IBM437_WHITE_CIRCLE	0x0009
#define T_IBM437_INVERSE_WHITE_CIRCLE	0x000A
#define T_IBM437_MALE_SIGN	0x000B
#define T_IBM437_FEMALE_SIGN	0x000C
#define T_IBM437_EIGHTH_NOTE	0x000D
#define T_IBM437_BEAMED_EIGHTH_NOTES	0x000E
#define T_IBM437_WHITE_SUN_WITH_RAYS	0x000F
#define T_IBM437_BLACK_RIGHT_POINTING_TRIANGLE	0x0010
#define T_IBM437_BLACK_LEFT_POINTING_TRIANGLE	0x0011
#define T_IBM437_UP_DOWN_ARROW	0x0012
#define T_IBM437_DOUBLE_EXCLAMATION_MARK	0x0013
#define T_IBM437_PILCROW_SIGN	0x0014
#define T_IBM437_SECTION_SIGN	0x0015
#define T_IBM437_BLACK_RECTANGLE	0x0016
#define T_IBM437_UP_DOWN_ARROW_WITH_BASE	0x0017
#define T_IBM437_UPWARDS_ARROW	0x0018
#define T_IBM437_DOWNWARDS_ARROW	0x0019
#define T_IBM437_RIGHTWARDS_ARROW	0x001A
#define T_IBM437_LEFTWARDS_ARROW	0x001B
#define T_IBM437_RIGHT_ANGLE	0x001C
#define T_IBM437_LEFT_RIGHT_ARROW	0x001D
#define T_IBM437_BLACK_UP_POINTING_TRIANGLE	0x001E
#define T_IBM437_BLACK_DOWN_POINTING_TRIANGLE	0x001F
#define T_IBM437_SPACE	0x0020
#define T_IBM437_EXCLAMATION_MARK	0x0021
#define T_IBM437_QUOTATION_MARK	0x0022
#define T_IBM437_NUMBER_SIGN	0x0023
#define T_IBM437_DOLLAR_SIGN	0x0024
#define T_IBM437_PERCENT_SIGN	0x0025
#define T_IBM437_AMPERSAND	0x0026
#define T_IBM437_APOSTROPHE	0x0027
#define T_IBM437_LEFT_PARENTHESIS	0x0028
#define T_IBM437_RIGHT_PARENTHESIS	0x0029
#define T_IBM437_ASTERISK	0x002A
#define T_IBM437_PLUS_SIGN	0x002B
#define T_IBM437_COMMA	0x002C
#define T_IBM437_HYPHEN_MINUS	0x002D
#define T_IBM437_FULL_STOP	0x002E
#define T_IBM437_SOLIDUS	0x002F
#define T_IBM437_DIGIT_ZERO	0x0030
#define T_IBM437_DIGIT_ONE	0x0031
#define T_IBM437_DIGIT_TWO	0x0032
#define T_IBM437_DIGIT_THREE	0x0033
#define T_IBM437_DIGIT_FOUR	0x0034
#define T_IBM437_DIGIT_FIVE	0x0035
#define T_IBM437_DIGIT_SIX	0x0036
#define T_IBM437_DIGIT_SEVEN	0x0037
#define T_IBM437_DIGIT_EIGHT	0x0038
#define T_IBM437_DIGIT_NINE	0x0039
#define T_IBM437_COLON	0x003A
#define T_IBM437_SEMICOLON	0x003B
#define T_IBM437_LESS_THAN_SIGN	0x003C
#define T_IBM437_EQUALS_SIGN	0x003D
#define T_IBM437_GREATER_THAN_SIGN	0x003E
#define T_IBM437_QUESTION_MARK	0x003F
#define T_IBM437_COMMERCIAL_AT	0x0040
#define T_IBM437_LATIN_CAPITAL_LETTER_A	0x0041
#define T_IBM437_LATIN_CAPITAL_LETTER_B	0x0042
#define T_IBM437_LATIN_CAPITAL_LETTER_C	0x0043
#define T_IBM437_LATIN_CAPITAL_LETTER_D	0x0044
#define T_IBM437_LATIN_CAPITAL_LETTER_E	0x0045
#define T_IBM437_LATIN_CAPITAL_LETTER_F	0x0046
#define T_IBM437_LATIN_CAPITAL_LETTER_G	0x0047
#define T_IBM437_LATIN_CAPITAL_LETTER_H	0x0048
#define T_IBM437_LATIN_CAPITAL_LETTER_I	0x0049
#define T_IBM437_LATIN_CAPITAL_LETTER_J	0x004A
#define T_IBM437_LATIN_CAPITAL_LETTER_K	0x004B
#define T_IBM437_LATIN_CAPITAL_LETTER_L	0x004C
#define T_IBM437_LATIN_CAPITAL_LETTER_M	0x004D
#define T_IBM437_LATIN_CAPITAL_LETTER_N	0x004E
#define T_IBM437_LATIN_CAPITAL_LETTER_O	0x004F
#define T_IBM437_LATIN_CAPITAL_LETTER_P	0x0050
#define T_IBM437_LATIN_CAPITAL_LETTER_Q	0x0051
#define T_IBM437_LATIN_CAPITAL_LETTER_R	0x0052
#define T_IBM437_LATIN_CAPITAL_LETTER_S	0x0053
#define T_IBM437_LATIN_CAPITAL_LETTER_T	0x0054
#define T_IBM437_LATIN_CAPITAL_LETTER_U	0x0055
#define T_IBM437_LATIN_CAPITAL_LETTER_V	0x0056
#define T_IBM437_LATIN_CAPITAL_LETTER_W	0x0057
#define T_IBM437_LATIN_CAPITAL_LETTER_X	0x0058
#define T_IBM437_LATIN_CAPITAL_LETTER_Y	0x0059
#define T_IBM437_LATIN_CAPITAL_LETTER_Z	0x005A
#define T_IBM437_LEFT_SQUARE_BRACKET	0x005B
#define T_IBM437_REVERSE_SOLIDUS	0x005C
#define T_IBM437_RIGHT_SQUARE_BRACKET	0x005D
#define T_IBM437_CIRCUMFLEX_ACCENT	0x005E
#define T_IBM437_LOW_LINE	0x005F
#define T_IBM437_GRAVE_ACCENT	0x0060
#define T_IBM437_LATIN_SMALL_LETTER_A	0x0061
#define T_IBM437_LATIN_SMALL_LETTER_B	0x0062
#define T_IBM437_LATIN_SMALL_LETTER_C	0x0063
#define T_IBM437_LATIN_SMALL_LETTER_D	0x0064
#define T_IBM437_LATIN_SMALL_LETTER_E	0x0065
#define T_IBM437_LATIN_SMALL_LETTER_F	0x0066
#define T_IBM437_LATIN_SMALL_LETTER_G	0x0067
#define T_IBM437_LATIN_SMALL_LETTER_H	0x0068
#define T_IBM437_LATIN_SMALL_LETTER_I	0x0069
#define T_IBM437_LATIN_SMALL_LETTER_J	0x006A
#define T_IBM437_LATIN_SMALL_LETTER_K	0x006B
#define T_IBM437_LATIN_SMALL_LETTER_L	0x006C
#define T_IBM437_LATIN_SMALL_LETTER_M	0x006D
#define T_IBM437_LATIN_SMALL_LETTER_N	0x006E
#define T_IBM437_LATIN_SMALL_LETTER_O	0x006F
#define T_IBM437_LATIN_SMALL_LETTER_P	0x0070
#define T_IBM437_LATIN_SMALL_LETTER_Q	0x0071
#define T_IBM437_LATIN_SMALL_LETTER_R	0x0072
#define T_IBM437_LATIN_SMALL_LETTER_S	0x0073
#define T_IBM437_LATIN_SMALL_LETTER_T	0x0074
#define T_IBM437_LATIN_SMALL_LETTER_U	0x0075
#define T_IBM437_LATIN_SMALL_LETTER_V	0x0076
#define T_IBM437_LATIN_SMALL_LETTER_W	0x0077
#define T_IBM437_LATIN_SMALL_LETTER_X	0x0078
#define T_IBM437_LATIN_SMALL_LETTER_Y	0x0079
#define T_IBM437_LATIN_SMALL_LETTER_Z	0x007A
#define T_IBM437_LEFT_CURLY_BRACKET	0x007B
#define T_IBM437_VERTICAL_LINE	0x007C
#define T_IBM437_RIGHT_CURLY_BRACKET	0x007D
#define T_IBM437_TILDE	0x007E
#define T_IBM437_HOUSE	0x007F
#define T_IBM437_LATIN_CAPITAL_LETTER_C_WITH_CEDILLA	0x0080
#define T_IBM437_LATIN_SMALL_LETTER_U_WITH_DIAERESIS	0x0081
#define T_IBM437_LATIN_SMALL_LETTER_E_WITH_ACUTE	0x0082
#define T_IBM437_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX	0x0083
#define T_IBM437_LATIN_SMALL_LETTER_A_WITH_DIAERESIS	0x0084
#define T_IBM437_LATIN_SMALL_LETTER_A_WITH_GRAVE	0x0085
#define T_IBM437_LATIN_SMALL_LETTER_A_WITH_RING_ABOVE	0x0086
#define T_IBM437_LATIN_SMALL_LETTER_C_WITH_CEDILLA	0x0087
#define T_IBM437_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX	0x0088
#define T_IBM437_LATIN_SMALL_LETTER_E_WITH_DIAERESIS	0x0089
#define T_IBM437_LATIN_SMALL_LETTER_E_WITH_GRAVE	0x008A
#define T_IBM437_LATIN_SMALL_LETTER_I_WITH_DIAERESIS	0x008B
#define T_IBM437_LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX	0x008C
#define T_IBM437_LATIN_SMALL_LETTER_I_WITH_GRAVE	0x008D
#define T_IBM437_LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS	0x008E
#define T_IBM437_LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE	0x008F
#define T_IBM437_LATIN_CAPITAL_LETTER_E_WITH_ACUTE	0x0090
#define T_IBM437_LATIN_SMALL_LETTER_AE	0x0091
#define T_IBM437_LATIN_CAPITAL_LETTER_AE	0x0092
#define T_IBM437_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX	0x0093
#define T_IBM437_LATIN_SMALL_LETTER_O_WITH_DIAERESIS	0x0094
#define T_IBM437_LATIN_SMALL_LETTER_O_WITH_GRAVE	0x0095
#define T_IBM437_LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX	0x0096
#define T_IBM437_LATIN_SMALL_LETTER_U_WITH_GRAVE	0x0097
#define T_IBM437_LATIN_SMALL_LETTER_Y_WITH_DIAERESIS	0x0098
#define T_IBM437_LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS	0x0099
#define T_IBM437_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS	0x009A
#define T_IBM437_CENT_SIGN	0x009B
#define T_IBM437_POUND_SIGN	0x009C
#define T_IBM437_YEN_SIGN	0x009D
#define T_IBM437_PESETA_SIGN	0x009E
#define T_IBM437_LATIN_SMALL_LETTER_F_WITH_HOOK	0x009F
#define T_IBM437_LATIN_SMALL_LETTER_A_WITH_ACUTE	0x00A0
#define T_IBM437_LATIN_SMALL_LETTER_I_WITH_ACUTE	0x00A1
#define T_IBM437_LATIN_SMALL_LETTER_O_WITH_ACUTE	0x00A2
#define T_IBM437_LATIN_SMALL_LETTER_U_WITH_ACUTE	0x00A3
#define T_IBM437_LATIN_SMALL_LETTER_N_WITH_TILDE	0x00A4
#define T_IBM437_LATIN_CAPITAL_LETTER_N_WITH_TILDE	0x00A5
#define T_IBM437_FEMININE_ORDINAL_INDICATOR	0x00A6
#define T_IBM437_MASCULINE_ORDINAL_INDICATOR	0x00A7
#define T_IBM437_INVERTED_QUESTION_MARK	0x00A8
#define T_IBM437_REVERSED_NOT_SIGN	0x00A9
#define T_IBM437_NOT_SIGN	0x00AA
#define T_IBM437_VULGAR_FRACTION_ONE_HALF	0x00AB
#define T_IBM437_VULGAR_FRACTION_ONE_QUARTER	0x00AC
#define T_IBM437_INVERTED_EXCLAMATION_MARK	0x00AD
#define T_IBM437_LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK	0x00AE
#define T_IBM437_RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK	0x00AF
#define T_IBM437_LIGHT_SHADE	0x00B0
#define T_IBM437_MEDIUM_SHADE	0x00B1
#define T_IBM437_DARK_SHADE	0x00B2
#define T_IBM437_BOX_DRAWINGS_LIGHT_VERTICAL	0x00B3
#define T_IBM437_BOX_DRAWINGS_LIGHT_VERTICAL_AND_LEFT	0x00B4
#define T_IBM437_BOX_DRAWINGS_VERTICAL_SINGLE_AND_LEFT_DOUBLE	0x00B5
#define T_IBM437_BOX_DRAWINGS_VERTICAL_DOUBLE_AND_LEFT_SINGLE	0x00B6
#define T_IBM437_BOX_DRAWINGS_DOWN_DOUBLE_AND_LEFT_SINGLE	0x00B7
#define T_IBM437_BOX_DRAWINGS_DOWN_SINGLE_AND_LEFT_DOUBLE	0x00B8
#define T_IBM437_BOX_DRAWINGS_DOUBLE_VERTICAL_AND_LEFT	0x00B9
#define T_IBM437_BOX_DRAWINGS_DOUBLE_VERTICAL	0x00BA
#define T_IBM437_BOX_DRAWINGS_DOUBLE_DOWN_AND_LEFT	0x00BB
#define T_IBM437_BOX_DRAWINGS_DOUBLE_UP_AND_LEFT	0x00BC
#define T_IBM437_BOX_DRAWINGS_UP_DOUBLE_AND_LEFT_SINGLE	0x00BD
#define T_IBM437_BOX_DRAWINGS_UP_SINGLE_AND_LEFT_DOUBLE	0x00BE
#define T_IBM437_BOX_DRAWINGS_LIGHT_DOWN_AND_LEFT	0x00BF
#define T_IBM437_BOX_DRAWINGS_LIGHT_UP_AND_RIGHT	0x00C0
#define T_IBM437_BOX_DRAWINGS_LIGHT_UP_AND_HORIZONTAL	0x00C1
#define T_IBM437_BOX_DRAWINGS_LIGHT_DOWN_AND_HORIZONTAL	0x00C2
#define T_IBM437_BOX_DRAWINGS_LIGHT_VERTICAL_AND_RIGHT	0x00C3
#define T_IBM437_BOX_DRAWINGS_LIGHT_HORIZONTAL	0x00C4
#define T_IBM437_BOX_DRAWINGS_LIGHT_VERTICAL_AND_HORIZONTAL	0x00C5
#define T_IBM437_BOX_DRAWINGS_VERTICAL_SINGLE_AND_RIGHT_DOUBLE	0x00C6
#define T_IBM437_BOX_DRAWINGS_VERTICAL_DOUBLE_AND_RIGHT_SINGLE	0x00C7
#define T_IBM437_BOX_DRAWINGS_DOUBLE_UP_AND_RIGHT	0x00C8
#define T_IBM437_BOX_DRAWINGS_DOUBLE_DOWN_AND_RIGHT	0x00C9
#define T_IBM437_BOX_DRAWINGS_DOUBLE_UP_AND_HORIZONTAL	0x00CA
#define T_IBM437_BOX_DRAWINGS_DOUBLE_DOWN_AND_HORIZONTAL	0x00CB
#define T_IBM437_BOX_DRAWINGS_DOUBLE_VERTICAL_AND_RIGHT	0x00CC
#define T_IBM437_BOX_DRAWINGS_DOUBLE_HORIZONTAL	0x00CD
#define T_IBM437_BOX_DRAWINGS_DOUBLE_VERTICAL_AND_HORIZONTAL	0x00CE
#define T_IBM437_BOX_DRAWINGS_UP_SINGLE_AND_HORIZONTAL_DOUBLE	0x00CF
#define T_IBM437_BOX_DRAWINGS_UP_DOUBLE_AND_HORIZONTAL_SINGLE	0x00D0
#define T_IBM437_BOX_DRAWINGS_DOWN_SINGLE_AND_HORIZONTAL_DOUBLE	0x00D1
#define T_IBM437_BOX_DRAWINGS_DOWN_DOUBLE_AND_HORIZONTAL_SINGLE	0x00D2
#define T_IBM437_BOX_DRAWINGS_UP_DOUBLE_AND_RIGHT_SINGLE	0x00D3
#define T_IBM437_BOX_DRAWINGS_UP_SINGLE_AND_RIGHT_DOUBLE	0x00D4
#define T_IBM437_BOX_DRAWINGS_DOWN_SINGLE_AND_RIGHT_DOUBLE	0x00D5
#define T_IBM437_BOX_DRAWINGS_DOWN_DOUBLE_AND_RIGHT_SINGLE	0x00D6
#define T_IBM437_BOX_DRAWINGS_VERTICAL_DOUBLE_AND_HORIZONTAL_SINGLE	0x00D7
#define T_IBM437_BOX_DRAWINGS_VERTICAL_SINGLE_AND_HORIZONTAL_DOUBLE	0x00D8
#define T_IBM437_BOX_DRAWINGS_LIGHT_UP_AND_LEFT	0x00D9
#define T_IBM437_BOX_DRAWINGS_LIGHT_DOWN_AND_RIGHT	0x00DA
#define T_IBM437_FULL_BLOCK	0x00DB
#define T_IBM437_LOWER_HALF_BLOCK	0x00DC
#define T_IBM437_LEFT_HALF_BLOCK	0x00DD
#define T_IBM437_RIGHT_HALF_BLOCK	0x00DE
#define T_IBM437_UPPER_HALF_BLOCK	0x00DF
#define T_IBM437_GREEK_SMALL_LETTER_ALPHA	0x00E0
#define T_IBM437_LATIN_SMALL_LETTER_SHARP_S	0x00E1
#define T_IBM437_GREEK_CAPITAL_LETTER_GAMMA	0x00E2
#define T_IBM437_GREEK_SMALL_LETTER_PI	0x00E3
#define T_IBM437_GREEK_CAPITAL_LETTER_SIGMA	0x00E4
#define T_IBM437_GREEK_SMALL_LETTER_SIGMA	0x00E5
#define T_IBM437_MICRO_SIGN	0x00E6
#define T_IBM437_GREEK_SMALL_LETTER_TAU	0x00E7
#define T_IBM437_GREEK_CAPITAL_LETTER_PHI	0x00E8
#define T_IBM437_GREEK_CAPITAL_LETTER_THETA	0x00E9
#define T_IBM437_GREEK_CAPITAL_LETTER_OMEGA	0x00EA
#define T_IBM437_GREEK_SMALL_LETTER_DELTA	0x00EB
#define T_IBM437_INFINITY	0x00EC
#define T_IBM437_GREEK_SMALL_LETTER_PHI	0x00ED
#define T_IBM437_GREEK_SMALL_LETTER_EPSILON	0x00EE
#define T_IBM437_INTERSECTION	0x00EF
#define T_IBM437_IDENTICAL_TO	0x00F0
#define T_IBM437_PLUS_MINUS_SIGN	0x00F1
#define T_IBM437_GREATER_THAN_OR_EQUAL_TO	0x00F2
#define T_IBM437_LESS_THAN_OR_EQUAL_TO	0x00F3
#define T_IBM437_TOP_HALF_INTEGRAL	0x00F4
#define T_IBM437_BOTTOM_HALF_INTEGRAL	0x00F5
#define T_IBM437_DIVISION_SIGN	0x00F6
#define T_IBM437_ALMOST_EQUAL_TO	0x00F7
#define T_IBM437_DEGREE_SIGN	0x00F8
#define T_IBM437_BULLET_OPERATOR	0x00F9
#define T_IBM437_MIDDLE_DOT	0x00FA
#define T_IBM437_SQUARE_ROOT	0x00FB
#define T_IBM437_SUPERSCRIPT_LATIN_SMALL_LETTER_N	0x00FC
#define T_IBM437_SUPERSCRIPT_TWO	0x00FD
#define T_IBM437_BLACK_SQUARE	0x00FE
#define T_IBM437_NO_BREAK_SPACE	0x00FF

/* list of all characters */
#define T_LIST_IBM437(EL) \
    EL(_NULL) \
    EL(_WHITE_SMILING_FACE) \
    EL(_BLACK_SMILING_FACE) \
    EL(_BLACK_HEART_SUIT) \
    EL(_BLACK_DIAMOND_SUIT) \
    EL(_BLACK_CLUB_SUIT) \
    EL(_BLACK_SPADE_SUIT) \
    EL(_BULLET) \
    EL(_INVERSE_BULLET) \
    EL(_WHITE_CIRCLE) \
    EL(_INVERSE_WHITE_CIRCLE) \
    EL(_MALE_SIGN) \
    EL(_FEMALE_SIGN) \
    EL(_EIGHTH_NOTE) \
    EL(_BEAMED_EIGHTH_NOTES) \
    EL(_WHITE_SUN_WITH_RAYS) \
    EL(_BLACK_RIGHT_POINTING_TRIANGLE) \
    EL(_BLACK_LEFT_POINTING_TRIANGLE) \
    EL(_UP_DOWN_ARROW) \
    EL(_DOUBLE_EXCLAMATION_MARK) \
    EL(_PILCROW_SIGN) \
    EL(_SECTION_SIGN) \
    EL(_BLACK_RECTANGLE) \
    EL(_UP_DOWN_ARROW_WITH_BASE) \
    EL(_UPWARDS_ARROW) \
    EL(_DOWNWARDS_ARROW) \
    EL(_RIGHTWARDS_ARROW) \
    EL(_LEFTWARDS_ARROW) \
    EL(_RIGHT_ANGLE) \
    EL(_LEFT_RIGHT_ARROW) \
    EL(_BLACK_UP_POINTING_TRIANGLE) \
    EL(_BLACK_DOWN_POINTING_TRIANGLE) \
    EL(_SPACE) \
    EL(_EXCLAMATION_MARK) \
    EL(_QUOTATION_MARK) \
    EL(_NUMBER_SIGN) \
    EL(_DOLLAR_SIGN) \
    EL(_PERCENT_SIGN) \
    EL(_AMPERSAND) \
    EL(_APOSTROPHE) \
    EL(_LEFT_PARENTHESIS) \
    EL(_RIGHT_PARENTHESIS) \
    EL(_ASTERISK) \
    EL(_PLUS_SIGN) \
    EL(_COMMA) \
    EL(_HYPHEN_MINUS) \
    EL(_FULL_STOP) \
    EL(_SOLIDUS) \
    EL(_DIGIT_ZERO) \
    EL(_DIGIT_ONE) \
    EL(_DIGIT_TWO) \
    EL(_DIGIT_THREE) \
    EL(_DIGIT_FOUR) \
    EL(_DIGIT_FIVE) \
    EL(_DIGIT_SIX) \
    EL(_DIGIT_SEVEN) \
    EL(_DIGIT_EIGHT) \
    EL(_DIGIT_NINE) \
    EL(_COLON) \
    EL(_SEMICOLON) \
    EL(_LESS_THAN_SIGN) \
    EL(_EQUALS_SIGN) \
    EL(_GREATER_THAN_SIGN) \
    EL(_QUESTION_MARK) \
    EL(_COMMERCIAL_AT) \
    EL(_LATIN_CAPITAL_LETTER_A) \
    EL(_LATIN_CAPITAL_LETTER_B) \
    EL(_LATIN_CAPITAL_LETTER_C) \
    EL(_LATIN_CAPITAL_LETTER_D) \
    EL(_LATIN_CAPITAL_LETTER_E) \
    EL(_LATIN_CAPITAL_LETTER_F) \
    EL(_LATIN_CAPITAL_LETTER_G) \
    EL(_LATIN_CAPITAL_LETTER_H) \
    EL(_LATIN_CAPITAL_LETTER_I) \
    EL(_LATIN_CAPITAL_LETTER_J) \
    EL(_LATIN_CAPITAL_LETTER_K) \
    EL(_LATIN_CAPITAL_LETTER_L) \
    EL(_LATIN_CAPITAL_LETTER_M) \
    EL(_LATIN_CAPITAL_LETTER_N) \
    EL(_LATIN_CAPITAL_LETTER_O) \
    EL(_LATIN_CAPITAL_LETTER_P) \
    EL(_LATIN_CAPITAL_LETTER_Q) \
    EL(_LATIN_CAPITAL_LETTER_R) \
    EL(_LATIN_CAPITAL_LETTER_S) \
    EL(_LATIN_CAPITAL_LETTER_T) \
    EL(_LATIN_CAPITAL_LETTER_U) \
    EL(_LATIN_CAPITAL_LETTER_V) \
    EL(_LATIN_CAPITAL_LETTER_W) \
    EL(_LATIN_CAPITAL_LETTER_X) \
    EL(_LATIN_CAPITAL_LETTER_Y) \
    EL(_LATIN_CAPITAL_LETTER_Z) \
    EL(_LEFT_SQUARE_BRACKET) \
    EL(_REVERSE_SOLIDUS) \
    EL(_RIGHT_SQUARE_BRACKET) \
    EL(_CIRCUMFLEX_ACCENT) \
    EL(_LOW_LINE) \
    EL(_GRAVE_ACCENT) \
    EL(_LATIN_SMALL_LETTER_A) \
    EL(_LATIN_SMALL_LETTER_B) \
    EL(_LATIN_SMALL_LETTER_C) \
    EL(_LATIN_SMALL_LETTER_D) \
    EL(_LATIN_SMALL_LETTER_E) \
    EL(_LATIN_SMALL_LETTER_F) \
    EL(_LATIN_SMALL_LETTER_G) \
    EL(_LATIN_SMALL_LETTER_H) \
    EL(_LATIN_SMALL_LETTER_I) \
    EL(_LATIN_SMALL_LETTER_J) \
    EL(_LATIN_SMALL_LETTER_K) \
    EL(_LATIN_SMALL_LETTER_L) \
    EL(_LATIN_SMALL_LETTER_M) \
    EL(_LATIN_SMALL_LETTER_N) \
    EL(_LATIN_SMALL_LETTER_O) \
    EL(_LATIN_SMALL_LETTER_P) \
    EL(_LATIN_SMALL_LETTER_Q) \
    EL(_LATIN_SMALL_LETTER_R) \
    EL(_LATIN_SMALL_LETTER_S) \
    EL(_LATIN_SMALL_LETTER_T) \
    EL(_LATIN_SMALL_LETTER_U) \
    EL(_LATIN_SMALL_LETTER_V) \
    EL(_LATIN_SMALL_LETTER_W) \
    EL(_LATIN_SMALL_LETTER_X) \
    EL(_LATIN_SMALL_LETTER_Y) \
    EL(_LATIN_SMALL_LETTER_Z) \
    EL(_LEFT_CURLY_BRACKET) \
    EL(_VERTICAL_LINE) \
    EL(_RIGHT_CURLY_BRACKET) \
    EL(_TILDE) \
    EL(_HOUSE) \
    EL(_LATIN_CAPITAL_LETTER_C_WITH_CEDILLA) \
    EL(_LATIN_SMALL_LETTER_U_WITH_DIAERESIS) \
    EL(_LATIN_SMALL_LETTER_E_WITH_ACUTE) \
    EL(_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX) \
    EL(_LATIN_SMALL_LETTER_A_WITH_DIAERESIS) \
    EL(_LATIN_SMALL_LETTER_A_WITH_GRAVE) \
    EL(_LATIN_SMALL_LETTER_A_WITH_RING_ABOVE) \
    EL(_LATIN_SMALL_LETTER_C_WITH_CEDILLA) \
    EL(_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX) \
    EL(_LATIN_SMALL_LETTER_E_WITH_DIAERESIS) \
    EL(_LATIN_SMALL_LETTER_E_WITH_GRAVE) \
    EL(_LATIN_SMALL_LETTER_I_WITH_DIAERESIS) \
    EL(_LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX) \
    EL(_LATIN_SMALL_LETTER_I_WITH_GRAVE) \
    EL(_LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS) \
    EL(_LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE) \
    EL(_LATIN_CAPITAL_LETTER_E_WITH_ACUTE) \
    EL(_LATIN_SMALL_LETTER_AE) \
    EL(_LATIN_CAPITAL_LETTER_AE) \
    EL(_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX) \
    EL(_LATIN_SMALL_LETTER_O_WITH_DIAERESIS) \
    EL(_LATIN_SMALL_LETTER_O_WITH_GRAVE) \
    EL(_LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX) \
    EL(_LATIN_SMALL_LETTER_U_WITH_GRAVE) \
    EL(_LATIN_SMALL_LETTER_Y_WITH_DIAERESIS) \
    EL(_LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS) \
    EL(_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS) \
    EL(_CENT_SIGN) \
    EL(_POUND_SIGN) \
    EL(_YEN_SIGN) \
    EL(_PESETA_SIGN) \
    EL(_LATIN_SMALL_LETTER_F_WITH_HOOK) \
    EL(_LATIN_SMALL_LETTER_A_WITH_ACUTE) \
    EL(_LATIN_SMALL_LETTER_I_WITH_ACUTE) \
    EL(_LATIN_SMALL_LETTER_O_WITH_ACUTE) \
    EL(_LATIN_SMALL_LETTER_U_WITH_ACUTE) \
    EL(_LATIN_SMALL_LETTER_N_WITH_TILDE) \
    EL(_LATIN_CAPITAL_LETTER_N_WITH_TILDE) \
    EL(_FEMININE_ORDINAL_INDICATOR) \
    EL(_MASCULINE_ORDINAL_INDICATOR) \
    EL(_INVERTED_QUESTION_MARK) \
    EL(_REVERSED_NOT_SIGN) \
    EL(_NOT_SIGN) \
    EL(_VULGAR_FRACTION_ONE_HALF) \
    EL(_VULGAR_FRACTION_ONE_QUARTER) \
    EL(_INVERTED_EXCLAMATION_MARK) \
    EL(_LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK) \
    EL(_RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK) \
    EL(_LIGHT_SHADE) \
    EL(_MEDIUM_SHADE) \
    EL(_DARK_SHADE) \
    EL(_BOX_DRAWINGS_LIGHT_VERTICAL) \
    EL(_BOX_DRAWINGS_LIGHT_VERTICAL_AND_LEFT) \
    EL(_BOX_DRAWINGS_VERTICAL_SINGLE_AND_LEFT_DOUBLE) \
    EL(_BOX_DRAWINGS_VERTICAL_DOUBLE_AND_LEFT_SINGLE) \
    EL(_BOX_DRAWINGS_DOWN_DOUBLE_AND_LEFT_SINGLE) \
    EL(_BOX_DRAWINGS_DOWN_SINGLE_AND_LEFT_DOUBLE) \
    EL(_BOX_DRAWINGS_DOUBLE_VERTICAL_AND_LEFT) \
    EL(_BOX_DRAWINGS_DOUBLE_VERTICAL) \
    EL(_BOX_DRAWINGS_DOUBLE_DOWN_AND_LEFT) \
    EL(_BOX_DRAWINGS_DOUBLE_UP_AND_LEFT) \
    EL(_BOX_DRAWINGS_UP_DOUBLE_AND_LEFT_SINGLE) \
    EL(_BOX_DRAWINGS_UP_SINGLE_AND_LEFT_DOUBLE) \
    EL(_BOX_DRAWINGS_LIGHT_DOWN_AND_LEFT) \
    EL(_BOX_DRAWINGS_LIGHT_UP_AND_RIGHT) \
    EL(_BOX_DRAWINGS_LIGHT_UP_AND_HORIZONTAL) \
    EL(_BOX_DRAWINGS_LIGHT_DOWN_AND_HORIZONTAL) \
    EL(_BOX_DRAWINGS_LIGHT_VERTICAL_AND_RIGHT) \
    EL(_BOX_DRAWINGS_LIGHT_HORIZONTAL) \
    EL(_BOX_DRAWINGS_LIGHT_VERTICAL_AND_HORIZONTAL) \
    EL(_BOX_DRAWINGS_VERTICAL_SINGLE_AND_RIGHT_DOUBLE) \
    EL(_BOX_DRAWINGS_VERTICAL_DOUBLE_AND_RIGHT_SINGLE) \
    EL(_BOX_DRAWINGS_DOUBLE_UP_AND_RIGHT) \
    EL(_BOX_DRAWINGS_DOUBLE_DOWN_AND_RIGHT) \
    EL(_BOX_DRAWINGS_DOUBLE_UP_AND_HORIZONTAL) \
    EL(_BOX_DRAWINGS_DOUBLE_DOWN_AND_HORIZONTAL) \
    EL(_BOX_DRAWINGS_DOUBLE_VERTICAL_AND_RIGHT) \
    EL(_BOX_DRAWINGS_DOUBLE_HORIZONTAL) \
    EL(_BOX_DRAWINGS_DOUBLE_VERTICAL_AND_HORIZONTAL) \
    EL(_BOX_DRAWINGS_UP_SINGLE_AND_HORIZONTAL_DOUBLE) \
    EL(_BOX_DRAWINGS_UP_DOUBLE_AND_HORIZONTAL_SINGLE) \
    EL(_BOX_DRAWINGS_DOWN_SINGLE_AND_HORIZONTAL_DOUBLE) \
    EL(_BOX_DRAWINGS_DOWN_DOUBLE_AND_HORIZONTAL_SINGLE) \
    EL(_BOX_DRAWINGS_UP_DOUBLE_AND_RIGHT_SINGLE) \
    EL(_BOX_DRAWINGS_UP_SINGLE_AND_RIGHT_DOUBLE) \
    EL(_BOX_DRAWINGS_DOWN_SINGLE_AND_RIGHT_DOUBLE) \
    EL(_BOX_DRAWINGS_DOWN_DOUBLE_AND_RIGHT_SINGLE) \
    EL(_BOX_DRAWINGS_VERTICAL_DOUBLE_AND_HORIZONTAL_SINGLE) \
    EL(_BOX_DRAWINGS_VERTICAL_SINGLE_AND_HORIZONTAL_DOUBLE) \
    EL(_BOX_DRAWINGS_LIGHT_UP_AND_LEFT) \
    EL(_BOX_DRAWINGS_LIGHT_DOWN_AND_RIGHT) \
    EL(_FULL_BLOCK) \
    EL(_LOWER_HALF_BLOCK) \
    EL(_LEFT_HALF_BLOCK) \
    EL(_RIGHT_HALF_BLOCK) \
    EL(_UPPER_HALF_BLOCK) \
    EL(_GREEK_SMALL_LETTER_ALPHA) \
    EL(_LATIN_SMALL_LETTER_SHARP_S) \
    EL(_GREEK_CAPITAL_LETTER_GAMMA) \
    EL(_GREEK_SMALL_LETTER_PI) \
    EL(_GREEK_CAPITAL_LETTER_SIGMA) \
    EL(_GREEK_SMALL_LETTER_SIGMA) \
    EL(_MICRO_SIGN) \
    EL(_GREEK_SMALL_LETTER_TAU) \
    EL(_GREEK_CAPITAL_LETTER_PHI) \
    EL(_GREEK_CAPITAL_LETTER_THETA) \
    EL(_GREEK_CAPITAL_LETTER_OMEGA) \
    EL(_GREEK_SMALL_LETTER_DELTA) \
    EL(_INFINITY) \
    EL(_GREEK_SMALL_LETTER_PHI) \
    EL(_GREEK_SMALL_LETTER_EPSILON) \
    EL(_INTERSECTION) \
    EL(_IDENTICAL_TO) \
    EL(_PLUS_MINUS_SIGN) \
    EL(_GREATER_THAN_OR_EQUAL_TO) \
    EL(_LESS_THAN_OR_EQUAL_TO) \
    EL(_TOP_HALF_INTEGRAL) \
    EL(_BOTTOM_HALF_INTEGRAL) \
    EL(_DIVISION_SIGN) \
    EL(_ALMOST_EQUAL_TO) \
    EL(_DEGREE_SIGN) \
    EL(_BULLET_OPERATOR) \
    EL(_MIDDLE_DOT) \
    EL(_SQUARE_ROOT) \
    EL(_SUPERSCRIPT_LATIN_SMALL_LETTER_N) \
    EL(_SUPERSCRIPT_TWO) \
    EL(_BLACK_SQUARE) \
    EL(_NO_BREAK_SPACE)


/* list of all characters NOT IDENTICALLY MAPPED to UTF-16 */
#define T_NLIST_IBM437(EL) \
    EL(_NULL) \
    EL(_WHITE_SMILING_FACE) \
    EL(_BLACK_SMILING_FACE) \
    EL(_BLACK_HEART_SUIT) \
    EL(_BLACK_DIAMOND_SUIT) \
    EL(_BLACK_CLUB_SUIT) \
    EL(_BLACK_SPADE_SUIT) \
    EL(_BULLET) \
    EL(_INVERSE_BULLET) \
    EL(_WHITE_CIRCLE) \
    EL(_INVERSE_WHITE_CIRCLE) \
    EL(_MALE_SIGN) \
    EL(_FEMALE_SIGN) \
    EL(_EIGHTH_NOTE) \
    EL(_BEAMED_EIGHTH_NOTES) \
    EL(_WHITE_SUN_WITH_RAYS) \
    EL(_BLACK_RIGHT_POINTING_TRIANGLE) \
    EL(_BLACK_LEFT_POINTING_TRIANGLE) \
    EL(_UP_DOWN_ARROW) \
    EL(_DOUBLE_EXCLAMATION_MARK) \
    EL(_PILCROW_SIGN) \
    EL(_SECTION_SIGN) \
    EL(_BLACK_RECTANGLE) \
    EL(_UP_DOWN_ARROW_WITH_BASE) \
    EL(_UPWARDS_ARROW) \
    EL(_DOWNWARDS_ARROW) \
    EL(_RIGHTWARDS_ARROW) \
    EL(_LEFTWARDS_ARROW) \
    EL(_RIGHT_ANGLE) \
    EL(_LEFT_RIGHT_ARROW) \
    EL(_BLACK_UP_POINTING_TRIANGLE) \
    EL(_BLACK_DOWN_POINTING_TRIANGLE) \
    EL(_HOUSE) \
    EL(_LATIN_CAPITAL_LETTER_C_WITH_CEDILLA) \
    EL(_LATIN_SMALL_LETTER_U_WITH_DIAERESIS) \
    EL(_LATIN_SMALL_LETTER_E_WITH_ACUTE) \
    EL(_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX) \
    EL(_LATIN_SMALL_LETTER_A_WITH_DIAERESIS) \
    EL(_LATIN_SMALL_LETTER_A_WITH_GRAVE) \
    EL(_LATIN_SMALL_LETTER_A_WITH_RING_ABOVE) \
    EL(_LATIN_SMALL_LETTER_C_WITH_CEDILLA) \
    EL(_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX) \
    EL(_LATIN_SMALL_LETTER_E_WITH_DIAERESIS) \
    EL(_LATIN_SMALL_LETTER_E_WITH_GRAVE) \
    EL(_LATIN_SMALL_LETTER_I_WITH_DIAERESIS) \
    EL(_LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX) \
    EL(_LATIN_SMALL_LETTER_I_WITH_GRAVE) \
    EL(_LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS) \
    EL(_LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE) \
    EL(_LATIN_CAPITAL_LETTER_E_WITH_ACUTE) \
    EL(_LATIN_SMALL_LETTER_AE) \
    EL(_LATIN_CAPITAL_LETTER_AE) \
    EL(_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX) \
    EL(_LATIN_SMALL_LETTER_O_WITH_DIAERESIS) \
    EL(_LATIN_SMALL_LETTER_O_WITH_GRAVE) \
    EL(_LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX) \
    EL(_LATIN_SMALL_LETTER_U_WITH_GRAVE) \
    EL(_LATIN_SMALL_LETTER_Y_WITH_DIAERESIS) \
    EL(_LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS) \
    EL(_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS) \
    EL(_CENT_SIGN) \
    EL(_POUND_SIGN) \
    EL(_YEN_SIGN) \
    EL(_PESETA_SIGN) \
    EL(_LATIN_SMALL_LETTER_F_WITH_HOOK) \
    EL(_LATIN_SMALL_LETTER_A_WITH_ACUTE) \
    EL(_LATIN_SMALL_LETTER_I_WITH_ACUTE) \
    EL(_LATIN_SMALL_LETTER_O_WITH_ACUTE) \
    EL(_LATIN_SMALL_LETTER_U_WITH_ACUTE) \
    EL(_LATIN_SMALL_LETTER_N_WITH_TILDE) \
    EL(_LATIN_CAPITAL_LETTER_N_WITH_TILDE) \
    EL(_FEMININE_ORDINAL_INDICATOR) \
    EL(_MASCULINE_ORDINAL_INDICATOR) \
    EL(_INVERTED_QUESTION_MARK) \
    EL(_REVERSED_NOT_SIGN) \
    EL(_NOT_SIGN) \
    EL(_VULGAR_FRACTION_ONE_HALF) \
    EL(_VULGAR_FRACTION_ONE_QUARTER) \
    EL(_INVERTED_EXCLAMATION_MARK) \
    EL(_LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK) \
    EL(_RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK) \
    EL(_LIGHT_SHADE) \
    EL(_MEDIUM_SHADE) \
    EL(_DARK_SHADE) \
    EL(_BOX_DRAWINGS_LIGHT_VERTICAL) \
    EL(_BOX_DRAWINGS_LIGHT_VERTICAL_AND_LEFT) \
    EL(_BOX_DRAWINGS_VERTICAL_SINGLE_AND_LEFT_DOUBLE) \
    EL(_BOX_DRAWINGS_VERTICAL_DOUBLE_AND_LEFT_SINGLE) \
    EL(_BOX_DRAWINGS_DOWN_DOUBLE_AND_LEFT_SINGLE) \
    EL(_BOX_DRAWINGS_DOWN_SINGLE_AND_LEFT_DOUBLE) \
    EL(_BOX_DRAWINGS_DOUBLE_VERTICAL_AND_LEFT) \
    EL(_BOX_DRAWINGS_DOUBLE_VERTICAL) \
    EL(_BOX_DRAWINGS_DOUBLE_DOWN_AND_LEFT) \
    EL(_BOX_DRAWINGS_DOUBLE_UP_AND_LEFT) \
    EL(_BOX_DRAWINGS_UP_DOUBLE_AND_LEFT_SINGLE) \
    EL(_BOX_DRAWINGS_UP_SINGLE_AND_LEFT_DOUBLE) \
    EL(_BOX_DRAWINGS_LIGHT_DOWN_AND_LEFT) \
    EL(_BOX_DRAWINGS_LIGHT_UP_AND_RIGHT) \
    EL(_BOX_DRAWINGS_LIGHT_UP_AND_HORIZONTAL) \
    EL(_BOX_DRAWINGS_LIGHT_DOWN_AND_HORIZONTAL) \
    EL(_BOX_DRAWINGS_LIGHT_VERTICAL_AND_RIGHT) \
    EL(_BOX_DRAWINGS_LIGHT_HORIZONTAL) \
    EL(_BOX_DRAWINGS_LIGHT_VERTICAL_AND_HORIZONTAL) \
    EL(_BOX_DRAWINGS_VERTICAL_SINGLE_AND_RIGHT_DOUBLE) \
    EL(_BOX_DRAWINGS_VERTICAL_DOUBLE_AND_RIGHT_SINGLE) \
    EL(_BOX_DRAWINGS_DOUBLE_UP_AND_RIGHT) \
    EL(_BOX_DRAWINGS_DOUBLE_DOWN_AND_RIGHT) \
    EL(_BOX_DRAWINGS_DOUBLE_UP_AND_HORIZONTAL) \
    EL(_BOX_DRAWINGS_DOUBLE_DOWN_AND_HORIZONTAL) \
    EL(_BOX_DRAWINGS_DOUBLE_VERTICAL_AND_RIGHT) \
    EL(_BOX_DRAWINGS_DOUBLE_HORIZONTAL) \
    EL(_BOX_DRAWINGS_DOUBLE_VERTICAL_AND_HORIZONTAL) \
    EL(_BOX_DRAWINGS_UP_SINGLE_AND_HORIZONTAL_DOUBLE) \
    EL(_BOX_DRAWINGS_UP_DOUBLE_AND_HORIZONTAL_SINGLE) \
    EL(_BOX_DRAWINGS_DOWN_SINGLE_AND_HORIZONTAL_DOUBLE) \
    EL(_BOX_DRAWINGS_DOWN_DOUBLE_AND_HORIZONTAL_SINGLE) \
    EL(_BOX_DRAWINGS_UP_DOUBLE_AND_RIGHT_SINGLE) \
    EL(_BOX_DRAWINGS_UP_SINGLE_AND_RIGHT_DOUBLE) \
    EL(_BOX_DRAWINGS_DOWN_SINGLE_AND_RIGHT_DOUBLE) \
    EL(_BOX_DRAWINGS_DOWN_DOUBLE_AND_RIGHT_SINGLE) \
    EL(_BOX_DRAWINGS_VERTICAL_DOUBLE_AND_HORIZONTAL_SINGLE) \
    EL(_BOX_DRAWINGS_VERTICAL_SINGLE_AND_HORIZONTAL_DOUBLE) \
    EL(_BOX_DRAWINGS_LIGHT_UP_AND_LEFT) \
    EL(_BOX_DRAWINGS_LIGHT_DOWN_AND_RIGHT) \
    EL(_FULL_BLOCK) \
    EL(_LOWER_HALF_BLOCK) \
    EL(_LEFT_HALF_BLOCK) \
    EL(_RIGHT_HALF_BLOCK) \
    EL(_UPPER_HALF_BLOCK) \
    EL(_GREEK_SMALL_LETTER_ALPHA) \
    EL(_LATIN_SMALL_LETTER_SHARP_S) \
    EL(_GREEK_CAPITAL_LETTER_GAMMA) \
    EL(_GREEK_SMALL_LETTER_PI) \
    EL(_GREEK_CAPITAL_LETTER_SIGMA) \
    EL(_GREEK_SMALL_LETTER_SIGMA) \
    EL(_MICRO_SIGN) \
    EL(_GREEK_SMALL_LETTER_TAU) \
    EL(_GREEK_CAPITAL_LETTER_PHI) \
    EL(_GREEK_CAPITAL_LETTER_THETA) \
    EL(_GREEK_CAPITAL_LETTER_OMEGA) \
    EL(_GREEK_SMALL_LETTER_DELTA) \
    EL(_INFINITY) \
    EL(_GREEK_SMALL_LETTER_PHI) \
    EL(_GREEK_SMALL_LETTER_EPSILON) \
    EL(_INTERSECTION) \
    EL(_IDENTICAL_TO) \
    EL(_PLUS_MINUS_SIGN) \
    EL(_GREATER_THAN_OR_EQUAL_TO) \
    EL(_LESS_THAN_OR_EQUAL_TO) \
    EL(_TOP_HALF_INTEGRAL) \
    EL(_BOTTOM_HALF_INTEGRAL) \
    EL(_DIVISION_SIGN) \
    EL(_ALMOST_EQUAL_TO) \
    EL(_DEGREE_SIGN) \
    EL(_BULLET_OPERATOR) \
    EL(_MIDDLE_DOT) \
    EL(_SQUARE_ROOT) \
    EL(_SUPERSCRIPT_LATIN_SMALL_LETTER_N) \
    EL(_SUPERSCRIPT_TWO) \
    EL(_BLACK_SQUARE) \
    EL(_NO_BREAK_SPACE)


#endif /* _TUTF_IBM437_H */

