//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef __ENTITY_ELAB_HH__
#define __ENTITY_ELAB_HH__

#include "tyvis/Block.hh"
#include "tyvis/PortMap.hh"
#include <clutils/PluginBase.h>
#include <vector>
using std::vector;

class SignalNetinfo;
class VHDLType;
class ScalarType;
class RecordType;
class ArrayType;
class TypeConvert;
class VHDLKernel;
class Hierarchy;

extern ResolutionFnPtr *savantResolutionFn;
extern TypeConversionFnPtr *savantTypeConversionFn;

class _savant_entity_elab : public PluginBase {
public:
  _savant_entity_elab();
  virtual ~_savant_entity_elab();

  static int typeConversionFnIdCounter;
  static int resolutionFnIdCounter;

  virtual void instantiate( Hierarchy *hier );
  virtual void createNetInfo();
  virtual void connect(int inputsignals, int outputsignals, ...);
  
  virtual void Add( VHDLType &, VHDLType & );
  virtual void Add( VHDLType &, SignalNetinfo& sig );
  virtual void Add( VHDLType &, VHDLKernel * );
  virtual void Add( VHDLType &, VHDLKernel *, int sigid );
  virtual void Add( VHDLType &, SignalNetinfo *ptr );
  virtual void Addall( VHDLType &dest, const VHDLType &src );
  virtual void collectFanout( SignalNetinfo*, const VHDLType & );
  
  vector<VHDLType*> fanOutInfo;
  
  //@{ methods required for implementing resolution functions and type
  // conversion functions in tyvis/savant

  /** This method sets the resolution function id of the source of this
      signal. */
  void setResolutionFunctionId(VHDLType &, ResolutionFnPtr);  
  
  /** When a ResolutionFunctionPtr is added to the global
      resolution function pointer table, the id at which this pointer is
      stored is returned. */
  static int addResolutionFn(ResolutionFnPtr resolve);
  static int addTypeConversionFn(TypeConversionFnPtr upConvert);

  void setUpConversionFunctionId(VHDLType &, TypeConversionFnPtr);

  /** This method sets the down type conversion function id of the source of
      this signal. */
  void setDownConversionFunctionId(ScalarType&, TypeConversionFnPtr);

  /** If the source of the corresponding SignalNetinfo is not initialized,
      we new a SourceData for it and assign the data to it.  If it is
      initialized and it has 0 children, then the source is a SourceData
      node.  Then, we "new" a SourceInfo node there, copy the contents of
      the old SourceData node as the new node's child, add the new child,
      and delete the old SourceData node.  This is done so as to remove the
      burden from the elaboration code that is generated. */
  void addChild(SignalNetinfo* sigInfo, VHDLType *data, VHDLKernel* processPtr);
  void addChild(VHDLType & sigInfo, VHDLType & data, VHDLKernel* processPtr);
  void addChild(VHDLType & sigInfo, VHDLType & data);
  void addChild(SignalNetinfo* sigInfo, SignalNetinfo* driverInfo);

  /** This method does the setup for the TypeConversion to be done during the
      runtime. It just holds the poniters to various temporary and permanent
      information needed during the TypeConversion. */
  void addUpConvertDriver(VHDLType & sigInfo, VHDLType &data, TypeConvert *typeConvertPtr);
  void addUpConvertDriver(SignalNetinfo *sigInfo, VHDLType *data, TypeConvert *typeConvertPtr);

  /** adds the driverInfo to the block existing in the SignalNetinfo class.
      first checks whether atleast one does not have additionalDriverList. If so
      it new's a Block and adds this driverInfo passes it to the subelements other
      wise, it just passes the driverInfo so that it can be added to the already
      existing block in the SignalNetinfo object.
  */
  void addDriver(VHDLType &sigInfo, VHDLType &driverInfo);
  void addDriver(VHDLType &sigInfo, Block *newDriverList);
  void addDriverData(VHDLType *data);
  //@}

  /** We are having a data structure of type Block to hold the pointers of the
      temporary signals which occur in the Type Conversion. This routine
      will return TRUE if the element already has the Block allocated for that
      element if it is a ScalarType. If it is a Composite Type, then it will
      return TRUE only if all the sub elements of the Composite Type have the
      Block already allocated. Even if one of the elements of the Composite Type
      does not have a Block allocated, it will return FALSE. */
  bool _is_block_present(VHDLType &sigInfo);

  void setSourceToRoot(ScalarType&);

  void setSourceInfo(VHDLType &, VHDLType &);

  void addDownTypeConversionFn(VHDLType &, VHDLType &, TypeConversionFnPtr);
  Block* getDownTypeConversionFnList(VHDLType &);
  PortMap portMapAspect;

  /** The component that is instantiated in an architecture declaration
      is bound to some real entity(architecture) The following function
      is used to get the information from the real entity(architecture)
      pair to logical component */
  virtual void buildSignalTree();

  virtual void copyGenericsToGlobals(){};

  /** The following two function check to ensure that the types of the
      signals being passed to the actual setSourceInfo() method are of the
      same type.  Different types of signals can arise if sub-elements in
      composite signals are assigned thro' the port maps. Here is a quick
      example

      component comp port (i : bit_vector(0 to 2)); end component;
      comp_inst : comp port map (i(0) => bit0; i(1) => bit1; i(2) => bit2);

      In this case 3 signals will be passed in connect. Now, these signals
      need to be combined into a bit_vector and then passed to the actual
      methods. 
  */

  /** Check if source and destination have the same number of elements in them
      If they do well and good. If they don't then create a new sig_netinfo
      and use as many parameters as necessary and return the number of the
      next parameter to use back to the calling process. */
  int checkSetSourceInfo( VHDLType &, int, vector<VHDLType *> & );


  /** Check if source and destination have the same number of elements in
      them If they do well and good. If they don't then create a new
      sig_netinfo and use as many parameters as necessary and return the
      number of the next parameter to use back to the calling process. */
  int checkAdd( VHDLType &, int, vector<VHDLType *> & );

  const string getPluginType() const { return "tyvis entity elab object"; }
  const string getPluginName() const { return "_savant_entity_elab"; }

protected:
  void addToFanOut( VHDLType * );

  //@}

public:
  /**
     This Data structure contains the drivers. They are added to the Block
     and deleted in the destructor and they are not deleted in SourceData node
  */
  Block driverData;
  Block typeConvertData;
  Block blockForDrivers;
};

#endif
