#include <iostream>
#include <ubit/ubit.hpp>
using namespace std;

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
// should be in header file

class Demo : public UFrame {
public:
	Demo();

private:
	uptr<UButton> button;		                // NB: 'button' is a SMART pointer

	static  void foo1(const char*);
	virtual void foo2(UEvent&, const char*, int);
};

// end of header - - - - - - - - - - - - - - - - - - - - - - - - - -
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

int main(int argc, char* argv[]) {
	UAppli* appli = new UAppli(&argc, argv);

	Demo* frame = new Demo();
	appli->add(frame);
	frame->show(true);
	
	return appli->mainLoop();
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

Demo::Demo() {	
	// creates a push button and adds callbacks to it
	button = &ubutton
		(
			"Please Click Me !"
			+ UOn::mpress / ucall("test1", &Demo::foo1)
			+ UOn::action / ucall(this, "test2", 666, &Demo::foo2)
			+ ucall(this, "test3", 777, &Demo::foo2)
			);

	// creates a label and adds the label and the button to the main frame
	addlist( ulabel("Simple demo 2") + button);
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

void Demo::foo1(const char* s) {
	cout << "pressed: " << s << endl;
}

void Demo::foo2(UEvent& e, const char* s, int i) {
	cout << "action: " << s << " " << i << endl;
}

