/* $Id: passwd.c,v 1.8 2002/10/29 16:15:55 bjk Exp $ */
/*
    Copyright (C) 2001-2002  Ben Kibbey <bjk@arbornet.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <pwd.h>
#include <grp.h>
#include <string.h>
#include <errno.h>
#include "common.h"

static void gecosinfo(INFO * info)
{
    int i = 0;
    char *tmp, *buf;

    tmp = info->passwd->pw_gecos;

    info->gecos->name = NONE;
    info->gecos->office = NONE;
    info->gecos->officephone = NONE;
    info->gecos->homephone = NONE;

    while ((buf = strsep(&tmp, ",")) != NULL) {
	if (!buf[0])
	    continue;

	switch (i++) {
	    case 0:
		info->gecos->name = buf;
		break;
	    case 1:
		info->gecos->office = buf;
		break;
	    case 2:
		info->gecos->officephone = buf;
		break;
	    case 3:
		info->gecos->homephone = buf;
		break;
	    default:
		break;
	}
    }

    return;
}

static void getgroups(INFO * info)
{
    struct group *grp;
    GROUP *node;
    gid_t first_gid = -1;

    info->group = Malloc(sizeof(GROUP));
    node = info->group;

    if ((grp = getgrgid(info->passwd->pw_gid)) == NULL) {
	node->id = info->passwd->pw_gid;
	strncpy(node->name, UNKNOWN, sizeof(node->name));
	node->next = NULL;
	return;
    }

    node->id = first_gid = grp->gr_gid;
    strncpy(node->name, grp->gr_name, sizeof(node->name));
    node->next = Calloc(1, sizeof(GROUP));
    node = node->next;

#ifdef HAVE_SETGROUPENT
    setgroupent(1);
#else
    setgrent();
#endif

    group_info = 1;

    while ((grp = getgrent()) != NULL) {
	char **members = grp->gr_mem;

	while (*members) {
	    if (strcmp(*members++, info->passwd->pw_name) == 0) {
		if (grp->gr_gid == first_gid)
		    continue;

		node->id = grp->gr_gid;
		strncpy(node->name, grp->gr_name, sizeof(node->name));
		node->next = Calloc(1, sizeof(GROUP));
		node = node->next;
	    }
	}
    }

    node->next = NULL;
    return;
}

void passwdinfo(INFO * info)
{
    int i;

    for (i = 0; i < ARRAYCNT(optspec) && optspec[i]; i++) {
	switch (optspec[i]) {
	    case 'i':
		gecosinfo(info);
		break;
	    case 'g':
		getgroups(info);
		break;
	    default:
		break;
	}
    }

    return;
}
