/***************************************************************************
                          dcevent.h  -  description
                             -------------------
    begin                : Sun Dec 15 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCEVENT_H
#define DCEVENT_H

/**
  *@author Mathias Kster
  */

#include <qevent.h>

// user events
#define EVENT_UPDATE_DM_STATUSBAR	QEvent::Type(QEvent::User+1)
#define EVENT_TRANSLATION		QEvent::Type(QEvent::User+2)
#define EVENT_UPDATE_FM_STATUSBAR	QEvent::Type(QEvent::User+3)
#define EVENT_UPDATE_TR_STATUSBAR	QEvent::Type(QEvent::User+4)
#define EVENT_UPDATE_FRIEND		QEvent::Type(QEvent::User+5)

class CDownloadManagerInfo;
class CFileManagerInfo;
class DCMessageTraffic;
class DCFriendObject;

// friend event
class DC_FriendEvent : public QEvent {
public:
	/** construtor */
	DC_FriendEvent( Type type, DCFriendObject * friendobject );
	/** destructor */
	virtual ~DC_FriendEvent();

	/** */
	DCFriendObject * m_pFriendObject;
};

// dl manager event
class DC_DownloadManagerEvent : public QEvent {
public:
	/** construtor */
	DC_DownloadManagerEvent( Type type, CDownloadManagerInfo * info );
	/** destructor */
	virtual ~DC_DownloadManagerEvent();

	/** */
	CDownloadManagerInfo * m_pDownloadManagerInfo;
};

// fm manager event
class DC_FileManagerEvent : public QEvent {
public:
	/** construtor */
	DC_FileManagerEvent( Type type, CFileManagerInfo * info );
	/** destructor */
	virtual ~DC_FileManagerEvent();

	/** */
	CFileManagerInfo * m_pFileManagerInfo;
};

// tr manager event
class DC_TrafficInfoEvent : public QEvent {
public:
	/** construtor */
	DC_TrafficInfoEvent( Type type, DCMessageTraffic * info );
	/** destructor */
	virtual ~DC_TrafficInfoEvent();

	/** */
	DCMessageTraffic * m_pTrafficInfo;
};

// translator event
class DC_TranslationEvent : public QEvent {
public:
	/** construtor */
	DC_TranslationEvent( Type type ) : QEvent( type ) { };
	/** destructor */
	virtual ~DC_TranslationEvent() {};

	/** */
	bool m_bTranslate;
	/** */
	QString m_sOriginal;
	/** */
	QString m_sTranslation;
	/** */
	QObject * m_pReceiver;
};

#endif
