# $Header: /usr/build/vile/vile/filters/RCS/mk-2nd.awk,v 1.8 2000/10/25 23:53:14 tom Exp $
#
# Generate makefile rules for vile's external and built-in filters.  We will
# build each filter only one way (external _or_ built-in).  This script uses
# these parameters:
#	mode =	'built-in' or 'external'
#	list =	a list of the filter root-names that are built-in, with 'all'
#		matching all root-names.
BEGIN	{
		first = 1;
		count = 0;
	}
	!/^#/ {
		# command-line parameters aren't available until we're matching
		if (first == 1) {
			Len = split(list,List,/ /)
			Opt = (mode == "built-in");
		}
		found = !Opt;
		if ( $NF >= 2 ) {
			for (i = 1; i <= Len; i++) {
				if ( $1 == List[i] || List[i] == "all" ) {
					found = Opt;
					break;
				}
			}
			if (found) {
				if ( NF > 3 ) {
					main[count] = 0;
					dest[count] = $4 "$x";
				} else {
					main[count] = 1;
					dest[count] = "vile-" $1 "-filt$x";
				}
				name[count] = $1;
				file[count] = sprintf("%s.%s", $2, $3);
				root[count] = $2;
				type[count] = $3;
				count = count + 1;
				if (first == 1) {
					printf "# Lists generated by filters/mk-2nd.awk for %s filters\n", mode
					first = 0;
				}
			}
		}
	}
END	{
		if ( !Opt ) {
			for (i = 0; i < count; i++) {
				src = sprintf("vile-%s$x", root[i]);
				nit = (type[i] == "c") ? "C" : "L";
				print ""
				if (main[i]) {
					printf "%s : %s$o $(%sF_DEPS)\n", dest[i], root[i], nit
					printf "\t%s$(LINK) $(LDFLAGS) -o $@ %s$o $(%sF_ARGS)\n", linking, root[i], nit
				} else {
					printf "%s : %s$o\n", dest[i], root[i]
					printf "\t%s$(LINK) $(LDFLAGS) -o $@ %s$o\n", linking, root[i]
				}
			}
			print ""
			print "# dependency-rules for install/installdirs"
			for (i = 0; i < count; i++) {
				src = sprintf("vile-%s-filt$x", name[i]);
				dst = sprintf("$(BINDIR)/%s", src);
				printf "%s :\t%s\t\t; $(INSTALL_PROGRAM) $? $@\n", dst, src
			}
		} else {
			for (i = 0; i < count; i++) {
				dst = sprintf("%s$o", root[i]);
				print ""
				printf "%s : %s\n", dst, file[i]
				if (index(compiling,"#") == 0)
					printf "\t@echo compiling %s\n", file[i]
				if (type[i] == "l") {
					printf "\t%s$(LEX) -P%s_ -t %s/%s > %s.c\n", show, name[i], from, file[i], root[i]
					printf "\t%s$(CC) -c $(CPPFLAGS) $(CFLAGS) -Dfilter_def=define_%s %s/%s.c\n", show, name[i], ".", root[i]
					printf "\t%s $(RM) %s.c\n", show, root[i]
				} else {
					printf "\t%s$(CC) -c $(CPPFLAGS) $(CFLAGS) -Dfilter_def=define_%s %s/%s.c\n", show, name[i], from, root[i]
				}
			}
			print ""
		}
	}
