// Object part of VDisplay class

/*

    Copyright (C) 1991-2001 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/
#include <vips/intl.h>

#include <stdlib.h>

#include <vips/vips.h>
#include <vips/vipscpp.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

/* Refcounting stuff first.
 */

// Free an im_col_display
static void
free_display( im_col_display *d )
{
	if( d->d_name )
		im_free( d->d_name );
	im_free( d );
}

// Dupe an im_col_display
static im_col_display *
dup_display( im_col_display *in )
{
	im_col_display *out;

	if( !(out = IM_NEW( NULL, im_col_display )) )
		verror();

	*out = *in;
	if( in->d_name )
		if( !(out->d_name = strdup( in->d_name )) ) {
			free_display( out );
			verror( "out of memory" );
		}

	return( out );
}

// Remove lut
void VDisplay::refblock::cleanlut()
{
	if( luts ) {
		im_free( luts );
		luts = 0;
	}
}

// Remove attached things
void VDisplay::refblock::cleanref()
{
	if( disp && priv ) {
		free_display( (im_col_display *) disp );
		disp = 0;
		priv = 0;
	}
	cleanlut();
}

// Get ready to write to disp
void VDisplay::refblock::wready()
{
	cleanlut();
	if( !priv ) {
		disp = dup_display( (im_col_display *) disp );
		priv = 1;
	}
}

// Check that luts are up-to-date
void VDisplay::refblock::cluts()
{
	if( !luts )
		if( !(luts = im_col_make_tables_RGB( NULL, 
			(im_col_display *) disp )) )
			verror();
}

VDisplay::~VDisplay()
{
	ref->nrefs--;
	if( !ref->nrefs ) 
		delete ref;
}

VDisplay &VDisplay::operator=( const VDisplay &a )
{ 
	ref->nrefs--;

	if( ref->nrefs > 0 ) 
		// Need fresh
		ref = new refblock;
	else 
		// Recycle old
		ref->cleanref();

	ref = a.ref; 
	ref->nrefs++; 
	
	return( *this ); 
}

VDisplay::VDisplay( const char *name )
{
	// Search for a matching name in the VIPS colour list
        im_col_display *scr = im_col_display_name( name );
 
	if( !scr ) {
		VError err;

		err.app( "VDisplay error: " );
		err.app( "unknown display type \"" ).app( name ).app( "\"\n" );
		err.app( "display should be one of:" );

		for( int i = 0; (scr = im_col_displays( i )); i++ ) {
			err.app( " \"" );
			err.app( im_col_displays( i )->d_name );
			err.app( "\"" );
		}

		err.app( "\n" );

		throw( err );
	}

	// Install display
	ref = new refblock;
	ref->disp = scr;
}

VDisplay::VDisplay()
{
	// Just use SPARC
	ref = new refblock;
	ref->disp = im_col_displays( 1 );
}

// Return references to fields in display. 
char *VDisplay::name() 
	{ ref->wready(); return( ((im_col_display*)ref->disp)->d_name ); }
VDisplay::VDisplayType &VDisplay::type() 
	{ ref->wready(); return( (VDisplayType&) 
		((im_col_display*)ref->disp)->d_type ); }
VDisplay::matrix &VDisplay::mat()
	{ ref->wready(); return( ((im_col_display*)ref->disp)->d_mat ); }
float &VDisplay::YCW()
	{ ref->wready(); return( ((im_col_display*)ref->disp)->d_YCW ); }
float &VDisplay::xCW()
	{ ref->wready(); return( ((im_col_display*)ref->disp)->d_xCW ); }
float &VDisplay::yCW()
	{ ref->wready(); return( ((im_col_display*)ref->disp)->d_yCW ); }
float &VDisplay::YCR()
	{ ref->wready(); return( ((im_col_display*)ref->disp)->d_YCR ); }
float &VDisplay::YCG()
	{ ref->wready(); return( ((im_col_display*)ref->disp)->d_YCG ); }
float &VDisplay::YCB()
	{ ref->wready(); return( ((im_col_display*)ref->disp)->d_YCB ); }
int &VDisplay::Vrwr()
	{ ref->wready(); return( ((im_col_display*)ref->disp)->d_Vrwr ); }
int &VDisplay::Vrwg()
	{ ref->wready(); return( ((im_col_display*)ref->disp)->d_Vrwg ); }
int &VDisplay::Vrwb()
	{ ref->wready(); return( ((im_col_display*)ref->disp)->d_Vrwb ); }
float &VDisplay::Y0R()
	{ ref->wready(); return( ((im_col_display*)ref->disp)->d_Y0R ); }
float &VDisplay::Y0G()
	{ ref->wready(); return( ((im_col_display*)ref->disp)->d_Y0G ); }
float &VDisplay::Y0B()
	{ ref->wready(); return( ((im_col_display*)ref->disp)->d_Y0B ); }
float &VDisplay::gammaR()
	{ ref->wready(); return( ((im_col_display*)ref->disp)->d_gammaR ); }
float &VDisplay::gammaG()
	{ ref->wready(); return( ((im_col_display*)ref->disp)->d_gammaG ); }
float &VDisplay::gammaB()
	{ ref->wready(); return( ((im_col_display*)ref->disp)->d_gammaB ); }
float &VDisplay::B()
	{ ref->wready(); return( ((im_col_display*)ref->disp)->d_B ); }
float &VDisplay::P()
	{ ref->wready(); return( ((im_col_display*)ref->disp)->d_P ); }

