/*
vrerror.c - error reporting functions
Copyright (C) 2001  Jeff Carneal

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include <stdio.h>
#include <stdarg.h>
#include <errno.h>
#include <string.h>
#include "vrerror.h"
#include "vrfile.h"

void
vr_error (const char *msg, ...)
{
	va_list ap;
	char buf[128];

	va_start (ap, msg);
	vsnprintf (buf, 128, msg, ap);
	if (errno)
		fprintf (stderr, "\n%s - %s\n\n", buf, strerror (errno));
	else
		fprintf (stderr, "\n%s\n\n", buf);
	va_end (ap);

	vrfile_cleanup (1);
}

void
vr_warning (const char *msg, ...)
{
	va_list ap;
	char buf[128];

	va_start (ap, msg);
	vsnprintf (buf, 128, msg, ap);
	if (errno)
		fprintf (stderr, "\n%s - %s\n", buf, strerror (errno));
	else
		fprintf (stderr, "\n%s\n", buf);
	va_end (ap);
}
