/*
    This file is part of Waiho (http://info.xdev.org/projets/waiho)
    Copyright (C) 2001-2002 Nicolas Roard (nicolas@roard.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "mainWindow.h"
#import "CellFile.h"
#import "Browser.h"
#import "FTPBrowser.h"
#import "DownloadDelegate.h"
#import "UploadDelegate.h"

@interface MainWindowController : NSWindowController
{
	IBOutlet	NSBrowser* localView;
	IBOutlet	NSBrowser* remoteView;
	IBOutlet	NSButton* lmkdir;
	IBOutlet	NSButton* rmkdir;
	IBOutlet	NSButton* ldelete;
	IBOutlet	NSButton* rdelete;
	IBOutlet	NSButton* edit;
	
	IBOutlet	NSButton* Connect;
	IBOutlet	NSButton* Bookmarks;
	IBOutlet	NSButton* Get;
	IBOutlet	NSButton* Put;
	IBOutlet	NSTableView* Downloads;
	IBOutlet	NSTableView* Uploads;
	MainWindow*	theWindow;
}

- (id) init;
- (void) dealloc;

- (void) setConnected;
- (void) setDisconnected;
- (void) setDialing;
- (void) createLocalDirectory: (id) sender;
- (void) createRemoteDirectory: (id) sender;

- (void) deleteLocalFile: (id) sender;
- (void) deleteRemoteFile: (id) sende;

- (NSArray*) remoteViewSelectedCells;
- (NSArray*) localViewSelectedCells;
- (NSString*) remotePath;
- (NSString*) localPath;
- (void) refreshRemote;
- (void) refreshLocal;

- (void) refreshDownloadTable;
- (void) refreshUploadTable;

- (MainWindow*) window;

@end;
