/*
    This file is part of Waiho (http://info.xdev.org/projets/waiho)
    Copyright (C) 2001-2002 Nicolas Roard (nicolas@roard.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "mainWindowController.h"

@implementation MainWindowController

- (id) init {
	theWindow = [[MainWindow alloc] initWithContentRect: NSMakeRect (100,100,640,600)
				styleMask: (NSTitledWindowMask | NSClosableWindowMask 
					| NSMiniaturizableWindowMask | NSResizableWindowMask)
				backing: NSBackingStoreBuffered
				defer: YES];
	[super initWithWindow: theWindow];
	[theWindow setMinSize: NSMakeSize (400,400)];
	[theWindow layoutWindow];
	[theWindow setDelegate: self];

	NSLog (@"on est dans l'init du mainWindowController\n");
	
	localView = [theWindow localView];
	remoteView = [theWindow remoteView];
	lmkdir = [theWindow lmkdir];
	rmkdir = [theWindow rmkdir];
	ldelete = [theWindow ldelete];
	rdelete = [theWindow rdelete];
	edit = [theWindow edit];
	Connect = [theWindow Connect];
	Bookmarks = [theWindow Bookmarks];
	Get = [theWindow Get];
	Put = [theWindow Put];
	Downloads = [theWindow Downloads];
	Uploads   = [theWindow Uploads];

	// We sets delegates
	NSLog (@"on mets les delegates");

	[localView setDelegate: [[GestBrowser alloc] init]];
	NSLog (@"on mets les delegates A");
	[localView setCellClass: [CellFile class]];
	NSLog (@"on mets les delegates A2");
	[localView setPath: [[NSFileManager defaultManager] currentDirectoryPath]];
	NSLog (@"on mets les delegates B");

	[remoteView setDelegate: [[GestFTPBrowser alloc] init]];
	NSLog (@"on mets les delegates C");
	[remoteView setCellClass: [CellFile class]];

	[Downloads setDataSource: [DownloadTableView alloc]];
	NSLog (@"on mets les delegates D");
	[Uploads setDataSource: [UploadTableView alloc]];

	// We sets actions
	NSLog (@"on mets les actions");

	[Connect setAction: @selector (getParametersOfConnection:)];
	[Get setAction: @selector (getFile:)];
	[Put setAction: @selector (putFile:)];
	[lmkdir setAction: @selector (createLocalDirectory:)];
	[rmkdir setAction: @selector (createRemoteDirectory:)];
	
	[ldelete setAction: @selector (deleteLocalFile:)];
	[rdelete setAction: @selector (deleteRemoteFile:)];

	[Bookmarks setEnabled: NO];
	[Get setEnabled: NO];
	[Put setEnabled: NO];

	[[self window] setTitle: @"GNUstep FTP Client"];
	return self;
}
- (void) dealloc {
}
- (MainWindow*) window {
	return theWindow;
}
- (void) setConnected {
	NSLog (@"On entre dans setConnected");
	[Connect setImage: [NSImage imageNamed: @"Connect.tiff"]];
	[Connect setTitle: _(@"Connected")];
	[Connect setAction: @selector (disconnectFromFTP:)];
	[Get setEnabled: YES];
	[Put setEnabled: YES];
	[remoteView reloadColumn: 0];
	NSLog (@"On quitte setConnected");
}
- (void) setDisconnected {
	NSLog (@"==> On entre dans setDisconnected");
	[Connect setImage: [NSImage imageNamed: @"Disconnect.tiff"]];
	[Connect setTitle: _(@"Disconnected")];
	[Connect setAction: @selector(getParametersOfConnection:)];
	[Get setEnabled: NO];
	[Put setEnabled: NO];
	[remoteView reloadColumn: 0];
	NSLog (@"==> On quitte setDisconnected");
}
- (void) setDialing {
	[Connect setTitle: _(@"Dialing")];
	[Connect setImage: [NSImage imageNamed: @"Connect-zoom.tiff"]];
}
- (void) createLocalDirectory: (id) sender {
	GetNameDirController* namedir;
	NSLog (@" on veut creer une directory local\n");
	namedir = [[GetNameDirController alloc] initWithRemote: NO];
	[namedir showWindow: self];
}
- (void) createRemoteDirectory: (id) sender {
	GetNameDirController* namedir;
	NSLog (@" on veut creer une directory distant\n");
	namedir = [[GetNameDirController alloc] initWithRemote: YES];
	[namedir showWindow: self];
}

- (void) deleteLocalFile: (id) sender {
    int i;
    NSArray* lfiles = [self localViewSelectedCells];
    NSLog (@" on veut effacer un ou des fichier(s) en local");

    for (i = 0; i < [lfiles count]; i++)
    {
	File* f = [[lfiles objectAtIndex: i] getFile];
	NSMutableString* str = AUTORELEASE ([[NSMutableString alloc] initWithString: [self localPath]]);
	[str appendString: @"/"];
	[str appendString: [f name]];
	NSLog (@" on veut effacer le fichier : %@\n", str);
	unlink ([str cString]);
	[self refreshLocal];
    }
}
- (void) deleteRemoteFile: (id) sender {
    int i;
    NSArray* rfiles = [self remoteViewSelectedCells];
    NSLog (@" on veut effacer un ou des fichier(s) distant");

    for (i = 0; i< [rfiles count]; i++)
    {
	File* f = [[rfiles objectAtIndex: i] getFile];
	NSMutableString* str = AUTORELEASE ([[NSMutableString alloc] initWithString: @"DELE "]);
	[str appendString: [self remotePath]];
	[str appendString: @"/"];
	[str appendString: [f name]];
	NSLog (@" on envoie au ftp la commande : %@\n", str);
	[[[NSApp delegate] ftp] command: str];
	[self refreshRemote];
    }
}

- (NSArray*) remoteViewSelectedCells {
	return [remoteView selectedCells];
}
- (NSArray*) localViewSelectedCells {
    NSLog (@"On est dans localViewSelectedCells !");
	return [localView selectedCells];
}
- (NSString*) remotePath {
	int pos = [remoteView lastVisibleColumn];
	NSLog (@"Lastvisiblecolumn remote : %d\n", pos);
	return [remoteView pathToColumn: pos];
}
- (NSString*) localPath {
	int pos = [localView lastVisibleColumn];
	NSLog (@"Lastvisiblecolumn local : %d\n", pos);
	return [localView pathToColumn: pos];
}
- (void) refreshRemote {
	int pos;

	NSLog (@"On est dans refreshRemote !");
	pos = [remoteView lastVisibleColumn];
	[remoteView reloadColumn: pos];
	NSLog (@"On quitte refreshRemote !");
}
- (void) refreshLocal {
	int pos;
	NSLog (@"On est dans refreshLocal !");
	pos = [localView lastVisibleColumn];
	[localView reloadColumn: pos];
	NSLog (@"On quitte refreshLocal !");
}
- (void) refreshDownloadTable {
	[Downloads reloadData];
}
- (void) refreshUploadTable {
	NSLog (@"RefreshUploadTable()");
	[Uploads reloadData];
}

@end
