/*
    This file is part of Waiho (http://info.xdev.org/projets/waiho)
    Copyright (C) 2001-2002 Nicolas Roard (nicolas@roard.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import "parametersController.h"
#import "mainWindowController.h"
#import "getNameDirController.h"
#import "ftp.h"
#import "sites.h"
#import "bookmark.h"

@interface MyDelegate : NSObject
{
	MainWindowController* myWindow;
	ParametersWindowController* params;
	GetNameDirController* namedir;
	FTP* FTPInterface;
	FTP* DataTransfertIn;
	FTP* DataTransfertOut;
	NSMutableArray* downloadQueue;
	NSMutableArray* uploadQueue;
	//NSNotificationCenter*   center;
	NSNotificationCenter*   DistributedCenter;
	NSMutableData* save;
	Sites* bookmarks;
}

- (MainWindowController*) window;
- (FTP*) ftp;
- (NSArray*) downloadQueue;
- (NSArray*) uploadQueue;
- (Sites*) bookmarks;

- (void) disconnectRemote: (id) sender ;
- (void) getParametersOfConnection: (id) sender;
- (void) getFile: (id) sender;
- (void) putFile: (id) sender;
- connectWithAddress: (NSString*) adr withLogin: (NSString*) login withPassword: (NSString*) password;
- (void) downloadFiles;
- (void) uploadFiles;
- (void) FileSaved: (NSNotification*) notification;
- (void) FileSend: (NSNotification*) notification;
- (void) receive: (NSNotification*) notification ;

- (void) createMenu;
- (void) applicationWillFinishLaunching: (NSNotification *) not;
- (void) applicationDidFinishLaunching: (NSNotification *) not;

@end
