#ifndef TCP_SELECT_PHYSICAL_COMMUNICATION_LAYER_H
#define TCP_SELECT_PHYSICAL_COMMUNICATION_LAYER_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Jorgen Dahl                 dahlj@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "eclmplCommonInclude.h"
#include "NetworkMessage.h"
#include "eclmplPhysicalCommunicationLayer.h"
#include "TCPConnectionInterface.h"

/** The TCPSelectPhysicalCommunicationLayer class.

*/
class TCPSelectPhysicalCommunicationLayer : public eclmplPhysicalCommunicationLayer {
public:
  /**@name Public Class Methods of TCPSelectPhysicalCommunicationLayer. */
  //@{

  /// Default Constructor.
  TCPSelectPhysicalCommunicationLayer();

  /// Destructor.
  ~TCPSelectPhysicalCommunicationLayer();
  
  //@} // End of Public Class Methods of TCPSelectPhysicalCommunicationLayer.

protected:
  /**@name Protected Class Methods of TCPSelectPhysicalCommunicationLayer. */
  //@{

  void probeNetwork();
  void initializeCommunicationLayerAttributes();

  //@} // End of Protected Class Attributes of TCPSelectPhysicalCommunicationLayer.

  /**@name Protected Class Attributes of TCPSelectPhysicalCommunicationLayer. */
  //@{

  // For calls to select.
  fd_set selectListenSet, fdSet;
  int maxFd;

  //@} // End of Protected Class Attributes of TCPSelectPhysicalCommunicationLayer.
};

#endif
