/*
 * Copyright (c) 1997 Loughborough University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the LUTCHI Research
 *      Centre at Loughborough University.
 * 4. Neither the name of the University nor of the Centre may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


/*
 *  File: db.h
 *
 *  Description: Whiteboard history database definitions.
 *
 *  J.C.Highfield, 4/97.
 *
 */

#ifndef DB_H
#define DB_H

#include "wb.h"

/*
 * The whiteboard uses a database of draw history per page.
 *
 * It also has several queues:
 *   an outgoing draw command queue (bandwidth limited)
 *   a correction-request queue (timer & bandwidth limited)
 *     (requests are cancelled if identical requests are seen).
 *   a correction-reply queue (timer & bandwidth limited)
 *     (replies are cancelled if identical replies are seen).
 *
 */


/* A list of pages... */
struct page
{
	long		 page_number;
	unsigned long	 creator_ip;
	long		 seq_num_max;
	struct page	*next;
	struct page	*prev;
	struct writer	*writers;
	struct action	*actions;
};

/* each page has a list of writers... */
struct writer
{
	unsigned long	 writer_ip;
	unsigned long	 seq_num_max;
	struct writer	*next;
	struct writer	*prev;
};

/* and a (combined) list of what they wrote... */

struct action
{
	uint32 timestamp;
	unsigned long	 writer_ip;
	unsigned long	 seq_num;
	struct action	*next;
	struct action	*prev;
	struct pk_draw_msg *message;
};



/*
 * Queue stuff.
 *
 */

enum
{
	Q_DRAW_MSG    = 0x0001,
	Q_STATE       = 0x0002,
	Q_REPAIR      = 0x0003,
	Q_REQUEST     = 0x0004,
	Q_REPORT      = 0x0005,
	Q_ASKPAGE     = 0x0006
};

struct mqueue
{
	int		 type;
	int		 size;
	int		 delay;
	struct message	*data;
	struct mqueue	*next;
};


/*
 * List of Senders stuff.
 *
 */

#define SENDER_NAME_LENGTH	32
struct sender
{
	uint32		 sender_ip;
	uint32		 last_sent;
	uint32		 last_seen;
	uint32		 last_drawn;
	char		 name[SENDER_NAME_LENGTH];
	struct sender	*next;
};

#endif

