#!/usr/local/bin/perl
# domain_form.cgi
# Display a form for setting up a new virtual domain

require './virtual-server-lib.pl';
&ReadParse();
if ($in{'import'}) {
	# Redirect to the import form
	&redirect("import_form.cgi");
	return;
	}

# Get parent settings
$access{'create'} || &error($text{'form_ecannot'});
if ($in{'to'}) {
	# Creating an alias domain
	$aliasdom = &get_domain($in{'to'});
	$parentdom = $aliasdom->{'parent'} ?
		&get_domain($aliasdom->{'parent'}) : $aliasdom;
	$parentuser = $parentdom->{'user'};
	}
elsif ($access{'create'} == 2) {
	# This user can only create a subdomain
	$parentuser = $remote_user;
	}
elsif ($in{'parentuser1'} || $in{'parentuser2'}) {
	# Creating subdomain explicitly
	$parentuser = $in{'add1'} ? $in{'parentuser1'} : $in{'parentuser2'};
	}
if ($parentuser && !$parentdom) {
	$parentdom = &get_domain_by("user", $parentuser, "parent", "");
	$parentdom || &error(&text('form_eparent', $parentuser));
	}

&ui_print_header(undef, $aliasdom ? $text{'form_title3'} :
	$parentdom ? $text{'form_title2'} : $text{'form_title'}, "");

print "<form action=domain_setup.cgi method=post>\n";
print "<input type=hidden name=parentuser value='$parentuser'>\n";
print "<input type=hidden name=to value='$in{'to'}'>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'form_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td><b>", &hlink($text{'form_domain'}, "domainname"), "</b></td>";
print "<td colspan=3><input name=dom size=40></td>\n";

print "<tr> <td><b>", &hlink($text{'form_owner'}, "ownersname"), "</b></td>";
print "<td colspan=3><input name=owner size=50></td>\n";

# These settings are not needed for a sub-domain, as they come from the owner
if (!$parentuser) {
	print "<tr> <td><b>", &hlink($text{'form_email'}, "ownersemail"), "</b></td>";
	print "<td colspan=3><input type=radio name=email_def value=1 checked> ",
	      $text{'form_email_def'};
	print "<input type=radio name=email_def value=0> $text{'form_email_set'}\n";
	print "<input name=email size=30></td> </tr>\n";

	print "<tr> <td><b>", &hlink($text{'form_user'}, "unixusername"), "</b></td>";
	print "<td nowrap colspan=3><input type=radio name=user_def value=1 checked> ",
	      "$text{'form_auto'}";
	print "<input type=radio name=user_def value=0> $text{'form_nwuser'} ";
	print "<input name=user size=15></td> </tr>\n";

	print "<tr> <td><b>", &hlink($text{'form_pass'}, "password"), "</b></td>";
	print "<td colspan=3><input name=pass type=password size=15></td> </tr>\n";

	print "<tr> <td><b>",&hlink($text{'form_mgroup'}, "mailgroupname"),"</b></td>";
	print "<td colspan=3><input type=radio name=mgroup_def value=1 checked> ",
	      "$text{'form_auto'}";
	print "<input type=radio name=mgroup_def value=0> $text{'form_nwgroup'} ",
	      "<input name=mgroup size=13></td> </tr>\n";

	print "<tr> <td><b>",&hlink($text{'form_group'}, "unixgroupname"),"</b></td>";
	print "<td colspan=3><input type=radio name=group_def value=1 checked> ",
	      "$text{'form_crgroup'}";
	print "<input type=radio name=group_def value=0> $text{'form_exgroup'}";
	print &unix_group_input("group"),"</td> </tr>\n";
	}
elsif ($aliasdom) {
	# Show destination of alias
	print "<tr> <td><b>", &hlink($text{'form_aliasdom'}, "aliasdom"), "</b></td>";
	print "<td><a href='edit_domain.cgi?id=$parentdom->{'id'}'>$aliasdom->{'dom'}</a></td> </tr>\n";
	}
else {
	# Show parent domain
	print "<tr> <td><b>", &hlink($text{'form_parentdom'}, "parentdom"), "</b></td>";
	print "<td><a href='edit_domain.cgi?id=$parentdom->{'id'}'>$parentdom->{'dom'}</a> (<tt>$parentuser</tt>)</td> </tr>\n";
	}

if (!$aliasdom && &max_username_length()) {
	# Show input for mail username prefix, if needed
	print "<tr> <td><b>",&hlink($text{'form_prefix'}, "prefixname"),"</b></td>";
	print "<td colspan=3><input type=radio name=prefix_def value=1 checked> ",
	      "$text{'form_auto'}";
	print "<input type=radio name=prefix_def value=0> ",
	      "<input name=prefix size=13></td> </tr>\n";
	}
else {
	print "<input type=hidden name=prefix_def value=1>\n";
	}

if (!$aliasdom && &database_feature() && !$access{'nodbname'}) {
	# Show database name field, iff this is not an alias domain
	print "<tr> <td><b>",&hlink($text{'form_dbname'},"dbname"),"</b></td>\n";
	print "<td colspan=3><input type=radio name=db_def value=1 checked> ",
	      "$text{'form_auto'}";
	print "<input type=radio name=db_def value=0> ",
	      "<input name=db size=13></td> </tr>\n";
	}

if (!$aliasdom) {
	# Show mail alias option, iff this is not an alias domain
	print "<tr> <td><b>",&hlink($text{'form_mailbox'},"usermailbox"),"</b></td>\n";
	print "<td><input type=radio name=mailbox value=1> $text{'yes'}\n";
	print "<input type=radio name=mailbox value=0 checked> $text{'no'}</td></tr>\n";
	}

# Show template selection field
print "<tr> <td><b>",&hlink($text{'form_template'},"template"),"</b></td>\n";
print "<td><select name=template>\n";
foreach $t (&list_templates()) {
	next if ($t->{'deleted'});
	next if (($parentdom && !$aliasdom) && !$t->{'for_sub'});
	next if (!$parentdom && !$t->{'for_parent'});
	next if (!&master_admin() && !$t->{'for_users'});
	next if ($aliasdom && !$t->{'for_alias'});
	print "<option value=$t->{'id'}>$t->{'name'}\n";
	}
print "</select></td> </tr>\n";

# Only display quota inputs if enabled, and if not creating a subdomain
if ($config{'home_quotas'} && !$parentuser) {
	print "<tr> <td colspan=4><hr></td> </tr>\n";
	print "<tr> <td><b>", &hlink($text{'form_quota'}, "websitequota"), "</b></td>\n";
	@defquota = split (/ /,$config{'defquota'});
	if ( !@defquota or $#defquota eq 0 ) {
	    print "<td>",&quota_input("quota", $config{'defquota'},
				      $config{'home_quotas'}),"</td>\n";
	} else {
	    print "<td><select name=quota>\n";
	    foreach $i (@defquota) {
		chomp $i;
		print "<option value=\"$i\">$i</option>\n";
	    }
	    print "<option value=\"-1\">$text{'other'}</option></select>\n";
	    print &quota_input("otherquota", "",
			       $config{'home_quotas'}),"</td>\n";
	}
	print "</tr>\n";

	print "<tr> <td><b>", &hlink($text{'form_uquota'}, "unixuserquota"), "</b></td>\n";
	@defuquota = split (/ /,$config{'defuquota'});
	if ( !@defuquota or $#defuquota eq 0 ) {
	    print "<td>",&quota_input("uquota", $config{'defuquota'},
				      $config{'home_quotas'}),"</td>\n";
	} else {
	    print "<td><select name=uquota>\n";
	    foreach $i (@defuquota) {
		chomp $i;
		print "<option value=\"$i\">$i</option>\n";
	    }
	    print "<option value=\"-1\">$text{'other'}</option></select>\n";
	    print &quota_input("otheruquota", "",
			       $config{'home_quotas'}),"</td>\n";
	}
	print "</tr>\n";
}

if (!$parentdom && $config{'bw_active'}) {
	# Show bandwidth limit field
	print "<tr> <td><b>",&hlink($text{'edit_bw'},
			    "bwlimit"),"</b></td> <td colspan=3>\n";
	print &bandwidth_input("bw", $config{'defbwlimit'});
	print "</td> </tr>\n";
	}

if (!$parentuser) {
	# Show input for limit on number of mailboxes
	print "<tr> <td><b>",&hlink($text{'form_mailboxlimit'},
			    "mailboxlimit"),"</b></td> <td colspan=2>\n";
	print &ui_opt_textbox("mailboxlimit", $config{'defmailboxlimit'}, 4,
	       $text{'form_unlimit'}, $text{'form_atmost'}),"</td> </tr>\n";

	# And databases
	print "<tr> <td><b>",&hlink($text{'form_dbslimit'},
			    "dbslimit"),"</b></td> <td colspan=2>\n";
	print &ui_opt_textbox("dbslimit", $config{'defdbslimit'}, 4,
	       $text{'form_unlimit'}, $text{'form_atmost'}),"</td> </tr>\n";

	# Show input for restriction of number of sub-domains this domain
	# owner can create
	local $dlm = $config{'defdomslimit'} eq "" ? 1 :
		     $config{'defdomslimit'} eq "*" ? 2 : 0;
	print "<tr> <td><b>",&hlink($text{'form_domslimit'},
			    "domslimit"),"</b></td> <td colspan=2>\n";
	printf "<input type=radio name=domslimit_def value=1 %s> %s\n",
		$dlm == 1 ? "checked" : "",
		$text{'no'};
	printf "<input type=radio name=domslimit_def value=2 %s> %s\n",
		$dlm == 2 ? "checked" : "",
		$text{'form_domsunlimit'};
	printf "<input type=radio name=domslimit_def value=0 %s> %s\n",
		$dlm == 0 ? "checked" : "",
		$text{'form_domsyes'};
	printf "<input name=domslimit value='%s' size=4></td></tr>\n",
		$dlm == 0 ? $config{'defdomslimit'} : "";

	# Show input for default database name limit
	print "<tr> <td><b>$text{'limits_nodbname'}</b></td>\n";
	print "<td>",&ui_radio("nodbname", $config{'defnodbname'} ? 1 : 0,
	       [ [ 0, $text{'yes'} ], [ 1, $text{'no'} ] ]),"</td> </tr>\n";
	}

# Show section for custom fields, if any
$fields = &show_custom_fields();
if ($fields) {
	print "<tr> <td colspan=4><hr></td> </tr>\n";
	print $fields;
	}

# Show radio buttons for features
print "<tr> <td colspan=4><hr></td> </tr>\n";
$i = 0;
foreach $f ($aliasdom ? @opt_alias_features : @opt_features) {
	# Don't allow access to features that this user hasn't been
	# granted for his subdomains.
	next if ($access{'create'} == 2 &&
		 $parentdom && !$access{"feature_$f"});
	next if ($parentdom && $f eq "webmin");
	next if ($parentdom && $f eq "unix");
	next if ($aliasdom && !$aliasdom->{$f});
	$can_feature{$f}++;

	print "<tr>\n" if ($i%2 == 0);
	local $txt = $parentdom ? $text{'form_sub'.$f} : undef;
	$txt ||= $text{'form_'.$f};
	print "<td><b>",&hlink($txt, $f),"</b></td>";
	if ($config{$f} || !defined($config{$f})) {
		print "<td nowrap>\n";
		printf "<input type=radio name=%s value=1 %s> %s\n",
			$f, $config{$f} == 2 ? "" : "checked", $text{'yes'};
		printf "<input type=radio name=%s value=0 %s> %s\n",
			$f, $config{$f} == 2 ? "checked" : "", $text{'no'};
		print "</td>\n";
		}
	else {
		print "<td><i>$text{'form_unavail'}</i></td>\n";
		}
	print "</tr>\n" if ($i++%2 == 1);
	}

# Show radio buttons for plugins
foreach $f (@feature_plugins) {
	next if (!&plugin_call($f, "feature_suitable",
				$parentdom, $aliasdom));
	next if ($access{'create'} == 2 &&
		 $parentdom && !$access{"feature_$f"});
	next if ($aliasdom && !$aliasdom->{$f});

	print "<tr>\n" if ($i%2 == 0);
	$label = &plugin_call($f, "feature_label", 0);
	print "<td><b>$label</b></td>\n";
	print "<td nowrap>\n";
	printf "<input type=radio name=%s value=1 %s> %s\n",
		$f, "checked", $text{'yes'};
	printf "<input type=radio name=%s value=0 %s> %s\n",
		$f, "", $text{'no'};
	print "</td>\n";
	print "</tr>\n" if ($i++%2 == 1);
	}

# Show inputs for setting up a proxy-only virtual server
if ($config{'proxy_pass'} && !$aliasdom) {
	print &frame_fwd_input();
	}

# Show field for mail forwarding
if ($can_feature{'mail'} && !$aliasdom) {
	print "<tr> <td><b>",&hlink($text{'form_fwdto'}, "fwdto"),"</b></td>\n";
	print "<td colspan=3>",&ui_opt_textbox("fwdto", undef, 30, $text{'form_fwdto_none'}),"</td> </tr>\n";
	}

# Show IP address allocation section
if (!$aliasdom) {
	$defip = &get_default_ip();
	print "<tr> <td><b>",&hlink($text{'form_iface'},"iface"),"</b></td>\n";
	if ($config{'all_namevirtual'}) {
		print "<td><input name=ip size=20 value=\"$defip\">",
		      "</td> </tr>\n";
		}
	else {
		print "<td colspan=3>\n";
		print "<input type=radio name=virt value=0 checked> ",
		      &text('form_shared', $defip),"\n";
		if ($config{'ip_ranges'}) {
			# Can do automatic allocation
			local $alloc = &free_ip_address();
			if ($alloc) {
				print "<input type=radio name=virt value=1> ",
				      &text('form_alloc', $alloc);
				}
			else {
				# None left!
				print $text{'form_noalloc'};
				}
			}
		else {
			# Ask the user to enter
			print "<input type=radio name=virt value=1> ",
			      "$text{'form_vip'}\n";
			print "<input name=ip size=20>\n";
			}
		print "</td> </tr>\n";
		}
	}

print "</table></td></tr></table>\n";
print "<input type=submit value='$text{'form_ok'}'></form>\n";

&ui_print_footer("", $text{'index_return'});

