# Functions for managing a domain's home directory

# setup_dir(&domain)
# Creates the home directory
sub setup_dir
{
local $tmpl = &get_template($_[0]->{'template'});
&require_useradmin();
local $qh = quotemeta($_[0]->{'home'});

# Get Unix user, either for this domain or its parent
local $uinfo;
if ($_[0]->{'unix'} || $_[0]->{'parent'}) {
	local @users = &list_all_users();
	($uinfo) = grep { $_->{'user'} eq $_[0]->{'user'} } @users;
	}
if ($_[0]->{'unix'} && !$uinfo) {
	# If we are going to have a Unix user but none has been created
	# yet, fake his details here for use in chowning and skel copying
	$uinfo ||= { 'uid' => $_[0]->{'uid'},
		     'gid' => $_[0]->{'ugid'},
		     'shell' => '/bin/sh',
		     'group' => $_[0]->{'group'} };
	}

# Create and populate home directory
&$first_print($text{'setup_home'});
&system_logged("mkdir $qh");
&system_logged("chmod '$uconfig{'homedir_perms'}' $qh");
if ($uinfo) {
	&system_logged("chown $uinfo->{'uid'}:$uinfo->{'gid'} $qh");
	}
if ($tmpl->{'skel'} ne "none") {
	&copy_skel_files($tmpl->{'skel'}, $uinfo, $_[0]->{'home'},
			 $_[0]->{'group'});
	}

# Setup web directories
local $d;
foreach $d ( [ &public_html_dir($_[0], 1), '755' ],
             [ 'cgi-bin', '755' ],
             [ 'logs', '755' ],
             [ $config{'homes_dir'}, '755' ] ) {
        &system_logged("mkdir -p $qh/$d->[0] 2>/dev/null");
        &system_logged("chmod $d->[1] $qh/$d->[0]");
	if ($uinfo) {
		&system_logged("chown $uinfo->{'uid'}:$uinfo->{'gid'} $qh/$d->[0]");
		}
        }
&$second_print($text{'setup_done'});
}

# modify_dir(&domain, &olddomain)
# Rename home directory if needed
sub modify_dir
{
if ($_[0]->{'home'} ne $_[1]->{'home'}) {
	# Move the home directory if changed, and if not already moved as
	# part of parent
	if (-d $_[1]->{'home'}) {
		&$first_print($text{'save_dirhome'});
		&system_logged("mv ".quotemeta($_[1]->{'home'}).
			       " ".quotemeta($_[0]->{'home'}));
		&$second_print($text{'setup_done'});
		}
	}
if ($_[0]->{'unix'} && !$_[1]->{'unix'}) {
	# Unix user now exists! Set ownership of home dir
	&$first_print($text{'save_dirchown'});
	&set_home_ownership($_[0]);
	&$second_print($text{'setup_done'});
	}
}

# delete_dir(&domain)
# Delete the home directory
sub delete_dir
{
# Delete homedir
if (-d $_[0]->{'home'} && $_[0]->{'home'} ne "/") {
	&$first_print($text{'delete_home'});
	&system_logged("rm -rf ".quotemeta($_[0]->{'home'}));
	&$second_print($text{'setup_done'});
	}
}

# check_dir_clash(&domain, [field])
sub check_dir_clash
{
# Does nothing ..?
return 0;
}

# backup_dir(&domain, file, &options)
# Backs up the server's home directory in tar format to the given file
sub backup_dir
{
&$first_print($text{'backup_dirtar'});
local $out;
if ($_[2]->{'dirnologs'}) {
	$xtemp = &tempname();
	open(XTEMP, ">$xtemp");
	print XTEMP "logs\n";
	close(XTEMP);
	$out = `cd '$_[0]->{'home'}'; tar cfX '$_[1]' '$xtemp' . 2>&1`;
	unlink($xtemp);
	}
else {
	$out = `cd '$_[0]->{'home'}'; tar cf '$_[1]' . 2>&1`;
	}
if ($?) {
	&$second_print(&text('backup_dirtarfailed', "<pre>$out</pre>"));
	return 0;
	}
else {
	&$second_print($text{'setup_done'});
	return 1;
	}
}

# show_backup_dir(&options)
# Returns HTML for the backup logs option
sub show_backup_dir
{
return sprintf
	"(<input type=checkbox name=dir_logs value=1 %s> %s)",
	!$opts{'dirnologs'} ? "checked" : "", $text{'backup_dirlogs'};
}

# parse_backup_dir(&in)
# Parses the inputs for directory backup options
sub parse_backup_dir
{
local %in = %{$_[0]};
return { 'dirnologs' => !$in{'dir_logs'} };
}

# restore_dir(&domain, file, &options)
# Extracts the given tar file into server's home directory
sub restore_dir
{
&$first_print($text{'restore_dirtar'});
local $out = `cd '$_[0]->{'home'}'; tar xf '$_[1]' 2>&1`;
if ($?) {
	&$second_print(&text('backup_unixtarfailed', "<pre>$out</pre>"));
	return 0;
	}
else {
	&$second_print($text{'setup_done'});
	if ($_[2]->{'chown'} && $_[0]->{'unix'}) {
		# Set ownership on extracted home directory, apart from
		# content of ~/homes
		&$first_print($text{'restore_dirchowning'});
		&set_home_ownership($_[0]);
		&$second_print($text{'setup_done'});
		}

	return 1;
	}
}

# set_home_ownership(&domain)
# Update the ownership of all files in a server's home directory, EXCEPT
# the homes directory which is used by mail users
sub set_home_ownership
{
local $hd = $config{'homes_dir'};
$hd =~ s/^\.\///;
&system_logged("find ".quotemeta($_[0]->{'home'})." \! -name $hd | xargs chown $_[0]->{'uid'}:$_[0]->{'gid'}");
&system_logged("chown $_[0]->{'uid'}:$_[0]->{'gid'} ".quotemeta($_[0]->{'home'})."/".$config{'homes_dir'});
}

# show_restore_dir(&options)
# Returns HTML for home restore option inputs
sub show_restore_dir
{
# Offer to set file ownership
return sprintf
	"(<input type=checkbox name=dir_chown value=1 %s> %s)",
	$opts{'chown'} ? "checked" : "", $text{'restore_dirchown'};
}

# parse_restore_dir(&in)
# Parses the inputs for home restore options
sub parse_restore_dir
{
local %in = %{$_[0]};
return { 'chown' => $in{'dir_chown'} };
}

1;

