/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

using namespace std;

#include <stdio.h>
#include <stdlib.h>
#include <arpa/inet.h>

#include "wfnetobjs.h"
#include "defs.h"


/* ipaddr, network, netmask (netbits), broadcast */

enum { ADDRESS = 1, NETWORK, NETMASK, BROADCAST };

int
main(int argc, char *argv[]) {
  wf_iface iface;
  wf_ipaddr& ipaddr = iface.ipaddr;
  wf_network& network = iface.network;
  string str;

  while (1) {
    cout << _("1. address:\t") << ipaddr;
    if (ipaddr.isdefined() &&
	network.network.isdefined() && network.netmask.isdefined()) {
      if (network.belong(ipaddr) == false)
	cout << _(" (warning: does not belong to network)");
    }
    cout << '\n';
    cout << _("2. network:\t") << network.network << '\n';
    cout << _("3. netmask:\t") << network.netmask;
    if (network.netmask.isdefined())
      cout << " (/" << wf_netmask_tobitmask(network.netmask.get()) << ')';
    cout << '\n';
    cout << _("4. broadcast:\t") << iface.broadcast << '\n';

    cout << _("Choice: ") << flush;
    
    getline(cin, str);
    if (cin.eof()) {
      cout << '\n';
      cin.clear();
    }

    if (str.empty())
      continue;
    char* p;
    int i = strtol(str.c_str(), &p, 0);
    if (*p != '\0') {
      cout << _("Invalid argument") << '\n';
      continue;
    }

    if (i < 1 || i > 4) {
      cout << _("Error") << '\n';
      continue;     
    }

    cout << _("New value: ") << flush;
    getline(cin, str);

    switch (i) {
    case ADDRESS:
      if (ipaddr.set(str) == false) {
	cout << _("Error: wrong ipaddr") << '\n';
	continue;
      }
      if (!network.network.isdefined() && network.netmask.isdefined() )
	network.network.set(ipaddr.get() & network.netmask.get());
      break;
    case NETWORK:
      if (network.network_set(str) == false) {
	cout << _("Error: wrong network") << '\n';
	continue;
      }
      break;
    case NETMASK:
      if (network.netmask_set(str) == false) {
	cout << _("Error: wrong netmask") << '\n';
	continue;
      }
      if (ipaddr.isdefined())
	network.network.set(ipaddr.get() & network.netmask.get());
      break;
    case BROADCAST:
      if (iface.broadcast.set(str) == false) {
	cout << _("Error: wrong broadcast") << '\n';
	continue;
      }
      break;
    }

    iface.complete();
  }

  exit(0);
}
