using namespace std;

#include "wfnetobjs.h"

int
main(int argc, char *argv[]) {
  wf_ipaddr ipaddr1("10.0.17.18");
  // wf_ipaddr ipaddr1;
  wf_ipaddr ipaddr2("10.0.18.16");

  // wf_network network("10.0.18.*");
  // wf_network network("10.0.18.16/24);
  // wf_network network("10.0.18.16", 24);
  wf_network network(ipaddr1, 24);
  //  wf_network network(ipaddr1, 24);

  wf_ipaddr_range ipaddr_range(ipaddr1, ipaddr2);

  network.comment = strdup("my network");

  wf_metahost_elem elem1;
  wf_metahost_elem elem2;
  wf_metahost_elem elem3(ipaddr1);

  elem1.debugprint(cout);
  elem2.debugprint(cout);

  elem1.set(network);
  elem2.set(ipaddr_range);

  elem1.debugprint(cout);
  elem2.debugprint(cout);

  wf_metahost metahost1;
  metahost1.name = "metahost1";
  metahost1.add(elem1);
  metahost1.add(elem2);
  metahost1.add(elem3);

  metahost1.debugprint(cout);
  cout << endl;

  wf_metahost metahost2;
  metahost2.name = "metahost2";
  metahost2.add(metahost1);
  metahost2.add(ipaddr1);

  metahost2.debugprint(cout);

  wf_iface iface1, iface2;
  wf_service service1(6, 25);
  wf_service service2(17, 53);
  wf_host host;

  iface1.comment = strdup("my interface");
  iface1.name = strdup("eth0");
  iface1.ipaddr = ipaddr1;
  iface1.network = network;
  
  //  ipaddr1.set("10.0.18.16");

  //  network.network_set("10.0.18.0/24");
  //  network.netmask.set("255.255.255.0");
  //  network.netmask_set(23);
  iface1.complete();

  iface2.comment = strdup("my interface2");
  iface2.name = strdup("eth1");
  iface2.ipaddr = ipaddr1;
  iface2.network = network;

  /*
  iface1.debugprint(cout);
  iface2.debugprint(cout);
  */

  /*
  service1.debugprint(cout);
  service2.debugprint(cout);
  */

  host.comment = strdup("my host");
  host.name = strdup("myhost");

  host.iface_add(iface1);
  host.iface_add(iface2);

  host.service_add(service1);
  host.service_add(service2);

  host.service_del(service1);

  //  host.debugprint(cout);
 
  host.iface_del("eth3");
  //  host.debugprint(cout);

  //  host.iface_add(iface1);

  host.debugprint(cout);
  cout << endl;

  wf_macaddr mac1("00:10:4B:7F:E1:D8");
  //  wf_macaddr mac1("ff:ff:ff:ff:ff:ff");
  cout << mac1 << endl;
  cout << "isbroadcast: "  << mac1.isbroadcast() << endl;
  cout << "vendor: " << mac1.vendor() << endl;
  exit(0);
}
