dnl This file is distributed under the terms of the GNU General Public license.
dnl Copyright (C) 1999 Michael Day (See the file COPYING for details).
dnl
dnl --------------------------------------------------------------------------
dnl Documentation:
dnl
dnl Available macros for checking languages and language features:
dnl
dnl LANGUAGES(
dnl	C(
dnl	    STDLIB
dnl	)
dnl	CXX(
dnl	    STDLIB,
dnl	    BOOL,
dnl	    NAMESPACE,
dnl	    CONST_CAST,
dnl	    MEMBER_FUNCTION_TEMPLATES,
dnl	    MEMBER_CLASS_TEMPLATES,
dnl	    MUTABLE,
dnl	    PARTIAL_SPECIALIZATION,
dnl	    FRIEND_TEMPLATES,
dnl	    INTRINSIC_CONSTRUCTORS
dnl	)
dnl )
dnl
dnl Available macros for checking packages:
dnl
dnl PACKAGES(
dnl
dnl )
dnl
dnl --------------------------------------------------------------------------
dnl Linux distribution mirror location database:

dnl TODO: add more distributions

define([linux_mirror],
[
    Your local $1 mirror site -- ifelse(
	$1, Redhat, ftp://ftp.redhat.com/MIRRORS.html,
	$1, SuSE, http://www.suse.com/ftp_new.html,
	$1, Debian, http://ftp.debian.org/,
	$1, Slackware, ftp://ftp.cdrom.com/pub/linux/slackware/,
	somewhere on the net.)
])

dnl --------------------------------------------------------------------------
dnl Friendly user messages:

dnl TODO: internationalization? :)

define([sorry_message], "Sorry things didn't work out.")
define([again_message], "Please install this package and run configure again.")
define([thank_message], "Thank you for your patience.")

dnl --------------------------------------------------------------------------
dnl Uncommented remainder of file:

define([CATEGORY],
[
    define([$1], [$3] $1_RECURSE($[]*) [$4])

    define([$1_RECURSE], [ifelse](dnl
$[]#, 0,,
$[]#, 1,
[[$2]]$[]1,
[[$2]]$[]1 [[$1_RECURSE]]([builtin]([[shift]], $[]@))))
])


CATEGORY([PACKAGES], [PACKAGES_],
[
],
[
    if test x"$test_failed" = xtrue ; then

	echo "configure: error: $test_msg1

Available from:"

	if test -z "$test_msg2" ; then

	    echo "$mirror" 1>&2

	else

	    echo "
    $test_msg2
" 1>&2

	    if test ! -z "$BROWSER" ; then
    
		echo "Would you like to download this now with $BROWSER? (y/N)"
		read input
	
		changequote(,)dnl
		if echo "$input" | grep "^[Yy]" > /dev/null ; then
		changequote([,])dnl
    
		    $BROWSER $test_msg2
		    echo thank_message 1>&2

		else

		    echo
		    echo sorry_message 1>&2

		fi

	    else

		echo
		echo sorry_message 1>&2
	    fi
	fi

	echo again_message 1>&2
	echo 1>&2
	exit 1

    fi
])


CATEGORY([PACKAGES_REQUIRED], [PACKAGES_],
[
    test_optional=false
])


CATEGORY([PACKAGES_OPTIONAL], [PACKAGES_],
[
    test_optional=true
],
[
    test_optional=false
])


CATEGORY([LANGUAGES], [LANGUAGES_])


CATEGORY([LANGUAGES_C], [C_],
[
    AC_LANG_SAVE
    AC_LANG_C

    AC_PROG_CC
    AC_PROG_CPP
],
[
    AC_LANG_RESTORE
])


CATEGORY([C_REQUIRED], [C_],
[
    test_optional=false
])


CATEGORY([C_OPTIONAL], [C_],
[
    test_optional=true
],
[
    test_optional=false
])


CATEGORY([LANGUAGES_CXX], [CXX_],
[
    AC_LANG_SAVE
    AC_LANG_CPLUSPLUS

    AC_PROG_CXX
],
[
    if test x"$test_failed" = xtrue ; then

	echo "configure: error: $test_msg1

        Please install an ansi compliant C++ compiler and libraries,
	such as a recent version of gcc (the GNU Compiler Collection).
"	

	exit 1

    fi

    AC_LANG_RESTORE
])


CATEGORY([CXX_REQUIRED], [CXX_],
[
    test_optional=false
])


CATEGORY([CXX_OPTIONAL], [CXX_],
[
    test_optional=true
],
[
    test_optional=false
])


CATEGORY([SUMMARY], [SUMMARY_])


AC_DEFUN([SUMMARY_MESSAGE],
[
echo
echo "Great, now try:"
echo

echo "make              -- to compile this package"
echo "make install      -- to install this package (in $prefix)"
echo "make dist         -- to create a distribution from this package"
echo "make doc          -- to generate the documentation (requires Doxygen)"
dnl echo "make check        -- to run the test suite (requires DejaGnu)"


echo
])


AC_DEFUN([SETUP_EVERYTHING],
[
    AC_REQUIRE([AC_CANONICAL_HOST])

    AC_PROG_INSTALL
    AC_PROG_LN_S
    AC_PROG_MAKE_SET

    dnl Check for whether tar should be gtar, to ensure that "make dist"
    dnl works correctly. Check for useful downloaders such as wget or lynx.

    AC_CHECK_PROGS(TAR, gtar, tar)
    AC_CHECK_PROGS(WGET, wget)
    AC_CHECK_PROGS(LYNX, lynx)

    dnl Choose an appropriate downloader if one exists, giving preference
    dnl to wget, then lynx.

    if test ! -z "$WGET" ; then

	BROWSER="$WGET"

    elif test ! -z "$LYNX" ; then

	BROWSER="$LYNX"

    fi

    dnl Check if host is running linux, and if so attempt to determine
    dnl which distribution (for selecting appropriate mirror sites).

    dnl TODO: add tests for more distributions

    if test "$host_os" = "linux-gnu" ; then

	if test -f /etc/redhat-release ; then

	    mirror="linux_mirror(Redhat)"

	elif test -f /etc/SuSE-release ; then

	    mirror="linux_mirror(SuSE)"

	elif test -f /etc/debian_version ; then

	    mirror="linux_mirror(Debian)"

	elif test -f /usr/lib/setup/slack-version ; then

	    mirror="linux_mirror(Slackware)"

	else

	    mirror="linux_mirror(Linux)"

	fi
    
    else

	case "$host_vendor" in
	    acorn) vendor="Acorn" ;;
	    apple) vendor="Apple" ;;
	    be) vendor="Be" ;;
	    bull) vendor="Bull" ;;
	    cbm) vendor="Commodore" ;;
	    cray) vendor="Cray" ;;
	    crds) vendor="CRDS" ;;
	    dec) vendor="Digital" ;;
	    dg) vendor="DG" ;;
	    fujitsu) vendor="Fujitsu" ;;
	    hitachi) vendor="Hitachi" ;;
	    hp) vendor="HP" ;;
	    ibm) vendor="IBM" ;;
	    next) vendor="NeXT" ;;
	    ns) vendor="NS" ;;
	    omron) vendor="Omron" ;;
	    sequent) vendor="Sequent" ;;
	    siemens) vendor="Siemens" ;;
	    sgi) vendor="SGI" ;;
	    sony) vendor="Sony" ;;
	    sun) vendor="Sun" ;;
	    wrs) vendor="WRS" ;;
	    *) vendor="$host_vendor" ;;
	esac

	mirror="
    Your local $vendor operating system vendor
"

    fi
])


AC_DEFUN([TEST_SKIP],
[
    if test ! x"$test_failed" = xtrue ; then

	$1

    fi
])


AC_DEFUN([TEST_FAILED],
[
    if test ! x"$test_optional" = xtrue ; then
	
	test_failed=true
	test_msg1="$1"
	test_msg2="$2"

    fi
])


dnl CHECK_LIB(foo.h, foo, foo_func, http://foo.com, -lfoo-help)
AC_DEFUN([CHECK_LIB],
[
    AC_CHECK_HEADER($1,
    [
	AC_CHECK_LIB($2, $3,, TEST_FAILED(lib$2 not found, [$4]), [$5])
    ],
    [
	TEST_FAILED($1 from lib$2 not found, [$4])
    ])
])


dnl CHECK_LIB_HEADER_VERSION(foo, func, foo.h, version.h, VERSION, 1.2.3, url)
AC_DEFUN([CHECK_LIB_HEADER_VERSION],
[
    AC_CHECK_HEADER($3,
    [
	AC_CHECK_LIB($1, $2,
	[
changequote(, )dnl
ac_tr_lib=HAVE_LIB`echo $1 | sed -e 's/[^a-zA-Z0-9_]/_/g' \
 -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`
changequote([, ])dnl
AC_DEFINE_UNQUOTED($ac_tr_lib)
LIBS="-l$1 $LIBS"
	
	    AC_MSG_CHECKING(for lib$1 v$6)

	    ac_ver_var=`echo $1['_']$6 | sed 'y%./+-%__p_%'`    

	    AC_CACHE_VAL(ac_cv_ver_$ac_ver_var,
[

    MJ=`expr $6 : '\(.*\)\..*\..*'`
    MI=`expr $6 : '.*\.\(.*\)\..*'`
    MC=`expr $6 : '.*\..*\.\(.*\)'`

cat > conftest.$ac_ext <<EOF
[#]line __oline__ "configure"
#include "confdefs.h"
#include <$3>
snort $5 snort
EOF

    major_bad=1
    minor_bad=1
    micro_bad=1

    if version=`(eval "$ac_cpp conftest.$ac_ext") 2>/dev/null` ; then

	version=`echo $version | sed "s/.*snort\(.*\)snort.*/\1/g"`
	version=`echo $version | sed "s/ \|\"//g"`

	rm -rf conftest*
	    
	major=`expr $version : '\(.*\)\..*\..*'`
	minor=`expr $version : '.*\.\(.*\)\..*'`
	micro=`expr $version : '.*\..*\.\(.*\)'`

	major_bad=`expr $major \< $MJ`
	minor_bad=`expr $major \= $MJ \& $minor \< $MI`
	micro_bad=`expr $major \= $MJ \& $minor \= $MI \& $micro \< $MC`

    fi

    if expr $major_bad \| $minor_bad \| $micro_bad > /dev/null ; then

	eval "ac_cv_ver_$ac_ver_var=no"

    else

	eval "ac_cv_ver_$ac_ver_var=yes"

    fi

])

	    if eval "test \"`echo '$ac_cv_ver_'$ac_ver_var`\" = yes" ; then

		AC_MSG_RESULT(yes)

	    else
	
		AC_MSG_RESULT(no)
		TEST_FAILED([a newer version of lib$1 is required], [$7])
	
	    fi
	],
	[
	    TEST_FAILED(lib$1 not found, [$7])
	])
    ],
    [
	TEST_FAILED($2 from lib$1 not found, [$7])
    ])
])


dnl CHECK_LIB_SCRIPT_VERSION(foo, foo-script, 1.2.3, url)
AC_DEFUN([CHECK_LIB_SCRIPT_VERSION],
[
    AC_MSG_CHECKING(for lib$1 v$3)

    ac_ver_var=`echo $1['_']$3 | sed 'y%./+-%__p_%'`

    msg="lib$1 not found"

    AC_CACHE_VAL(ac_cv_ver_$ac_ver_var,
[   
    MJ=`expr $3 : '\(.*\)\..*\..*'`
    MI=`expr $3 : '.*\.\(.*\)\..*'`
    MC=`expr $3 : '.*\..*\.\(.*\)'`

    if type "$2" > /dev/null 2>&1 ; then

	version=`$2 --version | sed "s/[[^0-9.]]//g"`
	major=`expr $version : '\(.*\)\..*\..*'`
	minor=`expr $version : '.*\.\(.*\)\..*'`
	micro=`expr $version : '.*\..*\.\(.*\)'`

	major_ok=`expr $major \> $MJ`
	minor_ok=`expr $major \= $MJ \& $minor \> $MI`
	micro_ok=`expr $major \= $MJ \& $minor \= $MI \& $micro \>= $MC`

	if expr $major_ok \| $minor_ok \| $micro_ok > /dev/null ; then

	    eval "ac_cv_ver_$ac_ver_var=yes"

	else

	    eval "ac_cv_ver_$ac_ver_var=no"
	    msg="a newer version of lib$1 is required"

	fi
    
    else

	eval "ac_cv_ver_$ac_ver_var=no"
	msg="lib$1 not found"

    fi

])

    if eval "test \"`echo '$ac_cv_ver_'$ac_ver_var`\" = yes"
    then

	AC_MSG_RESULT(yes)

	LIBS="-l$1 $LIBS"
	CPPFLAGS="`$2 --cflags` $CPPFLAGS"

	changequote(,)dnl

	ac_tr_lib=HAVE_LIB`echo $1 | sed -e 's/[^a-zA-Z0-9_]/_/g' \
	    -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`

	changequote([,])dnl

	AC_DEFINE_UNQUOTED($ac_tr_lib)

	dnl The following ghastly hack is necessary for autoheader
	dnl to recognize that this is a library, given that we are
	dnl not actually *using* AC_CHECK_LIB(). Ouch.

	if false ; then

	    AC_CHECK_LIB($1, foo)

	fi

    else

	AC_MSG_RESULT(no)
	TEST_FAILED($msg, [$4])

    fi
])


AC_DEFUN([PACKAGES_LIBM],
[
    TEST_SKIP(
    [
	dnl This test is courtesy of sponge's investigative work on BeOS. It
	dnl checks to see if the maths functions are available in the default
	dnl libraries first and only if that fails does it check libm.

	AC_CHECK_FUNC(pow,,
	[
	    CHECK_LIB(
		math.h,
		m,
		pow)
	])
    ])
])


AC_DEFUN([PACKAGES_PTHREADS],
[
    TEST_SKIP(
    [
	CHECK_LIB(
	    pthread.h,
	    pthread,
	    pthread_create)

	dnl Needs to detect appropriate flags for Solaris, such as
	dnl those which set POSIX threads semantics.

	CPPFLAGS="$CPPFLAGS -D_REENTRANT"
    ])
])

AC_DEFUN([PACKAGES_LIBC_R],
[
    TEST_SKIP(
    [
	CHECK_LIB(
	    pthread.h,
	    c_r,
	    pthread_create)

	dnl Needs to detect appropriate flags for Solaris, such as
	dnl those which set POSIX threads semantics.

	CPPFLAGS="$CPPFLAGS -D_THREAD_SAFE"
    ])
])


AC_DEFUN([PACKAGES_SDL],
[
    TEST_SKIP(
    [
	CHECK_LIB_HEADER_VERSION(
	    SDL,
	    SDL_Init,
	    SDL/SDL.h,
	    SDL/SDL_version.h,
	    SDL_MAJOR_VERSION.SDL_MINOR_VERSION.SDL_PATCHLEVEL,
	    $1,
	http://www.devolution.com/~slouken/SDL/SDL-0.10/src/SDL-$1.tar.gz)
    ])
])

AC_DEFUN([PACKAGES_LIBSDL_MIXER],
[
    TEST_SKIP(
    [
      AC_CHECK_HEADER(SDL/SDL_mixer.h,
	[
		AC_DEFINE(HAVE_MIXER))
		AC_CHECK_LIB([
			SDL_mixer, 
			MixSetPostMix,
			[$LIBS="-lSDL_mixer $LIBS" AC_DEFINE(HAVE_MIXER)], 
			TEST_FAILED(libSDL_mixer not found, Mix_SetPostMix)])
    	]
    ]

])

AC_DEFUN([PACKAGES_LIBZ],
[
    TEST_SKIP(
    [
	CHECK_LIB(
	    zlib.h,
	    z,
	    inflateInit_)
    ])
])


AC_DEFUN([PACKAGES_LIBXML],
[
    TEST_SKIP(
    [
	CHECK_LIB_SCRIPT_VERSION(
	    xml,
	    xml-config,
	    $1)
    ])
])


AC_DEFUN([PACKAGES_LIBPNG],
[
    TEST_SKIP(
    [
dnl	CHECK_LIB(
dnl	    png.h,
dnl	    png,
dnl	    png_create_read_struct)
	AC_CHECK_LIB(png, png_create_read_struct, LIBS="-lpng $LIBS")
    ])
])


AC_DEFUN([PACKAGES_FREETYPE],
[
    TEST_SKIP(
    [
	CHECK_LIB_HEADER_VERSION(
	    ttf,
	    TT_Open_Face,
	    freetype.h,
	    freetype.h,
	    TT_FREETYPE_MAJOR.TT_FREETYPE_MINOR.0,
	    $1.0,
	ftp://ftp.freetype.org/pub/freetype/freetype-$1.tar.gz)
    ])
])



AC_DEFUN([PACKAGES_CURSES],
[
    TEST_SKIP(
    [
	CHECK_LIB(
	    curses.h,
	    curses,
	    initscr)
    ])
])


AC_DEFUN([PACKAGES_NCURSES],
[
    TEST_SKIP(
    [
	CHECK_LIB_HEADER_VERSION(
	    ncurses,
	    initscr,
	    ncurses.h,
	    ncurses.h,
	    NCURSES_VERSION_MAJOR.NCURSES_VERSION_MINOR.NCURSES_VERSION_PATCH,
	    ifelse($2,, $1.0, $1.$2),
	ftp://ftp.gnu.org/gnu/ncurses/ncurses-$1.tar.gz)
    ])
])


AC_DEFUN([PACKAGES_X11],
[
    TEST_SKIP(
    [
	AC_PATH_X

	if test "$no_x" = yes ; then

	    TEST_FAILED([could not locate X-Windows client libraries])

	fi

	LIBS="-L$x_libraries -lX11 -lXext $LIBS"
    ])
])


AC_DEFUN([PACKAGES_MESA],
[
    TEST_SKIP(
    [
	CHECK_LIB_HEADER_VERSION(
	    MesaGL,
	    glBegin,
	    GL/gl.h,
	    GL/gl.h,
	    MESA_MAJOR_VERSION.MESA_MINOR_VERSION.0,
	    $1.0,
	ftp://ftp.mesa3d.org/mesa/MesaLib-$1.tar.gz)
    ])
])


dnl CHECK_FEATURE(name, declarations, function-body)
AC_DEFUN([CHECK_FEATURE],
[
    AC_MSG_CHECKING([for $1])

    ac_feature_var=`echo $1 | sed 'y%./+- %__p__%'`

    AC_CACHE_VAL(ac_cv_feature_$ac_feature_var,
[
    AC_TRY_COMPILE([$2], [$3],
    [
	eval "ac_cv_feature_$ac_feature_var=yes"
    ],
    [
	eval "ac_cv_feature_$ac_feature_var=no"
    ])
])

    if eval "test \"`echo '$ac_cv_feature_'$ac_feature_var`\" = yes"
    then

	AC_MSG_RESULT(yes)

    else

	AC_MSG_RESULT(no)
	TEST_FAILED(obsolete C++ compiler)
    fi
])
    
])


AC_DEFUN([C_STDLIB],
[
    TEST_SKIP(
    [
	AC_HEADER_STDC
    ])
])


AC_DEFUN([CXX_STDLIB],
[
    TEST_SKIP(
    [
	AC_CHECK_HEADERS(vector map algorithm string,,
	[
	    TEST_FAILED(obsolete C++ libraries)
	])
    ])
])


AC_DEFUN([CXX_BOOL],
[
    TEST_SKIP(
    [
	CHECK_FEATURE([bool],,[ bool t = true, f = false; ])
    ])
])


AC_DEFUN([CXX_NAMESPACE],
[
    TEST_SKIP(
    [
	CHECK_FEATURE([namespace],
	[
	    namespace foo { int i; } 
	],
	[
	    foo::i = 1; 
	])
    ])
])


AC_DEFUN([CXX_CONST_CAST],
[
    TEST_SKIP(
    [
	CHECK_FEATURE([const_cast],
	[
	    class foo;
	],
	[
	    const foo *c = 0; 
	    foo *c1 = const_cast<foo *>(c);
	])
    ])
])


AC_DEFUN([CXX_MEMBER_FUNCTION_TEMPLATES],
[
    TEST_SKIP(
    [
	CHECK_FEATURE([member function templates],
	[
	    class foo
	    {
		public:

		template <class T> void method(T t);
	    };

	    template <class T>
	    void foo::method(T t) { t = 0; }
	])
    ])
])


AC_DEFUN([CXX_MEMBER_CLASS_TEMPLATES],
[
    TEST_SKIP(
    [
	CHECK_FEATURE([member class templates],
	[
	    struct S
	    {
		template <class T> struct A { };
		template <class T> struct B { };
	    };
	])
    ])
])


AC_DEFUN([CXX_MUTABLE],
[
    TEST_SKIP(
    [
	CHECK_FEATURE([mutable],
	[
	    class foo
	    {
		mutable char *s;

		public:

		void bar() const { s = 0; }
	    };
	])
    ])
])


AC_DEFUN([CXX_PARTIAL_SPECIALIZATION],
[
    TEST_SKIP(
    [
	CHECK_FEATURE([partial specialization],
	[
	    template <class A, class B>
	    class Foo { };

	    template <class B>
	    class Foo<void, B> { };
	],
	[
	    Foo<float, float> a;
	    Foo<void, void> b;
	])
    ])
])


AC_DEFUN([CXX_FRIEND_TEMPLATES],
[
    TEST_SKIP(
    [
	CHECK_FEATURE([friend templates],
	[
	    struct A
	    {
		template <class T>
		friend T *gen();
	    };
	])
    ])
])


AC_DEFUN([CXX_INTRINSIC_CONSTRUCTORS],
[
    TEST_SKIP(
    [
	CHECK_FEATURE([intrinsic constructors],
	[
	    template <class T>
	    struct A
	    {
		T t;
		A() : t() { }
	    };

	    A<int> i;
	])
    ])
])


AC_DEFUN([CHECK_TYPE],
[AC_REQUIRE([AC_HEADER_STDC])dnl
AC_MSG_CHECKING(for $2)
AC_CACHE_VAL(ac_cv_type_$2,
[AC_EGREP_CPP(dnl
changequote(<<,>>)
<<(^|[^a-zA-Z_0-9])$2[^a-zA-Z_0-9]>>
changequote([,]), [#include <$1>
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif], ac_cv_type_$2=yes, ac_cv_type_$2=no)])dnl
AC_MSG_RESULT($ac_cv_type_$2)
if test $ac_cv_type_$2 = no; then
  AC_DEFINE($2, $3)
fi
])


AC_DEFUN([PACKAGES_NETWORKING],
[
    TEST_SKIP(
    [
	dnl Needs to check for BeOS networking header files.
	dnl Needs to check for Win32 networking header files.
    
	AC_CHECK_LIB(socket, socket, LIBS="-lsocket $LIBS")
	AC_CHECK_LIB(nsl, gethostbyname, LIBS="-lnsl $LIBS")
	AC_CHECK_LIB(resolv, hstrerror, LIBS="-lresolv $LIBS")
	CHECK_TYPE(sys/socket.h, socklen_t, int)
    ])
])


dnl FUDGE_CONFIG_HEADER(path to config.h.in)
AC_DEFUN([FUDGE_CONFIG_HEADER],
[
    if test -f "$1"
    then

	dnl Massively munge config.h.in
	dnl Basically changes certain /* ... */ to /// for Doc++

	changequote(,)dnl
	arg=`echo "$1" | sed -e 's/[\/]/\\\\\\//g' -e 's/[.]/\\\\./g'`
	sed "\/\/\* $arg/!s/\/\*\(.*\)\*\//\/\/\/\1/" < "$1" > config.h.$$
	changequote([,])dnl
	
	mv config.h.$$ "$1"

    fi
])

dnl PKG_CHECK_MODULES(GSTUFF, gtk+-2.0 >= 1.3 glib = 1.3.4, action-if, action-not)
dnl defines GSTUFF_LIBS, GSTUFF_CFLAGS, see pkg-config man page
dnl also defines GSTUFF_PKG_ERRORS on error
AC_DEFUN(PKG_CHECK_MODULES, [
  succeeded=no

  if test -z "$PKG_CONFIG"; then
    AC_PATH_PROG(PKG_CONFIG, pkg-config, no)
  fi

  if test "$PKG_CONFIG" = "no" ; then
     echo "*** The pkg-config script could not be found. Make sure it is"
     echo "*** in your path, or set the PKG_CONFIG environment variable"
     echo "*** to the full path to pkg-config."
     echo "*** Or see http://www.freedesktop.org/software/pkgconfig to get pkg-config."
  else
     PKG_CONFIG_MIN_VERSION=0.9.0
     if $PKG_CONFIG --atleast-pkgconfig-version $PKG_CONFIG_MIN_VERSION; then
        AC_MSG_CHECKING(for $2)

        if $PKG_CONFIG --exists "$2" ; then
            AC_MSG_RESULT(yes)
            succeeded=yes

            AC_MSG_CHECKING($1_CFLAGS)
            $1_CFLAGS=`$PKG_CONFIG --cflags "$2"`
            AC_MSG_RESULT($$1_CFLAGS)

            AC_MSG_CHECKING($1_LIBS)
            $1_LIBS=`$PKG_CONFIG --libs "$2"`
            AC_MSG_RESULT($$1_LIBS)
        else
            $1_CFLAGS=""
            $1_LIBS=""
            ## If we have a custom action on failure, don't print errors, but 
            ## do set a variable so people can do so.
            $1_PKG_ERRORS=`$PKG_CONFIG --errors-to-stdout --print-errors "$2"`
            ifelse([$4], ,echo $$1_PKG_ERRORS,)
        fi

        AC_SUBST($1_CFLAGS)
        AC_SUBST($1_LIBS)
     else
        echo "*** Your version of pkg-config is too old. You need version $PKG_CONFIG_MIN_VERSION or newer."
        echo "*** See http://www.freedesktop.org/software/pkgconfig"
     fi
  fi

  if test $succeeded = yes; then
     ifelse([$3], , :, [$3])
  else
     ifelse([$4], , AC_MSG_ERROR([Library requirements ($2) not met; consider adjusting the PKG_CONFIG_PATH environment variable if your libraries are in a nonstandard prefix so pkg-config can find them.]), [$4])
  fi
])

# Configure paths for SDL
# Sam Lantinga 9/21/99
# stolen from Manish Singh
# stolen back from Frank Belew
# stolen from Manish Singh
# Shamelessly stolen from Owen Taylor

dnl AM_PATH_SDL([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for SDL, and define SDL_CFLAGS and SDL_LIBS
dnl
AC_DEFUN(AM_PATH_SDL,
[dnl 
dnl Get the cflags and libraries from the sdl-config script
dnl
AC_ARG_WITH(sdl-prefix,[  --with-sdl-prefix=PFX   Prefix where SDL is installed (optional)],
            sdl_prefix="$withval", sdl_prefix="")
AC_ARG_WITH(sdl-exec-prefix,[  --with-sdl-exec-prefix=PFX Exec prefix where SDL is installed (optional)],
            sdl_exec_prefix="$withval", sdl_exec_prefix="")
AC_ARG_ENABLE(sdltest, [  --disable-sdltest       Do not try to compile and run a test SDL program],
		    , enable_sdltest=yes)

  if test x$sdl_exec_prefix != x ; then
     sdl_args="$sdl_args --exec-prefix=$sdl_exec_prefix"
     if test x${SDL_CONFIG+set} != xset ; then
        SDL_CONFIG=$sdl_exec_prefix/bin/sdl-config
     fi
  fi
  if test x$sdl_prefix != x ; then
     sdl_args="$sdl_args --prefix=$sdl_prefix"
     if test x${SDL_CONFIG+set} != xset ; then
        SDL_CONFIG=$sdl_prefix/bin/sdl-config
     fi
  fi

  PATH="$prefix/bin:$prefix/usr/bin:$PATH"
  AC_PATH_PROG(SDL_CONFIG, sdl-config, no, [$PATH])
  min_sdl_version=ifelse([$1], ,0.11.0,$1)
  AC_MSG_CHECKING(for SDL - version >= $min_sdl_version)
  no_sdl=""
  if test "$SDL_CONFIG" = "no" ; then
    no_sdl=yes
  else
    SDL_CFLAGS=`$SDL_CONFIG $sdlconf_args --cflags`
    SDL_LIBS=`$SDL_CONFIG $sdlconf_args --libs`

    sdl_major_version=`$SDL_CONFIG $sdl_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    sdl_minor_version=`$SDL_CONFIG $sdl_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    sdl_micro_version=`$SDL_CONFIG $sdl_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_sdltest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $SDL_CFLAGS"
      LIBS="$LIBS $SDL_LIBS"
dnl
dnl Now check if the installed SDL is sufficiently new. (Also sanity
dnl checks the results of sdl-config to some extent
dnl
      rm -f conf.sdltest
      AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "SDL.h"

char*
my_strdup (char *str)
{
  char *new_str;
  
  if (str)
    {
      new_str = (char *)malloc ((strlen (str) + 1) * sizeof(char));
      strcpy (new_str, str);
    }
  else
    new_str = NULL;
  
  return new_str;
}

int main (int argc, char *argv[])
{
  int major, minor, micro;
  char *tmp_version;

  /* This hangs on some systems (?)
  system ("touch conf.sdltest");
  */
  { FILE *fp = fopen("conf.sdltest", "a"); if ( fp ) fclose(fp); }

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = my_strdup("$min_sdl_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_sdl_version");
     exit(1);
   }

   if (($sdl_major_version > major) ||
      (($sdl_major_version == major) && ($sdl_minor_version > minor)) ||
      (($sdl_major_version == major) && ($sdl_minor_version == minor) && ($sdl_micro_version >= micro)))
    {
      return 0;
    }
  else
    {
      printf("\n*** 'sdl-config --version' returned %d.%d.%d, but the minimum version\n", $sdl_major_version, $sdl_minor_version, $sdl_micro_version);
      printf("*** of SDL required is %d.%d.%d. If sdl-config is correct, then it is\n", major, minor, micro);
      printf("*** best to upgrade to the required version.\n");
      printf("*** If sdl-config was wrong, set the environment variable SDL_CONFIG\n");
      printf("*** to point to the correct copy of sdl-config, and remove the file\n");
      printf("*** config.cache before re-running configure\n");
      return 1;
    }
}

],, no_sdl=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_sdl" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$SDL_CONFIG" = "no" ; then
       echo "*** The sdl-config script installed by SDL could not be found"
       echo "*** If SDL was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the SDL_CONFIG environment variable to the"
       echo "*** full path to sdl-config."
     else
       if test -f conf.sdltest ; then
        :
       else
          echo "*** Could not run SDL test program, checking why..."
          CFLAGS="$CFLAGS $SDL_CFLAGS"
          LIBS="$LIBS $SDL_LIBS"
          AC_TRY_LINK([
#include <stdio.h>
#include "SDL.h"

int main(int argc, char *argv[])
{ return 0; }
#undef  main
#define main K_and_R_C_main
],      [ return 0; ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding SDL or finding the wrong"
          echo "*** version of SDL. If it is not finding SDL, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means SDL was incorrectly installed"
          echo "*** or that you have moved SDL since it was installed. In the latter case, you"
          echo "*** may want to edit the sdl-config script: $SDL_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     SDL_CFLAGS=""
     SDL_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(SDL_CFLAGS)
  AC_SUBST(SDL_LIBS)
  rm -f conf.sdltest
])
