#ifndef __PINGER_H__
#define __PINGER_H__


#include <netinet/in.h>
#include "list.h"
#include "config.h"
#include <sys/time.h>

#define MAXFD 64

#define MAXPACKET       (65536 - 60 - 8)/* max packet size */
#define DATALEN         1 /* 1 byte ;) */
#define PINGER_DONTPING 1

#ifdef HAVE_STRUCT_ICMP

#define STRUCT_ICMP struct icmp
#define ICMP_TYPE icmp_type
#define ICMP_CODE icmp_code
#define ICMP_CKSUM icmp_cksum
#define ICMP_SEQ icmp_seq
#define ICMP_ID icmp_id

#else

#define STRUCT_ICMP struct icmphdr
#define ICMP_TYPE type
#define ICMP_CODE code
#define ICMP_CKSUM checksum
#define ICMP_SEQ un.echo.sequence
#define ICMP_ID un.echo.id

#endif

#ifndef ICMP_UNREACH
#define ICMP_UNREACH ICMP_DEST_UNREACH
#endif

#ifndef ICMP_UNREACH_PORT
#define ICMP_UNREACH_PORT ICMP_PORT_UNREACH
#endif

#ifdef HAVE_STRUCT_UDPBSD
#define UDP_DPORT uh_dport
#else
#define UDP_DPORT dest
#endif

#if ! (defined(__GLIBC__) && (__GLIBC__ >= 2))
#define inet_ntoa(x) inet_ntoa(*((struct in_addr *)&(x)))
#endif

#define TIMEOUT_SIZE 55

typedef struct {
	struct sockaddr_in *sock, *tcpsock;
	time_t lastping;
	time_t lastreply;
	struct timeval lp,lr;
	long timeout[TIMEOUT_SIZE];
	int timeoutptr;
	int sequence;
	int flags;
	int totalfailures;
	int tcpport,udpport,udpstatus;
	int tcp_socket;
} pinger_host;

typedef struct {
	struct protoent *proto;
	int socket;
	int ident;
	ListItem hosts;
	unsigned char outbuf[MAXPACKET],inbuf[MAXPACKET];
	fd_set fdmask_read, fdmask_write;
} pinger;

/* Statics */

/* functions */

int 		pinger_init(pinger*);
pinger_host 	*pinger_addhost(pinger *p,char*);
int 		pinger_poll(pinger*,pinger_host *);
int 		pinger_checkstatus(pinger*);
unsigned long 	pinger_checkoneandsleep(pinger*,unsigned long);
int 		pinger_pollall(pinger*);
pinger_host	*pinger_pollnext(pinger*);
pinger_host	*pinger_pollinit(pinger*);

int tcp_isalive(pinger_host *h);

#endif
