// $Id: HFEditHeight.h,v 1.14 2001/10/30 15:32:59 nekeme Exp $
#ifndef WE_HF_EDITHEIGHT_H
#define WE_HF_EDITHEIGHT_H


#include "HeightFieldChange.h"


class HFEditHeight : public HeightFieldChange
{
  protected:
    inline int Clamp255(int h)
    {
      if (h < 0) return 0;
      if (255 < h) return 255;
      return h;
    }

    float ComputeStandardAttenuation(float);
    virtual void ApplyAtPoint(int,int,float) {}

    /// Clone the tool but not the state
    virtual HeightFieldChange* Clone()
    { 
	return CreateNew
	   (m_World, m_Operation, m_BrushSize, m_Attenuation, m_Strength);
    }

  public:
    int m_Operation;
    int m_BrushSize;
    float m_Attenuation;
    float m_Strength;

  public:
    HFEditHeight(World* world, int type, int size, float att, float str);

    virtual ~HFEditHeight();

    virtual void Apply(int,int);

    virtual HFEditHeight* CreateNew
         (World* w, int t, int s, float a, float h) const
    {
      return new HFEditHeight(w, t, s, a, h);
    }
    
    /// Create a command with a correct state.
    virtual Command* CreateCommand() { return 0; }

};


#endif // WE_HF_EDITHEIGHT_H
