#include "xev.h"
#include "enemy.h"

PRIVATE char *fn[] = {
      "gzakart.img",
      "zakart2.img",
      "zakartapp1.img",
      "zakartapp2.img",
      "zakartapp3.img"
};
PRIVATE Pixmap pixmap[5];
PRIVATE Pixmap pixmap_mask[5];
PRIVATE GC gc[5];
PRIVATE int anim[12] = {
      4,4,4,3,
      4,3,3,2,
      3,2,2,2};

void GZakartSetChar()
{
      int c_no;
      char img[CSIZE*CSIZE] , mask[3*18];
      XGCValues gcv;

      gcv.graphics_exposures = False;

      for(c_no = 0 ; c_no < 5 ; c_no++) {
            int x,y;
            
            sprintf(tpath , "%s/%s",IMAGE_DIR,fn[c_no]);
            LoadChar(tpath,img , sizeof(img));
	    pixmap[c_no] = XCreatePixmap(d,w,24,18,depth);
            bzero(mask , sizeof(mask));
	    gc[c_no] = XCreateGC(d,w,GCGraphicsExposures,&gcv);

	    for(y = 0 ; y < 18 ; y++)
              for(x = 0 ; x < 24 ; x++) {
                    if(img[y*CSIZE+x] != 100) {
                          mask[y*3+x/8] |= (1<< (x%8));
                          XSetForeground(d,gc[c_no],
                                         pixel[img[y*CSIZE+x]]);
                          XDrawPoint(d,pixmap[c_no],gc[c_no],x,y);
                    }
              }
            pixmap_mask[c_no] 
              = XCreateBitmapFromData(d,w,mask,24,18);
            XSetClipMask(d,gc[c_no],pixmap_mask[c_no]);
      }
}

void GZakartFree()
{
      int i;

      for(i = 0 ; i < 5 ; i++) {
	    XFreePixmap(d,pixmap[i]);
	    XFreePixmap(d,pixmap_mask[i]);
	    XFreeGC(d,gc[i]);
      }
}

void GZakartInit(enemy_no)
     int enemy_no;
{
      ZakartInit(enemy_no);
      enemy[enemy_no].enemy_no = GZAKART;
      enemy[enemy_no].tmp1 = (enemy[enemy_no].tmp1*3)/2;
      enemy[enemy_no].tmp3 = 11;
}

int GZakart(enemy_no)
     int enemy_no;
{
      int i;
      int yararetaTL = 0;
      register int dx,dy;
      int sx,sy , char_no = 0;
      
      if(enemy[enemy_no].tmp3 > 0) {
            SetSprite(enemy[enemy_no].x.sht[UNION],
                      enemy[enemy_no].y.sht[UNION],
                      pixmap[anim[enemy[enemy_no].tmp3]],
                      gc[anim[enemy[enemy_no].tmp3]],
                      CSIZE,CSIZE);
            enemy[enemy_no].tmp3--;
      } else {
	    enemy[enemy_no].x.dummy += enemy[enemy_no].vx;
	    enemy[enemy_no].y.dummy += enemy[enemy_no].vy;
	    sx = enemy[enemy_no].x.sht[UNION];
	    sy = enemy[enemy_no].y.sht[UNION];
	    enemy[enemy_no].tmp1 --;
	    dx = jx.sht[UNION] - sx; dy = jy.sht[UNION] - sy;
	    
	    if(dx > -20 && dx < 20 && dy > -20 && dy < 20)
	      yararetaTL = 1;
	    
	    for(i = 0 ; i < SHOT_NUM ; i++)
	      {
		    if(!shot[i].flag)
		      continue;
		    
		    if((shot[i].x.sht[UNION] - sx) > -20 && 
		       (shot[i].x.sht[UNION] - sx) < 20
		       && (shot[i].y.sht[UNION] - sy) > -24 && 
		       (shot[i].y.sht[UNION] - sy) < 24)
		      {
			    score += 600+100*(rand() % 7);
			    shot[i].flag = 0;
			    BombInit(enemy_no);
			    return 0;
		      }
	      }
	    
	    if(sx < 0 ||sx > XSIZE
	       || sy > YSIZE)
	      {
		    enemy[enemy_no].enemy_no = 0;
	      }
	    else
	      {
		    if(enemy[enemy_no].tmp1 == 1)
		      char_no = 1;
		    if(enemy[enemy_no].tmp1 == 0) {
			  GZEShut(enemy_no,enemy[enemy_no].x.dummy,
				  enemy[enemy_no].y.dummy);
			  enemy[enemy_no].enemy_no = 0;
		    } else {
			  SetSprite(enemy[enemy_no].x.sht[UNION],
				    enemy[enemy_no].y.sht[UNION],
				    pixmap[char_no],gc[char_no],
				    CSIZE,CSIZE);
		    }
	      }
      }
      return yararetaTL;
}



