/*  
 *  xcall - Packet radio program for GTK+
 *  Copyright (C) 2001 Joop Stakenborg <pg4i@amsat.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* preferences.c: saving and recalling of preferences */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include "utils.h"
#include "support.h"
#include "types.h"

gchar *preferencesdir;
preferencestype preferences;

/*
 * Check if ~/.xcall directory exists. If not: create it and exit if errors.
 */
 
void dircheck()
{
  GString *packagedir;
  struct stat statdir;

  packagedir = g_string_new("/.");
  g_string_append(packagedir, PACKAGE);
  preferencesdir = g_strconcat(g_get_home_dir(), packagedir->str, NULL);
  if (stat(preferencesdir, &statdir) == -1)
  {
    if (mkdir(preferencesdir, S_IRUSR | S_IWUSR | S_IXUSR) == -1)
      g_error(_("Creating ~%s directory."), packagedir->str);
  }
  else if (!S_ISDIR(statdir.st_mode)) g_error(_("~%s is not a directory."), packagedir->str);
}

void loadpreferences() {
  gchar *preferencesfile, label[100], value[100], *downloaddir;
  FILE *fp;
  GdkColormap *colormap;

  /* defaults */
  preferences.font = g_string_new("8x13bold");
  colormap = gdk_colormap_get_system();
  (void)gdk_color_parse("white", &preferences.rxfgcolor);
  gdk_colormap_alloc_color(colormap, &preferences.rxfgcolor, FALSE, TRUE);
  (void)gdk_color_parse("grey20", &preferences.backgroundcolor);
  gdk_colormap_alloc_color(colormap, &preferences.backgroundcolor, FALSE, TRUE);
  (void)gdk_color_parse("yellow", &preferences.txfgcolor);
  gdk_colormap_alloc_color(colormap, &preferences.txfgcolor, FALSE, TRUE);
  (void)gdk_color_parse("red", &preferences.errorfgcolor);
  gdk_colormap_alloc_color(colormap, &preferences.errorfgcolor, FALSE, TRUE);
  (void)gdk_color_parse("green", &preferences.statusfgcolor);
  gdk_colormap_alloc_color(colormap, &preferences.statusfgcolor, FALSE, TRUE);
  preferences.scrollbar = TRUE;
  preferences.menu = TRUE;
  preferences.timeout = 90;
  downloaddir = g_strdup_printf("%s/.%s", g_get_home_dir(), PACKAGE);
  preferences.downloaddir = g_string_new(downloaddir);
  preferences.origin = FALSE;
  preferences.size = FALSE;
  preferences.dxcluster = FALSE;
  (void)gdk_color_parse("black", &preferences.dxbackgroundcolor);
  gdk_colormap_alloc_color(colormap, &preferences.dxbackgroundcolor, FALSE, TRUE);
  (void)gdk_color_parse("rgb:0000/6000/ffff", &preferences.dx1_8color);
  gdk_colormap_alloc_color(colormap, &preferences.dx1_8color, FALSE, TRUE);
  (void)gdk_color_parse("rgb:0000/7000/ffff", &preferences.dx3_5color);
  gdk_colormap_alloc_color(colormap, &preferences.dx3_5color, FALSE, TRUE);
  (void)gdk_color_parse("rgb:0000/8000/ffff", &preferences.dx7color);
  gdk_colormap_alloc_color(colormap, &preferences.dx7color, FALSE, TRUE);
  (void)gdk_color_parse("rgb:0000/9000/ffff", &preferences.dx10color);
  gdk_colormap_alloc_color(colormap, &preferences.dx10color, FALSE, TRUE);
  (void)gdk_color_parse("rgb:0000/a000/ffff", &preferences.dx14color);
  gdk_colormap_alloc_color(colormap, &preferences.dx14color, FALSE, TRUE);
  (void)gdk_color_parse("rgb:0000/b000/ffff", &preferences.dx18color);
  gdk_colormap_alloc_color(colormap, &preferences.dx18color, FALSE, TRUE);
  (void)gdk_color_parse("rgb:0000/c000/ffff", &preferences.dx21color);
  gdk_colormap_alloc_color(colormap, &preferences.dx21color, FALSE, TRUE);
  (void)gdk_color_parse("rgb:0000/d000/ffff", &preferences.dx24color);
  gdk_colormap_alloc_color(colormap, &preferences.dx24color, FALSE, TRUE);
  (void)gdk_color_parse("rgb:0000/e000/ffff", &preferences.dx28color);
  gdk_colormap_alloc_color(colormap, &preferences.dx28color, FALSE, TRUE);
  (void)gdk_color_parse("rgb:0000/ffff/ffff", &preferences.dxothercolor);
  gdk_colormap_alloc_color(colormap, &preferences.dxothercolor, FALSE, TRUE);

  /* open preferences file */
  preferencesfile = g_strconcat(preferencesdir, "/preferences", NULL);
  fp = fopen(preferencesfile, "r");
  if (fp == NULL) return;

  /* read preferences file */
  while(!feof(fp)) {
    if (fscanf(fp, "%s %s", label, value) == EOF) break;
    if (!g_strcasecmp(label, "font")) preferences.font = g_string_new(value);
    else if (!g_strcasecmp(label, "backgroundcolor"))
      gdk_color_parse(color_parse(value), &preferences.backgroundcolor);
    else if (!g_strcasecmp(label, "statusfgcolor"))
      gdk_color_parse(color_parse(value), &preferences.statusfgcolor);
    else if (!g_strcasecmp(label, "errorfgcolor"))
      gdk_color_parse(color_parse(value), &preferences.errorfgcolor);
    else if (!g_strcasecmp(label, "txfgcolor"))
      gdk_color_parse(color_parse(value), &preferences.txfgcolor);
    else if (!g_strcasecmp(label, "rxfgcolor"))
      gdk_color_parse(color_parse(value), &preferences.rxfgcolor);
    else if (!g_strcasecmp(label, "rxfgcolor"))
      gdk_color_parse(color_parse(value), &preferences.rxfgcolor);
    else if (!g_strcasecmp(label, "scrollbar"))
      { if (!g_strcasecmp(value, "off")) preferences.scrollbar = FALSE; }
    else if (!g_strcasecmp(label, "menu"))
      { if (!g_strcasecmp(value, "off")) preferences.menu = FALSE; }
    else if (!g_strcasecmp(label, "timeout"))
      preferences.timeout = atoi(value);
    else if (!g_strcasecmp(label, "downloaddir"))
      preferences.downloaddir = g_string_new(value);
    else if (!g_strcasecmp(label, "size"))
      { if (!g_strcasecmp(value, "on")) preferences.size = TRUE; }
    else if (!g_strcasecmp(label, "origin"))
      { if (!g_strcasecmp(value, "on")) preferences.origin = TRUE; }
    else if (!g_strcasecmp(label, "x"))
      preferences.x = atoi(value);
    else if (!g_strcasecmp(label, "y"))
      preferences.y = atoi(value);
    else if (!g_strcasecmp(label, "width"))
      preferences.width = atoi(value);
    else if (!g_strcasecmp(label, "height"))
      preferences.height = atoi(value);
    else if (!g_strcasecmp(label, "dxcluster"))
      { if (!g_strcasecmp(value, "on")) preferences.dxcluster = TRUE; }
    else if (!g_strcasecmp(label, "dxbackgroundcolor"))
      gdk_color_parse(color_parse(value), &preferences.backgroundcolor);
    else if (!g_strcasecmp(label, "dx1_8color"))
      gdk_color_parse(color_parse(value), &preferences.dx1_8color);
    else if (!g_strcasecmp(label, "dx3_5color"))
      gdk_color_parse(color_parse(value), &preferences.dx3_5color);
    else if (!g_strcasecmp(label, "dx7color"))
      gdk_color_parse(color_parse(value), &preferences.dx7color);
    else if (!g_strcasecmp(label, "dx10color"))
      gdk_color_parse(color_parse(value), &preferences.dx10color);
    else if (!g_strcasecmp(label, "dx14color"))
      gdk_color_parse(color_parse(value), &preferences.dx14color);
    else if (!g_strcasecmp(label, "dx18color"))
      gdk_color_parse(color_parse(value), &preferences.dx18color);
    else if (!g_strcasecmp(label, "dx21color"))
      gdk_color_parse(color_parse(value), &preferences.dx21color);
    else if (!g_strcasecmp(label, "dx24color"))
      gdk_color_parse(color_parse(value), &preferences.dx24color);
    else if (!g_strcasecmp(label, "dx28color"))
      gdk_color_parse(color_parse(value), &preferences.dx28color);
    else if (!g_strcasecmp(label, "dxothercolor"))
      gdk_color_parse(color_parse(value), &preferences.dxothercolor);
  }
}

void savepreferences() {
  gchar *preferencesfile, *timeout, *x, *y, *width, *height;
  FILE *fp;

  /* open preferences file */
  preferencesfile = g_strconcat(preferencesdir, "/preferences", NULL);
  fp = fopen(preferencesfile, "w");
  if (fp == NULL) return;

  /* warning and version */
  fprintf(fp, "# settings file for %s, do not edit\n", PACKAGE);
  fprintf(fp, "version %s\n", VERSION);

  /* settings */
  if (preferences.font) if (preferences.font->len > 0)
    fprintf(fp, "font %s\n", preferences.font->str);
  fprintf(fp, "backgroundcolor %04X,%04X,%04X\n", preferences.backgroundcolor.red, preferences.backgroundcolor.green, preferences.backgroundcolor.blue);
  fprintf(fp, "txfgcolor %04X,%04X,%04X\n", preferences.txfgcolor.red, preferences.txfgcolor.green, preferences.txfgcolor.blue);
  fprintf(fp, "rxfgcolor %04X,%04X,%04X\n", preferences.rxfgcolor.red, preferences.rxfgcolor.green, preferences.rxfgcolor.blue);
  fprintf(fp, "statusfgcolor %04X,%04X,%04X\n", preferences.statusfgcolor.red, preferences.statusfgcolor.green, preferences.statusfgcolor.blue);
  fprintf(fp, "errorfgcolor %04X,%04X,%04X\n", preferences.errorfgcolor.red, preferences.errorfgcolor.green, preferences.errorfgcolor.blue);
  if (!preferences.scrollbar) fprintf(fp, "scrollbar off\n");
  if (!preferences.menu) fprintf(fp, "menu off\n");
  timeout = g_strdup_printf("%d", preferences.timeout);
  fprintf(fp, "timeout %s\n", timeout);
  if (preferences.downloaddir) if (preferences.downloaddir->len > 0)
    fprintf(fp, "downloaddir %s\n", preferences.downloaddir->str);
  if (preferences.origin) fprintf(fp, "origin on\n");
  if (preferences.size) fprintf(fp, "size on\n");
  x = g_strdup_printf("%d", preferences.x);
  fprintf(fp, "x %s\n", x);
  y = g_strdup_printf("%d", preferences.y);
  fprintf(fp, "y %s\n", y);
  width = g_strdup_printf("%d", preferences.width);
  fprintf(fp, "width %s\n", width);
  height = g_strdup_printf("%d", preferences.height);
  fprintf(fp, "height %s\n", height);
  if (preferences.dxcluster) fprintf(fp, "dxcluster on\n");
  fprintf(fp, "dxbackgroundcolor %04X,%04X,%04X\n", preferences.dxbackgroundcolor.red, preferences.dxbackgroundcolor.green, preferences.dxbackgroundcolor.blue);
  fprintf(fp, "dx1_8color %04X,%04X,%04X\n", preferences.dx1_8color.red, preferences.dx1_8color.green, preferences.dx1_8color.blue);
  fprintf(fp, "dx3_5color %04X,%04X,%04X\n", preferences.dx3_5color.red, preferences.dx3_5color.green, preferences.dx3_5color.blue);
  fprintf(fp, "dx7color %04X,%04X,%04X\n", preferences.dx7color.red, preferences.dx7color.green, preferences.dx7color.blue);
  fprintf(fp, "dx10color %04X,%04X,%04X\n", preferences.dx10color.red, preferences.dx10color.green, preferences.dx10color.blue);
  fprintf(fp, "dx14color %04X,%04X,%04X\n", preferences.dx14color.red, preferences.dx14color.green, preferences.dx14color.blue);
  fprintf(fp, "dx18color %04X,%04X,%04X\n", preferences.dx18color.red, preferences.dx18color.green, preferences.dx18color.blue);
  fprintf(fp, "dx21color %04X,%04X,%04X\n", preferences.dx21color.red, preferences.dx21color.green, preferences.dx21color.blue);
  fprintf(fp, "dx24color %04X,%04X,%04X\n", preferences.dx24color.red, preferences.dx24color.green, preferences.dx24color.blue);
  fprintf(fp, "dx28color %04X,%04X,%04X\n", preferences.dx28color.red, preferences.dx28color.green, preferences.dx28color.blue);
  fprintf(fp, "dxothercolor %04X,%04X,%04X\n", preferences.dxothercolor.red, preferences.dxothercolor.green, preferences.dxothercolor.blue);
  fclose(fp);
}
