
#include "basicblocks.h"

using namespace std;

__BEGIN_YAFRAY

colorA_t floatToColor_t::stdoutColor(renderState_t &state,const surfacePoint_t &sp,
		const vector3d_t &eye,const scene_t *scene)const
{
	CFLOAT f=input->stdoutFloat(state,sp,eye,scene);
	return colorA_t(f,f,f);
}

shader_t * floatToColor_t::factory(paramMap_t &bparams,std::list<paramMap_t> &lparams,
				        renderEnvironment_t &render)
{
	string _inputs;
	const string *inputs=&_inputs;
	shader_t *input=NULL;
	bparams.getParam("input",inputs);
	input=render.getShader(*inputs);
	if(input!=NULL)
		return new floatToColor_t(input);
	else return NULL;
}

shader_t * colorToFloat_t::factory(paramMap_t &bparams,std::list<paramMap_t> &lparams,
				        renderEnvironment_t &render)
{
	string _inputs;
	const string *inputs=&_inputs;
	shader_t *input=NULL;
	bparams.getParam("input",inputs);
	input=render.getShader(*inputs);
	if(input!=NULL)
		return new colorToFloat_t(input);
	else return NULL;
}

shader_t * sinNode_t::factory(paramMap_t &bparams,std::list<paramMap_t> &lparams,
				        renderEnvironment_t &render)
{
	string _inputs;
	const string *inputs=&_inputs;
	shader_t *input=NULL;
	bparams.getParam("input",inputs);
	input=render.getShader(*inputs);
	if(input!=NULL)
		return new sinNode_t(input);
	else return NULL;
}

shader_t * mulNode_t::factory(paramMap_t &bparams,std::list<paramMap_t> &lparams,
				        renderEnvironment_t &render)
{
	string _in1,_in2;
	const string *in1=&_in1,*in2=&_in2;
	shader_t *input1=NULL,*input2=NULL;
	CFLOAT val=1.0;
	bparams.getParam("input1",in1);
	bparams.getParam("input2",in2);
	bparams.getParam("value",val);
	input1=render.getShader(*in1);
	input2=render.getShader(*in2);
	return new mulNode_t(input1,input2,val);
}

shader_t * coordsNode_t::factory(paramMap_t &bparams,std::list<paramMap_t> &lparams,
				        renderEnvironment_t &render)
{
	int w=0;
	string _var;
	const string *var=&_var;
	bparams.getParam("coord",var);
	if(*var=="X") w=0;
	if(*var=="Y") w=1;
	if(*var=="Z") w=2;
	return new coordsNode_t(w);
}
// CLOUDS

cloudsNode_t::cloudsNode_t(PFLOAT s, int dep, const shader_t *in1, const shader_t *in2)
		:tex(dep,color_t(0.0),color_t(1.0)),
		size(s), input1(in1), input2(in2)
{
}

CFLOAT cloudsNode_t::stdoutFloat(renderState_t &state,const surfacePoint_t &sp,const vector3d_t &eye
				,const scene_t *scene)const
{
	point3d_t P=sp.P();//=sp.getObject()->toObject(sp.P());
	P *= size;
	return tex.getFloat(P);
}

colorA_t cloudsNode_t::stdoutColor(renderState_t &state,const surfacePoint_t &sp,
		const vector3d_t &eye, const scene_t *scene)const
{
	point3d_t P=sp.P();//=sp.getObject()->toObject(sp.P());
	P.x *= size;
	P.y *= size;
	P.z *= size;
	CFLOAT intensidad = tex.getFloat(P);
	if ((input1==NULL) || (input2==NULL)) return colorA_t(intensidad);
	else
		return (input1->stdoutColor(state,sp,eye,scene))*intensidad
			+ (input2->stdoutColor(state,sp,eye,scene))*(1.0-intensidad);
}

shader_t * cloudsNode_t::factory(paramMap_t &bparams,std::list<paramMap_t> &lparams,
				        renderEnvironment_t &render)
{
	string _in1,_in2;
	const string *in1=&_in1,*in2=&_in2;
	CFLOAT size=1.0;
	int dep;
	shader_t *input1=NULL,*input2=NULL;
	bparams.getParam("input1",in1);
	bparams.getParam("input2",in2);
	bparams.getParam("size",size);
	bparams.getParam("depth",dep);
	input1=render.getShader(*in1);
	input2=render.getShader(*in2);

	return new cloudsNode_t(size,dep,input1,input2);
}
// MARBLE

marbleNode_t::marbleNode_t(PFLOAT sz, int dep, CFLOAT turb, CFLOAT shp, bool hrd,
		const shader_t *in1, const shader_t *in2)
		:tex(dep, color_t(0.0), color_t(1.0), turb, shp, hrd),
		size(sz), input1(in1), input2(in2)
{
}

CFLOAT marbleNode_t::stdoutFloat(renderState_t &state,const surfacePoint_t &sp, const vector3d_t &eye
				,const scene_t *scene) const
{
	point3d_t P = sp.P();//sp.getObject()->toObject(sp.P());
	P *= size;
	return tex.getFloat(P);
}

colorA_t marbleNode_t::stdoutColor(renderState_t &state,const surfacePoint_t &sp,
		const vector3d_t &eye, const scene_t *scene) const
{
	point3d_t P= sp.P();//sp.getObject()->toObject(sp.P());
	P *= size;
	CFLOAT intensidad = tex.getFloat(P);
	if ((input1==NULL) || (input2==NULL))
		return colorA_t(intensidad);
	return (input1->stdoutColor(state,sp,eye,scene))*intensidad
		+ (input2->stdoutColor(state,sp,eye,scene))*(1.0-intensidad);
}

shader_t * marbleNode_t::factory(paramMap_t &bparams,std::list<paramMap_t> &lparams,
				        renderEnvironment_t &render)
{
	string _in1,_in2;
	const string *in1=&_in1,*in2=&_in2;
	CFLOAT size = 1;
	int dep = 2;
	CFLOAT turb=1, shp=1;
	bool hrd = false;
	shader_t *input1=NULL, *input2=NULL;

	bparams.getParam("input1", in1);
	bparams.getParam("input2", in2);
	bparams.getParam("size", size);
	bparams.getParam("depth", dep);
	bparams.getParam("turbulence", turb);
	bparams.getParam("sharpness", shp);
	bparams.getParam("hard", hrd);

	input1=render.getShader(*in1);
	input2=render.getShader(*in2);

	return new marbleNode_t(size, dep, turb, shp, hrd, input1, input2);
}
// WOOD

woodNode_t::woodNode_t(PFLOAT sz, int dep, CFLOAT turb, PFLOAT rx, PFLOAT ry, bool hrd,
			const shader_t *in1, const shader_t *in2)
		:tex(dep, color_t(0.0), color_t(1.0), turb, rx, ry, hrd),
		size(sz), input1(in1), input2(in2)
{
}

CFLOAT woodNode_t::stdoutFloat(renderState_t &state,const surfacePoint_t &sp, const vector3d_t &eye
				,const scene_t *scene) const
{
	point3d_t P = sp.P();//sp.getObject()->toObject(sp.P());
	P *= size;
	return tex.getFloat(P);
}

colorA_t woodNode_t::stdoutColor(renderState_t &state,const surfacePoint_t &sp,
		const vector3d_t &eye, const scene_t *scene) const
{
	point3d_t P= sp.P(); //sp.getObject()->toObject(sp.P());
	P *= size;
	CFLOAT intensidad = tex.getFloat(P);
	if ((input1==NULL) || (input2==NULL))
		return colorA_t(intensidad);
	return (input1->stdoutColor(state,sp,eye,scene))*intensidad
		+ (input2->stdoutColor(state,sp,eye,scene))*(1.0-intensidad);
}

shader_t * woodNode_t::factory(paramMap_t &bparams,std::list<paramMap_t> &lparams,
				        renderEnvironment_t &render)
{
	string _in1,_in2;
	const string *in1=&_in1,*in2=&_in2;
	CFLOAT size = 1;
	int dep = 2;
	CFLOAT turb = 1;
	PFLOAT rx=1, ry=1;
	bool hrd = false;
	shader_t *input1=NULL, *input2=NULL;

	bparams.getParam("input1", in1);
	bparams.getParam("input2", in2);
	bparams.getParam("size", size);
	bparams.getParam("depth", dep);
	bparams.getParam("turbulence", turb);
	bparams.getParam("ringscale_x", rx);
	bparams.getParam("ringscale_y", ry);
	bparams.getParam("hard", hrd);

	input1=render.getShader(*in1);
	input2=render.getShader(*in2);

	return new woodNode_t(size, dep, turb, rx, ry, hrd, input1, input2);
}

// -----------------------------------------------------------------------------------------

CFLOAT colorBandNode_t::stdoutFloat(renderState_t &state,const surfacePoint_t &sp,
		const vector3d_t &eye, const scene_t *scene)const
{
	return stdoutColor(state, sp, eye, scene).energy();
}

colorA_t colorBandNode_t::stdoutColor(renderState_t &state,const surfacePoint_t &sp,
		const vector3d_t &eye, const scene_t *scene)const
{
	CFLOAT f=input->stdoutFloat(state,sp,eye,scene);
	unsigned int i;
	for(i=0;i<band.size();++i) if(f<band[i].first) break;
	if(i==0) return band.front().second;
	if(i==band.size()) return band.back().second;
	CFLOAT range=band[i].first-band[i-1].first;
	if(range<=0.0) return band[i].second;
	CFLOAT mix=(f-band[i-1].first)/range;
	return band[i-1].second*(1.0-mix)+band[i].second*mix;
}

shader_t * colorBandNode_t::factory(paramMap_t &bparams,std::list<paramMap_t> &lparams,
				        renderEnvironment_t &render)
{
	string _inputs;
	const string *inputs=&_inputs;
	shader_t *input=NULL;
	bparams.getParam("input",inputs);
	input=render.getShader(*inputs);
	if(input==NULL)
	{
		cerr<<"Input shader for colorband not found\n";
		return NULL;
	}

	vector<pair<CFLOAT,colorA_t> > band;
	for(list<paramMap_t>::iterator i=lparams.begin();i!=lparams.end();++i)
	{
		pair<CFLOAT,colorA_t> par;
		paramMap_t &params=*i;
		params.getParam("value",par.first);
		params.getParam("color",par.second);
		band.push_back(par);
	}
	shader_t *sha= new colorBandNode_t(band,input);
	return sha;
}

color_t phongNode_t::fromRadiosity(renderState_t &state,const surfacePoint_t &sp,
		const energy_t &ene,const vector3d_t &eye)const
{
	if( ((FACE_FORWARD(sp.Ng(),sp.N(),eye) * ene.dir)<0) || (color==NULL))
		return color_t(0,0,0);
	else
		return (color_t)color->stdoutColor(state,sp,eye)*ene.color;
}

color_t phongNode_t::fromLight(renderState_t &state,const surfacePoint_t &sp,
		const energy_t &energy,const vector3d_t &eye)const
{
	vector3d_t edir=eye;
	edir.normalize();
	color_t C(0.0),S(0.0);
	vector3d_t N=FACE_FORWARD(sp.Ng(),sp.N(),edir);
	CFLOAT inte=N*energy.dir;
	edir=reflect(N,edir);
	CFLOAT refle=edir*energy.dir;
	if(refle<0.0) refle=0.0;
	else refle=std::pow((CFLOAT)refle,(CFLOAT)hard);
	if(color!=NULL) C=color->stdoutColor(state,sp,eye);
	if(specular!=NULL) S=specular->stdoutColor(state,sp,eye);
	if((inte>0) || (refle>0)) return (C*inte*energy.color) + S*refle*energy.color;
	else return color_t(0,0,0);
}

color_t phongNode_t::fromWorld(renderState_t &state,const surfacePoint_t &sp,const scene_t &scene,
		const vector3d_t &eye)const
{
	if(env!=NULL) return env->stdoutColor(state,sp,eye,&scene);
	else return color_t(0,0,0);
}

const color_t phongNode_t::getDiffuse(renderState_t &state,const surfacePoint_t &sp, const vector3d_t &eye)const
{
	vector3d_t eye2=sp.N();
	if(color!=NULL) return color->stdoutColor(state,sp,eye2);
	else return color_t(0,0,0);
}

void phongNode_t::getCaustics(renderState_t &state,const surfacePoint_t &sp,const vector3d_t &eye,
														color_t &ref,color_t &trans,
														PFLOAT &ior)const
{
	if(caus_rcolor!=NULL) ref=caus_rcolor->stdoutColor(state,sp,eye);
	if(caus_tcolor!=NULL) trans=caus_tcolor->stdoutColor(state,sp,eye);
	ior=IOR;
}

shader_t * phongNode_t::factory(paramMap_t &bparams,std::list<paramMap_t> &lparams,
				        renderEnvironment_t &render)
{
	string _c,_s,_e,_cr,_ct;
	const string *c=&_c,*s=&_s,*e=&_e,*cr=&_cr,*ct=&_ct;
	CFLOAT hard=1.0,ior=1.0;
	shader_t *color=NULL,*specular=NULL,*env=NULL,*causr=NULL,*caust=NULL;
	bparams.getParam("color",c);
	bparams.getParam("specular",s);
	bparams.getParam("environment",e);
	bparams.getParam("caus_rcolor",cr);
	bparams.getParam("caus_tcolor",ct);
	bparams.getParam("hard",hard);
	bparams.getParam("IOR",ior);
	color=render.getShader(*c);
	specular=render.getShader(*s);
	env=render.getShader(*e);
	causr=render.getShader(*cr);
	caust=render.getShader(*ct);

	if((*c!="") && (color==NULL)) cerr<<"Input shader "<<c<<" not found\n";
	if((*s!="") && (specular==NULL)) cerr<<"Input shader "<<s<<" not found\n";
	if((*e!="") && (env==NULL)) cerr<<"Input shader "<<e<<" not found\n";
	if((*cr!="") && (causr==NULL)) cerr<<"Input shader "<<cr<<" not found\n";
	if((*ct!="") && (caust==NULL)) cerr<<"Input shader "<<ct<<" not found\n";

	return new phongNode_t(color,specular,env,causr,caust,hard,ior);
}

rgbNode_t::rgbNode_t(const shader_t *in1, const shader_t *in2, const shader_t *in3,
				const color_t &c)
{
	inputred = in1;
	inputgreen = in2;
	inputblue = in3;

	color=c;
}

colorA_t rgbNode_t::stdoutColor(renderState_t &state,const surfacePoint_t &sp,const vector3d_t &eye,const scene_t *scene)const
{
	return colorA_t(	(inputred == NULL)?color.getRed():inputred->stdoutFloat(state,sp,eye,scene),
					(inputgreen == NULL)?color.getGreen():inputgreen->stdoutFloat(state,sp,eye,scene),
					(inputblue == NULL)?color.getBlue():inputblue->stdoutFloat(state,sp,eye,scene));
}

shader_t * rgbNode_t::factory(paramMap_t &bparams,std::list<paramMap_t> &lparams,
				        renderEnvironment_t &render)
{
	string _in1,_in2,_in3;
	const string *in1=&_in1,*in2=&_in2,*in3=&_in3;
	shader_t *inputred=NULL,*inputgreen=NULL,*inputblue=NULL;

	bparams.getParam("inputred",in1);
	bparams.getParam("inputgreen",in2);
	bparams.getParam("inputblue",in3);
	inputred=render.getShader(*in1);
	inputgreen=render.getShader(*in2);
	inputblue=render.getShader(*in3);

	color_t color(0.0);
	bparams.getParam("color",color);

	return new rgbNode_t(inputred,inputgreen,inputblue,color);
}

hsvNode_t::hsvNode_t(const shader_t *in1, const shader_t *in2,
		const shader_t *in3, CFLOAT h, CFLOAT s, CFLOAT v)
{
	inputhue = in1;
	inputsaturation = in2;
	inputvalue = in3;

	hue = h;
	saturation = s;
	value = v;
}

colorA_t hsvNode_t::stdoutColor(renderState_t &state,const surfacePoint_t &sp,
		const vector3d_t &eye,const scene_t *scene)const
{
	CFLOAT h,s,v;
	CFLOAT red,green,blue;

	if(inputhue!=NULL)			h = inputhue->stdoutFloat(state,sp,eye,scene);		else h = hue;
	if(inputsaturation!=NULL)	s = inputsaturation->stdoutFloat(state,sp,eye,scene);	else s = saturation;
	if(inputvalue!=NULL)		v = inputvalue->stdoutFloat(state,sp,eye,scene);		else v = value;

	int i;
	CFLOAT f, p, q, t;

	if( s == 0 ) {
		// achromatic (grey)
		red = green = blue = v;
		return colorA_t(red,green,blue);
	}

	if (h == 1.0f) h = 0.0f;
	h *= 6;
	i = (int)floor( h );
	f = h - i;			// factorial part of h
	p = v * ( 1 - s );
	q = v * ( 1 - s * f );
	t = v * ( 1 - s * ( 1 - f ) );
	switch( i ) {
		case 0:
			red = v;
			green = t;
			blue = p;
			break;
		case 1:
			red = q;
			green = v;
			blue = p;
			break;
		case 2:
			red = p;
			green = v;
			blue = t;
			break;
		case 3:
			red = p;
			green = q;
			blue = v;
			break;
		case 4:
			red = t;
			green = p;
			blue = v;
			break;
		default:		// case 5:
			red = v;
			green = p;
			blue = q;
			break;
	}

	return colorA_t(red,green,blue);
}

shader_t * hsvNode_t::factory(paramMap_t &bparams,std::list<paramMap_t> &lparams,
				        renderEnvironment_t &render)
{
	string _in1,_in2,_in3;
	const string *in1=&_in1,*in2=&_in2,*in3=&_in3;
	shader_t *inputhue=NULL,*inputsaturation=NULL,*inputvalue=NULL;

	bparams.getParam("inputhue",in1);
	bparams.getParam("inputsaturation",in2);
	bparams.getParam("inputvalue",in3);
	inputhue=render.getShader(*in1);
	inputsaturation=render.getShader(*in2);
	inputvalue=render.getShader(*in3);

	CFLOAT hue=1.0,saturation=1.0,value=1.0;
	bparams.getParam("hue",hue);
	bparams.getParam("saturation",saturation);
	bparams.getParam("value",value);

	return new hsvNode_t(inputhue,inputsaturation,inputvalue,hue,saturation,value);
}

coneTraceNode_t::coneTraceNode_t(const color_t &c,PFLOAT angle,int s,PFLOAT ior,
		bool r)
{
	samples=s;
	IOR=ior;
	color=c;
	ref=r;
	if((samples<2) || (angle<=0))
	{
		samples=1;
		cosa=1.0;
	}
	else
		cosa=cos((angle/180.0)*M_PI);
	sqr=(int)sqrt((PFLOAT)samples);
	div=1.0/(CFLOAT)samples;
	sqrdiv=1.0/(PFLOAT)sqr;
}

colorA_t coneTraceNode_t::stdoutColor(renderState_t &state,const surfacePoint_t &sp,
		const vector3d_t &eye,const scene_t *scene)const
{
	if(scene==NULL) return colorA_t(0.0);
	if( ref && ((sp.Ng()*eye)<=0) && (state.raylevel>0)) return colorA_t(0.0);
	vector3d_t edir=eye;
	edir.normalize();
	vector3d_t N=FACE_FORWARD(sp.Ng(),sp.N(),edir);
	vector3d_t Ng=FACE_FORWARD(sp.Ng(),sp.Ng(),edir);
	point3d_t P=sp.P();
	if ((N*eye)<0) N=Ng;
	vector3d_t basedir;
	PFLOAT offset;
	if(ref) basedir=reflect(N,edir);
	else basedir=refract(sp.N(),edir,IOR);
	if(!ref) Ng=-Ng;
	offset=basedir*Ng;
	if(offset<=0.05)
	{
		basedir+=Ng*(0.05-offset);
		basedir.normalize();
	}
	int oldlevel=state.rayDivision;

	const void *oldorigin=state.skipelement;
	state.skipelement=sp.getOrigin();
	if((cosa==1.0) || (oldlevel>1)) 
	{
		color_t res=scene->raytrace(state,P, basedir)*color;
		state.skipelement=oldorigin;
		return res;
	}

	state.rayDivision=samples;
	color_t res(0.0);
	for(int i=0;i<sqr;++i)
		for(int j=0;j<sqr;++j)
		{
			PFLOAT r1=i*sqrdiv + ourRandom()*sqrdiv;
			PFLOAT r2=j*sqrdiv + ourRandom()*sqrdiv;
			vector3d_t ray=randomVectorCone(basedir,cosa,r1,r2);
			offset=ray*Ng;
			if(offset<=0.05)
			{
				ray+=Ng*(0.05-offset);
				ray.normalize();
			}
			res+=scene->raytrace(state,P, ray);
		}
	res*=div;
	state.rayDivision=oldlevel;
	state.skipelement=oldorigin;
	return res*color;
}

shader_t * coneTraceNode_t::factory(paramMap_t &bparams,std::list<paramMap_t> &lparams,
				        renderEnvironment_t &render)
{
	color_t color(0.0);
	float angle=0.0,IOR=1.5;
	int samples=1;
	bool ref;

	bparams.getParam("color",color);
	bparams.getParam("angle",angle);
	bparams.getParam("IOR",IOR);
	bparams.getParam("samples",samples);
	bparams.getParam("reflect",ref);

	int s=(int)sqrt((float)samples*samples);
	if(s!=samples)
		cerr<<"Using "<<s<<" samples in conetrace instead of "<<samples<<endl;

	return new coneTraceNode_t(color,angle,s,IOR,ref);
}

colorA_t fresnelNode_t::stdoutColor(renderState_t &state,const surfacePoint_t &sp,
		const vector3d_t &eye,const scene_t *scene)const
{
	vector3d_t edir=eye;
	edir.normalize();
	vector3d_t N=FACE_FORWARD(sp.Ng(),sp.N(),edir);
	vector3d_t Ng=FACE_FORWARD(sp.Ng(),sp.Ng(),edir);
	if ((N*eye)<0) N=Ng;
	CFLOAT fKr,fKt;
	fast_fresnel(edir, N, IOR, fKr, fKt);
	fKr+=minref;
	if(fKr>1.0) fKr=1.0;
	colorA_t R=(ref!=NULL) ? ref->stdoutColor(state,sp,eye,scene) : colorA_t(0.0);
	colorA_t T=(trans!=NULL) ? trans->stdoutColor(state,sp,eye,scene) : colorA_t(0.0);
	return R*fKr+T*fKt;
}

shader_t * fresnelNode_t::factory(paramMap_t &bparams,std::list<paramMap_t> &lparams,
				        renderEnvironment_t &render)
{
	string _inR,_inT;
	const string *inR=&_inR,*inT=&_inT;
	shader_t *inputR=NULL,*inputT=NULL;
	PFLOAT ior=1.0;
	CFLOAT minr=0.0;
	bparams.getParam("reflected",inR);
	bparams.getParam("transmitted",inT);
	bparams.getParam("IOR",ior);
	bparams.getParam("min_refle",minr);
	inputR=render.getShader(*inR);
	inputT=render.getShader(*inT);
	return new fresnelNode_t(inputR,inputT,ior,minr);
}

shader_t * imageNode_t::factory(paramMap_t &bparams,std::list<paramMap_t> &lparams,
				        renderEnvironment_t &render)
{
	string _name;
	const string *name=&_name;
	bparams.getParam("filename", name);
	if (*name=="")
		cerr << "Required argument filename not found for image block\n";
	else
		return new imageNode_t(name->c_str());
	return NULL;
}

colorA_t goboNode_t::stdoutColor(renderState_t &state,const surfacePoint_t &sp,const vector3d_t &eye,
				const scene_t *scene)const
{
	if(input1 == NULL || input2 == NULL) return colorA_t(0,0,0);
	if(goboColor == NULL && goboFloat == NULL) return colorA_t(0,0,0);

	colorA_t out,gobo,in1,in2;
	in1 = input1->stdoutColor(state,sp,eye,scene);
	in2 = input2->stdoutColor(state,sp,eye,scene);

	if(goboColor != NULL)
		gobo = goboColor->stdoutColor(state,sp,eye,scene);
	else
	{
		CFLOAT i = goboFloat->stdoutFloat(state,sp,eye,scene);
		gobo.set(i,i,i);
	}

	if(hardEdge == true)
	{
		CFLOAT r,g,b;
		if(gobo.getRed() >= edgeVal)
			r = in1.getRed();
		else
			r = in2.getRed();

		if(gobo.getGreen() >= edgeVal)
			g = in1.getGreen();
		else
			g = in2.getGreen();

		if(gobo.getBlue() >= edgeVal)
			b = in1.getBlue();
		else
			b = in2.getBlue();
		return colorA_t(r,g,b);		
	}
	else
	{
		CFLOAT r,g,b;
		r = in1.getRed()*gobo.getRed()+ in2.getRed()*(1-gobo.getRed());
		g = in1.getGreen()*gobo.getGreen()+ in2.getGreen()*(1-gobo.getGreen());
		b = in1.getBlue()*gobo.getBlue()+ in2.getBlue()*(1-gobo.getBlue());
		return colorA_t(r,g,b);			
	}

}

shader_t * goboNode_t::factory(paramMap_t &bparams,std::list<paramMap_t> &lparams,
				        renderEnvironment_t &render)
{
	string _si1,_si2,_sgC,_sgV;
	const string *si1=&_si1,*si2=&_si2,*sgC=&_sgC,*sgV=&_sgV;
	shader_t *i1=NULL,*i2=NULL,*gC=NULL,*gV=NULL;
	bool hard = true;
	CFLOAT ev = 0.5;

	bparams.getParam("input1",si1);
	bparams.getParam("input2",si2);
	bparams.getParam("goboColor",sgC);
	bparams.getParam("goboFloat",sgV);
	bparams.getParam("hardedge",hard);
	bparams.getParam("edgeval",ev);

	i1=render.getShader(*si1);
	i2=render.getShader(*si2);
	gV=render.getShader(*sgC);
	gC=render.getShader(*sgV);

	if(i1 == NULL) cerr << "Input Shader 1 -" << si1 << "- not found\n";
	if(i2 == NULL) cerr << "Input Shader 2 -" << si2 << "- not found\n";
	if(gC == NULL && gV == NULL) cerr << "No Gobo Specified\n";
	if(gC != NULL && gV != NULL)
	{
		cerr << "2 Gobo's Specified - Using Color Gobo\n";
		gV = NULL;
	}
	return new goboNode_t(i1,i2,gC,gV,hard,ev);
}

__END_YAFRAY
