/**************************************************************************************************
	$Header: /pub/cvsroot/yencode/src/crc.h,v 1.8 2002/03/18 17:20:06 bboy Exp $

	Copyright (C) 2002  Don Moore <bboy@bboy.net>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at Your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**************************************************************************************************/

#ifndef _YCRC_H
#define _YCRC_H


typedef uint32_t	crc32_t;

/* Macro to update the CRC */
#define	CRC_START(_Y_crc)			(_Y_crc = 0xFFFFFFFF)
#define	CRC_FINISH(_Y_crc)		(_Y_crc = _Y_crc ^ 0xFFFFFFFF)
//#define	CRC_UPDATE(crc,oct)	(_y_crc_32_tab[((crc) ^ ((unsigned char)oct)) & 0xff] ^ ((crc) >> 8))
#define	CRC_UPDATE(_Y_crc,_Y_oct)	((_Y_crc) = _y_crc_32_tab[((_Y_crc)^(_Y_oct)) & 0xff] ^ (((_Y_crc) >> 8) & 0x00FFFFFF))


/* CRC table */
extern crc32_t _y_crc_32_tab[];

/* Function to calculate the CRC of a string */
extern crc32_t cksum(unsigned char *str);

#endif /* !_YCRC_H */

/* vi:set ts=3: */
