/* cfg_cmp.hh
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CFG_CMP_H
#define CFG_CMP_H

#include <qwidget.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include "zbuser.hh"
#include "zbconfig.hh"

class cfg_cmp:public QWidget
{
Q_OBJECT public:
    cfg_cmp (QWidget * parent, companyInfo * cmp, bool write);
   ~cfg_cmp ();
  void setEnabled (bool write);
private:
  void initView ();
  void setText ();
  void clear ();
  void happyOff ();
  void happyOn (int i);
private:
    bool CfgWrite;
  companyInfo *info;
  /* main grid */
  QGridLayout *cmpGrid;
  /* Label for 'Company Name' */
  QLabel *cmpLbName;
  /* Company Name */
  QLineEdit *cmpEdName;
  /* Label for 'Company Owner' */
  QLabel *cmpLbOwner;
  /* Company Owner */
  QLineEdit *cmpEdOwner;
  /* Label for 'Street' */
  QLabel *cmpLbStreet;
  /* Street */
  QLineEdit *cmpEdStreet;
  /* Labet for Zip Code */
  QLabel *cmpLbZip;
  /* Zip Code */
  QLineEdit *cmpEdZip;
  /*  Label for City */
  QLabel *cmpLbCity;
  /* City */
  QLineEdit *cmpEdCity;
  /* Label for Telephone */
  QLabel *cmpLbTel;
  /* Telephone */
  QLineEdit *cmpEdTel;
  /* Label for Facsimile */
  QLabel *cmpLbFax;
  /* Facsimile */
  QLineEdit *cmpEdFax;
  /* Label for Mail */
  QLabel *cmpLbMail;
  /* Mail */
  QLineEdit *cmpEdMail;
  /* Label for WWW */
  QLabel *cmpLbWeb;
  /* WWW */
  QLineEdit *cmpEdWeb;

  QSpacerItem *cmpSpace;
  QWidget *cmpBtnWidget;
  QHBoxLayout *cmpBtnGrid;
  /* Button 'Undo' */
  QPushButton *cmpBtnUndo;
  /* Space between Undo and Save */
  QSpacerItem *cmpBtnSpace;
  /* Button 'Save' */
  QPushButton *cmpBtnSave;
  private slots:void slotBtnUndo ();
  void slotBtnSave ();
  void slotCmpName (const QString & s);
  void slotCmpOwner (const QString & s);
  void slotCmpStreet (const QString & s);
  void slotCmpZip (const QString & s);
  void slotCmpCity (const QString & s);
  void slotCmpTel (const QString & s);
  void slotCmpFax (const QString & s);
  void slotCmpMail (const QString & s);
  void slotCmpWeb (const QString & s);
    signals:void configChanged ();
};

#endif
