/* history.cc 
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "history.hh"

history::history (QWidget * parent, const char *name, bool modal,
		  userProdList * pList, productList * prods,
		  unsigned int colorPrint, unsigned int grayPrint,printInfo *printPrice, float price, QString time):
QDialog (parent, name, modal)
{
  setCaption (tr ("History for %1").arg (name));
  setFixedSize (250, 100);
  float p = 0;
  tbl = new QTable (0, 2, this);
  //tbl->horizontalHeader ()->setLabel (0, tr ("Time"));
  tbl->horizontalHeader ()->setLabel (0, tr ("Product"));
  tbl->horizontalHeader ()->setLabel (1, tr ("Price"));
  //tbl->setColumnWidth (0, 50);
  tbl->setColumnWidth (0, 100);
  tbl->setColumnWidth (1, 50);
  QString s;
  // products
  for (userProdList::iterator pi = pList->begin (); pi != pList->end (); ++pi)
    {
      tbl->insertRows (tbl->numRows ());
      //tbl->setText (tbl->numRows () - 1, 0, (*pi).zeit.toString ("hh:mm"));
      tbl->setText (tbl->numRows () - 1, 0, (*prods)[(*pi).index].name);
      s.setNum ((*prods)[(*pi).index].price, 'f' , 2);
      p += (*prods)[(*pi).index].price;
      tbl->setText (tbl->numRows () - 1, 1, s);
    }
  // printout
  if(grayPrint > 0)
    {
      tbl->insertRows(tbl->numRows());
      tbl->setText(tbl->numRows()-1,0,tr("grayscale printout"));
      s.setNum(grayPrint * printPrice->gray , 'f',2);
      tbl->setText(tbl->numRows()-1,1,s);
      p += grayPrint * printPrice->gray;
    }
  if(colorPrint > 0)
    {
      tbl->insertRows(tbl->numRows());
      tbl->setText(tbl->numRows()-1,0,tr("color printout"));
      s.setNum(colorPrint * printPrice->color,'f',2);
      tbl->setText(tbl->numRows()-1,1,s);
      p += colorPrint * printPrice->color;
    }
  // used time
  tbl->insertRows(tbl->numRows());
  tbl->setText(tbl->numRows()-1,0,tr("used time %1") .arg(time));
  s.setNum(price,'f',2);
  tbl->setText(tbl->numRows()-1,1,s);
  p += price;
  // gesamt preis
  s.setNum (p,'f',2);
  tbl->insertRows (tbl->numRows ());
  tbl->setText (tbl->numRows () - 1, 0, tr ("Gesamt"));
  tbl->setText (tbl->numRows () - 1, 1, s);
  setFixedHeight(tbl->height());
}

history::~history ()
{
}
