#ifndef INCLUDED_XINGLMC_H_
#define INCLUDED_XINGLMC_H_


/*____________________________________________________________________________
   
   Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)
   Portions Copyright (C) 1998-1999 EMusic.com

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
   $Id: xinglmc.h,v 1.12 2003/09/16 17:35:15 kgk Exp $

____________________________________________________________________________*/

/* system headers */
#include <stdlib.h>
#include <time.h>
#include <string>
#include <vector>

/* project headers */
#include "config.h"

#include "pmi.h"
#include "pmo.h"
#include "mutex.h"
#include "event.h"
#include "lmc.h"
#include "thread.h"
#include "mutex.h"
#include "queue.h"
#include "semaphore.h"

extern    "C"
{
#include "mhead.h"
#include "port.h"
}

#define BS_BUFBYTES 60000U
#define PCM_BUFBYTES 60000U

#define FRAMES_FLAG     0x0001
#define BYTES_FLAG      0x0002
#define TOC_FLAG        0x0004
#define VBR_SCALE_FLAG  0x0008

#define FRAMES_AND_BYTES (FRAMES_FLAG | BYTES_FLAG)
   typedef struct 
   {
    int h_id;       // from MPEG header, 0=MPEG2, 1=MPEG1
    int samprate;   // determined from MPEG header
    int flags;      // from Xing header data
    int frames;     // total bit stream frames from Xing header data
    int bytes;      // total bit stream bytes from Xing header data
    int vbr_scale;  // encoded vbr scale from Xing header data
    unsigned char *toc;  // pointer to unsigned char toc_buffer[100]
                         // may be NULL if toc not desired
   }   XHEADDATA;

class     XingLMC:public LogicalMediaConverter
{

   public:
            XingLMC(FAContext *context);
   virtual ~XingLMC();

   virtual uint32_t CalculateSongLength(const char *url);

   virtual Error ChangePosition(int32_t position);

   virtual Error CanDecode();
   virtual void  Clear();
   virtual Error ExtractMediaInfo();

   /** Gets the output buffer of this stream.
    *  Because the output buffer will be prepared for the caller, this function should be called
    *  only once.
    *  @param pBuffer is set to the output buffer. Normally it will be prepared for the caller.
    *  @returns Returns an error if one happened.
    */
   virtual Error GetOutputBuffer(PullBuffer **pBuffer);

   virtual Error InitDecoder();

   virtual Error SetEQData(float *, float);
   virtual Error SetEQData(bool);

   virtual std::vector<std::string> *GetExtensions(void);
   
 private:

   static void          DecodeWorkerThreadFunc(void *);
   void			SkipID3v2Tag(FILE*);
   void                 DecodeWork();
   Error                BeginRead(void *&pBuffer, unsigned int iBytesNeeded);
   Error                EndRead(size_t iBytesUsed);
   Error                AdvanceBufferToNextFrame();
   Error                GetHeadInfo();
   Error                GetBitstreamStats(float &fTotalSeconds, float &fMsPerFrame,
                                          int32_t &iTotalFrames, int32_t &iSampleRate, 
                                          int32_t &iLayer);

   int                  GetXingHeader(XHEADDATA *X,  unsigned char *buf);
   int32_t              SeekPoint(unsigned char TOC[100], int32_t file_bytes, float percent);
   int                  ExtractI4(unsigned char *buf);

   int                  m_iMaxWriteSize;
   int32_t                m_frameBytes, m_iBufferUpInterval, m_iBufferSize;
   size_t               m_lFileSize;
   MPEG_HEAD            m_sMpegHead;
   int32_t                m_iBitRate, m_iTotalFrames;
   bool                 m_bBufferingUp;
   Thread              *m_decoderThread;

   int32_t                m_frameCounter;
   const char          *m_szError;
   XHEADDATA           *m_pXingHeader;
   
   // These vars are used for a nasty hack.
   FILE                *m_fpFile;
   char                *m_pLocalReadBuffer;
   MPEG                 m_sMPEG;


};

#endif /* _XINGLMC_H */




/* arch-tag: 34d81430-dc2c-4287-9137-143519337658
   (do not change this comment) */
