/*____________________________________________________________________________

        Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

        Portions Copyright (C) 1999 EMusic.com

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        $Id: gdbmdatabase.cpp,v 1.1 2003/09/16 17:58:14 kgk Exp $
____________________________________________________________________________*/


#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <string.h>
#include <gdbm.h>

#include <strstream>

#include "errors.h"
#include "gdbmdatabase.h"

using namespace std;

#ifdef WIN32
#define S_IRWXU _S_IREAD|_S_IWRITE
#endif

#define DB_VERSION_KEY         "ZINF_DATABASE_VERSION"
#define DB_SUBVERSION_KEY      "ZINF_SUBVERSION"
#define DB_FORMAT_KEY          "ZINF_FORMAT"

vector<string> GDBMDatabase::supported_tags;

gdbm_iterator::gdbm_iterator()
    : m_dbase(0)
{
    key.dptr = NULL;
    //key.size = 0;
}
gdbm_iterator::gdbm_iterator(GDBMDatabase&db)
    : m_dbase(&db.m_dbase)
{
    key = gdbm_firstkey(*m_dbase);
}

gdbm_iterator::~gdbm_iterator()
{
    if (key.dptr)
        free(key.dptr);
}

string gdbm_iterator::operator *()
{
    string result;
    datum dbresult = gdbm_fetch(*m_dbase, key);
    result = dbresult.dptr;
    free(dbresult.dptr);
    return result;
    
}
gdbm_iterator& gdbm_iterator::operator ++ ()
{
    key = gdbm_nextkey(*m_dbase, key);
    return *this;
}
gdbm_iterator gdbm_iterator::operator ++ (int)
{
    gdbm_iterator next(*this);
    ++next;
    return next;
}
gdbm_iterator::operator string()
{
    return string(key.dptr);
}



GDBMDatabase::GDBMDatabase(const string&name, int version)
    : MetadataDB()
{
    m_dbase = NULL;

    assert(name.size());

    m_lock = new Mutex();
    m_dbase = gdbm_open((char*)name.c_str(), 0, GDBM_WRCREAT, S_IRWXU, NULL);

    if (m_dbase == 0) {
      fprintf(stderr, "failed to open %s\n", name.c_str());
    }
    
    m_upgraded = false;
    assert(m_dbase);

    if (version >= 0) {
        m_upgraded = loadDatabaseFormat(version);
        if (m_upgraded) {
            storeDatabaseFormat(version);
        }
    }
}

GDBMDatabase::~GDBMDatabase()
{
    m_lock->Acquire();
    if (m_dbase) {
        gdbm_sync(m_dbase);
        gdbm_close(m_dbase);
    }
    delete m_lock;
}

bool GDBMDatabase::isWorking()
{
    if (!m_dbase)
        return false;
    return true;
}

void GDBMDatabase::reloadCache()
{
    char *key = NextKey(NULL);

    while (key) {
        string url = key;
        Metadata md;
        getMetadata(url, md);
        m_cache->add(url, md);
        key = NextKey(key);
    }
}


bool GDBMDatabase::IsUpgraded()
{
    return m_upgraded;
}

int GDBMDatabase::Insert(const char *key, const char *content)
{
    datum gdbmKey;
    datum gdbmContent;
    int returnValue;

    gdbmKey.dptr = (char *)key;
    gdbmKey.dsize = strlen(key) * sizeof(char) + 1;
    gdbmContent.dptr = (char *)content;
    gdbmContent.dsize = strlen(content) * sizeof(char) + 1;

    m_lock->Acquire();
    returnValue = gdbm_store(m_dbase, gdbmKey, gdbmContent, GDBM_REPLACE);
    m_lock->Release();

   if (returnValue != 0)
       return kError_DbaseItemNotStored;
   return kError_NoErr;
}

void GDBMDatabase::Remove(const char *key)
{
    datum gdbmKey;

    gdbmKey.dptr = (char *)key;
    gdbmKey.dsize = strlen(key) + 1;

    m_lock->Acquire();
    gdbm_delete(m_dbase, gdbmKey);
    m_lock->Release();
}

char *GDBMDatabase::Value(const char *key)
{
    datum gdbmKey;
    datum returnData;

    gdbmKey.dptr = (char *)key;
    gdbmKey.dsize = strlen(key) + 1;

    m_lock->Acquire();
    returnData = gdbm_fetch(m_dbase, gdbmKey);
    m_lock->Release();

    if (returnData.dptr == NULL)
       return NULL; // deal with not found error..

    char *returninfo = new char[returnData.dsize + 1];
    strcpy(returninfo, returnData.dptr);
    free(returnData.dptr);

    return returninfo;
}

int GDBMDatabase::Exists(const char *key)
{
    datum gdbmKey;
    int found;

    gdbmKey.dptr = (char *)key;
    gdbmKey.dsize = strlen(key) + 1;

    m_lock->Acquire();
    found = gdbm_exists(m_dbase, gdbmKey);
    m_lock->Release();

    return found;
}

char *GDBMDatabase::NextKey(char *key)
{
    datum returnKey;
    char *nextKey;

    m_lock->Acquire();
    if (key)
    {
        datum gdbmKey;
        gdbmKey.dptr = (char *)key;
        gdbmKey.dsize = strlen(key) + 1;

        returnKey = gdbm_nextkey(m_dbase, gdbmKey);

        delete[] key;
    }
    else
        returnKey = gdbm_firstkey(m_dbase);

    m_lock->Release();

    if (!returnKey.dptr) 
        return NULL;
 
    nextKey = new char[returnKey.dsize + 1]; 
    strcpy(nextKey, returnKey.dptr);

    free(returnKey.dptr);

    if ((nextKey != NULL) && (!strcmp(DB_VERSION_KEY, nextKey)))
        nextKey = NextKey(nextKey);

    return nextKey;
}

void GDBMDatabase::Sync()
{
    m_lock->Acquire();
    gdbm_sync(m_dbase);
    m_lock->Release();
}

int GDBMDatabase::GetSubVersion()
{
    int sub_ver = 0;
    char *stored_ver = NULL;

    stored_ver = Value(DB_SUBVERSION_KEY);

    if (!stored_ver)
        sub_ver = 0;
    else
        sub_ver = atoi(stored_ver);

    delete [] stored_ver;
    return sub_ver;
}

void GDBMDatabase::StoreSubVersion(int version)
{
    char version_store[15];

    sprintf(version_store, "%d", version);

    Insert(DB_SUBVERSION_KEY, version_store);
}

bool GDBMDatabase::loadDatabaseFormat(int version)
{
    int database_ver = 0;
    char *stored_ver = NULL;
    
    stored_ver = Value(DB_VERSION_KEY);
 
    if (!stored_ver)
        return false;

    database_ver = atoi(stored_ver);

    delete [] stored_ver;

    if (version != database_ver)
        return false;
    return true;

    char *format = Value(DB_FORMAT_KEY);
    if (format == NULL) {
        supported_tags.push_back(Metadata::kArtist);
        supported_tags.push_back(Metadata::kAlbum);
        supported_tags.push_back(Metadata::kTitle);
        supported_tags.push_back(Metadata::kGenre);
        supported_tags.push_back(Metadata::kComment);
        supported_tags.push_back(Metadata::kTrack);
        supported_tags.push_back(Metadata::kYear);
    } else { 
        // Read supported tags from format string 
        for (char *tok = strtok(format," ");
             tok ;
             tok = strtok(NULL, " ")) {
            supported_tags.push_back(string(tok));
        }
    }
}

void GDBMDatabase::storeDatabaseFormat(int version)
{
    char version_store[15];
    
    sprintf(version_store, "%d", version);

    Insert(DB_VERSION_KEY, version_store);

    string format;
    vector<string>::iterator tag ;

    tag = supported_tags.begin();
    while (tag != supported_tags.end()) {
        format += *tag;
        format += ' ';
    }
    Insert(DB_FORMAT_KEY, format.c_str());
}



bool GDBMDatabase::add(const url_t& url, const Metadata&m)
{
    m_cache->add(url,m);
    setMetadata(url, m);
    return true;
}
bool GDBMDatabase::remove(const url_t& url)
{
    Remove(url.c_str());
    return true;
}

bool 
GDBMDatabase::contains(const url_t&url)
{
    return m_cache->contains(url) || Exists(url.c_str());
}



bool GDBMDatabase::getMetadata(const url_t&url, Metadata&metadata)
{
    if (!isWorking())
        return false;

    char *dbasedata = Value(url.c_str());

    if (!dbasedata)
        return false;

    uint32_t numFields = supported_tags.size();
    uint32_t* fieldLength = new uint32_t[numFields];
    istrstream ist(dbasedata);
    string buf;
    vector<string>::iterator tag ;

    // Save offsets of strings
    tag = supported_tags.begin();
    uint32_t i, sz, count;
    for (i = 0; i < numFields; i++){
        ist >> sz;
        fieldLength[i] = sz;
    }

    ist >> buf;
    tag = supported_tags.begin();
    count = 0;
    i = 0;
    while (tag != supported_tags.end()) {
        metadata.setTag(*tag, buf.substr(count, fieldLength[i]));
        count+= fieldLength[i];
        i++;
    }
    delete [] fieldLength;
    delete [] dbasedata;
    return true;


}

bool GDBMDatabase::setMetadata(const url_t&url, const Metadata&metadata)
{
    ostrstream ost;
    vector<string>::iterator tag ;
    string buf;

    // Save offsets of strings
    tag = supported_tags.begin();
    while (tag != supported_tags.end()) {
        metadata.getTag(*tag, buf);
        ost << buf.size();
        ost << ' ';
    }
    tag = supported_tags.begin();
    while (tag != supported_tags.end()) {
        metadata.getTag(*tag, buf);
        ost << buf;
    }

    ost.freeze();
    Insert(url.c_str(), ost.str());
    return true;
    
}

Error GDBMDatabase::query (const std::string&target, 
                           const params_t& params,
                           result_t& results)
{
    return m_cache->query(target, params, results);
}

/* arch-tag: b3f4dd90-ba08-4cb2-9da8-a20d50cb9a69 */
