/*____________________________________________________________________________

    Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

    Portions Copyright (C) 1999-2000 EMusic.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: albumart.cpp,v 1.2 2004/01/07 21:58:02 kgk Exp $
____________________________________________________________________________*/

#include "config.h"
#include <gtk/gtk.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <iostream>
#include "eventdata.h"
//#include "player.h"
#include "ui.h"
#include "albumart.h"

using namespace std;

extern "C" {

UserInterface *Initialize(FAContext *context) {
    return new albumart(context);
}
           }

gboolean window_destroy(GtkWidget *w, GdkEvent *event, albumart *user){
  cerr << "window_destroy" << endl;
  user->m_initialised = FALSE;
  Event *e = new Event(INFO_ReadyToDieUI);
  user->m_playerEQ->AcceptEvent(e);
  
  return FALSE;
}

albumart::albumart(FAContext *context)
{
    m_context = context;
    m_initialised = TRUE;
    m_scale=false;
    m_size=128;
    m_hide=false;
    m_filename="folder.jpg";
    pos_x=0;
    pos_y=0;
}

albumart::~albumart()
{
}

Error albumart::Init(int32_t startup_level) 
{
    if ((m_startupType = startup_level) != SECONDARY_UI_STARTUP) {
        cout << _("The albumart ui shouldn't run as the primary ui\n"); 
        return kError_InitFailedSafely;
    }

    m_playerEQ = m_context->target;
    loadprefs();
    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_signal_connect(GTK_OBJECT(window), "delete_event", G_CALLBACK(window_destroy), this);
    gtk_window_set_title (GTK_WINDOW (window), "Album Cover");
    gtk_window_set_default_size (GTK_WINDOW (window), 128, 128);
    gtk_window_set_resizable (GTK_WINDOW (window), FALSE);
    image = gtk_image_new();
    gtk_widget_show (image);
    gtk_container_add (GTK_CONTAINER (window), image);
    m_hidden=TRUE;
    pos_x=pos_y=16;
     
    return kError_NoErr;
}

Error albumart::AcceptEvent(Event *event)
{
	switch (event->Type()) {
	case CMD_Cleanup: {
	  m_initialised=FALSE;
	  gtk_widget_destroy(window);
		//cleanup
	  m_playerEQ->AcceptEvent(new Event(INFO_ReadyToDieUI));
	  break; }
        case INFO_PrefsChanged: {
	  loadprefs();
	  break; }
	case INFO_Paused: {
		break; }
        case INFO_Stopped: {
		break; }
        case INFO_PlaylistCurrentItemInfo:
        case INFO_Playing:{
	  showcurrent();
		break;
	}
        default:
            break;
    }
    return kError_NoErr;
}



void albumart::showcurrent(void)
{
  if(!m_initialised)
    return;
  string location;
  string imagepath;
  struct stat sb;
  GdkPixbuf* fileimg, *scaledimg;

  gdk_threads_enter();
  PlaylistItem* pItem=m_context->plm->GetCurrentItem();
  URLToFilePath(pItem->URL().c_str(), location);
  
  string::size_type pos = location.length();

  do{
    pos--;
    pos = location.rfind("/", pos);
    imagepath=location.substr(0, pos+1)+m_filename;
    if(!stat(imagepath.c_str(),&sb)){
      if(m_scale){
	fileimg=gdk_pixbuf_new_from_file(imagepath.c_str(),NULL);
	scaledimg=gdk_pixbuf_scale_simple(fileimg, m_size, m_size, GDK_INTERP_BILINEAR);      
	gtk_image_set_from_pixbuf(GTK_IMAGE(image), scaledimg);
	g_object_unref(fileimg);
      } else {
	gtk_image_set_from_file(GTK_IMAGE(image), imagepath.c_str());
      }
      if (m_hidden){
	m_hidden=FALSE;
	gtk_widget_show(window);
	gtk_window_move(GTK_WINDOW(window),pos_x,pos_y);
      }
      gdk_threads_leave();
      return;
    }
    
  } while(pos>1);
  if(!m_hidden && m_hide){
    m_hidden=TRUE;
    gtk_window_get_position(GTK_WINDOW(window),&pos_x,&pos_y);
    gtk_widget_hide(window);
  } else {
    gtk_image_set_from_stock(GTK_IMAGE(image), GTK_STOCK_MISSING_IMAGE, GTK_ICON_SIZE_DIALOG);
  }
  gdk_threads_leave();
}

void albumart::loadprefs(){
  if(m_context->prefs->GetPrefString("CoverName",&m_filename)==kError_NoPrefValue){
    m_context->prefs->SetPrefString("CoverName",m_filename);  
  };
  m_context->prefs->GetPrefInt32("CoverSize", &m_size);
  if (m_size<0){
    m_size=128;
    m_context->prefs->SetPrefInt32("CoverSize",m_size);
  }
  if(m_context->prefs->GetPrefBoolean("CoverScale", &m_scale)==kError_NoPrefValue){
    m_context->prefs->SetPrefBoolean("CoverScale", m_scale);
  }
  if(m_context->prefs->GetPrefBoolean("CoverHide", &m_hide)==kError_NoPrefValue){
    m_context->prefs->SetPrefBoolean("CoverHide", m_hide);
  }
}

// arch-tag: f5ee94d4-c897-45d3-a73e-05af80438847
