/*____________________________________________________________________________

   Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

   Copyright (C) 1999-2000 EMusic

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Id: GTKPreferenceWindow.h,v 1.12 2003/09/16 17:36:23 kgk Exp $
____________________________________________________________________________*/ 

#ifndef INCLUDED_GTKPREFERENCEWINDOW_H__
#define INCLUDED_GTKPREFERENCEWINDOW_H__

#include <map>
#include <set>

#include <gtk/gtk.h>

#include "config.h"
#include "PreferenceWindow.h"
#include "ThemeManager.h"
#include "preferences.h"
#include "log.h"
#include "registrar.h"

//typedef set<string> PortableSet;
class PrefsStruct
{
 public:
    Preferences* prefs;

    bool enableLogging;
    bool logMain;
    bool logInput;
    bool logOutput;
    bool logDecoder;
    bool logPerformance;

  //    PortableSet portablePlayers;

  // General 
    bool useTextLabels;
    bool useImages; 
    bool savePlaylistOnExit;
    bool playImmediately;
    bool setLastResume;
    bool softMixer;
    std::string LastDir;
    bool allowMultipleInstances;
    bool convertUnderscores;
    bool  reclaimFiletypes;
    bool  askReclaimFiletypes;
  // Themes
    std::string defaultFont;
    std::string currentTheme;
    int    listboxIndex;
  // Directories & Programs
    std::string saveMusicDirectory;
    std::string watchThisDirectory;
    int32_t  watchThisDirTimeout;
    std::string browser;
  // Streaming
    bool saveStreams;
    std::string saveStreamsDirectory;
    bool useProxyServer;
    std::string proxyServer; 
    bool useAlternateIP;
    std::string alternateIP;
    
  // Plugins
    std::string defaultPMO;
    std::string alsaOutput;
    bool   writeID3v1Tags;
    bool   writeID3v2Tags;
    bool   writeVorbisTags;

  // MusicBrainz
    bool pollCD;
    std::string CDDevicePath;
    std::string MBServer;

  // Advanced
    int32_t inputBufferSize;
    int32_t outputBufferSize;
    int32_t preBufferLength;

  // Playlist
    std::string playlistHeaders;
  // About

    bool operator == (const PrefsStruct& pref)
    {
        return (
                // General 
                useTextLabels == pref.useTextLabels &&
                useImages == pref.useImages && 
                savePlaylistOnExit == pref.savePlaylistOnExit &&
                playImmediately == pref.playImmediately &&
                setLastResume == pref.setLastResume &&
                softMixer == pref.softMixer &&
                LastDir == pref.LastDir &&
                allowMultipleInstances == pref.allowMultipleInstances &&
                convertUnderscores == pref.convertUnderscores &&
                reclaimFiletypes == pref.reclaimFiletypes &&
                askReclaimFiletypes == pref.askReclaimFiletypes &&
                // Themes
                defaultFont == pref.defaultFont &&
                currentTheme == pref.currentTheme &&
                listboxIndex == pref.listboxIndex &&
                // Directories & Programs
                saveMusicDirectory == pref.saveMusicDirectory &&
                watchThisDirectory == pref.watchThisDirectory &&
                watchThisDirTimeout == pref.watchThisDirTimeout &&
                browser == pref.browser &&
                // Streaming
                saveStreams == pref.saveStreams &&
                saveStreamsDirectory == pref.saveStreamsDirectory &&
                useProxyServer == pref.useProxyServer &&
                proxyServer == pref.proxyServer && 
                useAlternateIP == pref.useAlternateIP &&
                alternateIP == pref.alternateIP &&
                // Plugins
                defaultPMO == pref.defaultPMO &&
                alsaOutput == pref.alsaOutput &&
                writeID3v1Tags == pref.writeID3v1Tags &&
                writeID3v2Tags == pref.writeID3v2Tags &&
                writeVorbisTags == pref.writeVorbisTags &&

                // MusicBrainz
                pollCD == pref.pollCD &&
                CDDevicePath == pref.CDDevicePath &&
                MBServer == pref.MBServer &&
                // Advanced
                inputBufferSize == pref.inputBufferSize &&
                outputBufferSize == pref.outputBufferSize &&
                preBufferLength == pref.preBufferLength &&
                playlistHeaders == pref.playlistHeaders );
    }

    bool operator != (const PrefsStruct& pref)
    {
        return ! (*this == pref);
    }
};


class OptionsPane {
  public:
    OptionsPane(std::string label, std::string desc, uint32_t page, GtkWidget *pane)
    {
        m_label = label; m_description = desc; m_pageno = page; 
        m_pane = pane;
    }
    ~OptionsPane() { }

    std::string     m_label;
    std::string     m_description;
    uint32_t     m_pageno;
    GtkWidget *m_pane;
};

class GTKPreferenceWindow : public PreferenceWindow
{
  public:

  enum { GENERAL, THEMES, DIRECTORY, STREAM, 
         PLUGINS, MUSICBRAINZ, ADVANCED, PLAYLIST,
         ABOUT };


               GTKPreferenceWindow(FAContext *context,
                                   ThemeManager *pThemeMan,
                                   uint32_t defaultPage);
      virtual ~GTKPreferenceWindow(void); 
      
      virtual  bool Show(Window *pParent);

               void GetPrefsValues(Preferences* prefs, 
                                   PrefsStruct* values);

               void SavePrefsValues(Preferences* prefs, 
                                    PrefsStruct* values);

  protected:

      PrefsStruct  currentValues;
      PrefsStruct  originalValues;
      PrefsStruct  proposedValues;

      std::map<std::string, std::string> m_oThemeList;

  private:
      bool   eventLoop;
      uint32_t startPage;

      GtkWidget *CreateGeneral(void);
      GtkWidget *CreateStreaming(void);
      GtkWidget *CreatePlugins(void);
      GtkWidget *CreateAbout(void);
      GtkWidget *CreateThemes(void);
      GtkWidget *CreateAdvanced(void);
      GtkWidget *CreateDirectories(void);
      GtkWidget *CreateCD(void);
      GtkWidget *CreatePlaylistHeaders(void);
      
      GtkWidget *saveMusicBox;

      GtkWidget *applyButton;

      GtkWidget *saveStreamLabel;
      GtkWidget *saveStreamBox;
      GtkWidget *saveBrowseBox;

      GtkWidget *proxyAddyLabel;
      GtkWidget *proxyAddyBox;
      GtkWidget *proxyColon;
      GtkWidget *proxyPortLabel;
      GtkWidget *proxyPortBox;

      GtkWidget *ipLabel;
      GtkWidget *ipOneBox;
      GtkWidget *ipPeriod1;
      GtkWidget *ipTwoBox;
      GtkWidget *ipPeriod2;
      GtkWidget *ipThreeBox;
      GtkWidget *ipPeriod3;
      GtkWidget *ipFourBox;

      GtkWidget *pmoMenu;
      GtkWidget *alsaOneBox;
      GtkWidget *alsaTwoBox;

      GtkWidget *themeList;

      GtkWidget *fontDialog;

      GtkWidget *paneLabel;
      GtkStyle  *paneStyle;

      GtkWidget *paneVbox;
      GtkWidget *visiblePane;
  
      GtkWidget *watchDirBox;
      GtkWidget *browserBox;

      GtkWidget *prefTree;
      GtkListStore *prefStore;

      GtkWidget *profileEnable;
      GtkWidget *profileListFrame;
      GtkWidget *profileTextFrame;
      GtkWidget *profileList;
      GtkWidget *profileEntry;
      GtkWidget *profileAdd;
      GtkWidget *profileDelete;
      
      bool enableProfiles;
     
      GtkWidget *pollCD;
      GtkWidget *cdPath;
      GtkWidget *mbServer;
      GtkWidget *enableMB;
      GtkWidget *enableBitzi;
      
      std::vector<OptionsPane *> *paneList;
      void AddPane(OptionsPane *pane);      

      bool firsttime;

      void ApplyProfiles(void);
      std::vector<std::string> *m_PMOnames;
      std::set<uint32_t>     m_profileSelection;

      GtkWidget *plAvailableList;
      GtkWidget *plShownList;

  public:
      void SetPane(OptionsPane *pane);
      void SetPane(uint32_t panenum);

      GtkWidget *mainWindow;
      GtkWidget *pmoOptionMenu;

      bool  done;

      void UpdateThemeList(void);
      void AddThemeEvent(const char *newpath);
      void DeleteThemeEvent(void);
      void ChooseFont(void);
      void SetFont(void);

      void ApplyInfo(void);
      void CancelInfo(void);
      
      int  SetInputBufferSize(int newvalue);
      void SetOutputBufferSize(int newvalue);
      void SetPreBufferLength(int newvalue);

      void SaveLocalToggle(int active);
      void SaveLocalSet(char *newpath, bool set);
      void ProxyAddySet(void);
      void ProxyToggle(int active);
      void AltIPSet(void);
      void AltIPToggle(int active);

      void SelectTheme(int number);

      void SetPMO(int newsel);
      void AlsaSet(void);

      void ShowHelp(void);

      void SaveMusicSet(char *newpath, bool set);
      void SetToolbar(bool text, bool pics);
      void SaveOnExitToggle(int active);
      void PlayImmediatelyToggle(int active);
      void SetLastResumeToggle(int active);
      void SoftMixerToggle(int active);
      void AllowMultipleToggle(int active);
      void ConvertUnderscoresToggle(int active);
      void ReclaimTypesToggle(int active);
      void AskReclaimToggle(int active);

      void WatchDirSet(char *newpath, bool set);
      void SetWatchTimeout(int32_t timeout);
      void SetBrowser (const char *);

      void PollCDToggle(int active);
      void CDPathSet(char *newpath, bool set);
      void MBServerSet(char *newpath, bool set);

      void UpdatePLHeaders(void);     
      void AddPLSelection(void);
      void RemovePLSelection(void);

      PrefsStruct& proposed() { return proposedValues; }
      void enableApply () { 
        if (!firsttime)
          gtk_widget_set_sensitive(applyButton, TRUE);
      }

      FAContext *GetContext(void) { return m_pContext; }
};

#endif

/* arch-tag: 2f4944cf-5690-404b-891e-7a1b4c574f05
   (do not change this comment) */
