/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.image.PngChunk;
import org.eclipse.swt.internal.image.PngChunkReader;
import org.eclipse.swt.internal.image.PngIdatChunk;
import org.eclipse.swt.internal.image.PngLzBlockReader;

public class PngDecodingDataStream {
    PngIdatChunk currentChunk;
    PngChunkReader chunkReader;
    byte currentByte;
    int nextByteIndex;
    int nextBitIndex;
    PngLzBlockReader lzBlockReader;
    int adlerValue;
    static final int PRIME = 65521;
    static final int MAX_BIT = 7;

    PngDecodingDataStream(PngIdatChunk pngIdatChunk, PngChunkReader pngChunkReader) {
        this.currentChunk = pngIdatChunk;
        this.chunkReader = pngChunkReader;
        this.nextByteIndex = 0;
        this.nextBitIndex = 8;
        this.adlerValue = 1;
        this.lzBlockReader = new PngLzBlockReader(this);
        this.readCompressedDataHeader();
        this.lzBlockReader.readNextBlockHeader();
    }

    void assertImageDataAtEnd() {
        this.lzBlockReader.assertCompressedDataAtEnd();
    }

    int getNextIdatBits(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 |= this.getNextIdatBit() << n3;
            ++n3;
        }
        return n2;
    }

    byte getNextIdatBit() {
        if (this.nextBitIndex > 7) {
            this.currentByte = this.getNextIdatByte();
            this.nextBitIndex = 0;
        }
        int n = 1 << this.nextBitIndex;
        ++this.nextBitIndex;
        return (this.currentByte & n) > 0 ? (byte)1 : 0;
    }

    private PngIdatChunk getNextChunk() {
        PngChunk pngChunk = this.chunkReader.readNextChunk();
        if (pngChunk == null) {
            this.error();
        }
        if (pngChunk.getChunkType() != 2) {
            this.error();
        }
        return (PngIdatChunk)pngChunk;
    }

    byte getNextIdatByte() {
        if (this.nextByteIndex > this.currentChunk.getLength() - 1) {
            this.currentChunk = this.getNextChunk();
            this.nextByteIndex = 0;
        }
        byte by = this.currentChunk.getDataByteAtOffset(this.nextByteIndex);
        ++this.nextByteIndex;
        this.nextBitIndex = 8;
        return by;
    }

    private void updateAdler(byte by) {
        int n = this.adlerValue & 0xFFFF;
        int n2 = this.adlerValue >> 16 & 0xFFFF;
        int n3 = by & 0xFF;
        n = (n + n3) % 65521;
        n2 = (n + n2) % 65521;
        this.adlerValue = n2 << 16 | n;
    }

    byte getNextDecodedByte() {
        byte by = this.lzBlockReader.getNextByte();
        this.updateAdler(by);
        return by;
    }

    void error() {
        SWT.error(40);
    }

    private void readCompressedDataHeader() {
        int n;
        int n2;
        byte by;
        byte by2 = this.getNextIdatByte();
        int n3 = (by2 & 0xFF) << 8 | (by = this.getNextIdatByte()) & 0xFF;
        if (n3 % 31 != 0) {
            this.error();
        }
        if ((n2 = by2 & 0xF) != 8) {
            this.error();
        }
        if ((n = (by2 & 0xF0) >> 4) > 7) {
            this.error();
        }
        int n4 = 1 << n + 8;
        this.lzBlockReader.setWindowSize(n4);
        int n5 = by & 0x20;
        if (n5 != 0) {
            this.error();
        }
    }

    void checkAdler() {
        int n = (this.getNextIdatByte() & 0xFF) << 24 | (this.getNextIdatByte() & 0xFF) << 16 | (this.getNextIdatByte() & 0xFF) << 8 | this.getNextIdatByte() & 0xFF;
        if (n != this.adlerValue) {
            this.error();
        }
    }
}

