/*
	mosaic.c - animate mosaic

	Author:	Susumu Shiohara (shiohara@tpp.epson.co.jp)

		Copyright 1993-1997 by Susumu Shiohara

			All Rights Reserved

*/

#include "xslideshow.h"
#include "animproto.h"

static byte *subImage;
static XImage *subXImage;
static int mapsize;

#if defined(__STDC__) || defined(__cplusplus)
static void drawSubImage(int px,int py,int sx,int sy,int w, int h)
#else
static void drawSubImage(px,py,sx,sy,w,h)
int px, py, sx, sy, w, h;
#endif
{
byte pix;
int	i, j, l, psize;

	if(theVisual->class == PseudoColor){

		/* get a pixel */
		pix = gim.subImageList->image[py * gim.subImageList->width + px];

		/* generate a mosaic block */
		for(j = 0; j < h; j++){
			for(i = 0; i < w; i++){
				subImage[(sy + j) * gim.subImageList->width + (sx + i)] = pix;
			}
		}

	}
	else {

		if(gim.pmf.bits_per_pixel > 16)
			psize = sizeof(dword);
		else if(gim.pmf.bits_per_pixel > 8)
			psize = sizeof(word);
		else
			psize = sizeof(byte);

		for(j = 0; j < h; j++){
			for(i = 0; i < w; i++){
				for(l = 0; l < psize; l++){
					pix = gim.subImageList->image[py * gim.subImageList->width * psize + px * psize + l];
					subImage[(sy + j) * gim.subImageList->width * psize + (sx + i) * psize + l] = pix;
				}
			}
		}

	}
	
}

/* MOSAIC */
static void mosaicImage()
{
Pixmap pic;
XGCValues gcv;
GC	gc;
int	i,j,k,l,x,y,xof,yof,xpos,ypos,xmax,ymax,psize;
int	b_cx,b_cy,b_w,b_h,pb_w,pb_h; /* block */
int	xx,yy,maxsize,xsize,ysize;
int	*tmp,tmpindex;

	if(gim.subImageList->width <= 1 || gim.subImageList->height <= 1)
		return;

	if(theVisual->class == PseudoColor){

		if((subImage = (byte *)XtMalloc(gim.subImageList->width * gim.subImageList->height)) == NULL){
			fprintf(stderr,"xslideshow: mosaic() memory allocation error\n");
			goodbyekiss();
		}

		subXImage = XCreateImage(
							theDisp,
							theVisual,
							DefaultDepth(theDisp,theScreenNumber),
							ZPixmap,
							0,
							(char *)subImage,
							(dword)gim.subImageList->width,
							(dword)gim.subImageList->height,
							gim.pmf.scanline_pad,
							(int)gim.subImageList->width );
	}

	else {

		if(gim.pmf.bits_per_pixel > 16)
			psize = sizeof(dword);
		else if(gim.pmf.bits_per_pixel > 8)
			psize = sizeof(word);
		else
			psize = sizeof(byte);


		if((subImage = (byte *)XtMalloc(gim.subImageList->width * gim.subImageList->height * psize)) == NULL){
			fprintf(stderr,"xslideshow: mosaic() memory allocation error\n");
			goodbyekiss();
		}

		subXImage = XCreateImage(
							theDisp,
							theVisual,
							DefaultDepth(theDisp,theScreenNumber),
							ZPixmap,
							0,
							(char *)subImage,
							(dword)gim.subImageList->width,
							(dword)gim.subImageList->height,
							gim.pmf.scanline_pad,
							(int)gim.subImageList->width * psize );
	}

	gcv.function = GXcopy;
	gc = XCreateGC(theDisp,theWindow,GCFunction,&gcv);
	if((pic = XCreatePixmap(
							theDisp,
							theWindow,
							gim.subImageList->width,gim.subImageList->height,
							DefaultDepth(theDisp,theScreenNumber))
							) == (Pixmap)0) {
		fprintf(stderr,"xslideshow: mosaic() Error : can't create a Pixmap. Abort.\n");
		goodbyekiss();
	}

	/* calc left and top offset */
	xof  = (windowWidth  - gim.subImageList->width)  / 2;
	yof  = (windowHeight - gim.subImageList->height) / 2;

	/* calc right and bottom position */
	xmax = xof + gim.subImageList->width;
	ymax = yof + gim.subImageList->height;

	/* first block size = width(height) / 2 */
	b_w  = gim.subImageList->width  / 2;
	b_h  = gim.subImageList->height / 2;

	if(b_w == 0) b_w = 1;
	else if(b_w > gim.subImageList->width)  b_w = gim.subImageList->width;
	if(b_h == 0) b_h = 1;
	else if(b_h > gim.subImageList->height) b_h = gim.subImageList->height;

	pb_w = b_w;
	pb_h = b_h;

	if(theVisual->class == PseudoColor){
		if((tmp = (int *)XtMalloc(sizeof(int) * gim.subImageList->width*gim.subImageList->height))==NULL){
			fprintf(stderr,"xslideshow: mosaic() memory allocation error\n");
			goodbyekiss();
		}
	}
	else {
		if(gim.pmf.bits_per_pixel > 16)
			psize = sizeof(dword);
		else if(gim.pmf.bits_per_pixel > 8)
			psize = sizeof(word);
		else
			psize = sizeof(byte);

		if((tmp = (int *)XtMalloc(sizeof(int) * gim.subImageList->width * gim.subImageList->height * psize))==NULL){
			fprintf(stderr,"xslideshow: mosaic() memory allocation error\n");
			goodbyekiss();
		}
	}

	while(1){

		/* Make mosaic */
		for(y = 0,j = 0; y < (gim.subImageList->height + b_h); y += b_h, j++){

			b_cy = b_h / 2 + b_h * j;

			if(b_cy >= gim.subImageList->height)
				b_cy = gim.subImageList->height - 1;

			for(x = 0, i = 0; x < (gim.subImageList->width + b_w); x += b_w, i++){

				xpos = (x < gim.subImageList->width ? x  : gim.subImageList->width)  + xof;
				ypos = (y < gim.subImageList->height ? y : gim.subImageList->height) + yof;

				b_cx = b_w / 2 + b_w * i;

				if(b_cx >= gim.subImageList->width)
					b_cx = gim.subImageList->width - 1;

				drawSubImage(
						b_cx, b_cy,
						xpos - xof, ypos - yof,
						(xpos + b_w) < xmax ? b_w : xmax - xpos,
						(ypos + b_h) < ymax ? b_h : ymax - ypos
						);
			}
		}

		if(b_w == (gim.subImageList->width / 2) && b_h == (gim.subImageList->height / 2)) {

			XPutImage(	theDisp,
						theWindow,
						gc,
						subXImage,
						0, 0,
						xof, yof,
						gim.subImageList->width, gim.subImageList->height	);

		}
		else{

			pb_w = (b_w < 8) ? pb_w : b_w * 2;
			pb_h = (b_h < 8) ? pb_h : b_h * 2;

			XPutImage(	theDisp,
						pic,
						gc,
						subXImage,
						0, 0,
						0, 0,
						gim.subImageList->width, gim.subImageList->height	);

			xsize = (gim.subImageList->width / pb_w) + (gim.subImageList->width % pb_w ? 1 : 0);
			ysize = (gim.subImageList->height / pb_h) + (gim.subImageList->height % pb_h ? 1 : 0);
			maxsize = xsize * ysize;

			for(k = 0; k < maxsize; k++)
				tmp[k]= -1;

			for(k = 0; k < maxsize; k++){

				for(l=0; ; l++){
					tmpindex = myrandom() % maxsize;
					if(tmp[tmpindex] == -1) {
						tmp[tmpindex] = k;
						break;
					}
				}

				xx = (tmpindex % xsize) * pb_w;
				yy = (tmpindex / xsize) * pb_h;
				if(((xx + xof) < 0 && (yy + yof) < 0) 
					|| ((xx + xof) >= windowWidth && (yy + yof) >= windowHeight))
					continue;

				XCopyArea(
						theDisp,
						pic,
						theWindow,
						gc,
						xx, yy,
						((xx+pb_w) < gim.subImageList->width ? pb_w : gim.subImageList->width - xx),
						((yy+pb_h) < gim.subImageList->height ? pb_h : gim.subImageList->height - yy),
						xx + xof, yy + yof);

			}
		}

		myusleep(app_data.mosaicTicks);
		if(gotSomeAction == True)
			break;

		/* Finish to make mosaic */
		if(b_w == 1 || b_h == 1)
			break;

		b_w = b_w / 2;
		if(b_w < 1) b_w = 1;

		b_h = b_h / 2;
		if(b_h < 1) b_h = 1;
	}

	XPutImage(	theDisp,
				theWindow,
				gc,
				theImage,
				0, 0,
				xof, yof,
				gim.subImageList->width, gim.subImageList->height	);

	XtFree((char *)tmp);
	XFreeGC(theDisp,gc);
	XFreePixmap(theDisp,pic);

	if (subXImage){
		if(subXImage->data)
			XtFree((char *)(subXImage->data)); 

		XFree(subXImage);
		subXImage=NULL;
	}
}

#if defined(__STDC__) || defined(__cplusplus)
ActionStatus xmosaicshow(char *fname)
#else
ActionStatus xmosaicshow(fname)
char *fname;
#endif
{
	mapsize = gim.subImageList->mapsize;

	PreDisplay();
	PreFadeColors(mapsize);
	StoreColors(xcolors, mapsize);

	if(app_data.showFileName)
		createFileNameWindow(fname);

	mosaicImage();

	ShowImage(	(windowWidth  - gim.subImageList->width)  / 2,
				(windowHeight - gim.subImageList->height) / 2,
				gim.subImageList->width, gim.subImageList->height
				);

	if(app_data.showFileName)
		raiseFileNameWindow();

	return(mywait());
}

#if defined(__STDC__) || defined(__cplusplus)
void postxmosaicshow(char *fname)
#else
void postxmosaicshow(fname)
char *fname;
#endif
{
	if(app_data.showFileName)
		removeFileNameWindow();

	FadeColors(True,mapsize);
}

