/*
	slit.c - animate slit

	Author:	Susumu Shiohara (shiohara@tpp.epson.co.jp)

		Copyright 1993-1997 by Susumu Shiohara

			All Rights Reserved

*/

#include "xslideshow.h"
#include "animproto.h"

static	Window *wd = NULL;
static	int xof,yof,pw,ph,steps,maxwnum,*t = NULL;
static	int hasRes = False;
static	int mapsize;

#if defined(__STDC__) || defined(__cplusplus)
static void QuickSort(int from,int to)
#else
static void QuickSort(from,to)
int from,to;
#endif
{
int i,j,k,mean,tmp;
int x1,y1,x2,y2;

	i = from;
	j = to;
	mean = (t[i]+t[j])/2;

	while(True){

		while(t[i] < mean)
			i++;

		while(t[j] > mean)
			j--;

		if(i<=j){
			x1 = xof;
			y1 = yof + t[i] * steps;
			x2 = xof;
			y2 = yof + t[j] * steps;

			for(k = 0; k < j; k++)
				XLowerWindow(theDisp,wd[k]);

			for(k++; k < maxwnum; k++)
				XLowerWindow(theDisp,wd[k]);

			move_on_bresenham_line(
								wd[j],
								x2, y2,
								x1, y1,
								2, app_data.moveOnTheLineTicks);

			for(k = 0; k < i; k++)
				XLowerWindow(theDisp,wd[k]);

			for(k++; k < maxwnum; k++)
				XLowerWindow(theDisp,wd[k]);

			move_on_bresenham_line(
								wd[i],
								x1,y1,
								x2,y2,
								2, app_data.moveOnTheLineTicks);

			tmp  = t[i];
			t[i] = t[j];
			t[j] = tmp;

			myusleep(app_data.slitTicks);
			if(gotSomeAction == True)
				return;

			i++;
			j--;
		}
		else
			break;
	}

	if(from < j)
		QuickSort(from,j);

	if(i < to)
		QuickSort(i,to);
}

static void ShellSort()
{
int h,i,j,k,l,m,tmp;
int x1,y1,x2,y2;

	m = ph;

	/* Shell Sort */
	for(h = m >> 1; h > 0; h >>= 1) {
		for(i = m - h,k = 1; k <= i; k++) {
			for(j = k - 1; (j >= 0) && (t[j] > t[j+1]); j -= h){
				x1 = xof;
				y1 = yof + t[j] * steps;
				x2 = xof;
				y2 = yof + t[j+1] * steps;

				for(l = 0; l < (j + 1); l++)
					XLowerWindow(theDisp,wd[l]);

				for(l++; l < maxwnum; l++)
					XLowerWindow(theDisp,wd[l]);

				move_on_bresenham_line(
									wd[j+1],	
									x2, y2,
									x1, y1,
									2, app_data.moveOnTheLineTicks);

				for(l = 0; l < j; l++)
					XLowerWindow(theDisp,wd[l]);

				for(l++; l < maxwnum; l++)
					XLowerWindow(theDisp,wd[l]);

				move_on_bresenham_line(
									wd[j],
									x1, y1,
									x2, y2,
									2, app_data.moveOnTheLineTicks);

				tmp    = t[j];
				t[j]   = t[j+1];
				t[j+1] = tmp;
				myusleep(app_data.slitTicks);
				if(gotSomeAction == True)
					return;
			}
		}
	}
}

static void BubbleSort()
{
int i,j,k,m,tmp;
int x1,y1,x2,y2;

	m = ph;

	/* Bubble Sort */
	for(i = 0; i < m - 1; i++) {
		for(j = 0; j < m - 1; j++) {
			if(t[j] > t[j+1]){
				x1 = xof;
				y1 = yof + t[j] * steps;
				x2 = xof;
				y2 = yof + t[j+1] * steps;

				/* move the window (x2,y2) -> (x1,y1) */
				for(k = 0; k < (j + 1); k++)
					XLowerWindow(theDisp,wd[k]);

				for(k++; k < maxwnum; k++)
					XLowerWindow(theDisp,wd[k]);

				move_on_bresenham_line(
									wd[j+1],
									x2, y2,
									x1, y1,
									2, app_data.moveOnTheLineTicks);

				/* move the window (x1,y1) -> (x2,y2) */
				for(k = 0; k < j; k++)
					XLowerWindow(theDisp,wd[k]);

				for(k++; k < maxwnum; k++)
					XLowerWindow(theDisp,wd[k]);

				move_on_bresenham_line(
									wd[j],
									x1, y1,
									x2, y2,
									2, app_data.moveOnTheLineTicks);

				tmp    = t[j];
				t[j]   = t[j+1];
				t[j+1] = tmp;
				myusleep(app_data.slitTicks);
				if(gotSomeAction == True)
					return;
			}
		}
	} 
}

static void SlitIt()
{
int i,j,m;
XImage *subImage;
Pixmap pic,subPic;
XSetWindowAttributes xswa;
XGCValues gcv;
GC gc;

	if(app_data.slitSteps > gim.subImageList->height)
		steps = gim.subImageList->height;
	else
		steps = app_data.slitSteps;

	if(steps == 0) steps = 1;

	xof = (windowWidth - gim.subImageList->width) / 2;
	yof = (windowHeight - gim.subImageList->height) / 2;

	pw = gim.subImageList->width;
	ph = gim.subImageList->height / steps;

	if(ph < 1){ 
		hasRes = False;
		return;
	}

	gcv.function   = GXcopy;
	gcv.background = bcol;
	gcv.foreground = bcol;

	if((pic = XCreatePixmap(	theDisp,
								theWindow,
								gim.subImageList->width,
								gim.subImageList->height,
								DefaultDepth(theDisp,theScreenNumber))) == (Pixmap)0){
		fprintf(stderr,"xslideshow: Pixmap creation error\n");
		goodbyekiss();
	}

	gc = XCreateGC(theDisp,pic,GCFunction | GCForeground | GCBackground,&gcv );
	XPutImage(theDisp,pic,gc,theImage,0,0,0,0,gim.subImageList->width,gim.subImageList->height);
	XFreeGC(theDisp,gc);

	m = ph;
	t = (int *)XtMalloc(sizeof(int) * m);
	if(t == (int *)NULL){
		fprintf(stderr,"xslideshow: memory allocation error\n");
		goodbyekiss();
	}

	/* Create the random able */
	for(i = 0; i < m; i++)
		t[i] = -1;

	for(i = 0; i < m; i++){
		while(1){
			j = myrandom() % m;
			if(t[j] == -1){
				t[j] = i;
				break;
			}
		}
	}

	wd = (Window *)XtMalloc(sizeof(Window) * m);
	if(wd == (Window *)NULL){
		fprintf(stderr,"xslideshow: memory allocation error\n");
		goodbyekiss();
	}
	for(i = 0; i < m; i++){
		wd[i] = XCreateSimpleWindow(	theDisp,
										theWindow,
										xof,
										yof + t[i] * steps,
										pw,
										steps,
										0,
										bcol, bcol	);

		if(wd[i] == (Window)0){
			/* Error has been caused */
			for(j = 0; j < i; j++)
				XDestroyWindow(theDisp,wd[j]);

			XtFree((char *)t); t = NULL;
			XtFree((char *)wd); wd = NULL;
			XFreePixmap(theDisp,pic);
			hasRes = False;
			return;
		}

		xswa.override_redirect = True;
		XChangeWindowAttributes(theDisp,wd[i],CWOverrideRedirect,&xswa);

		subPic = XCreatePixmap(	theDisp,
								wd[i],
								pw,
								steps,
								DefaultDepth(theDisp,theScreenNumber)	);

		subImage = XGetImage(	theDisp,
								pic,
								0,
								i * steps,	
								pw,
								steps,
								XAllPlanes(),
								ZPixmap	);

		gc = XCreateGC(theDisp,wd[i],GCFunction | GCForeground | GCBackground,&gcv );
		XPutImage(theDisp,subPic,gc,subImage,0,0,0,0,pw,steps);
		XSetWindowBackgroundPixmap(theDisp,wd[i],subPic);

		XDestroyImage(subImage);
		XFreePixmap(theDisp,subPic);
		XFreeGC(theDisp,gc);
		myevent();
	}

	for(i = 0; i < m; i++) {
		XLowerWindow(theDisp,wd[i]);
		XMapWindow(theDisp,wd[i]);
	}
	maxwnum = m;

	XFreePixmap(theDisp,pic);
	hasRes = True;
	return;
}

static void freeResources()
{
int i,m;

	m = ph;

	for(i=0;i<m;i++)
		XDestroyWindow(theDisp,wd[i]);

	XtFree((char *)t);
		t = NULL;

	XtFree((char *)wd);
		wd = NULL;

	hasRes = False;

	myusleep(0); /* Flush */
}

#if defined(__STDC__) || defined(__cplusplus)
ActionStatus xslitshow(char *fname)
#else
ActionStatus xslitshow(fname)
char *fname;
#endif
{
	mapsize = gim.subImageList->mapsize;

	PreDisplay();

	if(app_data.showFileName)
		createFileNameWindow(fname);

	SlitIt();

	ShowImage(	(windowWidth - gim.subImageList->width) / 2,
				(windowHeight - gim.subImageList->height) / 2,
				gim.subImageList->width, gim.subImageList->height);

	if(app_data.slitFade){
		PreFadeColors(mapsize);
		FadeColors(False,mapsize);
	}

	StoreColors(xcolors,mapsize);

	if(hasRes){

		myusleep(3000000); /* wait 3 sec */

		if(strcmp(app_data.slitSort,"bubble")==0)
			BubbleSort();

		else if(strcmp(app_data.slitSort,"shell")==0)
			ShellSort();

		else /* if(strcmp(app_data.slitSort,"quick")==0) */
			QuickSort(0, ph - 1);
	}

	if(app_data.showFileName)
		raiseFileNameWindow();

	return(mywait());
}

#if defined(__STDC__) || defined(__cplusplus)
void postxslitshow(char *fname)
#else
void postxslitshow(fname)
char *fname;
#endif
{
	if(app_data.showFileName)
		removeFileNameWindow();

	if(app_data.slitFade){
		FadeColors(True,mapsize);
	}

	if(hasRes) {
		freeResources();
		XClearWindow(theDisp,theWindow);
	}
}

