
/*
 *  Copyright (c) 1998 - 1999, 2001 Karel Zak "Zakkr" <zakkr@zf.jcu.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  $Id: radio.c,v 1.2 2001/01/02 14:16:15 zakkr Exp $
 */

#include "aca.h"
#include "aca_widget.h"

#include "widget_utils.h"


   int radio_fn(SessW *s, Widget *w, void *data, int key, int Msg)
   {
      Wradio	*r;
      
      _D(" radio_fn()");
      DEBUG_WIDGET(w,s);
      
      r = (Wradio *) data;			
  
      switch(Msg) {
      case WIDGET_DRAW:
         if (w->id == s->actual) {
            W_mvaddastr(w, w->y, w->x+4, r->astr, TplC->radio.sel_astr, TplC->radio.sel); 
            aca_c(TplC->radio.sel);
            if (r->flag & B_DEPEND)
               mvprintw(w->y, w->x, "(%c) ", show_bit(*r->point, r->mybit) ? '*' : ' ');            	
            else
               mvprintw(w->y, w->x, "(%c) ", r->set ? '*' : ' ');
            curs_set(1);	
            move(w->y, w->x+1);
         } 
         else if (!(w->flag & Wf_NOTVISIBLE)) {	
            W_mvaddastr(w, w->y, w->x+4, r->astr, TplC->radio.nsel_astr, TplC->radio.nsel); 
            aca_c(TplC->radio.nsel);
            if (r->flag & B_DEPEND)
               mvprintw(w->y, w->x, "(%c) ", show_bit(*r->point, r->mybit) ? '*' : ' ');
            else	
               mvprintw(w->y, w->x, "(%c) ", r->set ? '*' : ' ');
            curs_set(0);	
         }
         return Wr_OK;
      case WIDGET_KEY:
         if ((w->id == s->actual) && ((key == ' ' || key == '\n' || 
         widget_keys(key, w, s))) ) {
            if (r->flag & B_DEPEND) {
               if (!show_bit(*r->point, r->mybit)) {
                  *r->point =  0;
                  set_bit(r->point, r->mybit, 1);
               }
            } 
            else	
               r->set = (r->set ? FALSE : TRUE);
         
            aca_c(TplC->radio.sel);
            mvprintw(w->y, w->x, "(%c) ", r->set ? '*' : ' ');
            curs_set(1);	
            move(w->y, w->x+1);
            if (r->flag & B_DEPEND) 
               return Wr_RADIO_DEPEND;
            else        
               return (r->set ? Wr_RADIO_SET : Wr_RADIO_UNSET);
         } 
         else 
            widget_keys(key, w, s);         
         return Wr_OK;
      }
      return Wr_ERROR;
   }
