/* -*- C++ -*- */
//=============================================================================
/**
 *  @file   Activator_NT_Service.h
 *
 *  Activator_NT_Service.h,v 1.2 2003/11/12 22:58:08 michel_j Exp
 *
 *  @author Darrell Brunsch <brunsch@cs.wustl.edu>
 *  @author Jeff Parsons <parsons@cs.wustl.edu>
 *  @author John Tucker <jtucker@infoglide.com> 
 *  @author Mike Vitalo <mvitalo@infoglide.com>   
 */
//=============================================================================

#ifndef Activator_NT_Service_H
#define Activator_NT_Service_H

#include "ace/config.h"

#if defined (ACE_WIN32)

#include "ace/NT_Service.h"
#include "ace/Singleton.h"
#include "tao/orbconf.h"

static const char * IMR_ACTIVATOR_SERVICE_NAME = "TAOIMRActivator";
static const char * IMR_ACTIVATOR_DISPLAY_NAME = "TAO Implementation Repository Activator";
static const char * IMR_ACTIVATOR_DESCRIPTION = "Implementation Repository Activator service for TAO";

/**
 * @class Activator_NT_Service
 *
 * @brief Allows the Implementation Repository to act as a Windows NT Service.
 */
class Activator_NT_Service : public ACE_NT_Service
{
public:
  typedef TAO_SYNCH_RECURSIVE_MUTEX MUTEX;

  /// We override <handle_control> because it handles stop requests
  /// privately.
  virtual void handle_control (DWORD control_code);

  /// We override <handle_exception> so a 'stop' control code can wake
  /// the reactor off of its wait.
  virtual int handle_exception (ACE_HANDLE h);

  /// This is a virtual method inherited from ACE_NT_Service.
  virtual int svc (void);
private:
  friend class ACE_Singleton<Activator_NT_Service, MUTEX>;
};

typedef ACE_Singleton<Activator_NT_Service, Activator_NT_Service::MUTEX> SERVICE;

#endif /* ACE_WIN32 */

#endif /* Activator_NT_Service_H */
